/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.util.Enumeration;
import java.util.Vector;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Target;

class LeaseInfo {
    VMID vmid;
    long expiration;
    Vector notifyList = new Vector();

    LeaseInfo(VMID vMID, long l) {
        this.vmid = vMID;
        this.expiration = System.currentTimeMillis() + l;
    }

    synchronized void renew(long l) {
        long l2 = System.currentTimeMillis() + l;
        if (l2 > this.expiration) {
            this.expiration = l2;
        }
    }

    boolean expired(long l) {
        if (this.expiration < l) {
            if (DGCImpl.logLevel >= 10) {
                LogStream.log("dgc").println("LeaseInfo.expired: " + this.vmid);
            }
            Enumeration enumeration = this.notifyList.elements();
            while (enumeration.hasMoreElements()) {
                Target target = (Target)enumeration.nextElement();
                target.vmidDead(this.vmid);
            }
            return true;
        }
        return false;
    }
}

