/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.CORBA;

import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class OctetSequence {
    private byte[] _contents;
    private static byte[] EMPTY = new byte[0];

    public OctetSequence() {
        this._contents = EMPTY;
    }

    public OctetSequence(byte[] byArray) {
        if (byArray == null) {
            this._contents = EMPTY;
            return;
        }
        this._contents = byArray;
    }

    public byte[] toBytes() {
        return this._contents;
    }

    public int length() {
        return this._contents.length;
    }

    public OctetSequence(InputStream inputStream) {
        this._contents = new byte[inputStream.read_long()];
        inputStream.read_octet_array(this._contents, 0, this._contents.length);
    }

    public void write(OutputStream outputStream) {
        outputStream.write_long(this._contents.length);
        outputStream.write_octet_array(this._contents, 0, this._contents.length);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OctetSequence)) {
            return false;
        }
        OctetSequence octetSequence = (OctetSequence)object;
        if (this._contents.length != octetSequence._contents.length) {
            return false;
        }
        if (this._contents == octetSequence._contents) {
            return true;
        }
        int n = 0;
        while (n < this._contents.length) {
            if (this._contents[n] != octetSequence._contents[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        int n = this._contents.length;
        if (n == 0) {
            return "{}";
        }
        String string = "{" + n + " bytes: ";
        if (n > 100) {
            n = 100;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = (char)this._contents[n2];
            string = c >= ' ' && c <= '~' ? String.valueOf(string) + "[" + c + "]" : String.valueOf(string) + "(" + new Integer(c).toString() + ")";
            ++n2;
        }
        if (n < this._contents.length) {
            string = String.valueOf(string) + "...";
        }
        return String.valueOf(string) + "}";
    }
}

