/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import netscape.ldap.LDAPControl;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;

public class LDAPVirtualListControl
extends LDAPControl {
    public static final String VIRTUALLIST = "2.16.840.1.113730.3.4.9";
    private static final int TAG_BYINDEX = 0;
    private static final int TAG_BYFILTER = 1;
    private int m_beforeCount;
    private int m_afterCount;
    private int m_listIndex = -1;
    private int m_listSize;

    LDAPVirtualListControl() {
        super(VIRTUALLIST, true, null);
    }

    public LDAPVirtualListControl(String string, int n, int n2) {
        super(VIRTUALLIST, true, null);
        this.setRange(string, n, n2);
    }

    public LDAPVirtualListControl(int n, int n2, int n3, int n4) {
        super(VIRTUALLIST, true, null);
        this.m_listSize = n4;
        this.setRange(n, n2, n3);
    }

    public void setRange(int n, int n2, int n3) {
        this.m_beforeCount = n2;
        this.m_afterCount = n3;
        this.m_listIndex = n;
        this.m_value = this.createPageSpecification(this.m_listIndex, this.m_listSize, this.m_beforeCount, this.m_afterCount);
    }

    public void setRange(String string, int n, int n2) {
        this.m_beforeCount = n;
        this.m_afterCount = n2;
        this.m_value = this.createPageSpecification(string, this.m_beforeCount, this.m_afterCount);
    }

    public int getIndex() {
        return this.m_listIndex;
    }

    public int getListSize() {
        return this.m_listSize;
    }

    public void setListSize(int n) {
        this.m_listSize = n;
    }

    public int getBeforeCount() {
        return this.m_beforeCount;
    }

    public int getAfterCount() {
        return this.m_afterCount;
    }

    private byte[] createPageSpecification(String string, int n, int n2) {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BERInteger(n));
        bERSequence.addElement(new BERInteger(n2));
        bERSequence.addElement(new BERTag(129, new BEROctetString(string), true));
        return this.flattenBER(bERSequence);
    }

    private byte[] createPageSpecification(int n, int n2, int n3, int n4) {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BERInteger(n3));
        bERSequence.addElement(new BERInteger(n4));
        BERSequence bERSequence2 = new BERSequence();
        bERSequence2.addElement(new BERInteger(n));
        bERSequence2.addElement(new BERInteger(n2));
        bERSequence.addElement(new BERTag(160, bERSequence2, true));
        return this.flattenBER(bERSequence);
    }
}

