/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import sun.awt.image.ImageDecoder;
import sun.awt.image.InputStreamImageSource;

public class URLImageSource
extends InputStreamImageSource {
    URL url;
    URLConnection conn;
    String actualHost;
    int actualPort;

    public URLImageSource(URL uRL) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
        }
        this.url = uRL;
    }

    public URLImageSource(String string) throws MalformedURLException {
        this(new URL(null, string));
    }

    public URLImageSource(URL uRL, URLConnection uRLConnection) {
        this(uRL);
        this.conn = uRLConnection;
    }

    public URLImageSource(URLConnection uRLConnection) {
        this(uRLConnection.getURL(), uRLConnection);
    }

    final boolean checkSecurity(Object object, boolean bl) {
        if (this.actualHost != null) {
            try {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(this.actualHost, this.actualPort, object);
                }
            }
            catch (SecurityException securityException) {
                if (!bl) {
                    throw securityException;
                }
                return false;
            }
        }
        return true;
    }

    private synchronized URLConnection getConnection() throws IOException {
        URLConnection uRLConnection;
        if (this.conn != null) {
            uRLConnection = this.conn;
            this.conn = null;
        } else {
            uRLConnection = this.url.openConnection();
        }
        return uRLConnection;
    }

    protected ImageDecoder getDecoder() {
        Object object;
        InputStream inputStream = null;
        String string = null;
        try {
            object = this.getConnection();
            inputStream = ((URLConnection)object).getInputStream();
            string = ((URLConnection)object).getContentType();
            URL uRL = ((URLConnection)object).getURL();
            if (uRL != this.url && (uRL.getHost() != this.url.getHost() || uRL.getPort() != this.url.getPort())) {
                if (this.actualHost != null && (this.actualHost != uRL.getHost() || this.actualPort != uRL.getPort())) {
                    throw new SecurityException("image moved!");
                }
                this.actualHost = uRL.getHost();
                this.actualPort = uRL.getPort();
            }
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {}
            }
            return null;
        }
        object = this.decoderForType(inputStream, string);
        if (object == null) {
            object = this.getDecoder(inputStream);
        }
        return object;
    }
}

