/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.DragSession;
import netscape.application.DragSource;
import netscape.application.EmptyBorder;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class DragWell
extends View
implements DragSource {
    Image image;
    String dataType;
    Object data;
    Border border = BezelBorder.loweredBezel();
    boolean enabled = true;
    static final String IMAGE_KEY = "image";
    static final String DATA_KEY = "data";
    static final String DATATYPE_KEY = "dataType";
    static final String ENABLED_KEY = "enabled";
    static final String BORDER_KEY = "border";

    public DragWell() {
        this(0, 0, 0, 0);
    }

    public DragWell(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public DragWell(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public boolean isTransparent() {
        return false;
    }

    public void setImage(Image image) {
        if (this.image != image) {
            this.image = image;
            this.draw();
        }
    }

    public Image image() {
        return this.image;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public String dataType() {
        return this.dataType;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public Object data() {
        return this.data;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.draw();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setBorder(Border border) {
        if (border == null) {
            border = EmptyBorder.emptyBorder();
        }
        this.border = border;
    }

    public Border border() {
        return this.border;
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return false;
        }
        Image image = this.image();
        if (image == null) {
            return false;
        }
        Rect rect = new Rect((this.width() - image.width()) / 2, (this.height() - image.height()) / 2, image.width(), image.height());
        if (!rect.contains(mouseEvent.x, mouseEvent.y)) {
            return false;
        }
        new DragSession(this, image, rect.x, rect.y, mouseEvent.x, mouseEvent.y, this.dataType(), this.data);
        return true;
    }

    public void drawView(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.width(), this.height());
        Image image = this.image();
        if (image != null) {
            image.drawCentered(graphics, 0, 0, this.width(), this.height());
        }
        this.border.drawInRect(graphics, 0, 0, this.width(), this.height());
    }

    public View sourceView(DragSession dragSession) {
        return this;
    }

    public void dragWasAccepted(DragSession dragSession) {
    }

    public boolean dragWasRejected(DragSession dragSession) {
        return true;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.DragWell", 1);
        classInfo.addField(IMAGE_KEY, (byte)18);
        classInfo.addField(DATA_KEY, (byte)18);
        classInfo.addField(DATATYPE_KEY, (byte)16);
        classInfo.addField(ENABLED_KEY, (byte)0);
        classInfo.addField(BORDER_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(IMAGE_KEY, this.image);
        encoder.encodeObject(DATA_KEY, (Codable)this.data);
        encoder.encodeString(DATATYPE_KEY, this.dataType);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        if (this.border instanceof EmptyBorder) {
            encoder.encodeObject(BORDER_KEY, null);
            return;
        }
        encoder.encodeObject(BORDER_KEY, this.border);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.image = (Image)decoder.decodeObject(IMAGE_KEY);
        this.data = decoder.decodeObject(DATA_KEY);
        this.dataType = decoder.decodeString(DATATYPE_KEY);
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        this.setBorder((Border)decoder.decodeObject(BORDER_KEY));
    }
}

