/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.DragDestination;
import netscape.application.DragSource;
import netscape.application.DragView;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.View;

public class DragSession {
    String dataType;
    Object data;
    Image image;
    int initialX;
    int initialY;
    int mouseDownX;
    int mouseDownY;
    int mouseX;
    int mouseY;
    DragSource source;
    DragDestination destination;
    DragView dragView;
    int modifiers;
    RootView rootView;
    View sourceView;
    View destinationView;
    boolean isAccepting;
    public static final int SHIFT_MASK = 1;
    public static final int CONTROL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;

    public DragSession(DragSource dragSource, Image image, int n, int n2, int n3, int n4, String string, Object object, boolean bl) {
        Point point = new Point();
        Point point2 = new Point();
        this.sourceView = dragSource.sourceView(this);
        this.rootView = this.sourceView.rootView();
        this.sourceView.convertToView(null, n, n2, point);
        this.sourceView.convertToView(null, n3, n4, point2);
        if (this.rootView.windowClipView() != null) {
            this.rootView.convertPointToView(this.rootView.windowClipView(), point, point);
            this.rootView.convertPointToView(this.rootView.windowClipView(), point2, point2);
        }
        this.source = dragSource;
        this.image = image;
        this.initialX = point.x;
        this.initialY = point.y;
        this.mouseDownX = point2.x;
        this.mouseDownY = point2.y;
        this.dataType = string;
        this.data = object;
        if (bl) {
            this.dragView = new DragView(this);
        }
    }

    public DragSession(DragSource dragSource, Image image, int n, int n2, int n3, int n4, String string, Object object) {
        this(dragSource, image, n, n2, n3, n4, string, object, true);
    }

    public Object data() {
        return this.data;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public String dataType() {
        return this.dataType;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public DragSource source() {
        return this.source;
    }

    public DragDestination destination() {
        return this.destination;
    }

    public int dragModifiers() {
        return this.modifiers;
    }

    public boolean isShiftKeyDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isControlKeyDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaKeyDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isAltKeyDown() {
        return (this.modifiers & 8) != 0;
    }

    void updateModifiers(MouseEvent mouseEvent) {
        this.modifiers = 0;
        if (mouseEvent == null) {
            return;
        }
        if (mouseEvent.isShiftKeyDown()) {
            ++this.modifiers;
        }
        if (mouseEvent.isControlKeyDown()) {
            this.modifiers += 2;
        }
        if (mouseEvent.isMetaKeyDown()) {
            this.modifiers += 4;
        }
        if (mouseEvent.isAltKeyDown()) {
            this.modifiers += 8;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        DragDestination dragDestination = null;
        Point point = new Point(mouseEvent.x, mouseEvent.y);
        if (this.dragView != null) {
            this.dragView.convertPointToView(null, point, point);
        }
        int n = point.x;
        int n2 = point.y;
        this.updateModifiers(mouseEvent);
        View view = this.rootView.viewForMouse(n, n2);
        if (this.rootView.viewExcludedFromModalSession(view)) {
            view = null;
        }
        if (view != null) {
            Point point2 = Point.newPoint();
            this.rootView.convertToView(view, n, n2, point2);
            dragDestination = view.acceptsDrag(this, point2.x, point2.y);
            while (dragDestination == null && view._superview != null) {
                point2.x += view.bounds.x;
                point2.y += view.bounds.y;
                view = view._superview;
                dragDestination = view.acceptsDrag(this, point2.x, point2.y);
            }
            Point.returnPoint(point2);
        }
        if (this.destination == null && dragDestination != null) {
            this.destination = dragDestination;
            this.destinationView = view;
            this.isAccepting = this.destination.dragEntered(this);
            return;
        }
        if (this.destination != null && dragDestination == null) {
            this.destination.dragExited(this);
            this.destination = null;
            this.destinationView = null;
            return;
        }
        if (this.destination != dragDestination) {
            this.destination.dragExited(this);
            this.destination = dragDestination;
            this.destinationView = view;
            this.destination.dragEntered(this);
            return;
        }
        if (this.destination != null) {
            this.isAccepting = this.destination.dragMoved(this);
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        boolean bl;
        block9: {
            boolean bl2 = false;
            bl = false;
            try {
                this.updateModifiers(mouseEvent);
                if (this.destination != null && this.isAccepting) {
                    bl2 = this.destination.dragDropped(this);
                }
                if (bl2) {
                    this.source.dragWasAccepted(this);
                    break block9;
                }
                bl = this.source.dragWasRejected(this);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var5_5 = null;
                    this.isAccepting = false;
                    if (this.dragView == null) break block10;
                    if (bl) {
                        this.dragView.startAnimatingRejectedDrag();
                    } else {
                        this.dragView.stopDragging();
                    }
                }
                throw throwable;
            }
        }
        Object var5_4 = null;
        this.isAccepting = false;
        if (this.dragView != null) {
            if (bl) {
                this.dragView.startAnimatingRejectedDrag();
            } else {
                this.dragView.stopDragging();
            }
        }
    }

    public View destinationView() {
        return this.destinationView;
    }

    public Rect destinationBounds() {
        if (this.destinationView == null) {
            return null;
        }
        Rect rect = this.absoluteBounds();
        this.rootView.convertRectToView(this.destinationView, rect, rect);
        return rect;
    }

    public Rect absoluteBounds() {
        Rect rect = new Rect(0, 0, this.image.width(), this.image.height());
        if (this.dragView != null) {
            this.dragView.convertRectToView(null, rect, rect);
        }
        return rect;
    }

    public Point absoluteMousePoint() {
        if (this.dragView != null) {
            Point point = new Point(this.dragView._lastX, this.dragView._lastY);
            this.dragView.superview().convertPointToView(null, point, point);
            return point;
        }
        return new Point(0, 0);
    }

    public Point destinationMousePoint() {
        if (this.destinationView == null) {
            return null;
        }
        if (this.dragView != null) {
            Point point = new Point(this.dragView._lastX, this.dragView._lastY);
            this.dragView.superview().convertPointToView(this.destinationView, point, point);
            return point;
        }
        return new Point(0, 0);
    }

    public boolean destinationIsAccepting() {
        return this.isAccepting;
    }
}

