/*
 * Decompiled with CFR 0.152.
 */
package ice.protocols.jam;

import ice.htmlbrowser.BrowserClassLoader;
import ice.protocols.jam.JamURLDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class JamConnection
extends URLConnection {
    private Object resource;
    private String name;
    private ClassLoader classLoader;
    private URL jarUrl;
    static String[][] contentMap = new String[][]{{"html", "text/html"}, {"htm", "text/html"}, {"zip", "application/zip"}, {"txt", "text/plain"}};

    protected JamConnection(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
        String string;
        String string2 = String.valueOf(uRL.getProtocol()) + "://" + uRL.getHost() + "/";
        JamURLDecoder jamURLDecoder = new JamURLDecoder();
        try {
            string = JamURLDecoder.decode(uRL.getHost());
        }
        catch (NumberFormatException numberFormatException) {
            MalformedURLException malformedURLException = new MalformedURLException("jam Protocol : Bad escape in embedded URL " + uRL.getHost());
            malformedURLException.fillInStackTrace();
            throw malformedURLException;
        }
        try {
            this.jarUrl = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            MalformedURLException malformedURLException2 = new MalformedURLException("jam Protocol : Bad embedded URL " + string);
            malformedURLException2.fillInStackTrace();
            throw malformedURLException2;
        }
        string2 = this.jarUrl.toString();
        BrowserClassLoader browserClassLoader = BrowserClassLoader.getBrowserClassLoader(string2, this.jarUrl.toString());
        browserClassLoader.loadJar(this.jarUrl);
        this.classLoader = browserClassLoader;
        this.name = uRL.getFile();
        if (this.name.charAt(0) == '/') {
            this.name = this.name.substring(1);
        }
    }

    public void connect() throws IOException {
        InputStream inputStream = this.classLoader.getResourceAsStream(this.name);
        if (inputStream == null) {
            this.resource = null;
            throw new IOException(String.valueOf(this.name) + " not in JAR file");
        }
        this.resource = inputStream;
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.resource;
    }

    public String getContentType() {
        String string = URLConnection.guessContentTypeFromName(this.name);
        if (string == null || string.equals("unknown")) {
            string = this.getContentTypeFor(this.name);
        }
        return string;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource instanceof InputStream) {
            return (InputStream)this.resource;
        }
        return this.classLoader.getResourceAsStream(this.name);
    }

    public String getContentTypeFor(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "unknown";
        }
        try {
            string2 = string.substring(n + 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            string2 = "";
        }
        int n2 = 0;
        while (n2 < contentMap.length) {
            if (string2.equalsIgnoreCase(contentMap[n2][0])) {
                return contentMap[n2][1];
            }
            ++n2;
        }
        return "unknown";
    }
}

