/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Box;
import ice.htmlbrowser.BoxLineBreak;
import ice.htmlbrowser.BoxTable;
import ice.htmlbrowser.BoxWord;
import ice.htmlbrowser.DocumentFrame;
import ice.htmlbrowser.VisControlPoint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

class VisDocument
implements Runnable {
    private int visWidth;
    private int startWidth;
    private int numBoxes;
    private int newStartWidth;
    private int newVisWidth;
    private Box firstBox;
    private Box newFirstBox;
    private Vector controlPoints = new Vector();
    private Thread layoutThread;
    private DocumentFrame observer = null;
    private int marginWidth;
    private int marginHeight;
    private Dimension docNormalSize = new Dimension(0, 0);
    private Dimension docMinSize = null;
    private static boolean flagFullLayout = true;
    private boolean start_flag = false;
    private boolean stop_flag = false;
    private Box firstVisBox;
    private int startDragX = -1;
    private int startDragY = -1;
    private Box prevStartBox;
    private Box prevEndBox;
    private boolean skip_sel_tables = true;
    private int str_x;
    private int str_start_x;
    private int str_y;
    private boolean str_underline = false;
    private boolean str_strikeout = false;
    private boolean str_selected = false;
    private Font str_font;
    private Color str_color;
    private String str_buf;

    VisDocument() {
    }

    VisDocument(DocumentFrame documentFrame, int n, int n2) {
        this();
        this.marginWidth = n;
        this.marginHeight = n2;
        this.observer = documentFrame;
        this.layoutThread = new Thread((Runnable)this, "visdoc");
        this.layoutThread.setPriority(5);
        this.layoutThread.start();
    }

    void stopThread() {
        if (this.layoutThread != null) {
            this.stop_flag = true;
            this.start_flag = true;
            VisDocument visDocument = this;
            synchronized (visDocument) {
                this.notify();
            }
            try {
                this.layoutThread.join();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            this.layoutThread = null;
        }
    }

    void doLayout(Box box, int n, int n2, int n3) {
        if (n == 0) {
            if (this.observer != null) {
                this.observer.finalDocumentDimension(false);
            }
            return;
        }
        if (n2 == this.visWidth && n == this.numBoxes && !flagFullLayout) {
            if (this.observer != null) {
                this.observer.finalDocumentDimension(false);
            }
            return;
        }
        if (n2 == 0 && n == this.numBoxes && this.docMinSize != null && !flagFullLayout) {
            this.visWidth = n2;
            this.docNormalSize = new Dimension(this.docMinSize);
            return;
        }
        this.newFirstBox = box;
        this.newVisWidth = n2;
        this.newStartWidth = n3;
        if (this.observer != null && this.layoutThread != null) {
            this.start_flag = true;
            this.observer.firstDocumentDimension();
            VisDocument visDocument = this;
            synchronized (visDocument) {
                this.notify();
                return;
            }
        }
        this.firstBox = box;
        this.visWidth = n2;
        this.startWidth = n3;
        this.layoutBoxes();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        ** GOTO lbl19
        {
            var1_1 = this;
            synchronized (var1_1) {
                try {
                    this.wait();
                }
                catch (InterruptedException v0) {}
            }
            do {
                if (!this.start_flag && !this.stop_flag) continue block5;
                this.firstBox = this.newFirstBox;
                this.visWidth = this.newVisWidth;
                this.startWidth = this.newStartWidth;
                this.start_flag = false;
                this.layoutBoxes();
lbl19:
                // 2 sources

            } while (!this.stop_flag);
        }
    }

    private Box getNextBox(Box box) {
        if (box.getNext() == null) {
            if (this.observer == null) {
                return null;
            }
            if (!(this.observer.isParsingDone() || this.start_flag || this.stop_flag)) {
                VisDocument visDocument = this;
                synchronized (visDocument) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            box = box.getNext();
        } else {
            box = box.getNext();
        }
        return box;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void layoutBoxes() {
        int n;
        int n2;
        Box box;
        this.controlPoints.removeAllElements();
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.startWidth;
        int n8 = this.marginHeight;
        int n9 = this.marginHeight;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        Box box2 = box = this.firstBox;
        Box box3 = null;
        int n15 = 0;
        this.numBoxes = 0;
        while (box != null && !this.start_flag && !this.stop_flag) {
            block55: {
                int n16;
                if (box2 != box && (box.isBreakable() || box3 == null && box2 instanceof BoxLineBreak)) {
                    box3 = box;
                    n15 = n6;
                }
                if (n9 >= n13) {
                    n11 = 0;
                }
                if (n9 >= n14) {
                    n12 = 0;
                }
                if ((n2 = this.visWidth - n11 - n12 - n10 - this.marginWidth * 2) <= 0 && (n13 > n9 || n14 > n9)) {
                    int n17 = n9;
                    if (n13 > n17) {
                        n17 = n13;
                    }
                    if (n14 > n17) {
                        n17 = n14;
                    }
                    n9 = n17;
                    n2 = this.visWidth - n10 - this.marginWidth * 2;
                    n12 = 0;
                    n11 = 0;
                }
                box.layout(n2, box2 == box);
                Dimension dimension = box.size();
                int n18 = box.getAttrib();
                if (n6 > 0 && box3 != null && (box instanceof BoxLineBreak || n6 + dimension.width > n2)) {
                    int n19;
                    n = n11 + n10 + this.marginWidth;
                    if (n15 < n2) {
                        if (n3 == 2) {
                            n += (n2 - n15) / 2;
                        } else if (n3 == 3) {
                            n += n2 - n15;
                        }
                    }
                    Box box4 = box2;
                    while (box4 != box3 && box4 != null) {
                        n19 = n9 + n5 - box4.getBaseLine();
                        box4.move(n, n19);
                        n += box4.size().width;
                        box4 = box4.getNext();
                    }
                    if ((n9 += n4) > n8) {
                        n8 = n9;
                    }
                    n6 -= n15;
                    n5 = 0;
                    n4 = 0;
                    box2 = box3;
                    box3.layout(n2, true);
                    box3 = null;
                    if (n9 >= n13) {
                        n11 = 0;
                    }
                    if (n9 >= n14) {
                        n12 = 0;
                    }
                    if ((n2 = this.visWidth - n11 - n12 - n10 - this.marginWidth * 2) <= 0 && (n13 > n9 || n14 > n9)) {
                        n19 = n9;
                        if (n13 > n19) {
                            n19 = n13;
                        }
                        if (n14 > n19) {
                            n19 = n14;
                        }
                        n9 = n19;
                        n2 = this.visWidth - n10 - this.marginWidth * 2;
                        n12 = 0;
                        n11 = 0;
                    }
                    dimension = box.size();
                }
                switch (n18) {
                    case 1: 
                    case 2: 
                    case 3: {
                        n3 = n18;
                        break;
                    }
                    case 9: {
                        n2 = this.visWidth - n11 - n12 - (n10 += 40) - this.marginWidth * 2;
                        box.layout(n2, box2 == box);
                        dimension = box.size();
                        break;
                    }
                    case 10: {
                        n2 = this.visWidth - n11 - n12 - (n10 -= 40) - this.marginWidth * 2;
                        box.layout(n2, box2 == box);
                        dimension = box.size();
                        break;
                    }
                    case 11: {
                        if (n10 <= 0) break;
                        n = this.marginWidth + n11 + n10 - dimension.width;
                        if (n < this.marginWidth) {
                            n = this.marginWidth;
                        }
                        box.move(n, n9);
                        box2 = this.getNextBox(box);
                        box3 = null;
                        this.makeControlPoint(box, this.numBoxes, n9 + dimension.height);
                        break block55;
                    }
                    case 4: {
                        box.move(n11 + this.marginWidth, n9);
                        if (dimension.width < this.visWidth - this.marginWidth * 2 - n11) {
                            n11 += dimension.width;
                            n8 = n13 = n9 + dimension.height;
                        } else {
                            if (n7 < dimension.width) {
                                n7 = dimension.width;
                            }
                            if (n8 < (n9 += dimension.height)) {
                                n8 = n9;
                            }
                        }
                        box2 = this.getNextBox(box);
                        box3 = null;
                        this.makeControlPoint(box, this.numBoxes, n9 + dimension.height);
                        break block55;
                    }
                    case 5: {
                        if (dimension.width < this.visWidth - this.marginWidth * 2) {
                            box.move(this.visWidth - dimension.width - this.marginWidth, n9);
                            n12 = dimension.width;
                            n8 = n14 = n9 + dimension.height;
                        } else {
                            box.move(this.marginWidth, n9);
                            if (n7 < dimension.width) {
                                n7 = dimension.width;
                            }
                            if (n8 < (n9 += dimension.height)) {
                                n8 = n9;
                            }
                        }
                        box2 = this.getNextBox(box);
                        box3 = null;
                        this.makeControlPoint(box, this.numBoxes, n9 + dimension.height);
                        break block55;
                    }
                    case 6: {
                        if (n13 <= n9) break;
                        n9 = n13;
                        break;
                    }
                    case 7: {
                        if (n14 <= n9) break;
                        n9 = n14;
                        break;
                    }
                    case 8: {
                        n = n9;
                        if (n13 > n) {
                            n = n13;
                        }
                        if (n14 > n) {
                            n = n14;
                        }
                        n9 = n;
                    }
                }
                n = box.getBaseLine() - n5;
                if (n > 0) {
                    n5 += n;
                    n4 += n;
                    n = 0;
                }
                if ((n += dimension.height) > n4) {
                    n4 = n;
                }
                if (!(box instanceof BoxLineBreak) && n7 < (n16 = (n6 += dimension.width) + n11 + n10 + this.marginWidth * 2)) {
                    n7 = n16;
                }
                if (this.observer != null) {
                    this.observer.updateDocumentDimension(n7, n9);
                    Thread.yield();
                }
                this.makeControlPoint(box, this.numBoxes, n9 + dimension.height);
            }
            box = this.getNextBox(box);
            ++this.numBoxes;
        }
        if (n6 > 0) {
            n2 = this.visWidth - n11 - n12 - n10 - this.marginWidth * 2;
            int n20 = n11 + n10 + this.marginWidth;
            if (n6 < n2) {
                if (n3 == 2) {
                    n20 += (n2 - n6) / 2;
                } else if (n3 == 3) {
                    n20 += n2 - n6;
                }
            }
            Box box5 = box2;
            while (box5 != box) {
                n = n9 + n5 - box5.getBaseLine();
                box5.move(n20, n);
                n20 += box5.size().width;
                box5 = box5.getNext();
            }
            if ((n9 += n4) > n8) {
                n8 = n9;
            }
        }
        if (this.start_flag || this.stop_flag) {
            return;
        }
        this.docNormalSize = new Dimension(n7, n8 += this.marginHeight);
        if (this.visWidth == 0) {
            this.docMinSize = new Dimension(this.docNormalSize);
        }
        if (this.observer != null) {
            this.observer.finalDocumentDimension(true);
        }
        flagFullLayout = false;
    }

    void prepareFullLayout() {
        flagFullLayout = true;
    }

    Dimension minMaxLayout(Box box) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (box != null) {
            if (box.getAttrib() == 9) {
                n += 40;
            } else if (box.getAttrib() == 10) {
                n -= 40;
            }
            if (box instanceof BoxLineBreak) {
                if (n3 < n5 + n) {
                    n3 = n5 + n;
                }
                n5 = 0;
                if (n2 < n4 + n) {
                    n2 = n4 + n;
                }
                n4 = 0;
            } else {
                int n6;
                if (box instanceof BoxTable) {
                    Dimension dimension = ((BoxTable)box).minMaxLayout();
                    n5 += dimension.height;
                    n6 = dimension.width;
                } else {
                    box.layout(0, n5 == 0);
                    n6 = box.size().width;
                    n5 += n6;
                }
                if (box.isBreakable()) {
                    if (n2 < n4 + n) {
                        n2 = n4 + n;
                    }
                    n4 = n6;
                } else {
                    n4 += n6;
                }
            }
            box = box.getNext();
        }
        if (n4 + n > n2) {
            n2 = n4 + n;
        }
        if (n5 + n > n3) {
            n3 = n5 + n;
        }
        return new Dimension(n2, n3);
    }

    synchronized Dimension docSize() {
        return new Dimension(this.docNormalSize);
    }

    private void makeControlPoint(Box box, int n, int n2) {
        int n3 = this.controlPoints.size() * 100;
        while (n2 > n3) {
            this.controlPoints.addElement(new VisControlPoint(box, n));
            n3 += 100;
        }
    }

    private int findFirstVisBox(int n) {
        Box box = this.firstBox;
        int n2 = 0;
        if ((n /= 100) >= 0 && n < this.controlPoints.size()) {
            VisControlPoint visControlPoint = (VisControlPoint)this.controlPoints.elementAt(n);
            box = visControlPoint.getBox();
            n2 = visControlPoint.getBoxIndex();
        }
        while (box != null) {
            if (box.location().y + box.size().height > n) break;
            box = box.getNext();
            ++n2;
        }
        this.firstVisBox = box;
        return n2;
    }

    private Box findBoxAt(int n, int n2, int n3, boolean bl) {
        int n4 = this.findFirstVisBox(n2 - n3);
        Box box = this.firstVisBox;
        Box box2 = null;
        Box box3 = null;
        Box box4 = this.firstVisBox;
        boolean bl2 = false;
        int n5 = 0;
        while (box != null && n4 < this.numBoxes && box2 == null) {
            Point point = box.location();
            Dimension dimension = box.size();
            if (n5 > point.x) {
                if (bl2) break;
                bl2 = true;
            }
            if (n2 >= point.y) {
                if (n2 < point.y + dimension.height) {
                    if (box3 == null || n > point.x) {
                        box3 = box;
                    }
                    if (n >= point.x && n < point.x + dimension.width) {
                        box2 = box;
                    }
                }
                box4 = box;
                bl2 = false;
            }
            box = box.getNext();
            ++n4;
        }
        if (box2 == null && !bl) {
            if (box3 != null) {
                return box3;
            }
            return box4;
        }
        return box2;
    }

    void setDragStart(Box box) {
        Point point = box.location();
        this.startDragX = point.x + 1;
        this.startDragY = point.y + 1;
        this.prevStartBox = this.prevEndBox = box;
    }

    Box mouseClicked(int n, int n2) {
        return this.mouseClicked(n, n2, 0);
    }

    Box mouseClicked(int n, int n2, int n3) {
        Box box;
        if (this.startDragX >= 0) {
            if (Math.abs(this.startDragX - n) >= 3 || Math.abs(this.startDragY - n2) >= 3) {
                this.startDragX = -1;
                return null;
            }
            this.startDragX = -1;
        }
        if ((box = this.findBoxAt(n, n2, n3, true)) != null) {
            Point point = box.location();
            return box.mouseClicked(n - point.x, n2 - point.y);
        }
        return null;
    }

    Box mouseMoved(int n, int n2) {
        return this.mouseMoved(n, n2, 0);
    }

    Box mouseMoved(int n, int n2, int n3) {
        this.startDragX = -1;
        Box box = this.findBoxAt(n, n2, n3, true);
        if (box != null) {
            Point point = box.location();
            return box.mouseMoved(n - point.x, n2 - point.y);
        }
        return null;
    }

    void mouseDragged(int n, int n2) {
        this.skip_sel_tables = false;
        this.mouseDragged(n, n2, 0);
        this.skip_sel_tables = true;
    }

    void mouseDragged(int n, int n2, int n3) {
        Object object;
        Box box;
        if (this.startDragX < 0) {
            this.startDragX = n;
            this.startDragY = n2;
            this.prevEndBox = null;
            this.prevStartBox = null;
            return;
        }
        if (Math.abs(this.startDragX - n) < 3 && Math.abs(this.startDragY - n2) < 3) {
            return;
        }
        int n4 = this.startDragX;
        int n5 = this.startDragY;
        int n6 = n;
        int n7 = n2;
        if (n2 < this.startDragY) {
            n4 = n;
            n5 = n2;
            n6 = this.startDragX;
            n7 = this.startDragY;
        }
        Box box2 = this.findBoxAt(n4, n5, n3, false);
        Box box3 = this.findBoxAt(n6, n7, n3, false);
        if (box2 == null) {
            return;
        }
        int n8 = box2.getAttrib();
        int n9 = 0;
        if (box3 != null) {
            n9 = box3.getAttrib();
        }
        if (n8 == 4 || n8 == 5 || n9 == 4 || n9 == 5) {
            return;
        }
        if (box3 != null && box2 != null) {
            box = box2;
            while (box != null && box != box3) {
                box = box.getNext();
            }
            if (box == null) {
                box = box3;
                box3 = box2;
                box2 = box;
            }
        }
        if (!this.skip_sel_tables && box2 instanceof BoxTable) {
            box = box2.getNext();
            while (box != null && (this.prevStartBox != null || this.prevEndBox != null)) {
                if (box == this.prevStartBox) {
                    this.prevStartBox = null;
                }
                object = box.location();
                if (box3 == null && ((Point)object).y > n7 || box3 != null && box == box3.getNext()) break;
                box = box.getNext();
            }
        }
        box = box2;
        while (box != null) {
            object = box.location();
            if (box3 == null && ((Point)object).y > n7 || box3 != null && box == box3.getNext()) break;
            if (!this.skip_sel_tables && box instanceof BoxTable) {
                BoxTable boxTable = (BoxTable)box;
                int n10 = n - box.location().x;
                int n11 = n2 - box.location().y;
                if (box.getAttrib() != 4 && box.getAttrib() != 5) {
                    if (box == box2 && box == box3) {
                        boxTable.mouseDragged(n10, n11);
                    } else if (box == box2) {
                        if (n4 == n && n5 == n2) {
                            if (this.prevStartBox == null) {
                                boxTable.mouseMoved(-1, -1);
                                boxTable.selectTo(true);
                            } else if (this.prevStartBox != box) {
                                boxTable.mouseMoved(-1, -1);
                                boxTable.selectTo(true);
                                boxTable.selectTo(false);
                            }
                            boxTable.mouseDragged(n10, n11);
                        } else {
                            boxTable.selectTo(true);
                        }
                    } else if (box == box3) {
                        if (n6 == n && n7 == n2) {
                            if (this.prevEndBox == null) {
                                boxTable.mouseMoved(-1, -1);
                                boxTable.selectTo(false);
                            } else if (this.prevEndBox != box) {
                                boxTable.mouseMoved(-1, -1);
                                boxTable.selectTo(false);
                                boxTable.selectTo(true);
                            }
                            boxTable.mouseDragged(n10, n11);
                        } else {
                            boxTable.selectTo(false);
                        }
                    } else if (box == this.prevStartBox) {
                        boxTable.selectTo(false);
                    } else if (box == this.prevEndBox) {
                        boxTable.selectTo(true);
                    } else {
                        box.setSelected(true);
                    }
                }
            } else {
                box.setSelected(true);
            }
            if (box == this.prevStartBox) {
                this.prevStartBox = null;
            }
            if (box == this.prevEndBox) {
                this.prevEndBox = null;
            }
            box = box.getNext();
        }
        if (box != null && box3 == null) {
            box3 = box;
        }
        if (this.prevStartBox != null) {
            box = this.prevStartBox;
            while (box != null && box != box2) {
                box = box.getNext();
            }
            if (box == box2) {
                box = this.prevStartBox;
                while (box != null && box != box2) {
                    box.setSelected(false);
                    box = box.getNext();
                }
            }
        }
        if (this.prevEndBox != null && box3 != null && this.prevEndBox != box3) {
            box = box3;
            while (box != null && box != this.prevEndBox) {
                box = box.getNext();
            }
            if (box == this.prevEndBox) {
                box = box3.getNext();
                object = this.prevEndBox.getNext();
                while (box != object) {
                    box.setSelected(false);
                    box = box.getNext();
                }
            }
        }
        this.prevStartBox = box2;
        this.prevEndBox = box3;
    }

    void paint(Graphics graphics, int n, int n2) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            return;
        }
        int n3 = rectangle.x + n;
        int n4 = n3 + rectangle.width;
        int n5 = rectangle.y + n2;
        int n6 = n5 + rectangle.height;
        int n7 = this.observer == null ? this.findFirstVisBox(rectangle.y) : this.findFirstVisBox(n5);
        Box box = this.firstVisBox;
        boolean bl = false;
        int n8 = 0;
        graphics.translate(-n, -n2);
        while (box != null && n7 < this.numBoxes) {
            Point point = box.location();
            box.size();
            if (n8 > point.x) {
                if (bl) break;
                bl = true;
            }
            n8 = point.x;
            if (point.y < n6) {
                bl = false;
                if (point.x < n4 && point.x + box.size().width > n3) {
                    if (box instanceof BoxWord) {
                        ((BoxWord)box).paint(graphics, this);
                    } else {
                        this.flushString(graphics);
                        Graphics graphics2 = graphics.create();
                        graphics2.translate(point.x, point.y);
                        box.paint(graphics2);
                        graphics2.dispose();
                    }
                }
            }
            box = box.getNext();
            ++n7;
        }
        this.flushString(graphics);
        graphics.translate(n, n2);
    }

    void drawString(Graphics graphics, String string, Font font, Color color, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (this.str_x != n || this.str_y != n2 || this.str_buf == null || this.str_underline != bl || this.str_strikeout != bl2 || this.str_selected != bl3 || this.str_font != font || this.str_color != color) {
            this.flushString(graphics);
            this.str_start_x = n;
            this.str_x = n + n3;
            this.str_y = n2;
            this.str_buf = string;
            this.str_font = font;
            this.str_color = color;
            this.str_underline = bl;
            this.str_strikeout = bl2;
            this.str_selected = bl3;
            return;
        }
        this.str_buf = String.valueOf(this.str_buf) + string;
        this.str_x += n3;
    }

    private void flushString(Graphics graphics) {
        if (this.str_buf != null) {
            graphics.setFont(this.str_font);
            graphics.setColor(this.str_color);
            graphics.drawString(this.str_buf, this.str_start_x, this.str_y);
            if (this.str_underline) {
                graphics.drawLine(this.str_start_x, this.str_y + 1, this.str_x, this.str_y + 1);
                this.str_underline = false;
            }
            if (this.str_strikeout) {
                graphics.drawLine(this.str_start_x, this.str_y - 4, this.str_x, this.str_y - 4);
                this.str_strikeout = false;
            }
            this.str_buf = null;
        }
    }
}

