/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Browser;
import ice.htmlbrowser.BrowserTools;
import ice.htmlbrowser.Document;
import ice.htmlbrowser.DocumentFrame;
import ice.htmlbrowser.FontInfo;
import ice.htmlbrowser.FrameHistory;
import ice.htmlbrowser.LexCache;
import ice.htmlbrowser.LexCacheCell;
import ice.htmlbrowser.MouseOverLinkEvent;
import ice.htmlbrowser.Queue;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

class FrameInfo {
    private Stack framesetStack = new Stack();
    private boolean isFrameset;
    private String name;
    private Document parent;
    private URL baseURL;
    private URL prevURL;
    private boolean baseChangeFlag = false;
    private int frameNameCounter;
    private String progress = "_self 0 0";
    private DocumentFrame doc;
    private int marginWidth = 10;
    private int marginHeight = 10;
    private int[] colValues = new int[]{100};
    private int[] colTypes = new int[]{1};
    private int[] rowValues = new int[]{100};
    private int[] rowTypes = new int[]{1};
    private Vector frames = new Vector();

    FrameInfo(Document document, String string) {
        this.parent = document;
        this.name = string;
        this.isFrameset = true;
    }

    private FrameInfo(Document document, String string, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.parent = document;
        this.name = string;
        this.colValues = nArray;
        this.colTypes = nArray2;
        this.rowValues = nArray3;
        this.rowTypes = nArray4;
        this.isFrameset = true;
    }

    private FrameInfo(Document document, String string, String string2, String string3, int n, int n2, int n3) {
        this.parent = document;
        this.name = string2;
        this.isFrameset = false;
        this.doc = new DocumentFrame(this, n3);
        document.add(this.doc);
        this.marginWidth = n;
        this.marginHeight = n2;
        this.htmlAppend(string, string3);
    }

    void addNames(Vector vector) {
        vector.addElement(this.name);
        if (this.isFrameset) {
            if (this.frames.size() < 1) {
                return;
            }
            int n = 0;
            while (n < this.frames.size()) {
                ((FrameInfo)this.frames.elementAt(n)).addNames(vector);
                ++n;
            }
        }
    }

    void save(Queue queue) {
        if (this.isFrameset) {
            if (this.frames.size() < 1) {
                return;
            }
            FrameHistory frameHistory = new FrameHistory(this.getDocumentBaseString(), this.name, this.colValues, this.colTypes, this.rowValues, this.rowTypes, this.frames.size());
            queue.push(frameHistory);
            int n = 0;
            while (n < this.frames.size()) {
                ((FrameInfo)this.frames.elementAt(n)).save(queue);
                ++n;
            }
            return;
        }
        FrameHistory frameHistory = new FrameHistory(this.getDocumentBaseString(), this.name, this.doc.getScrollPosition());
        queue.push(frameHistory);
    }

    void restore(Queue queue) {
        if (queue.empty()) {
            return;
        }
        FrameHistory frameHistory = (FrameHistory)queue.pop();
        queue.push(frameHistory);
        this.name = frameHistory.name;
        if (frameHistory.isFrameset) {
            if (!this.isFrameset || frameHistory.numSubFrames != this.frames.size() || !frameHistory.loc.equals(this.getDocumentBaseString())) {
                this.removeFrames();
                this.isFrameset = true;
                this.colValues = frameHistory.colValues;
                this.colTypes = frameHistory.colTypes;
                this.rowValues = frameHistory.rowValues;
                this.rowTypes = frameHistory.rowTypes;
                try {
                    this.setDocumentBaseString(frameHistory.loc);
                }
                catch (MalformedURLException malformedURLException) {}
                int n = 0;
                while (n < frameHistory.numSubFrames) {
                    FrameInfo frameInfo = new FrameInfo(this.parent, "temp");
                    this.frames.addElement(frameInfo);
                    frameInfo.restore(queue);
                    ++n;
                }
                return;
            }
            int n = 0;
            while (n < this.frames.size()) {
                ((FrameInfo)this.frames.elementAt(n)).restore(queue);
                ++n;
            }
            return;
        }
        this.setCurrentLocation(frameHistory.loc, null, frameHistory.pos);
    }

    FrameInfo findFrame(String string) {
        if (string.equals(this.name)) {
            return this;
        }
        FrameInfo frameInfo = null;
        if (this.isFrameset) {
            int n = this.frames.size();
            int n2 = 0;
            while (n2 < n && frameInfo == null) {
                frameInfo = (FrameInfo)this.frames.elementAt(n2);
                frameInfo = frameInfo.findFrame(string);
                ++n2;
            }
        }
        return frameInfo;
    }

    FontInfo getFontInfo() {
        return this.parent.getFontInfo();
    }

    String getEncoding() {
        return this.parent.getEncoding();
    }

    String getName() {
        return this.name;
    }

    void setDocumentTitle(String string) {
        if ("_top".equals(this.name)) {
            this.parent.setDocumentTitle(string);
        }
    }

    URL getDocumentBase() {
        return this.baseURL;
    }

    void setDocumentBase(URL uRL) {
        this.baseURL = uRL;
        this.baseChangeFlag = true;
        if ("_top".equals(this.name)) {
            this.parent.firePropertyChange("documentBase", null, this.getDocumentBaseString());
        }
        this.baseChangeFlag = false;
    }

    String getDocumentBaseString() {
        if (this.baseURL == null) {
            return "";
        }
        return this.baseURL.toString();
    }

    void setDocumentBaseString(String string) throws MalformedURLException {
        if (this.baseChangeFlag) {
            return;
        }
        this.prevURL = this.baseURL;
        this.baseURL = this.baseURL == null ? new URL(string) : new URL(this.baseURL, string);
        this.setDocumentBase(this.baseURL);
    }

    void restart() {
        this.removeFrames();
        this.isFrameset = true;
    }

    private void setCurrentLocation(String string, String string2, Point point) {
        if (this.isFrameset) {
            this.htmlAppend(string, string2);
            if (point != null) {
                this.doc.setWaitForPos(point);
            }
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(this.baseURL, string);
        }
        catch (MalformedURLException malformedURLException) {}
        if (string2 == null && BrowserTools.sameFile(uRL, this.baseURL)) {
            this.prevURL = this.baseURL;
            this.setDocumentBase(uRL);
            this.doc.setWaitForRef(this.baseURL);
            if (point != null) {
                this.doc.setWaitForPos(point);
            }
            this.doc.finalDocumentDimension(false);
            return;
        }
        this.htmlClear();
        this.htmlAppend(string, string2);
        if (point != null) {
            this.doc.setWaitForPos(point);
        }
    }

    void setCurrentLocation(String string, String string2) {
        this.setCurrentLocation(string, string2, null);
    }

    void htmlClear() {
        if (this.isFrameset) {
            this.removeFrames();
            this.isFrameset = false;
            this.doc = new DocumentFrame(this, 0);
            this.parent.add(this.doc);
            this.parent.validate();
        } else {
            this.doc.htmlEndDocument();
            this.doc.htmlBeginDocument();
        }
        this.setDocumentTitle("empty");
    }

    void dispose() {
        this.removeFrames();
    }

    void htmlAppend(String string) {
        if (this.isFrameset) {
            this.htmlClear();
        }
        this.doc.htmlAppend(new StringReader(string), "text/html", string.length());
    }

    void htmlAppend(Reader reader, String string) {
        if (this.isFrameset) {
            this.htmlClear();
        }
        this.doc.htmlAppend(reader, string, -1);
    }

    void htmlAppend(String string, String string2) {
        LexCacheCell lexCacheCell;
        if (this.isFrameset) {
            this.htmlClear();
        }
        try {
            this.setDocumentBaseString(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.htmlAppend("Malformed URL :" + string + "<br>cannot load");
            return;
        }
        this.setDocumentTitle(this.getDocumentBaseString());
        LexCache lexCache = Browser.getLexCache();
        if (lexCache != null && this.baseURL != null && string2 == null && (lexCacheCell = lexCache.getCachedURL(this.baseURL)) != null) {
            this.doc.htmlAppend(lexCacheCell, lexCacheCell.getMimeType(), lexCacheCell.getLength());
            this.doc.setWaitForRef(this.baseURL);
            return;
        }
        this.doc.htmlAppend(this.baseURL, string2);
    }

    void htmlWait(boolean bl) {
        if (this.doc != null) {
            this.doc.htmlWait(bl);
        }
    }

    void htmlInterrupt() {
        if (this.doc != null) {
            this.doc.htmlInterrupt();
        }
    }

    void printDoc(PrintJob printJob) {
        if (!this.isFrameset && this.doc != null) {
            this.doc.printDoc(printJob);
        }
    }

    void setScrollPosition(int n, int n2) {
        if (!this.isFrameset && this.doc != null) {
            this.doc.setScrollPosition(n, n2);
        }
    }

    Point getScrollPosition() {
        if (!this.isFrameset && this.doc != null) {
            return this.doc.getScrollPosition();
        }
        return new Point(0, 0);
    }

    Dimension getDocumentSize() {
        if (!this.isFrameset && this.doc != null) {
            return this.doc.getDocumentSize();
        }
        return new Dimension(0, 0);
    }

    Dimension getViewportSize() {
        if (!this.isFrameset && this.doc != null) {
            return this.doc.getViewportSize();
        }
        return new Dimension(0, 0);
    }

    void parseBeginFrameset(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        FrameInfo frameInfo = this;
        if (!this.framesetStack.empty()) {
            frameInfo = (FrameInfo)this.framesetStack.peek();
        }
        FrameInfo frameInfo2 = new FrameInfo(this.parent, this.makeFrameName(frameInfo), nArray, nArray2, nArray3, nArray4);
        this.framesetStack.push(frameInfo2);
    }

    void parseEndFrameset() {
        if (!this.framesetStack.empty()) {
            FrameInfo frameInfo = (FrameInfo)this.framesetStack.pop();
            if (!this.framesetStack.empty()) {
                FrameInfo frameInfo2 = (FrameInfo)this.framesetStack.peek();
                frameInfo2.addFrame(frameInfo);
                return;
            }
            if (this.isFrameset) {
                this.removeFrames();
            }
            this.isFrameset = true;
            this.frames.addElement(frameInfo);
            if (this.doc != null) {
                this.parent.remove(this.doc);
                DocumentFrame documentFrame = this.doc;
                this.doc = null;
                this.parent.validate();
                documentFrame.htmlEndDocument();
            }
        }
    }

    void parseAddFrame(String string, String string2, int n, int n2, int n3) {
        FrameInfo frameInfo = this;
        if (!this.framesetStack.empty()) {
            frameInfo = (FrameInfo)this.framesetStack.peek();
        }
        try {
            if (n3 < 0) {
                n3 = 0;
            }
            if (n >= 0 || n2 >= 0) {
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
            } else {
                n2 = 10;
                n = 10;
            }
            URL uRL = new URL(this.getDocumentBase(), string);
            if (frameInfo.frames.size() >= frameInfo.colValues.length * frameInfo.rowValues.length) {
                return;
            }
            if (string2 == null) {
                string2 = this.makeFrameName(frameInfo);
            }
            FrameInfo frameInfo2 = new FrameInfo(this.parent, uRL.toString(), string2, null, n, n2, n3);
            frameInfo.addFrame(frameInfo2);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
    }

    private void addFrame(FrameInfo frameInfo) {
        if (!this.isFrameset) {
            return;
        }
        if (this.frames.size() < this.colValues.length * this.rowValues.length) {
            this.frames.addElement(frameInfo);
        }
    }

    private void removeFrames() {
        if (this.isFrameset) {
            int n = this.frames.size();
            int n2 = 0;
            while (n2 < n) {
                FrameInfo frameInfo = (FrameInfo)this.frames.elementAt(n2);
                frameInfo.removeFrames();
                ++n2;
            }
            this.frames = new Vector();
        } else if (this.doc != null) {
            this.doc.htmlEndDocument();
            this.parent.remove(this.doc);
            this.doc = null;
        }
        this.frameNameCounter = 0;
    }

    void doLayout(int n, int n2, int n3, int n4) {
        if (this.isFrameset) {
            this.doLayoutFrameset(n, n2, n3, n4);
            return;
        }
        this.doLayoutFrame(n, n2, n3, n4);
    }

    private void doLayoutFrame(int n, int n2, int n3, int n4) {
        if (this.doc != null) {
            this.doc.setBounds(n, n2, n3, n4);
        }
    }

    private void doLayoutFrameset(int n, int n2, int n3, int n4) {
        int n5;
        int[] nArray = new int[this.colValues.length];
        int[] nArray2 = new int[this.rowValues.length];
        int n6 = n3;
        int n7 = 0;
        int n8 = 0;
        while (n8 < this.colValues.length) {
            if (this.colTypes[n8] == 1) {
                n5 = this.colValues[n8] * n3 / 100;
                n6 -= n5;
                nArray[n8] = n5;
            } else if (this.colTypes[n8] == 2) {
                n7 += this.colValues[n8];
                nArray[n8] = 0;
            } else {
                n6 -= this.colValues[n8];
                nArray[n8] = this.colValues[n8];
            }
            ++n8;
        }
        if (n6 > 0 && n7 > 0) {
            n8 = 0;
            while (n8 < this.colValues.length) {
                if (this.colTypes[n8] == 2) {
                    nArray[n8] = n6 * this.colValues[n8] / n7;
                }
                ++n8;
            }
        } else if (n6 != 0) {
            n8 = 0;
            while (n8 < this.colValues.length) {
                int n9 = n8;
                nArray[n9] = nArray[n9] + n6 * nArray[n8] / (n3 - n6);
                ++n8;
            }
        }
        n6 = n4;
        n7 = 0;
        n8 = 0;
        while (n8 < this.rowValues.length) {
            if (this.rowTypes[n8] == 1) {
                n5 = this.rowValues[n8] * n4 / 100;
                n6 -= n5;
                nArray2[n8] = n5;
            } else if (this.rowTypes[n8] == 2) {
                n7 += this.rowValues[n8];
                nArray2[n8] = 0;
            } else {
                n6 -= this.rowValues[n8];
                nArray2[n8] = this.rowValues[n8];
            }
            ++n8;
        }
        if (n6 > 0 && n7 > 0) {
            n8 = 0;
            while (n8 < this.rowValues.length) {
                if (this.rowTypes[n8] == 2) {
                    nArray2[n8] = n6 * this.rowValues[n8] / n7;
                }
                ++n8;
            }
        } else if (n6 != 0) {
            n8 = 0;
            while (n8 < this.rowValues.length) {
                int n10 = n8;
                nArray2[n10] = nArray2[n10] + n6 * nArray2[n8] / (n4 - n6);
                ++n8;
            }
        }
        n5 = this.frames.size();
        int n11 = 0;
        int n12 = 0;
        int n13 = n;
        int n14 = n2;
        n8 = 0;
        while (n8 < n5) {
            FrameInfo frameInfo = (FrameInfo)this.frames.elementAt(n8);
            frameInfo.doLayout(n13, n14, nArray[n11], nArray2[n12]);
            n13 += nArray[n11];
            if (++n11 >= nArray.length) {
                n11 = 0;
                n13 = n;
                n14 += nArray2[n12];
                ++n12;
            }
            ++n8;
        }
    }

    int search(int n, String string) {
        if (this.isFrameset) {
            return -1;
        }
        return this.doc.search(n, string);
    }

    String getSelectedText() {
        return this.doc.getSelectedText();
    }

    String getParsingProgress() {
        return this.progress;
    }

    void passParsingProgress(int n, int n2) {
        this.progress = String.valueOf(n) + " " + n2 + " " + this.name;
        this.parent.firePropertyChange("parsingProgress", null, this.progress);
    }

    void passMouseOverLink(int n, String string, String string2, String string3, MouseEvent mouseEvent) {
        Object object;
        if (string2.equals("_self")) {
            string2 = this.name;
        }
        try {
            if (string.startsWith("#")) {
                string = String.valueOf(this.baseURL.getFile()) + string;
            }
            object = new URL(this.baseURL, string);
            string = ((URL)object).toString();
        }
        catch (MalformedURLException malformedURLException) {}
        object = new MouseOverLinkEvent(n, string, string2, string3, mouseEvent);
        this.parent.fireMouseOverLink((MouseOverLinkEvent)object);
    }

    void passScrollPosition() {
        if (this.parent.getCurrentFrame().equals(this.name)) {
            this.parent.firePropertyChange("scrollPosition", null, this.getScrollPosition());
        }
    }

    void showStatus(String string) {
        this.parent.setStatusString(string);
    }

    void processEvent(AWTEvent aWTEvent) {
        this.parent.processEvent(aWTEvent);
    }

    URL getReferer() {
        return this.prevURL;
    }

    int getMarginWidth() {
        return this.marginWidth;
    }

    int getMarginHeight() {
        return this.marginHeight;
    }

    private String makeFrameName(FrameInfo frameInfo) {
        String string = String.valueOf(frameInfo.getName()) + "#" + frameInfo.frameNameCounter;
        ++frameInfo.frameNameCounter;
        return string;
    }
}

