/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BrowserTools;
import ice.htmlbrowser.WindowChoice;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.List;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class FormChoice
extends Button
implements ActionListener,
ItemListener,
MouseListener,
AdjustmentListener,
ComponentListener,
WindowListener {
    private WindowChoice winChoice;
    private List list;
    private Dimension pref;

    FormChoice() {
        super("-----------");
        this.addActionListener(this);
        this.initList();
    }

    public Dimension getPreferredSize() {
        if (this.pref != null) {
            return new Dimension(this.pref);
        }
        Dimension dimension = super.getPreferredSize();
        if (this.getFont() == null) {
            return dimension;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return dimension;
        }
        String[] stringArray = this.list.getItems();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n = fontMetrics.stringWidth(stringArray[n2]);
            if (n > dimension.width) {
                dimension.width = n;
            }
            ++n2;
        }
        dimension.width += 10;
        this.pref = dimension;
        return new Dimension(this.pref);
    }

    private void initList() {
        this.list = new List();
        this.list.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.list.getSelectedItem() != null) {
            this.setLabel(this.list.getSelectedItem());
        }
        this.closeWinChoice();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Dimension dimension = new Dimension(this.getSize().width, this.getFontMetrics(this.getFont()).getHeight() * (this.list.getItemCount() + 1));
        Frame frame = BrowserTools.findFrame(this);
        if (this.winChoice != null && this.winChoice.isShowing()) {
            this.closeWinChoice();
        }
        this.removeActionListener(this);
        if (frame != null) {
            this.winChoice = new WindowChoice(frame, this.getSize(), this.getLocationOnScreen(), dimension);
            this.winChoice.add(this.list);
            this.spy(true);
            if (!this.winChoice.isShowing()) {
                this.winChoice.show();
                this.winChoice.toFront();
            }
        }
    }

    synchronized void add(String string) {
        this.list.add(string);
        if (this.list.getItemCount() == 1) {
            this.select(0);
        }
    }

    int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    synchronized void select(int n) {
        this.list.select(n);
        if (this.list.getSelectedItem() != null) {
            this.setLabel(this.list.getSelectedItem());
        }
    }

    private void closeWinChoice() {
        this.spy(false);
        this.winChoice.dispose();
        this.addActionListener(this);
    }

    private void spy(boolean bl) {
        Frame frame = BrowserTools.findFrame(this);
        if (frame == null) {
            return;
        }
        if (bl) {
            frame.addComponentListener(this);
            frame.addWindowListener(this);
        } else {
            frame.removeComponentListener(this);
            frame.removeWindowListener(this);
        }
        this.spy_r(frame, bl);
    }

    private void spy_r(Component component, boolean bl) {
        if (component == null) {
            return;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this.spy_r(container.getComponent(n2), bl);
                ++n2;
            }
        }
        if (bl) {
            if (component instanceof Scrollbar) {
                ((Scrollbar)component).addAdjustmentListener(this);
                return;
            }
            component.addMouseListener(this);
            return;
        }
        if (component instanceof Scrollbar) {
            ((Scrollbar)component).removeAdjustmentListener(this);
            return;
        }
        component.removeMouseListener(this);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.closeWinChoice();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.closeWinChoice();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.closeWinChoice();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.closeWinChoice();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.closeWinChoice();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.closeWinChoice();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.closeWinChoice();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.closeWinChoice();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

