/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

class FontInfo {
    private Font defaultPropFont;
    private Font defaultFixFont;
    private Font[] fonts;
    private FontMetrics[] fontMetrics;
    private String[] types;
    private int[] styles;
    private int[] f_sizes;
    public static final int NORMAL = 0;
    public static final int FIXED = 1;
    static final int NUM_TYPES = 2;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    static final int NUM_STYLES = 4;
    static final int NUM_SIZES = 7;
    static final int NUM = 56;

    FontInfo() {
        this(new Font("SansSerif", 0, 12), new Font("Monospaced", 0, 12));
    }

    FontInfo(Font font, Font font2) {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.styles = nArray;
        this.f_sizes = new int[]{171, 171, 214, 214, 256, 256, 299, 299, 384, 384, 406, 406, 512, 512};
        if (font != null) {
            this.defaultPropFont = font;
        }
        if (font2 != null) {
            this.defaultFixFont = font2;
        }
        this.fonts = new Font[56];
        this.fontMetrics = new FontMetrics[56];
        this.types = new String[2];
        this.types[0] = this.defaultPropFont.getFamily();
        this.types[1] = this.defaultFixFont.getFamily();
    }

    synchronized Font getPropFont() {
        return this.defaultPropFont;
    }

    synchronized Font getFixFont() {
        return this.defaultFixFont;
    }

    synchronized Font getPropFont(int n, int n2) {
        int n3 = FontInfo.makeFontIdx(0, n2, n);
        return this.getFont(n3);
    }

    synchronized Font getFixFont(int n, int n2) {
        int n3 = FontInfo.makeFontIdx(1, n2, n);
        return this.getFont(n3);
    }

    synchronized Font getFont(int n) {
        if (this.fonts[n] == null) {
            this.buildFont(n);
        }
        return this.fonts[n];
    }

    synchronized FontMetrics getFontMetrics(int n) {
        if (this.fonts[n] == null) {
            this.buildFont(n);
        }
        return this.fontMetrics[n];
    }

    private void buildFont(int n) {
        int n2 = this.f_sizes[FontInfo.getSize(n) * 2 + FontInfo.getType(n)];
        n2 = FontInfo.getType(n) == 0 ? (n2 *= this.defaultPropFont.getSize()) : (n2 *= this.defaultFixFont.getSize());
        this.fonts[n] = new Font(this.types[FontInfo.getType(n)], this.styles[FontInfo.getStyle(n)], n2 /= 256);
        this.fontMetrics[n] = Toolkit.getDefaultToolkit().getFontMetrics(this.fonts[n]);
    }

    static int getSize(int n) {
        return n %= 7;
    }

    static int getStyle(int n) {
        n /= 7;
        return n %= 4;
    }

    static int getType(int n) {
        n /= 28;
        return n %= 2;
    }

    static int makeFontIdx(int n, int n2, int n3) {
        return (n * 4 + n2) * 7 + n3;
    }

    static int setType(int n, int n2) {
        if (n2 < 0 || n2 >= 2) {
            return n;
        }
        return FontInfo.makeFontIdx(n2, FontInfo.getStyle(n), FontInfo.getSize(n));
    }

    static int setStyle(int n, int n2) {
        if (n2 < 0 || n2 >= 4) {
            return n;
        }
        return FontInfo.makeFontIdx(FontInfo.getType(n), n2 |= FontInfo.getStyle(n), FontInfo.getSize(n));
    }

    static int setSize(int n, int n2) {
        if (n2 < 0 || n2 >= 7) {
            return n;
        }
        return FontInfo.makeFontIdx(FontInfo.getType(n), FontInfo.getStyle(n), n2);
    }
}

