/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.Document;
import ice.htmlbrowser.FrameInfo;
import ice.htmlbrowser.PrintDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;

class DocumentFrame
extends Panel
implements AdjustmentListener,
KeyListener,
MouseListener,
FocusListener {
    private boolean print_flag = false;
    private boolean cancel_flag = false;
    private Dimension printPage;
    private boolean repaint_flag = false;
    private boolean layoutDone = false;
    private int update_counter;
    private int scrollType = 0;
    private Point waitForPos;
    private URL waitForRef;
    private FrameInfo frame;
    private DocContainer doc;
    private ScrollPane scrollPane;
    private Scrollbar scrollH;
    private Scrollbar scrollV;
    static final int SCROLL_AUTO = 0;
    static final int SCROLL_YES = 1;
    static final int SCROLL_NO = 2;

    DocumentFrame(FrameInfo frameInfo, int n) {
        int n2 = Document.defaultScrollMode;
        if ((n2 & 4) != 0) {
            n = 2;
        }
        this.frame = frameInfo;
        this.scrollType = n;
        this.setLayout(new BorderLayout());
        if ((n2 & 1) != 0) {
            int n3 = 0;
            if (n == 1) {
                n3 = 1;
            } else if (n == 2) {
                n3 = 2;
            }
            this.scrollPane = new ScrollPane(n3);
        } else {
            this.scrollPane = null;
        }
        this.doc = new DocContainer(frameInfo, this);
        if (this.scrollPane == null) {
            this.add("Center", this.doc);
            if (!Document.pJavaMode) {
                this.setHAdjuster(new Scrollbar(0));
                this.setVAdjuster(new Scrollbar(1));
            }
        } else {
            this.scrollPane.add(this.doc);
            this.add("Center", this.scrollPane);
        }
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.doc.addKeyListener(this);
        this.doc.addFocusListener(this);
        this.doc.addMouseListener(this);
    }

    boolean isScrollPane() {
        return this.scrollPane != null;
    }

    void htmlBeginDocument() {
        this.doc.htmlBeginDocument();
        if (this.scrollPane != null) {
            this.scrollPane.setScrollPosition(0, 0);
            return;
        }
        if (this.scrollH != null) {
            if (!this.scrollV.isVisible()) {
                this.scrollV.setVisible(true);
                this.doLayout();
            }
            this.scrollH.setValue(0);
            this.scrollV.setValue(0);
        }
    }

    void htmlEndDocument() {
        this.doc.htmlEndDocument();
    }

    void htmlWait(boolean bl) {
        this.doc.htmlWait(bl);
        if (bl && !Document.frontierMode) {
            while (!this.isLayoutDone()) {
                DocumentFrame documentFrame = this;
                synchronized (documentFrame) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    void htmlInterrupt() {
        this.doc.htmlInterrupt();
    }

    void htmlAppend(Reader reader, String string, int n) {
        this.doc.htmlAppendReader(reader, string, n);
    }

    void htmlAppend(URL uRL, String string) {
        this.doc.htmlAppendURL(uRL, string);
        this.setWaitForRef(uRL);
    }

    void setWaitForRef(URL uRL) {
        if (uRL != null && uRL.getRef() != null) {
            this.waitForRef = uRL;
        }
    }

    void setWaitForPos(Point point) {
        this.waitForPos = point;
    }

    private void setHAdjuster(Scrollbar scrollbar) {
        int n = this.getSize().width;
        if (n < 1) {
            n = 1;
        }
        scrollbar.setMaximum(n);
        scrollbar.setVisibleAmount(n);
        scrollbar.setMinimum(0);
        scrollbar.setValue(0);
        scrollbar.setUnitIncrement(20);
        scrollbar.addAdjustmentListener(this);
        if (this.scrollH != null) {
            int n2 = this.scrollH.getValue();
            this.remove(this.scrollH);
            if (this.scrollV != null) {
                this.doc.scrollTo(n2, this.scrollV.getValue());
            }
        }
        this.scrollH = scrollbar;
        this.add("South", this.scrollH);
        if (this.scrollType != 1) {
            this.scrollH.setVisible(false);
        }
    }

    private void setVAdjuster(Scrollbar scrollbar) {
        int n = this.getSize().height;
        if (n < 1) {
            n = 1;
        }
        scrollbar.setMaximum(n);
        scrollbar.setVisibleAmount(n);
        scrollbar.setMinimum(0);
        scrollbar.setValue(0);
        scrollbar.setUnitIncrement(20);
        scrollbar.addAdjustmentListener(this);
        if (this.scrollV != null) {
            int n2 = this.scrollV.getValue();
            this.remove(this.scrollV);
            if (this.scrollH != null) {
                this.doc.scrollTo(this.scrollH.getValue(), n2);
            }
        }
        this.scrollV = scrollbar;
        this.add("East", this.scrollV);
        if (this.scrollType == 2) {
            this.scrollV.setVisible(false);
        }
    }

    void printDoc(PrintJob printJob) {
        if (printJob == null) {
            return;
        }
        try {
            PrintDialog printDialog = new PrintDialog(this, printJob);
            printDialog.show();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            printJob.end();
            throw throwable;
        }
        Object var3_3 = null;
        printJob.end();
    }

    void cancelPrint() {
        this.cancel_flag = true;
    }

    void printDoc2(PrintJob printJob, Label label) {
        Object object;
        int n = 10;
        int n2 = 30;
        int n3 = 0;
        int n4 = 60;
        try {
            object = System.getProperty("ice.htmlbrowser.printMarginLeft");
            if (object != null) {
                n = Integer.parseInt((String)object);
            }
            if ((object = System.getProperty("ice.htmlbrowser.printMarginRight")) != null) {
                n2 = Integer.parseInt((String)object);
            }
            if ((object = System.getProperty("ice.htmlbrowser.printMarginTop")) != null) {
                n3 = Integer.parseInt((String)object);
            }
            if ((object = System.getProperty("ice.htmlbrowser.printMarginBottom")) != null) {
                n4 = Integer.parseInt((String)object);
            }
        }
        catch (Exception exception) {}
        this.htmlWait(true);
        object = this.doc.getScrollPosition();
        this.printPage = printJob.getPageDimension();
        this.printPage.width -= n + n2;
        this.printPage.height -= n3 + n4;
        int n5 = 0;
        if (File.separatorChar == '/') {
            n5 = -40;
        }
        this.cancel_flag = false;
        this.print_flag = true;
        this.setLayoutDone(false);
        this.doc.doLayout();
        try {
            this.htmlWait(true);
            this.doc.moveComponentBoxes();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        Component[] componentArray = this.doc.getComponents();
        Dimension dimension = this.getDocumentSize();
        Rectangle rectangle = new Rectangle(this.printPage);
        rectangle.x = n;
        rectangle.y = n3;
        int n6 = 1;
        int n7 = 0;
        while (n7 < dimension.height && !this.cancel_flag) {
            int n8 = this.doc.findPageBreak(n7, this.printPage.height + n5);
            Graphics graphics = printJob.getGraphics();
            rectangle.height = n8 - n7;
            graphics.setClip(rectangle);
            graphics.translate(n + ((Point)object).x, -n7 + ((Point)object).y);
            label.setText("Printing page " + n6);
            this.doc.print(graphics);
            int n9 = 0;
            while (n9 < componentArray.length) {
                Component component = componentArray[n9];
                Graphics graphics2 = graphics.create(component.getLocation().x, component.getLocation().y, component.getSize().width, component.getSize().height);
                component.printAll(graphics2);
                graphics2.dispose();
                ++n9;
            }
            graphics.dispose();
            n7 = n8;
            ++n6;
        }
        this.print_flag = false;
        this.doc.doLayout();
        label.setText("Printing completed");
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.print_flag && this.scrollH != null) {
            this.doc.scrollTo(this.scrollH.getValue(), this.scrollV.getValue());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        Point point = this.getScrollPosition();
        switch (n) {
            case 39: {
                this.setScrollPosition(point.x + 20, point.y);
                return;
            }
            case 37: {
                this.setScrollPosition(point.x - 20, point.y);
                return;
            }
            case 40: {
                this.setScrollPosition(point.x, point.y + 20);
                return;
            }
            case 38: {
                this.setScrollPosition(point.x, point.y - 20);
                return;
            }
            case 32: 
            case 34: {
                this.setScrollPosition(point.x, point.y + this.getViewportSize().height);
                return;
            }
            case 33: {
                this.setScrollPosition(point.x, point.y - this.getViewportSize().height);
                return;
            }
            case 67: 
            case 88: {
                if (!keyEvent.isControlDown()) break;
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                String string = this.getSelectedText();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
                return;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Document.activeFrameInfo = this.frame;
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void addNotify() {
        super.addNotify();
        this.requestFocus();
    }

    public void doLayout() {
        this.setLayoutDone(false);
        if (this.scrollPane != null) {
            this.doc.invalidate();
        }
        super.doLayout();
    }

    boolean isLayoutDone() {
        return this.layoutDone;
    }

    private void setLayoutDone(boolean bl) {
        this.layoutDone = bl;
    }

    int search(int n, String string) {
        return this.doc.search(n, string);
    }

    String getSelectedText() {
        return this.doc.getSelectedText();
    }

    Dimension getDocumentSize() {
        return this.doc.getHTMLDocumentSize();
    }

    Dimension getViewportSize() {
        if (this.scrollPane != null) {
            return this.scrollPane.getViewportSize();
        }
        if (this.print_flag) {
            return this.printPage;
        }
        return this.doc.getSize();
    }

    Point getScrollPosition() {
        if (this.scrollPane != null) {
            return this.scrollPane.getScrollPosition();
        }
        return this.doc.getScrollPosition();
    }

    void setScrollPosition(int n, int n2) {
        if (this.scrollPane == null) {
            if (this.scrollH != null) {
                this.scrollH.setValue(n);
                this.scrollV.setValue(n2);
                this.doc.scrollTo(this.scrollH.getValue(), this.scrollV.getValue());
                return;
            }
            this.doc.scrollTo(n, n2);
            return;
        }
        this.scrollPane.setScrollPosition(n, n2);
        this.frame.passScrollPosition();
    }

    void firstDocumentDimension() {
        if (this.print_flag) {
            return;
        }
        this.repaint_flag = true;
    }

    void updateDocumentDimension(int n, int n2) {
        if (this.print_flag) {
            return;
        }
        if (this.scrollPane != null) {
            return;
        }
        if (this.update_counter > 0) {
            --this.update_counter;
            return;
        }
        this.update_counter = 100;
        Dimension dimension = this.getViewportSize();
        Point point = this.getScrollPosition();
        if (this.scrollH != null) {
            this.scrollH.setValue(point.x);
            this.scrollH.setBlockIncrement(dimension.width);
            this.scrollH.setVisibleAmount(dimension.width);
            this.scrollH.setMaximum(n);
            this.scrollV.setValue(point.y);
            this.scrollV.setBlockIncrement(dimension.height);
            this.scrollV.setVisibleAmount(dimension.height);
            this.scrollV.setMaximum(n2);
        }
        if (n2 >= point.y + dimension.height && this.repaint_flag) {
            this.repaint_flag = false;
            this.doc.repaint();
        }
    }

    void finalDocumentDimension(boolean bl) {
        Serializable serializable;
        if (this.print_flag) {
            this.setLayoutDone(true);
            return;
        }
        Dimension dimension = this.getDocumentSize();
        Dimension dimension2 = this.getViewportSize();
        if (this.scrollPane != null) {
            this.doc.setSize(dimension);
            this.scrollPane.doLayout();
            this.doc.moveComponentBoxes();
            if (this.waitForPos != null) {
                this.setScrollPosition(this.waitForPos.x, this.waitForPos.y);
                this.waitForPos = null;
                this.waitForRef = null;
            }
            if (this.waitForRef != null) {
                Point point = this.doc.getAnchorPosition(this.waitForRef);
                if (point != null) {
                    this.setScrollPosition(point.x, point.y);
                }
                this.waitForRef = null;
            }
            this.repaint_flag = false;
            this.doc.repaint();
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.scrollType == 0 && this.scrollH != null) {
            if (dimension.width <= dimension2.width) {
                if (this.scrollH.isVisible()) {
                    this.scrollH.setValue(0);
                    this.scrollH.setVisible(false);
                    dimension2.height += this.scrollH.getSize().height;
                    bl2 = true;
                }
            } else if (!this.scrollH.isVisible()) {
                this.scrollH.setVisible(true);
                dimension2.height -= this.scrollH.getSize().height;
                bl2 = true;
            }
            if (dimension.height <= dimension2.height) {
                if (this.scrollV.isVisible()) {
                    this.scrollV.setValue(0);
                    this.scrollV.setVisible(false);
                    dimension2.width += this.scrollV.getSize().width;
                    bl3 = true;
                }
            } else if (!this.scrollV.isVisible()) {
                this.scrollV.setVisible(true);
                dimension2.width -= this.scrollV.getSize().width;
                bl3 = true;
            }
        }
        if (this.scrollH != null) {
            this.scrollH.setMaximum(dimension.width);
            this.scrollH.setValue(this.getScrollPosition().x);
            this.scrollH.setBlockIncrement(dimension2.width);
            this.scrollH.setVisibleAmount(dimension2.width);
            this.scrollV.setMaximum(dimension.height);
            this.scrollV.setValue(this.getScrollPosition().y);
            this.scrollV.setBlockIncrement(dimension2.height);
            this.scrollV.setVisibleAmount(dimension2.height);
        }
        if (bl3 || bl2) {
            this.doLayout();
        }
        Point point = this.getScrollPosition();
        Point point2 = new Point(point);
        if (bl2 && this.scrollH != null && this.scrollH.isVisible()) {
            this.scrollH.setValue(point.x);
            this.scrollH.setVisibleAmount(dimension2.width);
            this.scrollH.setMaximum(dimension.width);
            this.scrollH.setBlockIncrement(dimension2.width);
        }
        if (this.waitForPos != null) {
            point2.y = this.waitForPos.y;
            this.waitForPos = null;
            this.waitForRef = null;
        }
        if (this.waitForRef != null) {
            serializable = this.doc.getAnchorPosition(this.waitForRef);
            if (serializable != null) {
                point2.y = serializable.y;
            }
            if (bl) {
                this.waitForRef = null;
            }
        }
        if (this.scrollH != null) {
            this.scrollH.setUnitIncrement(20);
            this.scrollV.setUnitIncrement(20);
        }
        if (bl && this.repaint_flag || bl3 || bl2 || point.x != point2.x || point.y != point2.y) {
            if (this.scrollH != null) {
                this.scrollH.setValue(point2.x);
                this.scrollV.setValue(point2.y);
                point2.x = this.scrollH.getValue();
                point2.y = this.scrollV.getValue();
            }
            this.doc.scrollJumpTo(point2.x, point2.y);
            this.repaint_flag = false;
        }
        if (this.repaint_flag) {
            this.doc.repaint();
            this.repaint_flag = false;
        }
        serializable = this;
        synchronized (serializable) {
            this.setLayoutDone(true);
            this.notifyAll();
        }
        if (Document.macMode) {
            this.doc.repaint();
        }
    }

    boolean isParsingDone() {
        return this.doc.isParsingDone();
    }
}

