/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BoxLineBreak;
import ice.htmlbrowser.DocContainer;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintGraphics;

class BoxListItem
extends BoxLineBreak {
    private Font font;
    private String text;
    private int type;
    private int sub_type;
    private int base_line;

    BoxListItem(DocContainer docContainer, int n, int n2, int n3, int n4) {
        super(docContainer, 0, n);
        this.setAttrib(11);
        this.type = n2;
        this.sub_type = n3;
        if (this.type == 1) {
            if (this.sub_type == 1 || this.sub_type == 2) {
                int n5 = 26;
                while (n4 > 0) {
                    int n6 = n4 % n5 - 1;
                    n4 /= n5;
                    String string = String.valueOf((char)(65 + n6));
                    this.text = this.text != null ? String.valueOf(string) + this.text : string;
                }
            } else {
                this.text = this.sub_type == 3 || this.sub_type == 4 ? this.decToRoman(n4) : String.valueOf(n4);
            }
            if (this.sub_type == 2 || this.sub_type == 4) {
                this.text = this.text.toLowerCase();
            }
            this.text = String.valueOf(this.text) + ". ";
        }
    }

    void paint(Graphics graphics) {
        graphics.setColor(this.color);
        if (this.type == 0) {
            int n = this.width / 2 - 4;
            int n2 = this.height / 2 - 4;
            if (this.sub_type == 0) {
                graphics.fillOval(n, n2, 7, 7);
                return;
            }
            if (this.sub_type == 1) {
                if (graphics instanceof PrintGraphics) {
                    graphics.fillRect(n, n2, 8, 8);
                    return;
                }
                graphics.drawOval(n, n2, 8, 8);
                return;
            }
            graphics.fillRect(n, n2, 8, 8);
            return;
        }
        if (this.type == 1) {
            graphics.setFont(this.font);
            graphics.drawString(this.text, 0, this.base_line);
        }
    }

    int getBaseLine() {
        return this.base_line;
    }

    void layout(int n, boolean bl) {
        this.font = this.doc.getFont(this.font_idx);
        FontMetrics fontMetrics = this.doc.getFontMetrics(this.font);
        this.height = fontMetrics.getHeight() + 2;
        if (this.type == 1) {
            this.base_line = fontMetrics.getHeight() - fontMetrics.getDescent();
            this.width = fontMetrics.stringWidth(this.text);
            return;
        }
        this.width = this.height;
        this.base_line = this.height;
    }

    private String decToRoman(int n) {
        String string = this.digitToRoman(n % 10, "I", "V", "X");
        string = String.valueOf(this.digitToRoman((n /= 10) % 10, "X", "L", "C")) + string;
        string = String.valueOf(this.digitToRoman((n /= 10) % 10, "C", "D", "M")) + string;
        string = String.valueOf(this.digitToRoman((n /= 10) % 10, "M", "H", " ")) + string;
        n /= 10;
        return string;
    }

    private String digitToRoman(int n, String string, String string2, String string3) {
        switch (n) {
            case 1: {
                return string;
            }
            case 2: {
                return String.valueOf(string) + string;
            }
            case 3: {
                return String.valueOf(string) + string + string;
            }
            case 4: {
                return String.valueOf(string) + string2;
            }
            case 5: {
                return string2;
            }
            case 6: {
                return String.valueOf(string2) + string;
            }
            case 7: {
                return String.valueOf(string2) + string + string;
            }
            case 8: {
                return String.valueOf(string2) + string + string + string;
            }
            case 9: {
                return String.valueOf(string) + string3;
            }
        }
        return "";
    }
}

