/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.signalviewer;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWTList;
import com.mathworks.toolbox.simulink.signalviewer.Simulink;
import com.mathworks.util.Assert;
import com.mathworks.util.ResLoader;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.Hashtable;

public class SignalList
extends MWTList
implements ItemListener,
ActionListener {
    public static final int CHECKMARK_ITEM = 7456;
    public static final int REMOVE_ITEM = 6547;
    public static final int REMOVE_ALL = 72698;
    public static final int ITEM_SELECTED = 72498;
    public static final int ITEM_DESELECTED = 72598;
    public static final String sSimulinkInterfaceFunction = "sviewer";
    private Image imTestPointIcon;
    private Image imBulletIcon;
    private Image imCheckmarkIcon;
    private Image imHilitedTestPointIcon;
    private Image imHilitedBulletIcon;
    private Image imHilitedCheckmarkIcon;
    private String sTestPointIconName = "resources/testpoint.gif";
    private String sBulletIconName = "resources/bullet.gif";
    private String sCheckmarkIconName = "resources/checkmark.gif";
    private String sHilitedTestPointIconName = "resources/htestpoint.gif";
    private String sHilitedBulletIconName = "resources/hbullet.gif";
    private String sHilitedCheckmarkIconName = "resources/hcheckmark.gif";
    private Double fDbl_CurrentHandle;
    private boolean fb_WaitingForReply = false;
    private static Simulink The_Simulink;
    private boolean[] bIsTestPoint;
    private boolean[] bIsSelected;
    private boolean bIsCheckmarkable = false;
    private int iNextId;
    private Hashtable hSignalHandles;
    private String sListIdentificator;
    private static final byte ICON_COLUMN = 0;
    private static final byte CHECKBOX_COLUMN = 1;
    private static final String LIST_WITH_ACTIVE_CHECKMARK_CONTROLS = "LIST_WITH_ACTIVE_CHECKMARK_CONTROLS";
    private static final String LIST_WITHOUT_ACTIVE_CHECKMARK_CONTROLS = "LIST_WITHOUT_ACTIVE_CHECKMARK_CONTROLS";

    private void setCurrentHandle(Double d) {
        this.fDbl_CurrentHandle = d;
        this.updateList();
    }

    private synchronized void updateList() {
        if (!this.fb_WaitingForReply && this.fDbl_CurrentHandle != null) {
            if (this.sListIdentificator == LIST_WITH_ACTIVE_CHECKMARK_CONTROLS) {
                super.removeAll();
                The_Simulink.feval(sSimulinkInterfaceFunction, "GetSignalLayer", this.fDbl_CurrentHandle, 5, new SignalListCompletionObserver(this.fDbl_CurrentHandle));
                return;
            }
            if (this.sListIdentificator == LIST_WITHOUT_ACTIVE_CHECKMARK_CONTROLS) {
                The_Simulink.feval(sSimulinkInterfaceFunction, "GetSignalName", this.fDbl_CurrentHandle, 2, new SignalListCompletionObserver(this.fDbl_CurrentHandle));
                return;
            }
            Assert.assert((boolean)false, (String)"Unknown value of the sListIdentificator field of SignalList class detected");
        }
    }

    private Double getCurrentHandle() {
        return this.fDbl_CurrentHandle;
    }

    public void setTestPointIcon(Image image) {
        this.imTestPointIcon = image;
    }

    public void setTestPointIcon(String string) {
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        this.imTestPointIcon = resLoader.loadImage(string);
        resLoader.waitForPendingImages();
    }

    public void setBulletIcon(Image image) {
        this.imBulletIcon = image;
    }

    public void setBulletIcon(String string) {
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        this.imBulletIcon = resLoader.loadImage(string);
        resLoader.waitForPendingImages();
    }

    public void setCheckmarkIcon(Image image) {
        this.imCheckmarkIcon = image;
    }

    public void setCheckmarkIcon(String string) {
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        this.imCheckmarkIcon = resLoader.loadImage(string);
        resLoader.waitForPendingImages();
    }

    public void setHilitedTestPointIcon(Image image) {
        this.imHilitedTestPointIcon = image;
    }

    public void setHilitedTestPointIcon(String string) {
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        this.imHilitedTestPointIcon = resLoader.loadImage(string);
        resLoader.waitForPendingImages();
    }

    public void setHilitedBulletIcon(Image image) {
        this.imHilitedBulletIcon = image;
    }

    public void setHilitedBulletIcon(String string) {
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        this.imHilitedBulletIcon = resLoader.loadImage(string);
        resLoader.waitForPendingImages();
    }

    public void setHilitedCheckmarkIcon(Image image) {
        this.imHilitedCheckmarkIcon = image;
    }

    public void setHilitedCheckmarkIcon(String string) {
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        this.imHilitedCheckmarkIcon = resLoader.loadImage(string);
        resLoader.waitForPendingImages();
    }

    public void invalidateDefaultIcons() {
        this.imTestPointIcon = null;
        this.imBulletIcon = null;
        this.imCheckmarkIcon = null;
        this.imHilitedTestPointIcon = null;
        this.imHilitedBulletIcon = null;
        this.imHilitedCheckmarkIcon = null;
    }

    public SignalList(boolean bl, int n, Simulink simulink) {
        super(false, false, n);
        this.setDrawColumnLines(false);
        this.setDrawRowLines(false);
        this.setWholeItemSelect(true);
        this.sListIdentificator = n > 2 ? LIST_WITH_ACTIVE_CHECKMARK_CONTROLS : LIST_WITHOUT_ACTIVE_CHECKMARK_CONTROLS;
        this.bIsTestPoint = new boolean[1000];
        this.bIsCheckmarkable = bl;
        The_Simulink = simulink;
        this.hSignalHandles = new Hashtable();
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        this.imTestPointIcon = resLoader.loadImage(this.sTestPointIconName);
        this.imBulletIcon = resLoader.loadImage(this.sBulletIconName);
        this.imCheckmarkIcon = resLoader.loadImage(this.sCheckmarkIconName);
        this.imHilitedTestPointIcon = resLoader.loadImage(this.sHilitedTestPointIconName);
        this.imHilitedBulletIcon = resLoader.loadImage(this.sHilitedBulletIconName);
        this.imHilitedCheckmarkIcon = resLoader.loadImage(this.sHilitedCheckmarkIconName);
        resLoader.waitForPendingImages();
        this.addItemListener(this);
    }

    public void removeAll() {
        super.removeAll();
        this.processActionEvent(new ActionEvent(this, 72698, "remove_all"));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        switch (itemEvent.getStateChange()) {
            case 1: {
                int n = this.getFirstSelectedItem();
                this.processActionEvent(new ActionEvent(this, 72498, String.valueOf((Double)this.hSignalHandles.get(new Integer(n)))));
                return;
            }
            case 2: {
                this.processActionEvent(new ActionEvent(this, 72598, "deselected"));
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (actionEvent.getID()) {
            case 7456: {
                this.setCurrentHandle(Double.valueOf(actionEvent.getActionCommand()));
                return;
            }
            case 6547: {
                if (this.sListIdentificator != LIST_WITHOUT_ACTIVE_CHECKMARK_CONTROLS) break;
                Integer n = (Integer)this.hSignalHandles.get(Double.valueOf(actionEvent.getActionCommand()));
                this.remove(n);
                return;
            }
            case 72698: {
                if (this.sListIdentificator != LIST_WITH_ACTIVE_CHECKMARK_CONTROLS) break;
                int n = 0;
                while (n < this.bIsSelected.length) {
                    this.bIsSelected[n] = false;
                    ++n;
                }
                ((Component)((Object)this)).repaint();
                return;
            }
            case 100398: {
                String[] stringArray = Simulink.MString2Array(actionEvent.getActionCommand());
                this.iNextId = 0;
                this.setCurrentHandle(Double.valueOf(stringArray[0]));
                return;
            }
            case 70898: {
                this.iNextId = 0;
                super.removeAll();
                return;
            }
        }
    }

    public boolean clickItem(MouseEvent mouseEvent, int n, int n2, Rectangle rectangle) {
        switch (n2) {
            case 0: {
                return true;
            }
            case 1: {
                if (this.sListIdentificator == LIST_WITH_ACTIVE_CHECKMARK_CONTROLS) {
                    if (this.bIsCheckmarkable) {
                        this.bIsSelected[n] = !this.bIsSelected[n];
                        ((Component)((Object)this)).repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        if (this.bIsSelected[n]) {
                            this.processActionEvent(new ActionEvent(this, 7456, String.valueOf((Double)this.hSignalHandles.get(new Integer(n)))));
                        } else {
                            this.processActionEvent(new ActionEvent(this, 6547, String.valueOf((Double)this.hSignalHandles.get(new Integer(n)))));
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    public void drawItem(Graphics graphics, int n, int n2, Rectangle rectangle, boolean bl) {
        switch (n2) {
            case 0: {
                if (!this.bIsTestPoint[n]) break;
                if (this.isSelected(n)) {
                    graphics.drawImage(this.imHilitedTestPointIcon, rectangle.x, rectangle.y, 16, 16, (ImageObserver)((Object)this));
                    return;
                }
                graphics.drawImage(this.imTestPointIcon, rectangle.x, rectangle.y, 16, 16, (ImageObserver)((Object)this));
                return;
            }
            case 1: {
                if (this.bIsCheckmarkable) {
                    if (this.bIsSelected[n]) {
                        if (this.isSelected(n)) {
                            graphics.drawImage(this.imHilitedCheckmarkIcon, rectangle.x, rectangle.y, 16, 16, (ImageObserver)((Object)this));
                            return;
                        }
                        graphics.drawImage(this.imCheckmarkIcon, rectangle.x, rectangle.y, 16, 16, (ImageObserver)((Object)this));
                        return;
                    }
                    if (this.isSelected(n)) {
                        graphics.drawImage(this.imHilitedBulletIcon, rectangle.x, rectangle.y, 16, 16, (ImageObserver)((Object)this));
                        return;
                    }
                    graphics.drawImage(this.imBulletIcon, rectangle.x, rectangle.y, 16, 16, (ImageObserver)((Object)this));
                    return;
                }
                super.drawItem(graphics, n, n2, rectangle, bl);
                return;
            }
            default: {
                super.drawItem(graphics, n, n2, rectangle, bl);
            }
        }
    }

    static /* synthetic */ boolean access$0(SignalList signalList) {
        return signalList.fb_WaitingForReply;
    }

    private class SignalListCompletionObserver
    implements CompletionObserver {
        private Double fDbl_local_Handle;

        private SignalListCompletionObserver() {
            SignalList.this = SignalList.this;
        }

        public SignalListCompletionObserver(Double d) {
            SignalList.this = SignalList.this;
            this.fDbl_local_Handle = d;
        }

        public void completed(int n, Object object) {
            int n2 = Matlab.getExecutionStatus((int)n);
            switch (n2) {
                case 0: {
                    SignalList.this.fb_WaitingForReply = false;
                    if (this.fDbl_local_Handle != SignalList.this.fDbl_CurrentHandle) {
                        SignalList.this.updateList();
                        return;
                    }
                    if (SignalList.this.sListIdentificator == LIST_WITH_ACTIVE_CHECKMARK_CONTROLS) {
                        this.CompleteTreePopulation(object);
                        return;
                    }
                    if (SignalList.this.sListIdentificator == LIST_WITHOUT_ACTIVE_CHECKMARK_CONTROLS) {
                        this.CompleteSignalAding(object);
                        return;
                    }
                    Assert.assert((boolean)false, (String)"Unknown value of the sListIdentificator field of SignalList class detected");
                    return;
                }
            }
            Assert.assert((boolean)false, (String)"Error in dara returned");
        }

        private void CompleteTreePopulation(Object object) {
            int n;
            Object[] objectArray = (Object[])object;
            double[] dArray = objectArray[0] != null ? (double[])objectArray[0] : null;
            String[] stringArray = objectArray[1] != null ? (String[])objectArray[1] : null;
            String[] stringArray2 = objectArray[2] != null ? (String[])objectArray[2] : null;
            String[] stringArray3 = objectArray[3] != null ? (String[])objectArray[3] : null;
            int n2 = n = dArray != null ? dArray.length : 0;
            if (n == 0) {
                return;
            }
            SignalList.this.hSignalHandles = new Hashtable();
            SignalList.this.bIsTestPoint = The_Simulink.ConvertStrings2Booleans((String[])objectArray[4]);
            SignalList.this.bIsSelected = new boolean[n];
            int n3 = 0;
            while (n3 < n) {
                if (dArray[n3] != -1.0) {
                    SignalList.this.hSignalHandles.put(new Integer(SignalList.this.iNextId), new Double(dArray[n3]));
                    if (stringArray[n3].length() == 0) {
                        stringArray[n3] = String.valueOf(stringArray2[n3]) + "_Port" + stringArray3[n3];
                    }
                    SignalList signalList = SignalList.this;
                    int n4 = signalList.iNextId;
                    signalList.iNextId = n4 + 1;
                    SignalList.this.add(-1, n4, new String[]{"", "", stringArray[n3].replace('\n', ' '), stringArray2[n3].replace('\n', ' '), stringArray3[n3]}, null, false);
                    ((SignalList)SignalList.this).bIsSelected[n3] = false;
                }
                ++n3;
            }
        }

        private void CompleteSignalAding(Object object) {
            Object[] objectArray = (Object[])object;
            String[] stringArray = (String[])objectArray[0];
            boolean[] blArray = The_Simulink.ConvertStrings2Booleans((String[])objectArray[1]);
            ((SignalList)SignalList.this).bIsTestPoint[((SignalList)SignalList.this).iNextId] = blArray[0];
            SignalList.this.hSignalHandles.put(this.fDbl_local_Handle, new Integer(SignalList.this.iNextId));
            SignalList signalList = SignalList.this;
            int n = signalList.iNextId;
            signalList.iNextId = n + 1;
            SignalList.this.add(-1, n, new String[]{"", stringArray[0]}, null, false);
        }
    }
}

