/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.signalselector;

import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCardPanel;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWSplitter;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWToolTip;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandPanel;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowResizer;
import com.mathworks.toolbox.simulink.signalselector.CellRenderer;
import com.mathworks.toolbox.simulink.signalselector.SignalDetailed;
import com.mathworks.toolbox.simulink.signalselector.SignalTable;
import com.mathworks.toolbox.simulink.signalviewer.SVTree;
import com.mathworks.toolbox.simulink.signalviewer.Simulink;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Timer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class SignalSelector
extends MWCommandPanel
implements ActionListener,
ItemListener,
MouseListener {
    private double fModelHandle = -1.0;
    private double fBlockHandle = -1.0;
    private Object[] fBlockData;
    private boolean fValidMouseClick = false;
    private String fPrefix = "/com/mathworks/toolbox/simulink/signalselector/resources/";
    private Hashtable fPortsTable;
    private MWCheckbox[] fCheckbox;
    private MWCheckbox[] fMatches;
    private Object[][] fDetailedData;
    private Object[][] fMatchedData;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.signalselector.resources.RES_SignalSelector");
    private Matlab fMatlab = new Matlab(new MWLooper(sRes.getString("title.SignalSelector")));
    private Timer fTimer = new Timer(500, (ActionListener)new LocalTimerListener(), "Key Timer");
    private String fMatchSequence;
    private SVTree fModelTree;
    private MWLabel fListLabel;
    private MWChoice fListOption;
    private MWPanel fMaskLinkPanel;
    private MWButton fLookUnderMasksButton;
    private MWButton fFollowLinksButton;
    private MWPanel fViewsPanel;
    private MWButton fListViewButton;
    private MWButton fDetailedViewButton;
    private MWPanel fLevelsPanel;
    private MWButton fCurrentLevelButton;
    private MWButton fCurrentAndBelowLevelsButton;
    private MWCardPanel fSignalPanel;
    private SignalTable fSignalTable;
    private SignalDetailed fSignalDetailed;
    private int NUM_COLS = 4;
    private MWMenu fContextMenu;
    private static final int CHECK_ALL = 1;
    private static final int UNCHECK_ALL = 2;
    private static final int CHECK_SELECTED = 3;
    private static final int UNCHECK_SELECTED = 4;
    private MWTextField fMatchField;
    private MWButton fHelpButton;
    private MWButton fCloseButton;
    static /* synthetic */ Class class$com$mathworks$mwt$MWCheckbox;

    private void doHelp() {
        HelpBrowser.getHelpBrowser().displayTopic("Signal Selector", "simulink", "signal_selector");
    }

    private void doClose() {
        Object[] objectArray = new Object[]{new String(sRes.getString("string.Close")), new Double(this.fBlockHandle), this.fBlockData};
        this.fMatlab.feval("signalselector", objectArray, null);
    }

    private void locateMatchedSequence(String string) {
        String string2;
        boolean bl;
        boolean bl2 = bl = this.fMatches != null && this.fMatches.length > 0;
        if (!bl) {
            return;
        }
        int n = this.fMatches.length;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < n) {
            string2 = string.toLowerCase();
            String string3 = this.fMatches[n2].getLabel().toLowerCase();
            if (string3.startsWith(string2)) {
                bl3 = true;
                break;
            }
            ++n2;
        }
        if (bl3) {
            string2 = this.fMatches[n2];
            int n3 = 0;
            int n4 = this.fSignalTable.getData().getHeight();
            int n5 = 0;
            int n6 = this.fSignalTable.getData().getWidth();
            int n7 = 0;
            int n8 = 0;
            n5 = 0;
            while (n5 < n6) {
                n3 = 0;
                while (n3 < n4) {
                    if ((MWCheckbox)this.fSignalTable.getData().getData(n3, n5) == string2) {
                        n7 = n3;
                        n8 = n5;
                        break;
                    }
                    ++n3;
                }
                ++n5;
            }
            this.fSignalTable.select(n7, n8);
            this.fSignalTable.scrollToCell(n7, n8);
            n4 = this.fSignalDetailed.getData().getHeight();
            n3 = 0;
            while (n3 < n4) {
                if ((MWCheckbox)this.fSignalDetailed.getData().getData(n3, 0) == string2) {
                    n7 = n3;
                    break;
                }
                ++n3;
            }
            this.fSignalDetailed.setSelectedIndex(n7);
            this.fSignalDetailed.scrollToCell(n7, 0);
        }
    }

    private boolean IsSignalTableSelected() {
        return this.fSignalPanel.getSelectedIndex() == 0;
    }

    private void processMultiSelection() {
        Object object = null;
        boolean bl = false;
        if (this.IsSignalTableSelected()) {
            object = this.fSignalTable.getFirstSelectedItem();
        } else {
            int[] nArray = this.fSignalDetailed.getSelectedIndexes();
            if (nArray != null && nArray.length > 0) {
                object = this.fSignalDetailed.getData().getData(nArray[0], 0);
            }
        }
        if (object instanceof MWCheckbox) {
            bl = ((MWCheckbox)object).getState();
        }
        if (bl) {
            this.doCommand(4);
            return;
        }
        this.doCommand(3);
    }

    public void doCommand(int n) {
        MWCheckbox[] mWCheckboxArray = null;
        boolean bl = false;
        if (n == 1 || n == 2) {
            mWCheckboxArray = this.fCheckbox;
        } else if (this.IsSignalTableSelected()) {
            Enumeration enumeration = this.fSignalTable.getSelectedCells();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                if (!(enumeration.nextElement() instanceof MWCheckbox)) continue;
                ++n2;
            }
            mWCheckboxArray = new MWCheckbox[n2];
            Enumeration enumeration2 = this.fSignalTable.getSelectedCells();
            n2 = 0;
            while (enumeration2.hasMoreElements()) {
                Object e = enumeration2.nextElement();
                if (!(e instanceof MWCheckbox)) continue;
                mWCheckboxArray[n2++] = (MWCheckbox)e;
            }
        } else {
            int[] nArray = this.fSignalDetailed.getSelectedIndexes();
            int n3 = nArray.length;
            mWCheckboxArray = new MWCheckbox[n3];
            int n4 = 0;
            while (n4 < n3) {
                Object object = this.fSignalDetailed.getData().getData(nArray[n4], 0);
                if (object instanceof MWCheckbox) {
                    mWCheckboxArray[n4] = (MWCheckbox)object;
                }
                ++n4;
            }
        }
        switch (n) {
            case 1: 
            case 3: {
                bl = true;
                break;
            }
            case 2: 
            case 4: {
                bl = false;
                break;
            }
        }
        if (mWCheckboxArray != null) {
            this.selectCheckbox(mWCheckboxArray, bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fHelpButton) {
            this.doHelp();
            return;
        }
        if (object == this.fCloseButton) {
            this.doClose();
            return;
        }
        if (object == this.fMatchField) {
            this.findMatchingSignals();
            return;
        }
        if (object == this.fSignalTable || object == this.fSignalDetailed) {
            this.processMultiSelection();
        }
    }

    private void findMatchingSignals() {
        int n;
        if (this.fCheckbox == null || this.fCheckbox.length == 0) {
            return;
        }
        this.fSignalTable.getData().setHeight(0);
        this.fSignalDetailed.getData().setHeight(0);
        String string = this.fMatchField.getText();
        String string2 = new String();
        int n2 = 0;
        while (n2 < string.length()) {
            n = string.charAt(n2);
            string2 = n == 42 ? String.valueOf(string2) + "" : String.valueOf(string2) + (char)n;
            ++n2;
        }
        n = 0;
        int n3 = 0;
        while (n3 < this.fCheckbox.length) {
            String string3 = this.fCheckbox[n3].getLabel();
            if (string3.indexOf(string2) >= 0) {
                ++n;
            }
            ++n3;
        }
        if (n > 0) {
            this.fMatches = new MWCheckbox[n];
            this.fMatchedData = new Object[n][this.NUM_COLS];
            n = 0;
            int n4 = 0;
            while (n4 < this.fCheckbox.length) {
                String string4 = this.fCheckbox[n4].getLabel();
                if (string4.indexOf(string2) >= 0) {
                    this.fMatches[n] = this.fCheckbox[n4];
                    this.fSignalTable.setCellData(n, 0, this.fCheckbox[n4]);
                    this.fMatchedData[n] = this.fDetailedData[n4];
                    this.fSignalDetailed.addItem(this.fDetailedData[n4]);
                    ++n;
                }
                ++n4;
            }
        } else {
            this.fMatches = null;
            this.fMatchedData = null;
        }
        this.adjustTableContents();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fValidMouseClick = false;
        if (!mouseEvent.isPopupTrigger()) {
            Object object = mouseEvent.getSource();
            if (object == this.fSignalTable) {
                if (this.fSignalTable.isContent(mouseEvent.getX(), mouseEvent.getY())) {
                    this.fValidMouseClick = true;
                }
            } else if (object == this.fSignalDetailed && this.fSignalDetailed.isContent(mouseEvent.getX(), mouseEvent.getY())) {
                this.fValidMouseClick = true;
            }
        }
        if (PlatformInfo.getPlatform() == 2) {
            this.processContextEvents(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (this.fValidMouseClick && !mouseEvent.isPopupTrigger()) {
            if (object == this.fSignalTable) {
                if (this.fSignalTable.isContent(mouseEvent.getX(), mouseEvent.getY())) {
                    this.processSingleSelection();
                }
            } else if (object == this.fSignalDetailed && this.fSignalDetailed.isContent(mouseEvent.getX(), mouseEvent.getY())) {
                this.processSingleSelection();
            }
        }
        this.fValidMouseClick = false;
        if (PlatformInfo.getPlatform() != 2) {
            this.processContextEvents(mouseEvent);
        }
    }

    private void processContextEvents(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Object object = mouseEvent.getSource();
            if (object == this.fSignalTable) {
                this.fContextMenu.attachTo((Component)((Object)this.fSignalTable));
                this.fContextMenu.show((Component)((Object)this.fSignalTable), mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (object == this.fSignalDetailed) {
                this.fContextMenu.attachTo((Component)((Object)this.fSignalDetailed));
                this.fContextMenu.show((Component)((Object)this.fSignalDetailed), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void processSingleSelection() {
        Object object;
        int n = 0;
        if (this.IsSignalTableSelected()) {
            object = this.fSignalTable.getSelectedCells();
            while (object.hasMoreElements()) {
                object.nextElement();
                ++n;
            }
        } else {
            object = this.fSignalDetailed.getSelectedIndexes();
            n = ((Object)object).length;
        }
        if (n == 1) {
            Object object2;
            object = null;
            if (this.IsSignalTableSelected()) {
                object = this.fSignalTable.getFirstSelectedItem();
            } else {
                object2 = this.fSignalDetailed.getSelectedIndexes();
                object = this.fSignalDetailed.getData().getData(object2[0], 0);
            }
            if (object instanceof MWCheckbox) {
                object2 = (MWCheckbox)object;
                MWCheckbox[] mWCheckboxArray = new MWCheckbox[]{(MWCheckbox)object2};
                this.selectCheckbox(mWCheckboxArray, !object2.getState());
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getSource();
        if (object == this.fLookUnderMasksButton || object == this.fFollowLinksButton) {
            this.updateModelTree();
        }
        boolean bl2 = bl = object == this.fLookUnderMasksButton || object == this.fFollowLinksButton || object == this.fCurrentLevelButton || object == this.fCurrentAndBelowLevelsButton || object == this.fListOption;
        if (object == this.fModelTree && itemEvent.getStateChange() == 1) {
            bl = true;
        }
        if (bl) {
            this.populate();
        }
        if (object == this.fListViewButton) {
            if (this.fListViewButton.getState()) {
                this.fSignalPanel.selectPanel(sRes.getString("panel.List"));
                return;
            }
            this.fSignalPanel.selectPanel(sRes.getString("panel.Detailed"));
        }
    }

    private double getSelectedBlockHandle() {
        double d = -1.0;
        int n = this.fModelTree.getFirstSelectedItem();
        if (n >= 0) {
            d = this.fModelTree.getHandlefromId(n);
        }
        return d;
    }

    private void selectCheckbox(MWCheckbox[] mWCheckboxArray, boolean bl) {
        Double[] doubleArray = new Double[mWCheckboxArray.length];
        int n = 0;
        while (n < mWCheckboxArray.length) {
            doubleArray[n] = (Double)this.fPortsTable.get(mWCheckboxArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < mWCheckboxArray.length) {
            mWCheckboxArray[n2].setState(bl);
            ++n2;
        }
        ((Component)((Object)this.fSignalTable)).repaint();
        ((Component)((Object)this.fSignalDetailed)).repaint();
        Object[] objectArray = new Object[]{new String(bl ? "AddSelection" : "RemoveSelection"), new Double(this.fBlockHandle), this.fBlockData, doubleArray};
        this.fMatlab.feval("signalselector", objectArray, null);
    }

    private int getMaxTextWidth(MWCheckbox[] mWCheckboxArray) {
        int n = -1;
        FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(this.getFont());
        int n2 = 0;
        while (n2 < mWCheckboxArray.length) {
            if (n < fontMetrics.stringWidth(mWCheckboxArray[n2].getLabel())) {
                n = fontMetrics.stringWidth(mWCheckboxArray[n2].getLabel());
            }
            ++n2;
        }
        return n + 50;
    }

    private void adjustTableContents() {
        boolean bl;
        this.fSignalTable.getData().setHeight(0);
        boolean bl2 = bl = this.fMatches != null && this.fMatches.length > 0;
        if (!bl) {
            return;
        }
        int n = this.fMatches.length;
        Rectangle rectangle = ((Component)((Object)this.fSignalTable)).getBounds();
        int n2 = this.fSignalTable.getRowOptions().getDefaultHeight();
        int n3 = rectangle.height / n2 - 1;
        if (n3 <= 0) {
            n3 = 1;
        }
        int n4 = n / n3 + 1;
        int n5 = this.getMaxTextWidth(this.fCheckbox);
        int n6 = 0;
        this.fSignalTable.getColumnOptions().setDefaultWidth(n5);
        this.fSignalTable.getData().setWidth(n4);
        this.fSignalTable.getData().setHeight(n3);
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                this.fSignalTable.setCellData(n8, n7, this.fMatches[n6++]);
                if (n6 == n) {
                    return;
                }
                ++n8;
            }
            ++n7;
        }
    }

    private void updateTitleBar(String string, Object[] objectArray) {
        MWFrame mWFrame = (MWFrame)((Component)((Object)this)).getParent();
        String string2 = String.valueOf(sRes.getString("frame.SignalSelector")) + string;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                string2 = String.valueOf(string2) + " : " + objectArray[n].toString();
                ++n;
            }
        }
        mWFrame.setTitle(string2);
    }

    private void updateModelTree() {
        this.getSelectedBlockHandle();
        this.fModelTree.removeAll();
        int n = 1;
        if (this.fLookUnderMasksButton.getState()) {
            n |= 0x100;
        }
        if (this.fFollowLinksButton.getState()) {
            n |= 0x200;
        }
        this.fModelTree.setModifiers(n);
        this.fModelTree.populate();
    }

    private void populate() {
        double d = this.getSelectedBlockHandle();
        if (d < 0.0) {
            d = this.fModelHandle;
        }
        Object[] objectArray = new Object[12];
        int n = 0;
        objectArray[n++] = "Populate";
        objectArray[n++] = new Double(this.fBlockHandle);
        objectArray[n++] = this.fBlockData;
        objectArray[n++] = new Double(d);
        objectArray[n++] = "LookUnderMasks";
        objectArray[n++] = this.fLookUnderMasksButton.getState() ? "all" : "off";
        objectArray[n++] = "FollowLinks";
        objectArray[n++] = this.fFollowLinksButton.getState() ? "on" : "off";
        objectArray[n++] = "SearchDepth";
        objectArray[n++] = this.fCurrentLevelButton.getState() ? "1" : "inf";
        objectArray[n++] = "SignalType";
        objectArray[n++] = this.fListOption.getSelectedItem();
        this.fSignalTable.getData().setHeight(0);
        this.fSignalDetailed.getData().setHeight(0);
        this.fMatlab.feval("signalselector", objectArray, 6, (CompletionObserver)new PopulateObserver());
    }

    private MWPanel createMaskLinkGroup() {
        MWPanel mWPanel = new MWPanel();
        MWImageResource mWImageResource = new MWImageResource(String.valueOf(this.fPrefix) + "LookUnderMasksIcon.gif", (Object)this);
        this.fLookUnderMasksButton = new MWButton(mWImageResource);
        this.fLookUnderMasksButton.setBehavior(1);
        this.fLookUnderMasksButton.addItemListener((ItemListener)this);
        new MWToolTip((Component)this.fLookUnderMasksButton, sRes.getString("tooltip.LookUnderMasks"));
        mWImageResource = new MWImageResource(String.valueOf(this.fPrefix) + "FollowLinksIcon.gif", (Object)this);
        this.fFollowLinksButton = new MWButton(mWImageResource);
        this.fFollowLinksButton.setBehavior(1);
        this.fFollowLinksButton.addItemListener((ItemListener)this);
        new MWToolTip((Component)this.fFollowLinksButton, sRes.getString("tooltip.FollowLinks"));
        mWPanel.setLayout(new GridLayout(1, 2, 0, 0));
        mWPanel.add((Component)this.fFollowLinksButton);
        mWPanel.add((Component)this.fLookUnderMasksButton);
        return mWPanel;
    }

    private MWPanel createViewsGroup() {
        MWPanel mWPanel = new MWPanel();
        MWExclusiveGroup mWExclusiveGroup = new MWExclusiveGroup();
        MWImageResource mWImageResource = new MWImageResource(String.valueOf(this.fPrefix) + "ListViewIcon.gif", (Object)this);
        this.fListViewButton = new MWButton(mWImageResource);
        this.fListViewButton.setGroup(mWExclusiveGroup);
        this.fListViewButton.setState(true);
        this.fListViewButton.addItemListener((ItemListener)this);
        new MWToolTip((Component)this.fListViewButton, sRes.getString("tooltip.ListView"));
        mWImageResource = new MWImageResource(String.valueOf(this.fPrefix) + "DetailedViewIcon.gif", (Object)this);
        this.fDetailedViewButton = new MWButton(mWImageResource);
        this.fDetailedViewButton.setGroup(mWExclusiveGroup);
        new MWToolTip((Component)this.fDetailedViewButton, sRes.getString("tooltip.DetailedView"));
        mWPanel.setLayout(new GridLayout(1, 2, 0, 0));
        mWPanel.add((Component)this.fListViewButton);
        mWPanel.add((Component)this.fDetailedViewButton);
        return mWPanel;
    }

    private MWPanel createLevelsGroup() {
        MWPanel mWPanel = new MWPanel();
        MWExclusiveGroup mWExclusiveGroup = new MWExclusiveGroup();
        MWImageResource mWImageResource = new MWImageResource(String.valueOf(this.fPrefix) + "CurrentLevelIcon.gif", (Object)this);
        this.fCurrentLevelButton = new MWButton(mWImageResource);
        this.fCurrentLevelButton.setGroup(mWExclusiveGroup);
        this.fCurrentLevelButton.setState(true);
        this.fCurrentLevelButton.addItemListener((ItemListener)this);
        new MWToolTip((Component)this.fCurrentLevelButton, sRes.getString("tooltip.CurrentSystem"));
        mWImageResource = new MWImageResource(String.valueOf(this.fPrefix) + "CurrentAndBelowIcon.gif", (Object)this);
        this.fCurrentAndBelowLevelsButton = new MWButton(mWImageResource);
        this.fCurrentAndBelowLevelsButton.setGroup(mWExclusiveGroup);
        new MWToolTip((Component)this.fCurrentAndBelowLevelsButton, sRes.getString("tooltip.CurrentAndBelow"));
        mWPanel.setLayout(new GridLayout(1, 2, 0, 0));
        mWPanel.add((Component)this.fCurrentLevelButton);
        mWPanel.add((Component)this.fCurrentAndBelowLevelsButton);
        return mWPanel;
    }

    private MWCardPanel createSignalViewPanel() {
        MWCardPanel mWCardPanel = new MWCardPanel("", 5);
        mWCardPanel.setMargins(new Insets(0, 0, 0, 0));
        this.fSignalTable = new SignalTable();
        this.fSignalTable.getTableStyle().setHGridVisible(false);
        this.fSignalTable.getTableStyle().setVGridVisible(false);
        this.fSignalTable.getColumnOptions().setHeaderVisible(false);
        this.fSignalTable.getRowOptions().setHeaderVisible(false);
        this.fSignalTable.setCursorType(0);
        this.fSignalTable.getSelectionOptions().setMode(3);
        this.fSignalTable.getSelectionOptions().setSelectBy(0);
        this.fSignalTable.getTableStyle().setCustomHilite(true);
        this.fSignalTable.setTableBackground(Decorations.getColor((int)2));
        this.fSignalTable.getTableStyle().setBackground(Decorations.getColor((int)2));
        this.fSignalTable.getData().setHeight(1);
        this.fSignalTable.getData().setWidth(1);
        this.fSignalTable.getVScrollbarOptions().setVisibility(1);
        this.fSignalTable.getHScrollbarOptions().setVisibility(0);
        this.fSignalTable.getHScrollbarOptions().setMode(1);
        ((Component)((Object)this.fSignalTable)).addMouseListener(this);
        this.fSignalTable.addItemListener(this);
        this.fSignalTable.addActionListener(this);
        ((Component)((Object)this.fSignalTable)).addKeyListener(new LocalKeyListener());
        this.fSignalTable.registerCellType(class$com$mathworks$mwt$MWCheckbox != null ? class$com$mathworks$mwt$MWCheckbox : (class$com$mathworks$mwt$MWCheckbox = SignalSelector.class$("com.mathworks.mwt.MWCheckbox")), (Cell)new CellRenderer((Table)this.fSignalTable));
        mWCardPanel.addPanel(sRes.getString("panel.List"), (Component)((Object)this.fSignalTable));
        this.fSignalDetailed = new SignalDetailed();
        mWCardPanel.addPanel(sRes.getString("panel.Detailed"), (Component)((Object)this.fSignalDetailed));
        mWCardPanel.selectPanel(sRes.getString("panel.List"));
        this.fSignalDetailed.setColumnCount(this.NUM_COLS);
        this.fSignalDetailed.setBorderStyle(2);
        this.fSignalDetailed.getTableStyle().setEditable(false);
        this.fSignalDetailed.setColumnHeaderData(0, sRes.getString("header.Signal"));
        this.fSignalDetailed.setColumnWidth(0, 125);
        this.fSignalDetailed.setColumnHeaderData(1, sRes.getString("header.Path"));
        this.fSignalDetailed.setColumnWidth(1, 200);
        this.fSignalDetailed.setColumnHeaderData(2, sRes.getString("header.Testpoint"));
        this.fSignalDetailed.setColumnWidth(2, 60);
        this.fSignalDetailed.setColumnHeaderData(3, sRes.getString("header.Type"));
        this.fSignalDetailed.setColumnWidth(3, 60);
        this.fSignalDetailed.getColumnOptions().setHeaderSelectable(false);
        this.fSignalDetailed.getColumnOptions().setResizable(true);
        this.fSignalDetailed.getColumnOptions().setHeaderVisible(true);
        this.fSignalDetailed.setAutoExpandColumn(1);
        this.fSignalDetailed.setMinAutoExpandColumnWidth(30);
        this.fSignalDetailed.getTableStyle().setHGridVisible(false);
        this.fSignalDetailed.getTableStyle().setVGridVisible(false);
        this.fSignalDetailed.getRowOptions().setHeaderVisible(false);
        this.fSignalDetailed.getSelectionOptions().setSelectBy(1);
        this.fSignalDetailed.getSelectionOptions().setMode(3);
        ((Component)((Object)this.fSignalDetailed)).addMouseListener(this);
        this.fSignalDetailed.addActionListener(this);
        this.fSignalDetailed.addItemListener(this);
        ((Component)((Object)this.fSignalDetailed)).addKeyListener(new LocalKeyListener());
        this.fSignalDetailed.registerCellType(class$com$mathworks$mwt$MWCheckbox != null ? class$com$mathworks$mwt$MWCheckbox : (class$com$mathworks$mwt$MWCheckbox = SignalSelector.class$("com.mathworks.mwt.MWCheckbox")), (Cell)new CellRenderer((Table)this.fSignalDetailed));
        Style style = new Style(256);
        style.setHAlignment(1);
        this.fSignalDetailed.setColumnStyle(2, style);
        this.fSignalDetailed.setColumnStyle(3, style);
        this.fContextMenu = new MWMenu("", new MWCommandCenter((MWCommandTarget)this));
        this.fContextMenu.addMenuItem(sRes.getString("menuitem.CheckSelectedSignals"), 3);
        this.fContextMenu.addMenuItem(sRes.getString("menuitem.UncheckSelectedSignals"), 4);
        this.fContextMenu.addSeparator();
        this.fContextMenu.addMenuItem(sRes.getString("menuitem.CheckAllSignals"), 1);
        this.fContextMenu.addMenuItem(sRes.getString("menuitem.UncheckAllSignals"), 2);
        return mWCardPanel;
    }

    public SignalSelector(String string, double d, double d2, Object[] objectArray) {
        this.fModelHandle = d;
        this.fBlockHandle = d2;
        this.fBlockData = objectArray;
        ((Container)((Object)this)).setLayout((LayoutManager)new MWBorderLayout());
        this.setInsets(new Insets(5, 5, 0, 5));
        this.fListLabel = new MWLabel(sRes.getString("label.ListContents"));
        this.fListOption = new MWChoice();
        this.fListOption.add(sRes.getString("option.AllSignals"));
        this.fListOption.add(sRes.getString("option.NamedSignalsOnly"));
        this.fListOption.add(sRes.getString("option.TestpointSignalsOnly"));
        this.fListOption.addItemListener((ItemListener)this);
        this.fMaskLinkPanel = this.createMaskLinkGroup();
        this.fViewsPanel = this.createViewsGroup();
        this.fLevelsPanel = this.createLevelsGroup();
        MWPanel mWPanel = new MWPanel((LayoutManager)new GridLayout(1, 2, 5, 5));
        mWPanel.add((Component)this.fViewsPanel);
        mWPanel.add((Component)this.fLevelsPanel);
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new BorderLayout(5, 5));
        mWPanel2.setInsets(new Insets(0, 0, 0, 0));
        mWPanel2.add((Component)this.fListLabel, "West");
        mWPanel2.add((Component)this.fListOption, "Center");
        mWPanel2.add((Component)mWPanel, "East");
        int n = string.indexOf("/");
        String string2 = n > 0 ? string.substring(0, n) : string;
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new MWBorderLayout());
        mWPanel3.add((Component)new MWLabel(sRes.getString("label.ModelHierarchy")), "West");
        mWPanel3.add((Component)this.fMaskLinkPanel, "East");
        MWGroupbox mWGroupbox = new MWGroupbox("", 0);
        mWGroupbox.setLayout((LayoutManager)new MWBorderLayout(5, 5));
        mWGroupbox.setInsets(new Insets(0, 0, 0, 0));
        this.fModelTree = new SVTree(true, Simulink.getSimulinkInstance(), 1);
        this.fModelTree.setModelName(string2);
        this.fModelTree.addItemListener(this);
        this.updateModelTree();
        mWGroupbox.add((Component)((Object)this.fModelTree), "Center");
        mWGroupbox.add((Component)mWPanel3, "North");
        this.fSignalPanel = this.createSignalViewPanel();
        MWGroupbox mWGroupbox2 = new MWGroupbox("", 0);
        mWGroupbox2.setLayout((LayoutManager)new MWBorderLayout(5, 5));
        mWGroupbox2.setInsets(new Insets(0, 0, 0, 0));
        mWGroupbox2.add((Component)this.fSignalPanel, "Center");
        mWGroupbox2.add((Component)mWPanel2, "North");
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new MWBorderLayout(5, 5));
        MWLabel mWLabel = new MWLabel(sRes.getString("label.ShowSignalsMatching"));
        this.fMatchField = new MWTextField();
        this.fMatchField.addActionListener((ActionListener)this);
        mWPanel4.add((Component)mWLabel, "West");
        mWPanel4.add((Component)this.fMatchField, "Center");
        mWGroupbox2.add((Component)mWPanel4, "South");
        MWSplitter mWSplitter = new MWSplitter((Component)mWGroupbox, (Component)mWGroupbox2, 0);
        mWSplitter.setDividerLocation(0.35);
        ((Container)((Object)this)).add((Component)mWSplitter, "Center");
        this.fHelpButton = new MWButton(sRes.getString("button.help"));
        this.fHelpButton.addActionListener((ActionListener)this);
        this.fCloseButton = new MWButton(sRes.getString("button.close"));
        this.fCloseButton.addActionListener((ActionListener)this);
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new FlowLayout(2));
        mWPanel5.add((Component)this.fHelpButton);
        mWPanel5.add((Component)this.fCloseButton);
        ((Container)((Object)this)).add((Component)mWPanel5, "South");
    }

    public void CreateSelectorWindow() {
        MWFrame mWFrame = new MWFrame();
        mWFrame.setBounds(200, 200, 650, 350);
        mWFrame.setLayout((LayoutManager)new MWBorderLayout());
        mWFrame.add((Component)((Object)this), "Center");
        mWFrame.setVisible(true);
        mWFrame.addWindowListener((WindowListener)((Object)new 1(this)));
        mWFrame.addComponentListener((ComponentListener)((Object)new 2(500, 250)));
    }

    public static SignalSelector CreateSignalSelector(String string, double d, double d2, Object[] objectArray) {
        SignalSelector signalSelector = new SignalSelector(string, d, d2, objectArray);
        signalSelector.CreateSelectorWindow();
        signalSelector.updateTitleBar(string, objectArray);
        return signalSelector;
    }

    public static void main(String[] stringArray) {
        SignalSelector.CreateSignalSelector("test/scope", -1.0, -1.0, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Matlab access$8(SignalSelector signalSelector) {
        return signalSelector.fMatlab;
    }

    static /* synthetic */ MWCheckbox[] access$16(SignalSelector signalSelector) {
        return signalSelector.fMatches;
    }

    static /* synthetic */ Object[][] access$18(SignalSelector signalSelector) {
        return signalSelector.fMatchedData;
    }

    private class LocalTimerListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SignalSelector.this.fMatchSequence = null;
        }

        LocalTimerListener() {
            SignalSelector.this = SignalSelector.this;
        }
    }

    private class LocalKeyListener
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            SignalSelector.this.fTimer.stop();
            if (!keyEvent.isActionKey() && keyEvent.getKeyCode() != 10) {
                char c = keyEvent.getKeyChar();
                SignalSelector.this.fMatchSequence = SignalSelector.this.fMatchSequence == null ? String.valueOf(c) : String.valueOf(SignalSelector.this.fMatchSequence) + c;
                SignalSelector.this.locateMatchedSequence(SignalSelector.this.fMatchSequence);
            }
            if (keyEvent.getKeyChar() == ' ') {
                SignalSelector.this.processMultiSelection();
            }
            SignalSelector.this.fTimer.start();
        }

        LocalKeyListener() {
            SignalSelector.this = SignalSelector.this;
        }
    }

    private class PopulateObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            if (n != 0) {
                return;
            }
            Object[] objectArray = (Object[])object;
            double[] dArray = (double[])objectArray[0];
            String[] stringArray = (String[])objectArray[1];
            double[] dArray2 = (double[])objectArray[2];
            String[] stringArray2 = (String[])objectArray[3];
            String[] stringArray3 = (String[])objectArray[4];
            String[] stringArray4 = (String[])objectArray[5];
            SignalSelector.this.fPortsTable = new Hashtable();
            SignalSelector.this.fCheckbox = new MWCheckbox[dArray.length];
            SignalSelector.this.fDetailedData = new Object[dArray.length][SignalSelector.this.NUM_COLS];
            int n2 = 0;
            while (n2 < dArray.length) {
                MWCheckbox mWCheckbox = new MWCheckbox(stringArray[n2], (int)dArray2[n2] == 1);
                SignalSelector.this.fPortsTable.put(mWCheckbox, new Double(dArray[n2]));
                ((SignalSelector)SignalSelector.this).fCheckbox[n2] = mWCheckbox;
                ((SignalSelector)SignalSelector.this).fDetailedData[n2][0] = mWCheckbox;
                ((SignalSelector)SignalSelector.this).fDetailedData[n2][1] = stringArray2[n2];
                ((SignalSelector)SignalSelector.this).fDetailedData[n2][2] = stringArray3[n2];
                ((SignalSelector)SignalSelector.this).fDetailedData[n2][3] = stringArray4[n2];
                ++n2;
            }
            SignalSelector.this.fMatches = SignalSelector.this.fCheckbox;
            SignalSelector.this.fMatchedData = SignalSelector.this.fDetailedData;
            SignalSelector.this.findMatchingSignals();
        }

        PopulateObserver() {
            SignalSelector.this = SignalSelector.this;
        }
    }

    private final class 1
    extends MWWindowActivater {
        public void windowClosing(WindowEvent windowEvent) {
            SignalSelector.this.doClose();
        }

        public void windowActivated(WindowEvent windowEvent) {
            super.windowActivated(windowEvent);
            SignalSelector.this.populate();
        }

        /* synthetic */ 1(SignalSelector signalSelector2) {
            super((Component)((Object)signalSelector2));
        }
    }

    private final class 2
    extends MWWindowResizer {
        public void componentResized(ComponentEvent componentEvent) {
            super.componentResized(componentEvent);
            SignalSelector.this.adjustTableContents();
        }

        /* synthetic */ 2(int n, int n2) {
            super(n, n2);
        }
    }
}

