/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.selectiondialog;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.toolbox.simulink.selectiondialog.ControlSubpanel;
import com.mathworks.toolbox.simulink.selectiondialog.FilterSubpanel;
import com.mathworks.toolbox.simulink.selectiondialog.NavigationSubpanel;
import com.mathworks.toolbox.simulink.selectiondialog.SelectionDialog;
import com.mathworks.toolbox.simulink.selectiondialog.util.LocalStateFactory;
import com.mathworks.toolbox.simulink.util.simulink.Simulink;
import com.mathworks.toolbox.simulink.util.simulink.SimulinkProxy;
import com.mathworks.toolbox.simulink.util.state.ObjectState;
import com.mathworks.toolbox.simulink.util.state.State;
import com.mathworks.toolbox.simulink.util.state.StateBroadcastingCmdPanel;
import com.mathworks.toolbox.simulink.util.state.StateChainRoot;
import com.mathworks.toolbox.simulink.util.state.StateFactory;
import com.mathworks.toolbox.simulink.util.state.StringState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class SelectionPanel
extends StateBroadcastingCmdPanel {
    protected ControlSubpanel fCSubpanel;
    protected NavigationSubpanel fNSubpanel;
    protected FilterSubpanel fFSubpanel;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.selectiondialog.resources.RES_selectiondialog");
    private SimulinkProxy fSimulinkProxy;
    private Simulink fSimulink = Simulink.getSimulinkInstance();
    private String fMFunctionName;
    private String fActionCommand;
    private String fFinalizationCommand = "Dispose";
    private String fDataQueueryCommand = "LookUpHandlesByNames";
    private SelectionDialog fParentSelectionDialog;
    private double[] fSelectionData;
    private static String fErrorAlertTitle = sRes.getString("title.Selection");
    private String fAdditionalAlertText = sRes.getString("string.AdditionalAlertText");

    public SelectionPanel() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
    }

    public void setControlSubpanel(ControlSubpanel controlSubpanel) {
        if (this.fCSubpanel != null) {
            this.remove((Component)((Object)this.fCSubpanel));
        }
        this.fCSubpanel = controlSubpanel;
        this.add((Component)((Object)this.fCSubpanel), "North");
    }

    public void setNavigationSubpanel(NavigationSubpanel navigationSubpanel) {
        if (this.fNSubpanel != null) {
            this.remove((Component)((Object)this.fNSubpanel));
        }
        this.fNSubpanel = navigationSubpanel;
        this.add((Component)((Object)this.fNSubpanel), "Center");
    }

    public void setFilterSubpanel(FilterSubpanel filterSubpanel) {
        if (this.fFSubpanel != null) {
            this.remove((Component)((Object)this.fFSubpanel));
        }
        this.fFSubpanel = filterSubpanel;
        this.add((Component)((Object)this.fFSubpanel), "South");
    }

    public void setState(State state) {
        switch (state.getStateId()) {
            case -11: {
                this.fMFunctionName = ((StringState)state).getValue();
                super.setState(state);
                return;
            }
            case -13: {
                this.fSimulinkProxy = (SimulinkProxy)((ObjectState)state).getValue();
                super.setState(state);
                return;
            }
            case -12: {
                this.fActionCommand = ((StringState)state).getValue();
                super.setState(state);
                return;
            }
        }
        super.setState(state);
    }

    public State getState(int n) {
        switch (n) {
            case -11: {
                return StateFactory.generateState(n, this.fMFunctionName);
            }
            case -13: {
                return StateFactory.generateState(n, this.fSimulinkProxy);
            }
            case -12: {
                return StateFactory.generateState(n, this.fActionCommand);
            }
        }
        return super.getState(n);
    }

    public double[] getSelectionData() {
        return this.fSelectionData;
    }

    public boolean isCommandEnabled(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return super.isCommandEnabled(n);
    }

    public void doCommand(int n) {
        switch (n) {
            case 1: 
            case 2: {
                this.repopulatePanel();
                return;
            }
            case 11: {
                this.finalizeSelection(this.fParentSelectionDialog);
                return;
            }
        }
        super.doCommand(n);
    }

    private void repopulatePanel() {
        CompletionObserver completionObserver = this.fSimulinkProxy.generateSimProxyCompletionObserver(null);
        StateChainRoot stateChainRoot = this.getChainRoot();
        this.fSimulink.feval(this.fMFunctionName, this.fActionCommand, new Double(-1.0), LocalStateFactory.TranslateStateToObject(stateChainRoot, -301), LocalStateFactory.TranslateStateToObject(stateChainRoot, -302), LocalStateFactory.TranslateStateToObject(stateChainRoot, -101), LocalStateFactory.TranslateStateToObject(stateChainRoot, -621), 8, completionObserver);
    }

    public void setParentObject(SelectionDialog selectionDialog) {
        this.fParentSelectionDialog = selectionDialog;
    }

    public void finalizeSelection(Object object) {
        ObjectState objectState = (ObjectState)this.getChainRoot().lookupState(-502);
        StringState stringState = (StringState)this.getChainRoot().lookupState(-611);
        Object[] objectArray = (Object[])objectState.getValue();
        String string = stringState.getValue();
        double[] dArray = objectArray != null ? (double[])objectArray[0] : null;
        boolean bl = false;
        if (string == null || string.length() == 0) {
            this.fSelectionData = dArray;
            bl = true;
        } else {
            try {
                String[] stringArray = this.parseTypedText(string);
                String[] stringArray2 = objectArray != null ? (String[])objectArray[1] : null;
                boolean bl2 = false;
                if (stringArray2 == null || stringArray2.length != stringArray.length) {
                    bl2 = true;
                } else {
                    int n = 0;
                    while (n < stringArray.length) {
                        if (!stringArray[n].equals(stringArray2[n])) {
                            bl2 = true;
                            break;
                        }
                        ++n;
                    }
                }
                this.fSelectionData = bl2 ? this.queryDataHandles(stringArray) : dArray;
                bl = true;
            }
            catch (DataValidationException dataValidationException) {
                this.launchAlertDialog(dataValidationException);
            }
        }
        this.executeConditionalFinalizationMCall(bl, object);
    }

    private void launchAlertDialog(DataValidationException dataValidationException) {
        String string = dataValidationException.getDataEntry();
        String string2 = dataValidationException.getDescription();
        Object object = this;
        String string3 = String.valueOf(string) + "\n" + string2 + "\n" + this.fAdditionalAlertText;
        while (!(object instanceof Frame)) {
            object = ((Component)object).getParent();
        }
        new MWAlert((Frame)object, fErrorAlertTitle, string3, 1);
    }

    private void executeConditionalFinalizationMCall(boolean bl, Object object) {
        if (bl) {
            this.fSimulink.feval(this.fMFunctionName, this.fFinalizationCommand, object, 0, null);
        }
    }

    private String[] parseTypedText(String string) throws DataValidationException {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        Object[] objectArray = null;
        if (!string2.startsWith("\"")) {
            objectArray = new String[]{string2};
        } else {
            int n;
            Vector<String> vector = new Vector<String>();
            boolean bl = true;
            boolean bl2 = false;
            int n2 = n = 1;
            while (n2 < string2.length()) {
                if (bl) {
                    if (string2.charAt(n2) == '\"') {
                        bl = false;
                        bl2 = true;
                        int n3 = n2;
                        String string3 = string2.substring(n, n3);
                        vector.addElement(string3);
                    }
                } else if (bl2) {
                    if (string2.charAt(n2) == ',') {
                        bl2 = false;
                    } else if (string2.charAt(n2) != ' ') {
                        throw new DataValidationException(string2.substring(n), sRes.getString("exception.CommaExpected"));
                    }
                } else if (string2.charAt(n2) == '\"') {
                    bl = true;
                    n = n2 + 1;
                } else if (string2.charAt(n2) != ' ') {
                    throw new DataValidationException(string2.substring(n2), sRes.getString("exception.QuoteExpected"));
                }
                ++n2;
            }
            if (bl) {
                throw new DataValidationException(string2.substring(n), sRes.getString("exception.MatchingQuoteExpected"));
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    private synchronized double[] queryDataHandles(String[] stringArray) throws DataValidationException {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        this.fSelectionData = null;
        this.fSimulink.feval(this.fMFunctionName, this.fDataQueueryCommand, LocalStateFactory.TranslateStateToObject(this.getChainRoot(), -401), LocalStateFactory.TranslateStateToObject(this.getChainRoot(), -101), stringArray, 1, new DataQueueryCompletionObserver());
        try {
            this.wait(10000L);
        }
        catch (InterruptedException interruptedException) {}
        if (this.fSelectionData != null) {
            int n = 0;
            while (n < this.fSelectionData.length) {
                if (this.fSelectionData[n] == -1.0) {
                    throw new DataValidationException(stringArray[n], sRes.getString("exception.NoCorrespondingObjectFound"));
                }
                ++n;
            }
            return this.fSelectionData;
        }
        return null;
    }

    private Object getThisReference() {
        return this;
    }

    static /* synthetic */ double[] access$2(SelectionPanel selectionPanel) {
        return selectionPanel.fSelectionData;
    }

    private class DataQueueryCompletionObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            Object object2;
            Object object3 = object2 = SelectionPanel.this.getThisReference();
            synchronized (object3) {
                if (n != 0) {
                    object2.notify();
                    throw new RuntimeException(sRes.getString("exception.DataHandleQueryFailed"));
                }
                SelectionPanel.this.fSelectionData = (double[])object;
                object2.notify();
                return;
            }
        }

        DataQueueryCompletionObserver() {
            SelectionPanel.this = SelectionPanel.this;
        }
    }

    private class DataValidationException
    extends Exception {
        private String fDataEntry;
        private String fDescription;

        public DataValidationException(String string, String string2) {
            super(string);
            SelectionPanel.this = SelectionPanel.this;
            this.fDataEntry = string;
            this.fDescription = string2;
        }

        public String getDataEntry() {
            return this.fDataEntry;
        }

        public String getDescription() {
            return this.fDescription;
        }
    }
}

