/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.selectiondialog;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.toolbox.simulink.selectiondialog.SelectionPanel;
import com.mathworks.toolbox.simulink.selectiondialog.constructor.SelectionPanelBuilder;
import com.mathworks.toolbox.simulink.selectiondialog.constructor.SelectionPanelConstructor;
import com.mathworks.toolbox.simulink.util.state.StateChainRoot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;

public abstract class SelectionDialog
implements MWCommandTarget {
    private MWFrame fSDialog;
    private SelectionPanel fSPanel;
    private MWButton fOKButton;
    private MWButton fCancelButton;
    private MWButton fHelpButton;
    private int fPrefWidth = 620;
    private int fPrefHight = 400;
    private int fScreenWidth;
    private int fScreenHeight;
    private String fFinalizationCallback;
    private Object fUserData;
    public static String fDialogTitle;
    private static ResourceBundle sRes;

    public SelectionDialog(String string, int n, int n2) {
        fDialogTitle = string;
        this.fScreenWidth = n;
        this.fScreenHeight = n2;
    }

    public void showDialog() {
        this.fSDialog = new MWFrame(fDialogTitle);
        this.fSDialog.addWindowListener(new OSDWindowAdapter());
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new FlowLayout(2));
        this.fOKButton = new MWButton(sRes.getString("button.OK"));
        this.fCancelButton = new MWButton(sRes.getString("button.Cancel"));
        this.fHelpButton = new MWButton(sRes.getString("button.Help"));
        mWPanel2.add((Component)this.fOKButton);
        mWPanel2.add((Component)this.fCancelButton);
        mWPanel2.add((Component)this.fHelpButton);
        mWPanel2.setInsets(new Insets(5, 5, 5, 5));
        this.fOKButton.addActionListener((ActionListener)new OSDWindowAction());
        this.fCancelButton.addActionListener((ActionListener)new OSDWindowAction());
        this.fHelpButton.addActionListener((ActionListener)new OSDWindowAction());
        mWPanel.add((Component)((Object)this.fSPanel), "Center");
        mWPanel.add((Component)mWPanel2, "South");
        this.fSDialog.add((Component)mWPanel);
        if (this.fScreenHeight != -1 && this.fScreenWidth != -1) {
            int n = this.fScreenWidth / 2 - this.fPrefWidth / 2;
            int n2 = this.fScreenHeight / 2 - this.fPrefHight / 2;
            this.fSDialog.setLocation(n, n2);
        }
        this.fSDialog.setSize(this.fPrefWidth, this.fPrefHight);
        this.fSDialog.setResizable(false);
        this.fSDialog.setVisible(true);
    }

    public void doCommand(int n) {
        switch (n) {
            case 11: {
                this.fSPanel.finalizeSelection(this);
                return;
            }
        }
    }

    public void disposeSelectionDialog() {
        this.fSDialog.dispose();
    }

    public void setFinalizationCallback(String string, Object object) {
        this.fFinalizationCallback = string;
        this.fUserData = object;
    }

    public String getFinalizationFcn() {
        return this.fFinalizationCallback;
    }

    public Object getUserData() {
        return this.fUserData;
    }

    public double[] getSelectionData() {
        return this.fSPanel.getSelectionData();
    }

    public Dimension getScreenSize() {
        return new Dimension(this.fScreenWidth, this.fScreenHeight);
    }

    protected SelectionDialog() {
    }

    protected void constructSelectionPanel(SelectionPanelBuilder selectionPanelBuilder) {
        SelectionPanelConstructor selectionPanelConstructor = new SelectionPanelConstructor(selectionPanelBuilder);
        selectionPanelConstructor.Construct();
        this.fSPanel = selectionPanelBuilder.getSelectionPanel();
        this.initializeStates(this.fSPanel);
        this.fSPanel.doCommand(1);
        this.fSPanel.setParentObject(this);
    }

    protected void initializeStates(StateChainRoot stateChainRoot) {
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.selectiondialog.resources.RES_selectiondialog");
    }

    private class OSDWindowAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == SelectionDialog.this.fSDialog) {
                SelectionDialog.this.disposeSelectionDialog();
            }
        }

        OSDWindowAdapter() {
            SelectionDialog.this = SelectionDialog.this;
        }
    }

    class OSDWindowAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SelectionDialog.this.fOKButton) {
                SelectionDialog.this.doCommand(11);
            }
            if (object == SelectionDialog.this.fCancelButton) {
                SelectionDialog.this.disposeSelectionDialog();
            }
            SelectionDialog.this.fHelpButton;
        }

        OSDWindowAction() {
            SelectionDialog.this = SelectionDialog.this;
        }
    }
}

