/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.selectiondialog;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWToolTip;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.toolbox.simulink.selectiondialog.customcomponents.CustomMWChoice;
import com.mathworks.toolbox.simulink.util.simulink.SimulinkProxy;
import com.mathworks.toolbox.simulink.util.state.BooleanState;
import com.mathworks.toolbox.simulink.util.state.DoubleState;
import com.mathworks.toolbox.simulink.util.state.ObjectState;
import com.mathworks.toolbox.simulink.util.state.State;
import com.mathworks.toolbox.simulink.util.state.StateChainRoot;
import com.mathworks.toolbox.simulink.util.state.StateFactory;
import com.mathworks.toolbox.simulink.util.state.StateMulticastCmdPanel;
import com.mathworks.toolbox.simulink.util.state.StringState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class LevelControlGroup
extends StateMulticastCmdPanel
implements CompletionObserver {
    private MWLabel fLookInTextLabel;
    private CustomMWChoice fLookInChoice;
    private MWButton fOneLevelUpButton;
    private String fOneLevelUpIconFileName = "resources/GoOneLevelUpIcon.gif";
    private MWImageResource fOneLevelUpIcon;
    private MWToolTip fButtonTooltip;
    private MWToolTip fPopupTooltip;
    private SimulinkProxy fSimulinkProxy;
    private Hashtable fItemRecTable = new Hashtable();
    private String fIndentString = "  ";
    private double fCurrentHandle = -1.0;
    private boolean fWaitingForData;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.selectiondialog.resources.RES_selectiondialog");

    public LevelControlGroup() {
        this.construct();
    }

    public synchronized void setState(State state) {
        switch (state.getStateId()) {
            case -13: {
                this.fSimulinkProxy = (SimulinkProxy)((ObjectState)state).getValue();
                if (this.fSimulinkProxy != null) {
                    this.fSimulinkProxy.addCompletionObserver(this);
                }
                super.setState(state);
                return;
            }
            case -400: {
                MWCommandCenter mWCommandCenter = this.getCommandCenter();
                boolean bl = ((BooleanState)state).getValue();
                this.fOneLevelUpButton.setEnabled(bl);
                this.fLookInChoice.setEnabled(bl);
                if (mWCommandCenter != null) {
                    mWCommandCenter.updateCommand(401);
                    mWCommandCenter.updateCommand(402);
                }
                state.setConsumed(true);
                return;
            }
            case -401: {
                String string = null;
                double d = -1.0;
                MWCommandCenter mWCommandCenter = this.getCommandCenter();
                if (state instanceof StringState) {
                    string = ((StringState)state).getValue();
                    ItemRec itemRec = (ItemRec)this.fItemRecTable.get(string);
                    if (itemRec != null) {
                        d = itemRec.Handle;
                    }
                } else if (state instanceof DoubleState) {
                    d = ((DoubleState)state).getValue();
                    string = this.LookUpItemByHandle(d);
                }
                if (string == null || d == -1.0) {
                    this.fWaitingForData = true;
                } else {
                    this.fLookInChoice.select(string);
                    this.fCurrentHandle = d;
                }
                if (mWCommandCenter != null) {
                    mWCommandCenter.doCommand(402);
                }
                state.setConsumed(true);
                return;
            }
        }
        super.setState(state);
    }

    public State getState(int n) {
        switch (n) {
            case -13: {
                return StateFactory.generateState(n, this.fSimulinkProxy);
            }
            case -400: {
                boolean bl = this.fOneLevelUpButton.isEnabled() && ((Component)((Object)this.fLookInChoice)).isEnabled();
                return StateFactory.generateState(-400, bl);
            }
            case -401: {
                double d = -1.0;
                if (this.fWaitingForData) {
                    ObjectState objectState = (ObjectState)this.getChainRoot().lookupState(-502);
                    Object[] objectArray = (Object[])objectState.getValue();
                    double[] dArray = (double[])objectArray[0];
                    d = dArray[0];
                } else {
                    String string = this.fLookInChoice.getSelectedItem();
                    ItemRec itemRec = (ItemRec)this.fItemRecTable.get(string);
                    d = itemRec.Handle;
                }
                return StateFactory.generateState(-401, d);
            }
        }
        return super.getState(n);
    }

    public boolean isCommandEnabled(int n) {
        switch (n) {
            case 401: {
                String string = this.fLookInChoice.getSelectedItem();
                ItemRec itemRec = (ItemRec)this.fItemRecTable.get(string);
                return itemRec.ParentItem != null;
            }
            case 402: {
                return ((BooleanState)this.getState(-400)).getValue();
            }
        }
        return super.isCommandEnabled(n);
    }

    public void registerCommandSources() {
        MWCommandCenter mWCommandCenter = this.getCommandCenter();
        if (mWCommandCenter != null) {
            mWCommandCenter.addCommandSource((MWCommandSource)this.fOneLevelUpButton, 401);
            mWCommandCenter.addCommandSource((MWCommandSource)this.fLookInChoice, 402);
        }
    }

    public void unregisterCommandSources() {
        MWCommandCenter mWCommandCenter = this.getCommandCenter();
        if (mWCommandCenter != null) {
            mWCommandCenter.removeCommandSource((MWCommandSource)this.fOneLevelUpButton, 401);
            mWCommandCenter.removeCommandSource((MWCommandSource)this.fLookInChoice, 402);
        }
    }

    private void updatePopupTooltip() {
        int n = this.fLookInChoice.getItemCount();
        this.fPopupTooltip.disposeToolTip();
        if (n > 1) {
            String string = "";
            int n2 = 0;
            while (n2 < n) {
                String string2 = this.fLookInChoice.getItem(n2);
                string = String.valueOf(string) + string2.trim() + "/";
                ++n2;
            }
            this.fPopupTooltip = new MWToolTip((Component)((Object)this.fLookInChoice), string);
        }
    }

    public void doCommand(int n) {
        switch (n) {
            case 401: {
                String string = this.fLookInChoice.getSelectedItem();
                ItemRec itemRec = (ItemRec)this.fItemRecTable.get(string);
                String string2 = itemRec.ParentItem;
                if (string2 == null) break;
                MWCommandCenter mWCommandCenter = this.getCommandCenter();
                ItemRec itemRec2 = (ItemRec)this.fItemRecTable.get(string2);
                this.setState(StateFactory.generateState(-401, string2));
                this.removeDescendentItems(string2);
                this.fCurrentHandle = itemRec2.Handle;
                if (mWCommandCenter == null) break;
                mWCommandCenter.updateCommand(401);
                return;
            }
            case 402: {
                String string = this.fLookInChoice.getSelectedItem();
                ItemRec itemRec = (ItemRec)this.fItemRecTable.get(string);
                if (this.fCurrentHandle != itemRec.Handle && !this.fWaitingForData) {
                    this.removeDescendentItems(string);
                    this.fCurrentHandle = itemRec.Handle;
                }
                super.doCommand(n);
                return;
            }
            case 501: {
                StateChainRoot stateChainRoot = this.getChainRoot();
                ObjectState objectState = (ObjectState)stateChainRoot.lookupState(-502);
                Object[] objectArray = (Object[])objectState.getValue();
                double[] dArray = (double[])objectArray[0];
                this.setState(StateFactory.generateState(-401, dArray[0]));
                return;
            }
            default: {
                super.doCommand(n);
            }
        }
    }

    public synchronized void completed(int n, Object object) {
        Object[] objectArray = (Object[])object;
        double[] dArray = (double[])objectArray[0];
        String[] stringArray = (String[])objectArray[1];
        if (dArray[0] != this.fCurrentHandle) {
            String string = this.LookUpItemByHandle(dArray[0]);
            MWCommandCenter mWCommandCenter = this.getCommandCenter();
            if (this.fCurrentHandle == -1.0 || this.fItemRecTable.isEmpty()) {
                string = stringArray[0];
                this.fItemRecTable.put(string, new ItemRec(0, dArray[0], null));
                this.fLookInChoice.add(string);
                this.fLookInChoice.select(string);
            } else if (string == null && this.fWaitingForData) {
                String string2 = this.fLookInChoice.getSelectedItem();
                ItemRec itemRec = (ItemRec)this.fItemRecTable.get(string2);
                int n2 = itemRec.LevelInTheHierarchy + 1;
                string = stringArray[0];
                int n3 = 0;
                while (n3 < n2) {
                    string = String.valueOf(this.fIndentString) + string;
                    ++n3;
                }
                itemRec.ChildItem = string = string.replace('\n', ' ');
                this.fItemRecTable.put(string, new ItemRec(n2, dArray[0], string2));
                this.fLookInChoice.add(string);
                this.fLookInChoice.select(string);
            }
            this.fWaitingForData = false;
            this.updatePopupTooltip();
            this.fCurrentHandle = dArray[0];
            if (mWCommandCenter != null) {
                mWCommandCenter.updateCommand(401);
            }
        }
    }

    private void construct() {
        int n = new FlowLayout().getHgap();
        this.fOneLevelUpIcon = new MWImageResource(this.fOneLevelUpIconFileName, (Object)this);
        this.fOneLevelUpButton = new MWButton(this.fOneLevelUpIcon);
        this.fButtonTooltip = new MWToolTip((Component)this.fOneLevelUpButton, sRes.getString("button.GoUpOneLevel"));
        ((Container)((Object)this)).setLayout(new BorderLayout());
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout());
        this.fLookInTextLabel = new MWLabel(sRes.getString("label.LookIn"), 0);
        mWPanel.add((Component)this.fLookInTextLabel);
        mWPanel.setInsets(new Insets(n, 0, n, 0));
        ((Container)((Object)this)).add((Component)mWPanel, "West");
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new GridLayout());
        this.fLookInChoice = new CustomMWChoice(this.fLookInTextLabel);
        this.fPopupTooltip = new MWToolTip((Component)((Object)this.fLookInChoice), "");
        this.fPopupTooltip.setVisible(false);
        mWPanel2.setInsets(new Insets(n, 0, n, 0));
        mWPanel2.add((Component)((Object)this.fLookInChoice));
        ((Container)((Object)this)).add((Component)mWPanel2, "Center");
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new FlowLayout());
        mWPanel3.add((Component)this.fOneLevelUpButton);
        ((Container)((Object)this)).add((Component)mWPanel3, "East");
        this.setState(StateFactory.generateState(-400, true));
        this.setState(StateFactory.generateState(-401, -1.0));
    }

    private String LookUpItemByHandle(double d) {
        if (this.fItemRecTable != null) {
            Enumeration enumeration = this.fItemRecTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ItemRec itemRec = (ItemRec)this.fItemRecTable.get(string);
                if (itemRec.Handle != d) continue;
                return string;
            }
        }
        return null;
    }

    private void removeDescendentItems(String string) {
        ItemRec itemRec = (ItemRec)this.fItemRecTable.get(string);
        String string2 = itemRec.ChildItem;
        while (string2 != null) {
            itemRec = (ItemRec)this.fItemRecTable.get(string2);
            if (itemRec == null) break;
            this.fLookInChoice.remove(string2);
            this.fItemRecTable.remove(string2);
            string2 = itemRec.ChildItem;
        }
        this.updatePopupTooltip();
    }

    private class ItemRec {
        public int LevelInTheHierarchy;
        public double Handle;
        public String ParentItem;
        public String ChildItem;

        public ItemRec(int n, double d, String string) {
            LevelControlGroup.this = LevelControlGroup.this;
            this.LevelInTheHierarchy = n;
            this.Handle = d;
            this.ParentItem = string;
        }
    }
}

