/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.selectiondialog;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWToolTip;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.toolbox.simulink.selectiondialog.customcomponents.CustomMWButton;
import com.mathworks.toolbox.simulink.util.state.BooleanState;
import com.mathworks.toolbox.simulink.util.state.IntegerState;
import com.mathworks.toolbox.simulink.util.state.State;
import com.mathworks.toolbox.simulink.util.state.StateFactory;
import com.mathworks.toolbox.simulink.util.state.StateMulticastCmdPanel;
import com.mathworks.util.Assert;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.ResourceBundle;

public class DepthControlButtonGroup
extends StateMulticastCmdPanel {
    public static final int CURRENT_BUTTON = 101;
    public static final int CURRENT_AND_BELOW_BUTTON = 102;
    private MWButton fCurrentLevelButton;
    private MWButton fCurrentAndBelowButton;
    private MWExclusiveGroup fExclusiveGroup;
    private MWToolTip fCurrentLevelButtonTooltip;
    private MWToolTip fCurrentAndBelowButtonTooltip;
    private String fCurrentLevelButtonTooltipStr = sRes.getString("string.CurrentLevel");
    private String fCurrentAndBelowButtonTooltipStr = sRes.getString("string.CurrentAndBelow");
    private String fCurrentLevelIconFileName = "resources/CurrentLevelIcon.gif";
    private String fCurrentAndBelowIconFileName = "resources/CurrentAndBelowIcon.gif";
    private MWImageResource fCurrentLevelIcon;
    private MWImageResource fCurrentAndBelowIcon;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.selectiondialog.resources.RES_selectiondialog");

    public DepthControlButtonGroup() {
        this.construct();
    }

    public synchronized void setState(State state) {
        switch (state.getStateId()) {
            case -100: {
                MWCommandCenter mWCommandCenter = this.getCommandCenter();
                boolean bl = ((BooleanState)state).getValue();
                this.fCurrentLevelButton.setEnabled(bl);
                this.fCurrentAndBelowButton.setEnabled(bl);
                if (mWCommandCenter != null) {
                    mWCommandCenter.updateCommand(101);
                    mWCommandCenter.updateCommand(102);
                }
                state.setConsumed(true);
                return;
            }
            case -101: {
                MWCommandCenter mWCommandCenter = this.getCommandCenter();
                int n = ((IntegerState)state).getValue();
                switch (n) {
                    case 101: {
                        this.fCurrentLevelButton.setState(true);
                        break;
                    }
                    case 102: {
                        this.fCurrentAndBelowButton.setState(true);
                        break;
                    }
                    default: {
                        Assert.assert((boolean)true);
                    }
                }
                state.setConsumed(true);
                return;
            }
        }
        super.setState(state);
    }

    public State getState(int n) {
        switch (n) {
            case -100: {
                boolean bl = this.fCurrentLevelButton.isEnabled() && this.fCurrentAndBelowButton.isEnabled();
                return StateFactory.generateState(-100, bl);
            }
            case -101: {
                int n2 = -1;
                if (this.fCurrentLevelButton.getState()) {
                    n2 = 101;
                }
                if (this.fCurrentAndBelowButton.getState()) {
                    n2 = 102;
                }
                return StateFactory.generateState(-101, n2);
            }
        }
        return super.getState(n);
    }

    public boolean isCommandEnabled(int n) {
        switch (n) {
            case 101: 
            case 102: {
                return ((BooleanState)this.getState(-100)).getValue();
            }
        }
        return super.isCommandEnabled(n);
    }

    public void registerCommandSources() {
        MWCommandCenter mWCommandCenter = this.getCommandCenter();
        if (mWCommandCenter != null) {
            mWCommandCenter.addCommandSource((MWCommandSource)this.fCurrentLevelButton, 101);
            mWCommandCenter.addCommandSource((MWCommandSource)this.fCurrentAndBelowButton, 102);
        }
    }

    public void unregisterCommandSources() {
        MWCommandCenter mWCommandCenter = this.getCommandCenter();
        if (mWCommandCenter != null) {
            mWCommandCenter.addCommandSource((MWCommandSource)this.fCurrentLevelButton, 101);
            mWCommandCenter.addCommandSource((MWCommandSource)this.fCurrentAndBelowButton, 102);
        }
    }

    private void construct() {
        this.fCurrentLevelIcon = new MWImageResource(this.fCurrentLevelIconFileName, (Object)this);
        this.fCurrentAndBelowIcon = new MWImageResource(this.fCurrentAndBelowIconFileName, (Object)this);
        this.fExclusiveGroup = new MWExclusiveGroup();
        this.fCurrentLevelButton = new CustomMWButton(this.fCurrentLevelIcon, this.fExclusiveGroup);
        this.fCurrentAndBelowButton = new CustomMWButton(this.fCurrentAndBelowIcon, this.fExclusiveGroup);
        this.fCurrentLevelButtonTooltip = new MWToolTip((Component)this.fCurrentLevelButton, this.fCurrentLevelButtonTooltipStr);
        this.fCurrentAndBelowButtonTooltip = new MWToolTip((Component)this.fCurrentAndBelowButton, this.fCurrentAndBelowButtonTooltipStr);
        ((Container)((Object)this)).setLayout(new FlowLayout(1, 0, 0));
        ((Container)((Object)this)).add((Component)this.fCurrentLevelButton);
        ((Container)((Object)this)).add((Component)this.fCurrentAndBelowButton);
        this.setState(StateFactory.generateState(-100, true));
        this.setState(StateFactory.generateState(-101, 101));
    }
}

