/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.preferences;

import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.services.Prefs;
import com.mathworks.toolbox.simulink.preferences.PrefsDescriptor;
import com.mathworks.toolbox.simulink.preferences.TaggedString;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ResourceBundle;

public class StringPrefsDescriptor
extends PrefsDescriptor {
    private MWTextField fText;
    private String fInitialText;
    private static final String STRING_TAG = "%<string>";

    public StringPrefsDescriptor(String string) {
        this.fParamName = string;
    }

    public void addPrefsWidget(MWPanel mWPanel, ResourceBundle resourceBundle) {
        super.addPrefsWidget(mWPanel, resourceBundle);
        MWPanel mWPanel2 = new MWPanel();
        mWPanel2.setLayout(new GridLayout(1, 2));
        mWPanel2.add((Component)new MWLabel(this.fPrompt, 0));
        this.fText = new MWTextField();
        mWPanel2.add((Component)this.fText);
        mWPanel.add((Component)mWPanel2);
    }

    public void configPrefsWidget(Object object) {
        this.fInitialText = Prefs.getStringPref((String)this.fPrefsKey, (String)((String)object));
        this.fText.setText(this.fInitialText);
        this.fText.setCaretPosition(0);
    }

    public String getSetPrefsString() {
        TaggedString taggedString = new TaggedString(super.getSetPrefsString());
        if (taggedString.toString() == null) {
            return null;
        }
        String string = null;
        if (this.fInitialText.compareTo(this.fText.getText()) != 0) {
            string = taggedString.replaceTag(STRING_TAG, this.fText.getText());
        }
        return string;
    }

    public String loadPrefs(ResourceBundle resourceBundle) {
        String string = null;
        super.loadPrefs(resourceBundle);
        if (Prefs.exists((String)this.fPrefsKey)) {
            TaggedString taggedString = new TaggedString(super.getSetPrefsString());
            this.fInitialText = Prefs.getStringPref((String)this.fPrefsKey);
            string = taggedString.replaceTag(STRING_TAG, this.fInitialText);
        }
        return string;
    }

    public void savePrefs() {
        if (this.fInitialText.compareTo(this.fText.getText()) != 0) {
            this.fInitialText = this.fText.getText();
            Prefs.setStringPref((String)this.fPrefsKey, (String)this.fText.getText());
        }
    }
}

