/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.preferences;

import com.mathworks.beans.editors.FontPicker;
import com.mathworks.mwt.MWFontHandler;
import com.mathworks.mwt.MWPanel;
import com.mathworks.services.Prefs;
import com.mathworks.toolbox.simulink.preferences.PrefsDescriptor;
import com.mathworks.toolbox.simulink.preferences.TaggedString;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ResourceBundle;

public class FontPrefsDescriptor
extends PrefsDescriptor {
    private FontPicker fFontPicker;
    private Font fInitialFont;
    private static final String FONTNAME_TAG = "%<fontName>";
    private static final String FONTSIZE_TAG = "%<fontSize>";
    private static final String FONTWEIGHT_TAG = "%<fontWeight>";
    private static final String FONTANGLE_TAG = "%<fontAngle>";

    public FontPrefsDescriptor(String string) {
        this.fParamName = string;
    }

    public void addPrefsWidget(MWPanel mWPanel, ResourceBundle resourceBundle) {
        super.addPrefsWidget(mWPanel, resourceBundle);
        MWPanel mWPanel2 = new MWPanel();
        mWPanel2.setLayout(new FlowLayout(0, 5, 3));
        this.fFontPicker = new FontPicker(null, true);
        mWPanel2.add((Component)this.fFontPicker);
        mWPanel.add((Component)mWPanel2);
    }

    public void configPrefsWidget(Object object) {
        Object object2;
        String string;
        Object[] objectArray;
        int n;
        int n2;
        String string2;
        Object[] objectArray2 = (Object[])object;
        if (this.fInitialFont != null) {
            string2 = MWFontHandler.getOSFontName((String)this.fInitialFont.getName());
            n2 = this.fInitialFont.getStyle();
            n = this.fInitialFont.getSize();
        } else {
            objectArray = (double[])objectArray2[1];
            string2 = (String)objectArray2[0];
            n = (int)objectArray[0];
            string = (String)objectArray2[2];
            String string3 = (String)objectArray2[3];
            n2 = 0;
            if (string.compareTo("bold") == 0) {
                ++n2;
            }
            if (string3.compareTo("italic") == 0) {
                n2 += 2;
            }
        }
        objectArray = new String[6];
        objectArray[0] = (double)string2;
        string = "MS ";
        objectArray[1] = string2.startsWith(string) ? (double)string2.substring(string.length()) : (double)new String(string2);
        objectArray[2] = (double)"";
        int n3 = 0;
        while (n3 < objectArray[1].length()) {
            object2 = new char[]{objectArray[1].charAt(n3)};
            if (object2[0] > ' ') {
                objectArray[2] = (double)objectArray[2].concat(new String((char[])object2));
            }
            ++n3;
        }
        objectArray[3] = (double)"helvetica";
        objectArray[4] = (double)"courier";
        objectArray[5] = (double)"Monospaced";
        object2 = MWFontHandler.newFont((String[])objectArray, (int)n2, (int)n);
        this.fFontPicker.setSelectedFont((Font)object2);
        this.fInitialFont = this.fFontPicker.getSelectedFont();
    }

    private String utGetSetPrefsString(Font font) {
        String string = MWFontHandler.getOSFontName((String)font.getName());
        int n = font.getSize();
        String string2 = font.isBold() ? "bold" : "normal";
        String string3 = font.isItalic() ? "italic" : "normal";
        TaggedString taggedString = new TaggedString(super.getSetPrefsString());
        taggedString = new TaggedString(taggedString.replaceTag(FONTNAME_TAG, string));
        taggedString = new TaggedString(taggedString.replaceTag(FONTSIZE_TAG, n));
        taggedString = new TaggedString(taggedString.replaceTag(FONTWEIGHT_TAG, string2));
        taggedString = new TaggedString(taggedString.replaceTag(FONTANGLE_TAG, string3));
        return taggedString.toString();
    }

    public String getSetPrefsString() {
        String string = null;
        Font font = this.fFontPicker.getSelectedFont();
        if (!font.equals(this.fInitialFont)) {
            string = this.utGetSetPrefsString(font);
        }
        return string;
    }

    public String loadPrefs(ResourceBundle resourceBundle) {
        String string = null;
        super.loadPrefs(resourceBundle);
        if (Prefs.exists((String)this.fPrefsKey)) {
            this.fInitialFont = Prefs.getFontPref((String)this.fPrefsKey);
            string = this.utGetSetPrefsString(this.fInitialFont);
        }
        return string;
    }

    public void savePrefs() {
        Font font = this.fFontPicker.getSelectedFont();
        if (!font.equals(this.fInitialFont)) {
            this.fInitialFont = font;
            Prefs.setFontPref((String)this.fPrefsKey, (Font)font);
        }
    }
}

