/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.finder;

import com.mathworks.ide.help.CSHelpTopicMapRegistry;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWCombobox;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWSplitter;
import com.mathworks.mwt.MWTabPanel;
import com.mathworks.mwt.MWTreeView;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandPanel;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.CellMWCheckbox;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.MixedState;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableData;
import com.mathworks.mwt.table.TreeData;
import com.mathworks.mwt.table.ValueEvent;
import com.mathworks.mwt.table.ValueListener;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.toolbox.simulink.finder.CustomCellCombobox;
import com.mathworks.toolbox.simulink.finder.CustomCellText;
import com.mathworks.toolbox.simulink.finder.CustomCellTextWithHeaderEvents;
import com.mathworks.toolbox.simulink.finder.ResultsListbox;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

public class Finder
extends MWCommandPanel
implements ActionListener,
ItemListener,
MouseListener,
TextListener,
ValueListener {
    private MWSplitter fMainPanel;
    private MWCommandCenter fCenter;
    private MWTreeView fObjectList;
    private MWCheckbox fMaskChoice;
    private MWCheckbox fLinkChoice;
    private MWTabPanel fSearchPanel;
    private MWChoice fRegexpChoice;
    private MWCheckbox fCaseChoice;
    private MWCombobox fNameField;
    private MWCheckbox fBlockParamsCheckbox;
    private MWListbox fPVList;
    private String[] fProperties;
    private MWCombobox fSystemField;
    private MWButton fSystemBrowse;
    private MWButton fFindButton;
    private MWButton fHelpButton;
    private MWButton fCancelButton;
    private ResultsListbox fResultsList;
    private MWLabel fStatus;
    private boolean fDialogResized = false;
    private int[] fTopNodeIds = new int[2];
    private int fNumTopNodes;
    private MWMenu fContextMenu;
    private static final int PARAMETERS = 1;
    private static final int PROPERTIES = 2;
    private static final int EDIT = 3;
    private static final int EXPLORE = 4;
    private Matlab fMatlab = new Matlab(new MWLooper("Finder - findslobj"));
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.finder.resources.RES_Finder");
    static /* synthetic */ Class class$com$mathworks$mwt$table$MixedState;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$mathworks$mwt$table$LabeledImageResource;

    public MWCombobox getSystemField() {
        return this.fSystemField;
    }

    private void updateWindowTitle(Finder finder) {
        MWFrame mWFrame = (MWFrame)((Component)((Object)finder)).getParent();
        mWFrame.setTitle(String.valueOf(sRes.getString("frame.title")) + this.fSystemField.getText());
    }

    public void setSystemField(String string) {
        this.fSystemField.setText(string);
        this.updateWindowTitle(this);
    }

    public ResultsListbox getResultsList() {
        return this.fResultsList;
    }

    public void setProperties(String[] stringArray) {
        this.fProperties = stringArray;
    }

    public String[] getProperties() {
        return this.fProperties;
    }

    public void doCommand(int n) {
        int n2 = this.fResultsList.getFirstSelectedRow();
        if (n2 >= 0) {
            Object[] objectArray = new Object[3];
            objectArray[0] = "ContextMenu";
            switch (n) {
                case 2: {
                    objectArray[1] = "Property";
                    break;
                }
                case 1: {
                    objectArray[1] = "Parameter";
                    break;
                }
                case 4: {
                    objectArray[1] = "Explore";
                    break;
                }
                case 3: {
                    objectArray[1] = "Edit";
                    break;
                }
            }
            objectArray[2] = new Integer(n2 + 1);
            this.fMatlab.feval("findslobj", objectArray, (CompletionObserver)new FinderObserver("ContextMenu"));
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.fNameField) {
            this.setBlockParamsCheckboxState();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (PlatformInfo.getPlatform() == 2) {
            this.processMouseEvents(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (PlatformInfo.getPlatform() != 2) {
            this.processMouseEvents(mouseEvent);
        }
    }

    private void processMouseEvents(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.fResultsList) {
            int n = this.fResultsList.getSelectedIndex();
            TableData tableData = this.fResultsList.getData();
            if (n >= 0 && mouseEvent.isPopupTrigger()) {
                LabeledImageResource labeledImageResource = (LabeledImageResource)tableData.getData(n, 0);
                String string = labeledImageResource.getLabel();
                this.fContextMenu.removeAll();
                String string2 = tableData.getDataAsText(n, 1);
                if (string.startsWith("Blo")) {
                    this.fContextMenu.addMenuItem(String.valueOf(sRes.getString("menuitem.parametersFor")) + string2, 1);
                    this.fContextMenu.addMenuItem(String.valueOf(sRes.getString("menuitem.propertiesFor")) + string2, 2);
                } else if (string.startsWith("Sig")) {
                    this.fContextMenu.addMenuItem(sRes.getString("menuitem.properties"), 2);
                } else if (!string.startsWith("Ann")) {
                    if (string.startsWith("Jun") || string.startsWith("Sta") || string.startsWith("Tra")) {
                        this.fContextMenu.addMenuItem(String.valueOf(sRes.getString("menuitem.explore")) + string2, 4);
                        this.fContextMenu.addMenuItem(String.valueOf(sRes.getString("menuitem.edit")) + string2, 3);
                        this.fContextMenu.addMenuItem(sRes.getString("menuitem.properties"), 2);
                    } else {
                        this.fContextMenu.addMenuItem(String.valueOf(sRes.getString("menuitem.explore")) + string2, 4);
                        this.fContextMenu.addMenuItem(sRes.getString("menuitem.properties"), 2);
                    }
                }
                this.fContextMenu.show((Component)((Object)this.fResultsList), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        if (itemEvent.getSource() == this.fResultsList && (n = this.fResultsList.getFirstSelectedRow()) >= 0) {
            Object[] objectArray = new Object[]{new String("SelectObjects"), new Integer(n + 1)};
            this.fMatlab.feval("findslobj", objectArray, (CompletionObserver)new FinderObserver("Select"));
        }
    }

    public void valueChanged(ValueEvent valueEvent) {
        int n = valueEvent.getRow();
        int n2 = valueEvent.getColumn();
        if (n2 == 1) {
            boolean bl;
            MWTreeView mWTreeView = (MWTreeView)valueEvent.getSource();
            TreeData treeData = mWTreeView.getTreeData();
            int n3 = treeData.getItemId(n);
            Object object = mWTreeView.getCellData(n, n2);
            boolean bl2 = bl = ((MixedState)object).getState() == 1;
            if (treeData.hasChildren(n3)) {
                int[] nArray = treeData.getChildren(n3);
                int n4 = 0;
                while (n4 < nArray.length) {
                    Object[] objectArray = (Object[])treeData.getItem(nArray[n4]);
                    ((MixedState)objectArray[1]).setState(bl ? 1 : 0);
                    ++n4;
                }
            } else {
                int n5;
                int[] nArray;
                int n6 = treeData.getParent(n3);
                boolean bl3 = false;
                Object[] objectArray = (Object[])treeData.getItem(n6);
                if (!bl) {
                    bl3 = bl;
                } else {
                    nArray = treeData.getChildren(n6);
                    bl3 = true;
                    n5 = 0;
                    while (n5 < nArray.length) {
                        Object[] objectArray2 = (Object[])treeData.getItem(nArray[n5]);
                        if (((MixedState)objectArray2[1]).getState() == 0) {
                            bl3 = false;
                            break;
                        }
                        ++n5;
                    }
                }
                nArray = treeData.getChildren(n6);
                n5 = 0;
                int n7 = 0;
                while (n7 < nArray.length) {
                    Object[] objectArray3 = (Object[])treeData.getItem(nArray[n7]);
                    if (((MixedState)objectArray3[1]).getState() == 1) {
                        n5 = 1;
                        break;
                    }
                    ++n7;
                }
                if (bl3) {
                    ((MixedState)objectArray[1]).setState(1);
                } else if (n5 != 0) {
                    ((MixedState)objectArray[1]).setState(2);
                } else {
                    ((MixedState)objectArray[1]).setState(0);
                }
            }
            mWTreeView.repaint();
            this.setBlockParamsCheckboxState();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fPVList.commitEdit();
        Frame frame = (Frame)((Component)((Object)this)).getParent();
        if (actionEvent.getSource() == this.fResultsList) {
            int n = this.fResultsList.getSelectedIndex();
            Object[] objectArray = new Object[]{new String("OpenObjects"), new Integer(n + 1)};
            this.fMatlab.feval("findslobj", objectArray, (CompletionObserver)new FinderObserver("Open"));
        }
        if (actionEvent.getSource() == this.fFindButton || actionEvent.getSource() == this.fNameField) {
            LabeledImageResource labeledImageResource;
            int n;
            Object[] objectArray;
            Object[] objectArray2;
            this.fStatus.setText(sRes.getString("status.searching"));
            this.setBusyAffordance();
            Dimension dimension = frame.getSize();
            if (!this.fDialogResized) {
                ((Component)frame).setSize(dimension.width, (int)((double)dimension.height / 0.65));
                this.fMainPanel.setDividerLocation(0.65);
                this.fDialogResized = true;
            }
            boolean bl = true;
            int n2 = 0;
            boolean bl2 = this.fSearchPanel.getSelectedIndex() == 1;
            int n3 = 0;
            TableData tableData = this.fPVList.getData();
            if (bl2) {
                n3 = 0;
                while (n3 < tableData.getHeight()) {
                    boolean bl3 = (Boolean)tableData.getData(n3, 0);
                    if (bl3) {
                        ++n2;
                    }
                    ++n3;
                }
            } else {
                this.addStringToSearchHistory(this.fNameField.getText());
                n2 = 1;
            }
            TableData tableData2 = this.fResultsList.getData();
            tableData2.setHeight(0);
            TreeData treeData = this.fObjectList.getTreeData();
            int n4 = this.fNumTopNodes;
            int n5 = 0;
            while (n5 < this.fNumTopNodes) {
                objectArray2 = treeData.getChildren(this.fTopNodeIds[n5]);
                n4 += objectArray2.length;
                ++n5;
            }
            objectArray2 = new String[n4];
            int n6 = 0;
            int n7 = 0;
            while (n7 < this.fNumTopNodes) {
                objectArray = (Object[])treeData.getItem(this.fTopNodeIds[n7]);
                objectArray2[n6++] = ((MixedState)objectArray[1]).getState() == 1 ? "true" : "false";
                int[] nArray = treeData.getChildren(this.fTopNodeIds[n7]);
                n = 0;
                while (n < nArray.length) {
                    labeledImageResource = (LabeledImageResource)treeData.getItem(nArray[n]);
                    objectArray2[n6++] = ((MixedState)labeledImageResource[1]).getState() == 1 ? "true" : "false";
                    ++n;
                }
                ++n7;
            }
            if (bl) {
                objectArray = new Object[12 + n2 * 2];
                int n8 = 0;
                objectArray[n8++] = "Find";
                objectArray[n8++] = "Objects";
                objectArray[n8++] = objectArray2;
                objectArray[n8++] = this.fSystemField.getText();
                objectArray[n8++] = "LookUnderMasks";
                objectArray[n8++] = this.fMaskChoice.getState() ? "on" : "off";
                objectArray[n8++] = "FollowLinks";
                objectArray[n8++] = this.fLinkChoice.getState() ? "on" : "off";
                objectArray[n8++] = "Regexp";
                objectArray[n8++] = this.fRegexpChoice.getSelectedIndex() == 0 ? "off" : "on";
                objectArray[n8++] = "CaseSensitive";
                Object object = objectArray[n8++] = this.fCaseChoice.getState() ? "on" : "off";
                if (bl2) {
                    n3 = 0;
                    while (n3 < tableData.getHeight()) {
                        n = ((Boolean)tableData.getData(n3, 0)).booleanValue() ? 1 : 0;
                        if (n != 0) {
                            labeledImageResource = (LabeledImageResource)tableData.getData(n3, 1);
                            objectArray[n8++] = labeledImageResource.getLabel();
                            objectArray[n8++] = tableData.getDataAsText(n3, 2);
                        }
                        ++n3;
                    }
                } else {
                    objectArray[n8++] = this.fBlockParamsCheckbox.getState() && this.fBlockParamsCheckbox.isEnabled() ? "SimpleAndParams" : "Simple";
                    objectArray[n8++] = this.fNameField.getText();
                }
                this.fMatlab.feval("findslobj", objectArray, (CompletionObserver)new FinderObserver("Find"));
                return;
            }
            this.fStatus.setText(sRes.getString("status.invalidProperty"));
            this.setIdleAffordance();
            return;
        }
        if (actionEvent.getSource() == this.fCancelButton) {
            ((Component)this.getFrame()).setVisible(false);
            this.clearResults();
            return;
        }
        if (actionEvent.getSource() == this.fHelpButton) {
            HelpBrowser.getHelpBrowser().displayTopic(sRes.getString("helptopic.finder"), "simulink", "finder");
            return;
        }
        if (actionEvent.getSource() == this.fSystemField) {
            this.updateWindowTitle(this);
        }
    }

    private void clearResults() {
        this.fResultsList.getData().setHeight(0);
        this.fStatus.setText(sRes.getString("status.ready"));
        Object[] objectArray = new Object[]{new String("ClearResults")};
        this.fMatlab.feval("findslobj", objectArray, (CompletionObserver)new FinderObserver("ClearResults"));
    }

    public Finder() {
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        MWPanel mWPanel = new MWPanel((LayoutManager)new MWBorderLayout());
        mWPanel.setName(new String("ControlPanel"));
        mWPanel.setInsets(new Insets(5, 5, 5, 5));
        MWGroupbox mWGroupbox = new MWGroupbox(sRes.getString("groupbox.filterOptions"));
        mWGroupbox.setStyle(0);
        mWGroupbox.setInsets(new Insets(5, 0, 5, 5));
        mWGroupbox.setLayout((LayoutManager)new MWBorderLayout());
        this.fObjectList = new MWTreeView();
        this.fObjectList.getData().setWidth(2);
        this.fObjectList.setColumnHeaderData(0, (Object)sRes.getString("header.lookfor"));
        this.fObjectList.setColumnHeaderData(1, (Object)sRes.getString("header.select"));
        this.fObjectList.getColumnOptions().setHeaderVisible(true);
        this.fObjectList.getColumnOptions().setResizable(true);
        this.fObjectList.setAutoExpandColumn(0);
        this.fObjectList.setMinAutoExpandColumnWidth(30);
        this.fObjectList.getSelectionOptions().setMode(0);
        this.fObjectList.setColumnWidth(1, 40);
        this.fObjectList.addValueListener((ValueListener)this);
        this.fObjectList.registerCellType(class$com$mathworks$mwt$table$MixedState != null ? class$com$mathworks$mwt$table$MixedState : (class$com$mathworks$mwt$table$MixedState = Finder.class$("com.mathworks.mwt.table.MixedState")), (Cell)new CellMWCheckbox((Table)this.fObjectList));
        Style style = new Style(1280);
        style.setEditable(true);
        style.setHAlignment(1);
        this.fObjectList.setColumnStyle(1, style);
        mWGroupbox.add((Component)this.fObjectList, "Center");
        mWGroupbox.setHelpTopicKey("FinderFilterOptions");
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new GridLayout(2, 1, 10, 10));
        mWPanel2.setName(new String("ConstraintsPanel"));
        mWPanel2.setInsets(new Insets(10, 0, 0, 0));
        this.fMaskChoice = new MWCheckbox();
        this.fMaskChoice.setLabel(sRes.getString("label.lookInsideMasked"));
        mWPanel2.add((Component)this.fMaskChoice);
        this.fLinkChoice = new MWCheckbox();
        this.fLinkChoice.setLabel(sRes.getString("label.lookInsideLinked"));
        mWPanel2.add((Component)this.fLinkChoice);
        mWGroupbox.add((Component)mWPanel2, "South");
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new MWBorderLayout());
        mWPanel3.setName(new String("SelectPanel"));
        Color color = Decorations.getColor((int)6);
        MWGroupbox mWGroupbox2 = new MWGroupbox(sRes.getString("groupbox.searchCriteria"));
        mWGroupbox2.setLayout((LayoutManager)new MWBorderLayout());
        mWGroupbox2.setInsets(new Insets(5, 0, 5, 5));
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new MWBorderLayout());
        mWPanel4.setName(new String("SimplePanel"));
        mWPanel4.setInsets(new Insets(0, 0, 5, 5));
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new MWBorderLayout(10, 10));
        mWPanel5.setName(new String("NamePanel"));
        MWLabel mWLabel = new MWLabel(sRes.getString("label.findWhat"));
        this.fNameField = new MWCombobox();
        this.fNameField.setName(new String("FindWhatCombobox"));
        this.fNameField.addActionListener((ActionListener)this);
        this.fNameField.addTextListener((TextListener)this);
        this.fBlockParamsCheckbox = new MWCheckbox(sRes.getString("checkbox.searchDialogParam"));
        this.fBlockParamsCheckbox.setEnabled(false);
        mWPanel5.add((Component)mWLabel, "North");
        mWPanel5.add((Component)this.fNameField, "Center");
        mWPanel5.add((Component)this.fBlockParamsCheckbox, "South");
        mWPanel4.add((Component)mWPanel5, "North");
        MWPanel mWPanel6 = new MWPanel((LayoutManager)new MWBorderLayout());
        mWPanel6.setName(new String("AdvancedPanel"));
        mWPanel6.setInsets(new Insets(0, 0, 0, 0));
        this.fPVList = new MWListbox();
        this.fPVList.setColumnCount(3);
        String string = "/com/mathworks/toolbox/simulink/finder/resources/EnumIcon.gif";
        int n = 0;
        while (n < 7) {
            this.fPVList.addItem("");
            this.fPVList.setCellData(n, 0, (Object)new Boolean(false));
            this.fPVList.setCellData(n, 1, (Object)new LabeledImageResource(string, "(none)"));
            ++n;
        }
        this.fPVList.setBorderStyle(2);
        this.fPVList.getTableStyle().setEditable(true);
        this.fPVList.getColumnOptions().setHeaderVisible(true);
        this.fPVList.getTableStyle().setHGridVisible(true);
        this.fPVList.getTableStyle().setVGridVisible(true);
        this.fPVList.setColumnHeaderData(0, (Object)sRes.getString("header.select"));
        this.fPVList.setColumnHeaderData(1, (Object)sRes.getString("header.property"));
        this.fPVList.setColumnHeaderData(2, (Object)sRes.getString("header.value"));
        this.fPVList.setColumnWidth(0, 40);
        this.fPVList.setColumnWidth(1, 100);
        this.fPVList.getColumnOptions().setHeaderSelectable(true);
        this.fPVList.getColumnOptions().setResizable(true);
        this.fPVList.getRowOptions().setHeaderVisible(false);
        this.fPVList.setTableBackground(color);
        this.fPVList.registerCellType(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Finder.class$("java.lang.String")), (Cell)new CustomCellText(this.fPVList));
        this.fPVList.registerCellType(class$com$mathworks$mwt$table$LabeledImageResource != null ? class$com$mathworks$mwt$table$LabeledImageResource : (class$com$mathworks$mwt$table$LabeledImageResource = Finder.class$("com.mathworks.mwt.table.LabeledImageResource")), (Cell)new CustomCellCombobox((Table)this.fPVList, this));
        this.fPVList.getSelectionOptions().setMode(0);
        this.fPVList.setColumnStyle(0, style);
        mWPanel6.add((Component)this.fPVList, "Center");
        MWPanel mWPanel7 = new MWPanel((LayoutManager)new GridLayout(1, 2));
        mWPanel7.setName(new String("CheckboxesPanel"));
        mWPanel7.setInsets(new Insets(5, 0, 0, 0));
        this.fCaseChoice = new MWCheckbox(sRes.getString("checkbox.matchCase"));
        this.fCaseChoice.setState(false);
        this.fRegexpChoice = new MWChoice();
        this.fRegexpChoice.addItem(sRes.getString("choice.wholeword"));
        this.fRegexpChoice.addItem(sRes.getString("choice.containword"));
        this.fRegexpChoice.addItem(sRes.getString("choice.regexp"));
        this.fRegexpChoice.setHelpTopicKey("FinderRegEx");
        this.fRegexpChoice.select(1);
        mWPanel7.add((Component)this.fCaseChoice);
        mWPanel7.add((Component)this.fRegexpChoice);
        this.fSearchPanel = new MWTabPanel();
        this.fSearchPanel.setName(new String("TabPanel"));
        this.fSearchPanel.addPanel("Basic", (Component)mWPanel4);
        this.fSearchPanel.addPanel("Advanced", (Component)mWPanel6);
        this.fSearchPanel.selectPanel("Basic");
        this.fSearchPanel.addItemListener((ItemListener)this);
        mWGroupbox2.add((Component)this.fSearchPanel, "Center");
        mWGroupbox2.add((Component)mWPanel7, "South");
        mWGroupbox2.setHelpTopicKey("FinderSearchCriteria");
        MWGroupbox mWGroupbox3 = new MWGroupbox(sRes.getString("groupbox.startInSystem"));
        mWGroupbox3.setName(new String("StartInSystem"));
        mWGroupbox3.setLayout((LayoutManager)new MWBorderLayout(10, 0));
        this.fSystemField = new MWCombobox();
        this.fSystemField.setName(new String("StartInSystemCombobox"));
        this.fSystemField.setTextEditable(true);
        this.fSystemField.setHelpTopicKey("FinderStartInSystem");
        this.fSystemField.addActionListener((ActionListener)this);
        this.fSystemBrowse = new MWButton(sRes.getString("button.browse"));
        mWGroupbox3.add((Component)this.fSystemField, "Center");
        mWPanel3.add((Component)mWGroupbox2, "Center");
        mWPanel3.add((Component)mWGroupbox3, "South");
        MWSplitter mWSplitter = new MWSplitter((Component)mWGroupbox, (Component)mWPanel3, 0);
        mWSplitter.setName(new String("FindPanelSplitter"));
        mWSplitter.setDividerLocation(0.45);
        mWPanel.add((Component)mWSplitter, "Center");
        MWPanel mWPanel8 = new MWPanel((LayoutManager)new MWBorderLayout());
        mWPanel8.setName(new String("PushButtonsPanel"));
        mWPanel8.setInsets(new Insets(10, 10, 10, 0));
        MWPanel mWPanel9 = new MWPanel((LayoutManager)new GridLayout(3, 1, 0, 5));
        mWPanel9.setName(new String("ButtonGridPanel"));
        mWPanel8.add((Component)mWPanel9, "North");
        this.fFindButton = new MWButton(sRes.getString("button.find"));
        this.fFindButton.addActionListener((ActionListener)this);
        this.fFindButton.setDefault(true);
        mWPanel9.add((Component)this.fFindButton);
        this.fHelpButton = new MWButton(sRes.getString("button.help"));
        this.fHelpButton.setEnabled(true);
        this.fHelpButton.addActionListener((ActionListener)this);
        mWPanel9.add((Component)this.fHelpButton);
        this.fCancelButton = new MWButton(sRes.getString("button.cancel"));
        this.fCancelButton.addActionListener((ActionListener)this);
        mWPanel9.add((Component)this.fCancelButton);
        mWPanel.add((Component)mWPanel8, "East");
        MWPanel mWPanel10 = new MWPanel((LayoutManager)new MWBorderLayout());
        mWPanel10.setName(new String("ResultsPanel"));
        mWPanel10.setInsets(new Insets(0, 0, 0, 0));
        Style style2 = new Style(1);
        style2.setFont(new Font("Dialog", 1, 12));
        this.fResultsList = new ResultsListbox();
        ((Component)((Object)this.fResultsList)).setName(new String("ResultsList"));
        this.fResultsList.setColumnCount(5);
        this.fResultsList.setBorderStyle(2);
        this.fResultsList.getTableStyle().setEditable(false);
        this.fResultsList.setHelpTopicKey("FinderResultsList");
        this.fResultsList.setColumnHeaderData(0, sRes.getString("header.type"));
        this.fResultsList.setCellStyle(-1, 0, style2);
        this.fResultsList.setColumnHeaderData(1, sRes.getString("header.name"));
        this.fResultsList.setColumnWidth(1, 125);
        this.fResultsList.setColumnHeaderData(2, sRes.getString("header.parent"));
        this.fResultsList.setColumnWidth(2, 150);
        this.fResultsList.setColumnHeaderData(3, sRes.getString("header.source"));
        this.fResultsList.setColumnHeaderData(4, sRes.getString("header.destination"));
        this.fResultsList.setColumnWidth(4, 110);
        this.fResultsList.getColumnOptions().setHeaderSelectable(true);
        this.fResultsList.getColumnOptions().setResizable(true);
        this.fResultsList.getColumnOptions().setHeaderVisible(true);
        this.fResultsList.setAutoExpandColumn(1);
        this.fResultsList.setMinAutoExpandColumnWidth(30);
        this.fResultsList.getTableStyle().setHGridVisible(false);
        this.fResultsList.getTableStyle().setVGridVisible(false);
        this.fResultsList.setTableBackground(color);
        this.fResultsList.getRowOptions().setHeaderVisible(false);
        this.fResultsList.getSelectionOptions().setSelectBy(1);
        ((Component)((Object)this.fResultsList)).addMouseListener(this);
        this.fResultsList.addItemListener(this);
        this.fResultsList.addActionListener(this);
        this.fResultsList.registerCellType(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Finder.class$("java.lang.String")), (Cell)new CustomCellTextWithHeaderEvents(this.fResultsList, style2));
        mWPanel10.add((Component)((Object)this.fResultsList), "Center");
        this.fContextMenu = new MWMenu("", this.fCenter);
        this.fContextMenu.attachTo((Component)((Object)this.fResultsList));
        this.fStatus = new MWLabel(sRes.getString("status.ready"));
        this.fStatus.setName("Status");
        this.fStatus.setFont(new Font("Dialog", 1, 10));
        mWPanel10.add((Component)this.fStatus, "South");
        this.fMainPanel = new MWSplitter((Component)mWPanel, (Component)mWPanel10);
        this.fMainPanel.setName(new String("MainPanelSplitter"));
        this.fMainPanel.setDividerLocation(1.0);
        this.fMainPanel.setStyle(2);
        ((Container)((Object)this)).setLayout(new GridLayout(1, 1));
        ((Component)((Object)this)).setName(new String("FinderPanel"));
        ((Container)((Object)this)).add((Component)this.fMainPanel);
        CSHelpTopicMapRegistry.registerTopicMap((Container)((Object)this), (Object)"simulink_csh");
    }

    public void addObjectList(String[] stringArray) {
        int n = stringArray.length;
        Object[] objectArray = new Object[]{new LabeledImageResource("/com/mathworks/toolbox/simulink/finder/resources/modelclosed.gif", stringArray[0]), new MixedState(1)};
        int n2 = this.fObjectList.addItem(-1, (Object)objectArray, true);
        this.fTopNodeIds[this.fNumTopNodes++] = n2;
        int n3 = 1;
        while (n3 < n) {
            objectArray = new Object[]{new LabeledImageResource("/com/mathworks/toolbox/simulink/finder/resources/block.gif", stringArray[n3]), new MixedState(1)};
            this.fObjectList.addItem(n2, (Object)objectArray, false);
            ++n3;
        }
    }

    public void setSystems(String[] stringArray) {
        int n = stringArray.length;
        this.fSystemField.removeAllItems();
        int n2 = 0;
        while (n2 < n) {
            this.fSystemField.addItem(stringArray[n2]);
            ++n2;
        }
    }

    public void Hide() {
        super.setVisible(false);
    }

    public void setBusyAffordance() {
        this.fFindButton.setEnabled(false);
        MWFrame mWFrame = (MWFrame)((Component)((Object)this)).getParent();
        mWFrame.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setIdleAffordance() {
        this.fFindButton.setEnabled(true);
        MWFrame mWFrame = (MWFrame)((Component)((Object)this)).getParent();
        mWFrame.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setBlockParamsCheckboxState() {
        Object[] objectArray;
        TreeData treeData = this.fObjectList.getTreeData();
        int[] nArray = treeData.getChildren(this.fTopNodeIds[0]);
        int n = nArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            objectArray = (Object[])treeData.getItem(nArray[n2]);
            LabeledImageResource labeledImageResource = (LabeledImageResource)objectArray[0];
            String string = labeledImageResource.getLabel();
            if (string.equalsIgnoreCase("Blocks")) {
                bl = ((MixedState)objectArray[1]).getState() == 1;
                break;
            }
            ++n2;
        }
        objectArray = this.fNameField.getText();
        boolean bl2 = objectArray.length() > 0;
        this.fBlockParamsCheckbox.setEnabled(bl && bl2);
    }

    private void addStringToSearchHistory(String string) {
        String[] stringArray = this.fNameField.getItems();
        this.fNameField.removeAllItems();
        this.fNameField.addItem(string);
        int n = stringArray.length >= 9 ? 9 : stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].compareTo(string) != 0) {
                this.fNameField.addItem(stringArray[n2]);
            }
            ++n2;
        }
    }

    public void CreateFinderWindow() {
        MWFrame mWFrame = new MWFrame("");
        mWFrame.setLocation(50, 50);
        mWFrame.setSize(575, 340);
        mWFrame.setLayout((LayoutManager)new MWBorderLayout());
        mWFrame.add((Component)((Object)this), "Center");
        mWFrame.addWindowListener((WindowListener)((Object)new FinderWindowActivater((Component)((Object)this))));
    }

    public static Finder CreateFindDlg() {
        Finder finder = new Finder();
        finder.CreateFinderWindow();
        return finder;
    }

    public static Finder CreateFindDlg(String string) {
        Finder finder = Finder.CreateFindDlg();
        finder.getSystemField().setText(string);
        finder.updateWindowTitle(finder);
        return finder;
    }

    public static void main(String[] stringArray) {
        Finder.CreateFindDlg();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class FinderWindowActivater
    extends MWWindowActivater {
        public FinderWindowActivater(Component component) {
            super(component);
            Finder.this = Finder.this;
        }

        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            Finder.this.clearResults();
        }
    }

    private class FinderObserver
    implements CompletionObserver {
        String fAction;

        public FinderObserver(String string) {
            Finder.this = Finder.this;
            this.fAction = string;
        }

        public void completed(int n, Object object) {
            if (this.fAction.equalsIgnoreCase("Find")) {
                String[] stringArray = (String[])object;
                int n2 = 0;
                if (stringArray != null && stringArray.length > 0) {
                    n2 = stringArray.length / 5;
                    TableData tableData = Finder.this.fResultsList.getData();
                    tableData.setHeight(n2);
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        LabeledImageResource labeledImageResource = new LabeledImageResource("/com/mathworks/toolbox/simulink/finder/resources/block.gif", stringArray[n3]);
                        Finder.this.fResultsList.setCellData(n3 / 5, 0, labeledImageResource);
                        Finder.this.fResultsList.setCellData(n3 / 5, 1, new String(stringArray[n3 + 1]));
                        Finder.this.fResultsList.setCellData(n3 / 5, 2, new String(stringArray[n3 + 2]));
                        Finder.this.fResultsList.setCellData(n3 / 5, 3, new String(stringArray[n3 + 3]));
                        Finder.this.fResultsList.setCellData(n3 / 5, 4, new String(stringArray[n3 + 4]));
                        n3 += 5;
                    }
                }
                Finder.this.fStatus.setText(String.valueOf(sRes.getString("status.found")) + n2 + sRes.getString("status.objects"));
                Finder.this.setIdleAffordance();
            }
        }
    }
}

