/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.finder;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.CellText;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableData;
import com.mathworks.toolbox.simulink.finder.ResultsListbox;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class CustomCellTextWithHeaderEvents
extends CellText {
    private Style fBoldStyle;
    private int selRow;
    private int selCol;
    private boolean mouseIn;
    private ResultsListbox fResults;

    public CustomCellTextWithHeaderEvents(ResultsListbox resultsListbox, Style style) {
        super((Table)resultsListbox);
        this.setEventMask(67);
        this.fBoldStyle = style;
        this.selRow = -2;
        this.selCol = -2;
        this.mouseIn = false;
        this.fResults = resultsListbox;
    }

    public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
        if (this.mouseIn && n == this.selRow && n2 == this.selCol) {
            Decorations.drawButtonBevel((Graphics)graphics, (Rectangle)rectangle, (boolean)true, (boolean)false, (boolean)true);
            graphics.setColor(Color.black);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        }
        super.render(graphics, n, n2, rectangle, object, style, bl);
    }

    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2, Object object) {
        if (n == -1 && !this.fResults.isInColumnResizeMode(mouseEvent.getX(), mouseEvent.getY())) {
            this.selRow = n;
            this.selCol = n2;
            this.mouseIn = true;
        }
        return super.mousePressed(mouseEvent, n, n2, object);
    }

    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2, Object object) {
        boolean bl;
        boolean bl2 = bl = n == this.selRow && n2 == this.selCol;
        if (this.mouseIn != bl) {
            this.mouseIn = bl;
        }
        return false;
    }

    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2, Object object) {
        if (n == -1 && n == this.selRow && n2 == this.selCol) {
            Object object2;
            Table table = this.getTable();
            TableData tableData = table.getData();
            int n3 = tableData.getHeight();
            int n4 = tableData.getWidth();
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(3));
            String[][] stringArray = new String[n3][n4];
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                if (n5 == 0) {
                    n6 = 0;
                    while (n6 < n3) {
                        object2 = (LabeledImageResource)tableData.getData(n6, n5);
                        stringArray[n6][n5] = object2.getLabel();
                        ++n6;
                    }
                } else {
                    n6 = 0;
                    while (n6 < n3) {
                        stringArray[n6][n5] = tableData.getDataAsText(n6, n5);
                        ++n6;
                    }
                }
                ++n5;
            }
            if (n3 > 0) {
                Matlab matlab = new Matlab();
                object2 = null;
                try {
                    Object[] objectArray = new Object[]{new String("Sort"), stringArray, new Integer(n2 + 1)};
                    Object object3 = matlab.feval("findslobj", objectArray);
                    object2 = (double[])object3;
                }
                catch (Exception exception) {}
                if (object2 != null) {
                    tableData.setHeight(n3 * 2);
                    int n7 = 0;
                    int n8 = 0;
                    while (n8 < n3) {
                        int n9 = 0;
                        while (n9 < n4) {
                            n7 = (int)object2[n8] - 1;
                            tableData.setData(n8 + n3, n9, tableData.getData(n7, n9));
                            ++n9;
                        }
                        ++n8;
                    }
                    tableData.removeRows(0, n3);
                }
            }
            int n10 = 0;
            while (n10 < n4) {
                table.setCellStyle(n, n10, null);
                ++n10;
            }
            table.setCellStyle(n, n2, this.fBoldStyle);
            table.repaint();
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(0));
        }
        this.mouseIn = false;
        return super.mouseReleased(mouseEvent, n, n2, object);
    }
}

