/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.finder;

import com.mathworks.mwt.MWPopupList;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.CellText;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableData;
import com.mathworks.toolbox.simulink.finder.Finder;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.Serializable;

public class CustomCellCombobox
extends CellText
implements ItemListener {
    private Point fImagePoint = new Point();
    private Point fTextPoint = new Point();
    private Finder fFinder;
    private MWPopupList fPopupList;
    private int fActiveRow;
    private int fActiveCol;

    public CustomCellCombobox(Table table, Finder finder) {
        super(table);
        this.fFinder = finder;
        this.fPopupList = null;
        this.fActiveRow = -1;
        this.fActiveCol = -1;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        TableData tableData = this.getTable().getData();
        Object object = tableData.getData(this.fActiveRow, this.fActiveCol);
        if (object instanceof LabeledImageResource && !(string = this.fPopupList.getSelectedItem()).startsWith("**")) {
            if (string.startsWith("other")) {
                ((LabeledImageResource)object).setLabel("");
                this.beginEdit(this.fActiveRow, this.fActiveCol);
            } else {
                ((LabeledImageResource)object).setLabel(this.fPopupList.getSelectedItem());
                tableData.setData(this.fActiveRow, 0, (Object)new Boolean(true));
            }
            this.getTable().fireValueChangedEvent(this.fActiveRow, this.fActiveCol);
            this.getTable().repaintCells(this.fActiveRow, this.fActiveCol - 1, this.fActiveRow, this.fActiveCol);
        }
    }

    public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
        if (object instanceof LabeledImageResource) {
            Serializable serializable;
            Image image = ((LabeledImageResource)object).getImage((Component)this.getTable());
            String string = ((LabeledImageResource)object).getLabel();
            graphics.setFont(style.getFont());
            this.getImageLocation(rectangle, image, string, graphics.getFontMetrics(), style, this.fImagePoint, this.fTextPoint);
            if (string != null) {
                if (bl && style.getCustomHilite()) {
                    serializable = graphics.getFontMetrics();
                    int n3 = ((FontMetrics)serializable).stringWidth(string);
                    int n4 = this.fTextPoint.y - ((FontMetrics)serializable).getMaxAscent();
                    int n5 = ((FontMetrics)serializable).getMaxAscent() + ((FontMetrics)serializable).getMaxDescent();
                    graphics.setColor(Decorations.getColor((int)4));
                    graphics.fillRect(this.fTextPoint.x - 1, n4 - 1, n3 + 2, n5 + 2);
                }
                if (bl && PlatformInfo.getAppearance() != 0) {
                    graphics.setColor(Decorations.getColor((int)5));
                } else {
                    graphics.setColor(style.getForeground());
                }
                graphics.drawString(string, this.fTextPoint.x, this.fTextPoint.y);
            }
            if (image != null) {
                serializable = new Rectangle();
                Insets insets = style.getMargins();
                ((Rectangle)serializable).x = this.fImagePoint.x;
                ((Rectangle)serializable).y = this.fImagePoint.y;
                ((Rectangle)serializable).width = image.getWidth((ImageObserver)this.getTable()) + insets.right;
                ((Rectangle)serializable).height = image.getHeight((ImageObserver)this.getTable()) + insets.bottom;
                Decorations.drawButtonBevel((Graphics)graphics, (Rectangle)serializable, (boolean)false, (boolean)false, (boolean)true);
                graphics.drawImage(image, this.fImagePoint.x, this.fImagePoint.y, (ImageObserver)this.getTable());
            }
        }
    }

    protected Rectangle getFieldBounds(int n, int n2) {
        Image image;
        Rectangle rectangle = super.getFieldBounds(n, n2);
        Object object = this.getTable().getData().getData(n, n2);
        int n3 = this.getTable().getCellStyle((int)n, (int)n2).getMargins().left;
        int n4 = this.getTable().getCellStyle((int)n, (int)n2).getMargins().right;
        if (object instanceof LabeledImageResource && (image = ((LabeledImageResource)object).getImage((Component)this.getTable())) != null) {
            n4 += image.getWidth((ImageObserver)this.getTable());
        }
        rectangle.x += n3;
        rectangle.width -= n4;
        return rectangle;
    }

    protected String getInitialValue(int n, int n2) {
        String string = "";
        Object object = this.getTable().getData().getData(n, n2);
        if (object instanceof LabeledImageResource) {
            string = ((LabeledImageResource)object).getLabel();
        }
        return string;
    }

    public void commitEdit(int n, int n2) {
        Object object;
        MWTextField mWTextField = this.getField();
        if (mWTextField != null && (object = this.getTable().getData().getData(n, n2)) instanceof LabeledImageResource) {
            LabeledImageResource labeledImageResource = (LabeledImageResource)object;
            labeledImageResource.setLabel(mWTextField.getText());
        }
        this.cancelEdit(n, n2);
        this.getTable().fireValueChangedEvent(n, n2);
    }

    private void getImageLocation(Rectangle rectangle, Image image, String string, FontMetrics fontMetrics, Style style, Point point, Point point2) {
        Insets insets = style.getMargins();
        fontMetrics.stringWidth("3");
        int n = image != null ? image.getWidth((ImageObserver)this.getTable()) : 0;
        int n2 = image != null ? image.getHeight((ImageObserver)this.getTable()) : 0;
        point.x = rectangle.x + rectangle.width - insets.right - n;
        point2.x = rectangle.x + insets.left;
        point.y = rectangle.y + rectangle.height - insets.bottom - n2;
        point2.y = rectangle.y + rectangle.height - insets.bottom - fontMetrics.getMaxDescent();
    }

    public boolean mouseClicked(MouseEvent mouseEvent, int n, int n2, Object object) {
        if (n2 != -1 && n != -1 && n2 != -2 && n != -2) {
            Rectangle rectangle = this.getFieldBounds(n, n2);
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.beginEdit(n, n2);
            } else {
                String[] stringArray;
                this.commitEdit(n, n2);
                if (this.fPopupList == null) {
                    this.fPopupList = new MWPopupList(true);
                    this.fPopupList.addItemListener((ItemListener)this);
                    stringArray = this.fFinder.getProperties();
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        this.fPopupList.addItem(stringArray[n3]);
                        ++n3;
                    }
                }
                stringArray = this.getTable().getCellBounds(n, n2);
                this.fActiveRow = n;
                this.fActiveCol = n2;
                this.fPopupList.show((Component)this.getTable(), stringArray.x, stringArray.y, stringArray.width, stringArray.height);
            }
        }
        return true;
    }
}

