/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.errordlg;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTList;
import com.mathworks.mwt.MWTextArea;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.util.ObjBuffer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;

public class SLError
extends MWPanel
implements ItemListener {
    private MWFrame fMyFrame;
    private int fNextID;
    private MWTList fBlockList = new MWTList(false, false);
    private MWTList fMsgList = new MWTList(false, false);
    private MWButton fOpenButton = new MWButton(sRes.getString("button.open"));
    private MWTextArea fErrMsg;
    private String fSystemName;
    private static ObjBuffer sErrorDialogs;
    private static ResourceBundle sRes;

    public SLError() {
    }

    public SLError(String string) {
        this.fNextID = 0;
        this.fSystemName = string;
        MWButton mWButton = new MWButton(sRes.getString("button.dismiss"));
        MWPanel mWPanel = new MWPanel();
        mWPanel.setInsets(new Insets(10, 0, 0, 0));
        mWPanel.setLayout(new FlowLayout(2));
        mWPanel.add((Component)this.fOpenButton);
        mWPanel.add((Component)mWButton);
        MWLabel mWLabel = new MWLabel(sRes.getString("label.blocks"));
        MWLabel mWLabel2 = new MWLabel(sRes.getString("label.message"));
        this.fErrMsg = new MWTextArea(3, 10);
        this.fErrMsg.setEditable(false);
        this.fErrMsg.setHScrollStyle(1);
        MWPanel mWPanel2 = new MWPanel();
        mWPanel2.setOpaque(false);
        mWPanel2.setInsets(new Insets(10, 0, 0, 0));
        mWPanel2.setLayout(new BorderLayout());
        mWPanel2.add((Component)mWLabel2, "North");
        mWPanel2.add((Component)this.fErrMsg, "Center");
        mWPanel2.add((Component)mWPanel, "South");
        this.setOpaque(false);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)mWLabel, "North");
        ((Container)((Object)this)).add((Component)this.fBlockList, "Center");
        ((Container)((Object)this)).add((Component)mWPanel2, "South");
        this.fMyFrame = new MWFrame(String.valueOf(sRes.getString("frame.title")) + string);
        this.fMyFrame.setSize(500, 265);
        this.fMyFrame.add((Component)((Object)this), "Center");
        this.fOpenButton.addActionListener((ActionListener)new EditButtonListener());
        mWButton.addActionListener((ActionListener)new CloseButtonListener());
        this.fBlockList.addMouseListener(new ErrorListMouseAdapter());
        this.fBlockList.addItemListener((ItemListener)this);
        this.fBlockList.setWholeItemHilite(true);
        this.fBlockList.setWholeItemSelect(true);
        this.fBlockList.setDrawRowLines(false);
    }

    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    private static void addErrorDialogToList(SLError sLError) {
        if (sErrorDialogs == null) {
            sErrorDialogs = new ObjBuffer();
        }
        sErrorDialogs.append((Object)sLError);
    }

    private static void removeErrorDialogFromList(SLError sLError) {
        if (sErrorDialogs != null) {
            int n = sErrorDialogs.length();
            int n2 = 0;
            while (n2 < n) {
                String string = ((SLError)SLError.sErrorDialogs.getAt((int)n2)).fSystemName;
                if (sLError.fSystemName != null && sLError.fSystemName.equals(string)) {
                    sErrorDialogs.delete(n2, n2 + 1);
                    return;
                }
                ++n2;
            }
        }
    }

    private static SLError getOpenErrorDialog(String string) {
        if (sErrorDialogs == null) {
            return null;
        }
        int n = sErrorDialogs.length();
        int n2 = 0;
        while (n2 < n) {
            SLError sLError = (SLError)sErrorDialogs.getAt(n2);
            if (sLError.fSystemName != null && sLError.fSystemName.equals(string)) {
                return sLError;
            }
            ++n2;
        }
        return null;
    }

    private void addNewErrors(String string, String string2) {
        if (this.fNextID == 0) {
            this.fBlockList.removeAll();
            this.fMsgList.removeAll();
        }
        if (string.length() > 0) {
            this.fBlockList.add(-1, this.fNextID, string, null, true);
        } else {
            this.fBlockList.add(-1, this.fNextID, sRes.getString("string.unknownObject"), null, true);
        }
        this.fMsgList.add(-1, this.fNextID++, string2, null, true);
        if (this.fNextID == 1) {
            this.fBlockList.selectItem(0);
            this.fErrMsg.setText(this.fMsgList.getItemString(0));
        }
        ((Component)((Object)this)).repaint();
    }

    public static void addToErrorList(String string, String string2, String string3) {
        if (string.length() != 0) {
            SLError.getNewOrExistingErrorDialog(string).addNewErrors(string2, string3);
        }
    }

    public static void doneWithErrors(String string) {
        SLError sLError = SLError.getNewOrExistingErrorDialog(string);
        sLError.fNextID = 0;
        sLError.fMyFrame.setVisible(true);
        sLError.fBlockList.selectItem(0);
        sLError.formatErrorMessage();
        ((Component)((Object)sLError)).addComponentListener(sLError.new ComponentEventHandler());
    }

    public static void closeDialog(String string) {
        SLError sLError = SLError.getOpenErrorDialog(string);
        if (sLError != null) {
            sLError.fMyFrame.dispose();
        }
    }

    public static SLError getNewOrExistingErrorDialog(String string) {
        SLError sLError = SLError.getOpenErrorDialog(string);
        if (sLError == null) {
            sLError = new SLError(string);
            SLError.addErrorDialogToList(sLError);
        }
        return sLError;
    }

    private void openBlock() {
        try {
            Matlab matlab = new Matlab();
            int n = this.fBlockList.getFirstSelectedItem();
            if (n == -1) {
                return;
            }
            String string = this.fBlockList.getItemString(n);
            if (string.compareTo(sRes.getString("string.unknownObject")) == 0) {
                return;
            }
            String string2 = "disp(get_param('" + string + "','type'));";
            String string3 = matlab.eval(string2);
            if (string3.compareTo("block") == 0) {
                string2 = "open_system(get_param('" + string + "','Parent'), 'force');";
                matlab.eval(string2);
            }
            string2 = "set_param('" + string + "','Selected','on');";
            matlab.eval(string2);
            string2 = "open_system('" + string + "')";
            matlab.eval(string2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void formatErrorMessage() {
        MWTextView mWTextView;
        int n = this.fBlockList.getFirstSelectedItem();
        if (n < 0) {
            return;
        }
        String string = this.fMsgList.getItemString(n);
        MWTextView mWTextView2 = mWTextView = this.fErrMsg.getView();
        synchronized (mWTextView2) {
            int n2;
            int n3 = mWTextView.getTextCanvasSize().width;
            mWTextView.beginDeferUpdates();
            this.fErrMsg.setText(string);
            mWTextView.setSel(0);
            char[] cArray = string.toCharArray();
            int n4 = 0;
            while ((n2 = mWTextView.posFromPixelX(n4++, n3)) != -1) {
                while (cArray[n2--] != ' ' && n2 > 0) {
                }
                if (n2 >= 0) {
                    cArray[n2 + 1] = 10;
                }
                String string2 = new String(cArray);
                this.fErrMsg.setText(string2);
                mWTextView.setSel(0);
            }
            mWTextView.endDeferUpdates();
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.fBlockList) {
            this.formatErrorMessage();
        }
    }

    public static void main(String[] stringArray) {
        SLError.addToErrorList("f14", "f14/source1", "f14 this is a message that will run off the edge of the text area that I am using.  This will test my stuff so I don't have to run MATLAB at all.  Now I'm going to make it even longer because I have to test even more lines since error messages can get quite long.  Have a nice day and don't bother me if you value your life.");
        SLError.addToErrorList("f14", "f14/source2", "f14 message22");
        SLError.addToErrorList("f14", "f14/source3", "f14 message333");
        SLError.addToErrorList("f14", "f14/source4", "f14 message4444");
        SLError.addToErrorList("f14", "f14/source5", "f14 message55555");
        SLError.addToErrorList("f14", "f14/source6", "f14 message666666");
        SLError.addToErrorList("f14", "f14/source7", "f14 message7777777");
        SLError.doneWithErrors("f14");
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.errordlg.resources.RES_SLError");
    }

    private class ComponentEventHandler
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            SLError.this.formatErrorMessage();
        }

        ComponentEventHandler() {
            SLError.this = SLError.this;
        }
    }

    private class ErrorListMouseAdapter
    extends MouseAdapter {
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                return;
            }
            if (SLError.this.fBlockList.getFirstSelectedItem() < 0) {
                SLError.this.fErrMsg.setText("");
                SLError.this.fOpenButton.setEnabled(false);
                return;
            }
            SLError.this.fOpenButton.setEnabled(true);
            SLError.this.formatErrorMessage();
            if (mouseEvent.getClickCount() == 2) {
                SLError.this.openBlock();
                return;
            }
        }

        ErrorListMouseAdapter() {
            SLError.this = SLError.this;
        }
    }

    private class EditButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SLError.this.openBlock();
        }

        EditButtonListener() {
            SLError.this = SLError.this;
        }
    }

    private class CloseButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SLError.removeErrorDialogFromList(SLError.this);
            SLError.this.fMyFrame.dispose();
        }

        CloseButtonListener() {
            SLError.this = SLError.this;
        }
    }
}

