/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.debugger;

import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.widgets.SyntaxTextArea;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWSplitter;
import com.mathworks.mwt.MWTabPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandPanel;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableData;
import com.mathworks.mwt.table.ValueEvent;
import com.mathworks.mwt.table.ValueListener;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.toolbox.simulink.debugger.BlockNameCellText;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

public class SimDebugger
extends MWCommandPanel
implements ActionListener,
ItemListener,
ValueListener {
    private Matlab fMatlab;
    private String fModel;
    private boolean fInDebugger = false;
    private boolean fInSimulation = false;
    private Font plainFont = new Font(sRes.getString("font.Courier"), 0, 12);
    private String fSeparator = new String("\n%------------------------------------------------------------%\n");
    private MWToolbar fToolbar;
    private MWPanel fToolbarPanel;
    private MWCommandCenter fCenter;
    private MWButton fClose;
    private MWListbox fBlockList;
    private MWButton fDeleteButton;
    private MWCheckbox fZcEvent;
    private MWCheckbox fStepEvent;
    private MWCheckbox fNanEvent;
    private MWCheckbox fMinorEvent;
    private MWTextField fTimeEvent;
    private MWTabPanel fTabPanel;
    private SyntaxTextArea fOutputArea;
    private SyntaxTextArea fSortedArea;
    private SyntaxTextArea fStatusArea;
    private static final int STEP = 1;
    private static final int NEXT = 2;
    private static final int START = 3;
    private static final int STOP = 4;
    private static final int BREAK = 5;
    private static final int TRACE = 6;
    private static final int PROBE = 7;
    private static final int HELP = 8;
    private static final int CLOSE = 9;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.debugger.resources.RES_SimDebugger");
    static /* synthetic */ Class class$java$lang$String;

    public void setModelName(String string) {
        this.fModel = new String(string);
    }

    private void EnableDebugger(boolean bl) {
        this.fToolbar.getTool(1).setEnabled(bl);
        this.fToolbar.getTool(2).setEnabled(bl);
        this.fToolbar.getTool(4).setEnabled(bl);
        this.fToolbar.getTool(7).setEnabled(bl);
        this.fInDebugger = bl;
    }

    private void EnableUI(boolean bl) {
        this.fToolbar.getTool(1).setEnabled(bl);
        this.fToolbar.getTool(2).setEnabled(bl);
        this.fToolbar.getTool(3).setEnabled(bl);
        this.fToolbar.getTool(5).setEnabled(bl);
        this.fToolbar.getTool(6).setEnabled(bl);
        this.fToolbar.getTool(7).setEnabled(bl);
        this.fToolbar.getTool(8).setEnabled(bl);
    }

    private void applyWatchPoints(int[] nArray, boolean bl) {
        TableData tableData = this.fBlockList.getData();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl2 = false;
            String string = tableData.getDataAsText(nArray[n2], 0);
            bl2 = (Boolean)tableData.getData(nArray[n2], 1);
            if (bl2) {
                this.doBreakGCB(string, bl);
            }
            if (bl2 = ((Boolean)tableData.getData(nArray[n2], 2)).booleanValue()) {
                this.doTraceGCB(string, bl);
            }
            ++n2;
        }
    }

    private void InitDebugger() {
        int n = this.fBlockList.getData().getHeight();
        if (n > 0) {
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = n2;
                ++n2;
            }
            this.applyWatchPoints(nArray, true);
        }
        if (this.fZcEvent.getState()) {
            this.doZcEvent();
        }
        if (this.fStepEvent.getState()) {
            this.doStepEvent();
        }
        if (this.fNanEvent.getState()) {
            this.doNanEvent();
        }
        if (this.fMinorEvent.getState()) {
            this.doMinorEvent();
        }
        if (this.fTimeEvent.getText().length() > 0) {
            this.doTimeEvent();
        }
        this.fSortedArea.setText("");
        this.fMatlab.eval("slist", (CompletionObserver)new SortedDebuggerObserver());
        this.fStatusArea.setText("");
        this.fMatlab.eval("status", (CompletionObserver)new StatusDebuggerObserver());
    }

    private void doTimeEvent() {
        this.fMatlab.evalNoOutput("tbreak " + this.fTimeEvent.getText(), 2048);
    }

    private void doDelete() {
        int[] nArray = this.fBlockList.getSelectedRows();
        int n = nArray.length;
        this.fBlockList.deselectAll();
        if (n > 0) {
            this.applyWatchPoints(nArray, false);
            int n2 = n - 1;
            while (n2 >= 0) {
                this.fBlockList.removeItem(nArray[n2]);
                --n2;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fTimeEvent) {
            this.doTimeEvent();
            return;
        }
        if (object == this.fClose) {
            this.doClose();
            return;
        }
        if (object == this.fDeleteButton) {
            this.doDelete();
        }
    }

    private void doZcEvent() {
        this.fMatlab.evalNoOutput("zcbreak", 2048);
    }

    private void doStepEvent() {
        this.fMatlab.evalNoOutput("xbreak", 2048);
    }

    private void doNanEvent() {
        this.fMatlab.evalNoOutput("nanbreak", 2048);
    }

    private void doMinorEvent() {
        this.fMatlab.evalNoOutput("minor", 2048);
    }

    private void doTabEvent() {
        int n = this.fTabPanel.getSelectedIndex();
        if (n == 1) {
            String string = this.fSortedArea.getText();
            if (string.length() == 0) {
                this.fMatlab.eval("slist", (CompletionObserver)new SortedDebuggerObserver());
                return;
            }
        } else if (n == 2) {
            this.fMatlab.eval("status", (CompletionObserver)new StatusDebuggerObserver());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (this.fInDebugger) {
            if (object == this.fZcEvent) {
                this.doZcEvent();
                return;
            }
            if (object == this.fStepEvent) {
                this.doStepEvent();
                return;
            }
            if (object == this.fNanEvent) {
                this.doNanEvent();
                return;
            }
            if (object == this.fMinorEvent) {
                this.doMinorEvent();
                return;
            }
            if (object == this.fTabPanel) {
                this.doTabEvent();
            }
        }
    }

    private void doBreakGCB(String string, boolean bl) {
        if (bl) {
            this.fMatlab.evalNoOutput("break '" + string + "'", 2048);
            return;
        }
        this.fMatlab.evalNoOutput("clear '" + string + "'", 2048);
    }

    private void doTraceGCB(String string, boolean bl) {
        if (bl) {
            this.fMatlab.evalNoOutput("trace '" + string + "'", 2048);
            return;
        }
        this.fMatlab.evalNoOutput("untrace '" + string + "'", 2048);
    }

    public void valueChanged(ValueEvent valueEvent) {
        Table table = valueEvent.getSource();
        if (table == this.fBlockList) {
            int n = valueEvent.getRow();
            int n2 = valueEvent.getColumn();
            Object object = this.fBlockList.getCellData(n, n2);
            String string = (String)this.fBlockList.getCellData(n, 0);
            boolean bl = (Boolean)object;
            switch (n2) {
                case 1: {
                    this.doBreakGCB(string, bl);
                    return;
                }
                case 2: {
                    this.doTraceGCB(string, bl);
                    return;
                }
            }
        }
    }

    private void appendToOutputArea(String string) {
        this.fOutputArea.append(string);
        this.fOutputArea.setCaretPosition(this.fOutputArea.getModel().length());
        this.fOutputArea.getView().setHScrollAmount(0);
        this.fTabPanel.selectPanel(0);
    }

    public SimDebugger() {
        ((Container)((Object)this)).setLayout((LayoutManager)new MWBorderLayout());
        this.fMatlab = new Matlab(new MWLooper());
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        MWPanel mWPanel = new MWPanel();
        mWPanel.setLayout((LayoutManager)new MWBorderLayout());
        String string = "/com/mathworks/toolbox/simulink/debugger/resources/";
        this.buildToolbar();
        ((Container)((Object)this)).add((Component)this.fToolbarPanel, "North");
        MWGroupbox mWGroupbox = new MWGroupbox(sRes.getString("label.breakDisplay"));
        mWGroupbox.setLayout((LayoutManager)new MWBorderLayout(5, 5));
        mWGroupbox.setMargins(new Insets(5, 5, 5, 5));
        this.fBlockList = new MWListbox();
        this.fBlockList.getColumnOptions().setHeaderVisible(true);
        this.fBlockList.getColumnOptions().setResizable(false);
        this.fBlockList.getTableStyle().setHGridVisible(true);
        this.fBlockList.setFont(this.plainFont);
        this.fBlockList.setColumnCount(3);
        this.fBlockList.setColumnHeaderData(0, (Object)sRes.getString("label.blocks"));
        this.fBlockList.setAutoExpandColumn(0);
        this.fBlockList.setMinAutoExpandColumnWidth(30);
        this.fBlockList.setColumnHeaderData(1, (Object)new LabeledImageResource(String.valueOf(string) + "break_gray.gif", ""));
        this.fBlockList.setColumnWidth(1, 20);
        this.fBlockList.setColumnHeaderData(2, (Object)new LabeledImageResource(String.valueOf(string) + "trace_gray.gif", ""));
        this.fBlockList.setColumnWidth(2, 20);
        this.fBlockList.setMultiSelection(true);
        this.fBlockList.addValueListener((ValueListener)this);
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new FlowLayout(2, 0, 0));
        mWPanel2.setInsets(new Insets(0, 0, 0, 0));
        this.fDeleteButton = new MWButton(sRes.getString("button.removeSelectedPoint"));
        this.fDeleteButton.addActionListener((ActionListener)this);
        mWPanel2.add((Component)this.fDeleteButton);
        Style style = new Style(1280);
        style.setEditable(true);
        style.setHAlignment(1);
        this.fBlockList.setColumnStyle(1, style);
        this.fBlockList.setColumnStyle(2, style);
        this.fBlockList.registerCellType(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SimDebugger.class$("java.lang.String")), (Cell)new BlockNameCellText(this.fBlockList));
        mWGroupbox.add((Component)this.fBlockList, "Center");
        mWGroupbox.add((Component)mWPanel2, "South");
        MWGroupbox mWGroupbox2 = new MWGroupbox(sRes.getString("groupbox.BreakOnConditions"));
        mWGroupbox2.setMargins(new Insets(5, 5, 5, 5));
        mWGroupbox2.setLayout(new GridLayout(5, 1));
        this.fZcEvent = new MWCheckbox(sRes.getString("checkbox.ZeroCrossings"));
        this.fZcEvent.addItemListener((ItemListener)this);
        mWGroupbox2.add((Component)this.fZcEvent);
        this.fStepEvent = new MWCheckbox(sRes.getString("checkbox.StepSizeLimit"));
        this.fStepEvent.addItemListener((ItemListener)this);
        mWGroupbox2.add((Component)this.fStepEvent);
        this.fMinorEvent = new MWCheckbox(sRes.getString("checkbox.MinorTimeSteps"));
        this.fMinorEvent.addItemListener((ItemListener)this);
        mWGroupbox2.add((Component)this.fMinorEvent);
        this.fNanEvent = new MWCheckbox(sRes.getString("checkbox.NanValues"));
        this.fNanEvent.addItemListener((ItemListener)this);
        mWGroupbox2.add((Component)this.fNanEvent);
        MWPanel mWPanel3 = new MWPanel();
        mWPanel3.setLayout((LayoutManager)new MWBorderLayout());
        MWLabel mWLabel = new MWLabel(sRes.getString("label.breakAtTime"));
        this.fTimeEvent = new MWTextField();
        this.fTimeEvent.addActionListener((ActionListener)this);
        mWPanel3.add((Component)mWLabel, "West");
        mWPanel3.add((Component)this.fTimeEvent, "Center");
        mWGroupbox2.add((Component)mWPanel3);
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new MWBorderLayout(5, 5));
        mWPanel4.add((Component)mWGroupbox, "Center");
        mWPanel4.add((Component)mWGroupbox2, "South");
        MWPanel mWPanel5 = new MWPanel();
        mWPanel5.setLayout((LayoutManager)new MWBorderLayout());
        this.fOutputArea = new SyntaxTextArea();
        this.fOutputArea.setFont(this.plainFont);
        String string2 = new String(String.valueOf(this.fSeparator) + sRes.getString("welcome.line1") + "% \n" + sRes.getString("welcome.line2") + sRes.getString("welcome.line3") + sRes.getString("welcome.line4") + sRes.getString("welcome.line5") + sRes.getString("welcome.line6") + sRes.getString("welcome.line7") + "% \n" + sRes.getString("welcome.line8") + this.fSeparator);
        this.fOutputArea.setText(string2);
        this.fOutputArea.setSyntaxHighlightingEnabled(true);
        this.fOutputArea.setFileType("M-code");
        this.fOutputArea.setEditable(false);
        this.fOutputArea.setDimBGWhenNotEditable(false);
        mWPanel5.add((Component)this.fOutputArea, "Center");
        MWPanel mWPanel6 = new MWPanel();
        mWPanel6.setLayout((LayoutManager)new MWBorderLayout());
        this.fSortedArea = new SyntaxTextArea();
        this.fSortedArea.setFont(this.plainFont);
        this.fSortedArea.setSyntaxHighlightingEnabled(true);
        this.fSortedArea.setFileType("M-code");
        this.fSortedArea.setEditable(false);
        this.fSortedArea.setDimBGWhenNotEditable(false);
        mWPanel6.add((Component)this.fSortedArea, "Center");
        MWPanel mWPanel7 = new MWPanel();
        mWPanel7.setLayout((LayoutManager)new MWBorderLayout());
        this.fStatusArea = new SyntaxTextArea();
        this.fStatusArea.setFont(this.plainFont);
        this.fStatusArea.setSyntaxHighlightingEnabled(true);
        this.fStatusArea.setFileType("M-code");
        this.fStatusArea.setEditable(false);
        this.fStatusArea.setDimBGWhenNotEditable(false);
        mWPanel7.add((Component)this.fStatusArea, "Center");
        this.fTabPanel = new MWTabPanel();
        this.fTabPanel.setMargins(new Insets(5, 5, 5, 5));
        this.fTabPanel.addPanel(sRes.getString("panel.outputs"), (Component)mWPanel5);
        this.fTabPanel.addPanel(sRes.getString("panel.executionorder"), (Component)mWPanel6);
        this.fTabPanel.addPanel(sRes.getString("panel.status"), (Component)mWPanel7);
        this.fTabPanel.selectPanel(sRes.getString("panel.outputs"));
        this.fTabPanel.addItemListener((ItemListener)this);
        MWSplitter mWSplitter = new MWSplitter(0);
        mWSplitter.setDividerLocation(0.3);
        mWSplitter.add((Component)mWPanel4);
        mWSplitter.add((Component)this.fTabPanel);
        MWPanel mWPanel8 = new MWPanel((LayoutManager)new MWBorderLayout());
        mWPanel8.setInsets(new Insets(5, 5, 5, 5));
        mWPanel8.add((Component)mWSplitter, "Center");
        this.EnableDebugger(false);
        ((Container)((Object)this)).add((Component)mWPanel8, "Center");
    }

    public void doCommand(int n) {
        switch (n) {
            case 1: {
                this.doStep();
                return;
            }
            case 2: {
                this.doNext();
                return;
            }
            case 3: {
                this.doStart();
                return;
            }
            case 4: {
                this.doStop();
                return;
            }
            case 5: {
                this.doBreak();
                return;
            }
            case 6: {
                this.doTrace();
                return;
            }
            case 8: {
                this.doHelp();
                return;
            }
            case 7: {
                this.doProbe();
                return;
            }
            case 9: {
                this.doClose();
                return;
            }
        }
    }

    private void doStep() {
        this.fMatlab.evalStreamOutput("step", (CompletionObserver)new OutputWithCheckDebuggerObserver(), 2048);
    }

    private void doNext() {
        this.fMatlab.evalStreamOutput("next", (CompletionObserver)new OutputDebuggerObserver(), 2048);
    }

    private void doStart() {
        this.EnableUI(false);
        if (this.fInDebugger) {
            this.fInSimulation = true;
            this.fMatlab.evalStreamOutput("cont", (CompletionObserver)new OutputWithCheckDebuggerObserver(), 2048);
            return;
        }
        this.fMatlab.evalStreamOutput("sldebug " + this.fModel, (CompletionObserver)new StartDebuggerObserver(), 2048);
    }

    private void doStop() {
        if (this.fInDebugger) {
            if (this.fInSimulation) {
                this.fMatlab.interrupt();
                this.fMatlab.evalNoOutput("stop", 2048);
                this.fInSimulation = false;
            } else {
                this.fMatlab.evalStreamOutput("stop", (CompletionObserver)new OutputDebuggerObserver(), 2048);
            }
            this.fInDebugger = false;
        }
        this.EnableDebugger(false);
    }

    private void doBreak() {
        Object[] objectArray = new Object[]{new String("GetCurrentBlock")};
        this.fMatlab.feval("sldebugui", objectArray, (CompletionObserver)new WatchPointDebuggerObserver(1));
    }

    private void doTrace() {
        Object[] objectArray = new Object[]{new String("GetCurrentBlock")};
        this.fMatlab.feval("sldebugui", objectArray, (CompletionObserver)new WatchPointDebuggerObserver(2));
    }

    private void doProbe() {
        Object[] objectArray = new Object[]{new String("GetCurrentBlock")};
        this.fMatlab.feval("sldebugui", objectArray, (CompletionObserver)new ProbeDebuggerObserver());
    }

    private void doHelp() {
        HelpBrowser.getHelpBrowser().displayTopic(sRes.getString("help.topicSimulinkDebugger"), "simulink", "debugger");
    }

    private void doClose() {
        this.doStop();
        this.fMatlab.evalNoOutput("sldebugui('Close')");
    }

    private void buildToolbar() {
        String string = "/com/mathworks/toolbox/simulink/debugger/resources/";
        this.fToolbar = new MWToolbar(this.fCenter);
        this.fToolbar.addImageButton(String.valueOf(string) + "step.gif", 1, sRes.getString("tooltip.stepnext"));
        this.fToolbar.addImageButton(String.valueOf(string) + "next.gif", 2, sRes.getString("tooltip.gotonext"));
        this.fToolbar.addImageButton(String.valueOf(string) + "start.gif", 3, sRes.getString("tooltip.startcontinue"));
        this.fToolbar.addImageButton(String.valueOf(string) + "stop.gif", 4, sRes.getString("tooltip.stop"));
        this.fToolbar.addSpacer();
        this.fToolbar.addImageButton(String.valueOf(string) + "break.gif", 5, sRes.getString("tooltip.break"));
        this.fToolbar.addImageButton(String.valueOf(string) + "trace.gif", 6, sRes.getString("tooltip.displayIOWhenExecuted"));
        this.fToolbar.addSpacer();
        this.fToolbar.addImageButton(String.valueOf(string) + "probe.gif", 7, sRes.getString("tooltip.displayCurrentIO"));
        this.fToolbar.addSpacer();
        this.fToolbar.addImageButton(String.valueOf(string) + "help.gif", 8, sRes.getString("tooltip.help"), this.fCenter);
        MWToolbar mWToolbar = new MWToolbar();
        this.fClose = new MWButton(sRes.getString("button.close"));
        this.fClose.addActionListener((ActionListener)this);
        mWToolbar.add((Component)this.fClose);
        this.fToolbarPanel = new MWPanel((LayoutManager)new MWBorderLayout());
        this.fToolbarPanel.add((Component)this.fToolbar, "Center");
        this.fToolbarPanel.add((Component)mWToolbar, "East");
    }

    public void CreateDebuggerWindow(String string) {
        MWFrame mWFrame = new MWFrame(String.valueOf(sRes.getString("frame.SimulinkDebugger")) + string);
        mWFrame.setBounds(100, 100, 700, 400);
        mWFrame.setLayout((LayoutManager)new MWBorderLayout());
        mWFrame.add((Component)((Object)this), "Center");
        mWFrame.setVisible(true);
        mWFrame.addWindowListener((WindowListener)((Object)new DebuggerWindowActivater((Component)((Object)this))));
    }

    public static SimDebugger CreateSimulinkDebugger(String string) {
        SimDebugger simDebugger = new SimDebugger();
        simDebugger.CreateDebuggerWindow(string);
        simDebugger.setModelName(string);
        return simDebugger;
    }

    public static void main(String[] stringArray) {
        SimDebugger.CreateSimulinkDebugger("foo");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$2(SimDebugger simDebugger) {
        return simDebugger.fInSimulation;
    }

    private class OutputDebuggerObserver
    implements CompletionObserver {
        public OutputDebuggerObserver() {
            SimDebugger.this = SimDebugger.this;
            SimDebugger.this.appendToOutputArea("\n");
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            SimDebugger.this.appendToOutputArea(string);
        }
    }

    private class OutputWithCheckDebuggerObserver
    implements CompletionObserver {
        public OutputWithCheckDebuggerObserver() {
            SimDebugger.this = SimDebugger.this;
            SimDebugger.this.appendToOutputArea("\n");
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            SimDebugger.this.appendToOutputArea(string);
            if (Matlab.getExecutionStatus((int)n) != 33) {
                SimDebugger.this.fInSimulation = false;
                Object[] objectArray = new Object[]{new String("GetModelState")};
                SimDebugger.this.fMatlab.feval("sldebugui", objectArray, (CompletionObserver)new FinishedCompletionObserver());
            }
        }
    }

    private class FinishedCompletionObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            String string = (String)object;
            if (string == null) {
                return;
            }
            SimDebugger.this.EnableUI(true);
            if (string.equalsIgnoreCase("stopped")) {
                String string2 = new String(String.valueOf(SimDebugger.this.fSeparator) + sRes.getString("string.percentComplete") + SimDebugger.this.fSeparator);
                SimDebugger.this.appendToOutputArea(string2);
                SimDebugger.this.EnableDebugger(false);
            }
        }

        FinishedCompletionObserver() {
            SimDebugger.this = SimDebugger.this;
        }
    }

    private class StartDebuggerObserver
    implements CompletionObserver {
        public StartDebuggerObserver() {
            SimDebugger.this = SimDebugger.this;
            SimDebugger.this.fOutputArea.setText("");
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            SimDebugger.this.appendToOutputArea(string);
            if (Matlab.getExecutionStatus((int)n) != 33) {
                boolean bl = string.indexOf("??? Error") >= 0;
                SimDebugger.this.EnableUI(true);
                if (!bl) {
                    SimDebugger.this.EnableDebugger(true);
                    SimDebugger.this.InitDebugger();
                    return;
                }
                SimDebugger.this.appendToOutputArea("\n%\n" + sRes.getString("string.pleaseFixError") + "%\n");
                SimDebugger.this.EnableDebugger(false);
            }
        }
    }

    private class SortedDebuggerObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            String string = (String)object;
            if (string.length() > 0) {
                int n2 = string.lastIndexOf("(sldebug");
                String string2 = null;
                if (n2 >= 0) {
                    n2 = n2 == 0 ? 0 : n2 - 1;
                    string2 = new String(string.substring(0, n2));
                } else {
                    string2 = new String(string);
                }
                SimDebugger.this.fSortedArea.append(string2);
            }
        }

        SortedDebuggerObserver() {
            SimDebugger.this = SimDebugger.this;
        }
    }

    private class StatusDebuggerObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            String string = (String)object;
            if (string.length() > 0) {
                int n2 = string.lastIndexOf("(sldebug");
                String string2 = null;
                if (n2 >= 0) {
                    n2 = n2 == 0 ? 0 : n2 - 1;
                    string2 = new String(string.substring(0, n2));
                } else {
                    string2 = new String(string);
                }
                SimDebugger.this.fStatusArea.setText(string2);
            }
        }

        StatusDebuggerObserver() {
            SimDebugger.this = SimDebugger.this;
        }
    }

    private class ProbeDebuggerObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            String string = (String)object;
            if (string.compareTo("") != 0) {
                SimDebugger.this.fMatlab.evalStreamOutput("probe gcb", (CompletionObserver)new OutputDebuggerObserver(), 2048);
            }
        }

        ProbeDebuggerObserver() {
            SimDebugger.this = SimDebugger.this;
        }
    }

    private class WatchPointDebuggerObserver
    implements CompletionObserver {
        int fColumn;

        public WatchPointDebuggerObserver(int n) {
            SimDebugger.this = SimDebugger.this;
            this.fColumn = n;
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            if (string.compareTo("") != 0) {
                Object object2;
                TableData tableData = SimDebugger.this.fBlockList.getData();
                boolean bl = false;
                int n2 = tableData.getHeight();
                int n3 = -1;
                int n4 = 0;
                while (n4 < n2) {
                    object2 = tableData.getDataAsText(n4, 0);
                    if (((String)object2).compareTo(string) == 0) {
                        bl = true;
                        n3 = n4;
                        break;
                    }
                    ++n4;
                }
                if (!bl) {
                    object2 = new Object[4];
                    object2[0] = string;
                    object2[1] = new Boolean(false);
                    object2[2] = new Boolean(false);
                    SimDebugger.this.fBlockList.addItem((Object[])object2);
                    n3 = n2;
                }
                SimDebugger.this.fBlockList.getData().setData(n3, this.fColumn, (Object)new Boolean(true));
                SimDebugger.this.fBlockList.select(n3, this.fColumn);
                if (SimDebugger.this.fInDebugger) {
                    SimDebugger.this.fBlockList.fireValueChangedEvent(n3, this.fColumn);
                }
            }
        }
    }

    class DebuggerWindowActivater
    extends MWWindowActivater {
        public DebuggerWindowActivater(Component component) {
            super(component);
            SimDebugger.this = SimDebugger.this;
        }

        public void windowClosing(WindowEvent windowEvent) {
            SimDebugger.this.doClose();
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (SimDebugger.this.fInDebugger) {
                Object[] objectArray = new Object[]{new String("GetModelState")};
                SimDebugger.this.fMatlab.feval("sldebugui", objectArray, (CompletionObserver)new FinishedCompletionObserver());
            }
        }
    }
}

