/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.databrowser;

import com.mathworks.ide.inspector.PropertyView;
import com.mathworks.ide.inspector.SelectedBeanDisplay;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.toolbox.simulink.util.simulink.Simulink;
import com.mathworks.toolbox.simulink.util.state.BooleanState;
import com.mathworks.toolbox.simulink.util.state.ObjectState;
import com.mathworks.toolbox.simulink.util.state.State;
import com.mathworks.toolbox.simulink.util.state.StateFactory;
import com.mathworks.toolbox.simulink.util.state.StateMulticastCmdPanel;
import com.mathworks.toolbox.simulink.util.state.StringState;
import com.mathworks.util.Timer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;

public class PropertyEditorWidget
extends StateMulticastCmdPanel {
    private SelectedBeanDisplay fSelectedBeanDisplay;
    private PropertyView fPropertyView;
    private ObjectRegistry fObjectRegistry;
    private String fPropertyViewTitle = sRes.getString("string.PropertiesPanel");
    private Timer fSelectionCommandTimer = new Timer(100, (ActionListener)new SelectionCommandTimerListener(), 2, "Selection Command Timer");
    private String fMFunctionName;
    private String fDataConversionActionCommand = "ConvertVariablesToJavaBeans";
    private boolean EMERGENCY_UPDATE_FLAG = false;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.databrowser.resources.RES_databrowser");

    public PropertyEditorWidget() {
        this.construct();
    }

    public State getState(int n) {
        switch (n) {
            case -201: {
                return StateFactory.generateState(-201, this.isComponentEnabled());
            }
        }
        return super.getState(n);
    }

    public synchronized void setState(State state) {
        switch (state.getStateId()) {
            case -201: {
                this.setComponentEnabled(((BooleanState)state).getValue());
                return;
            }
            case -22: {
                this.fMFunctionName = ((StringState)state).getValue();
                super.setState(state);
                return;
            }
        }
        super.setState(state);
    }

    public void doCommand(int n) {
        switch (n) {
            case 301: {
                this.fSelectionCommandTimer.stop();
                this.fSelectionCommandTimer.start();
                return;
            }
        }
        super.doCommand(n);
    }

    private void processSelectionCommand() {
        ObjectState objectState = (ObjectState)this.getChainRoot().lookupState(-302);
        Object[] objectArray = (Object[])objectState.getValue();
        if (objectArray != null && objectArray[0] != null) {
            this.requestPopulationData(objectArray);
            return;
        }
        this.clearPropertyEditor();
    }

    private void construct() {
        this.fObjectRegistry = ObjectRegistry.getRegistry();
        this.fPropertyView = new PropertyView(this.fObjectRegistry);
        this.fSelectedBeanDisplay = new SelectedBeanDisplay(this.fObjectRegistry);
        this.fPropertyView.setName(this.fPropertyViewTitle);
        this.clearPropertyEditor();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.fSelectedBeanDisplay, "North");
        ((Container)((Object)this)).add((Component)this.fPropertyView, "Center");
    }

    private void requestPopulationData(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        Double d = (Double)objectArray[0];
        String[] stringArray = (String[])objectArray[1];
        String[] stringArray2 = (String[])objectArray[2];
        String[] stringArray3 = (String[])objectArray[3];
        Simulink simulink = Simulink.getSimulinkInstance();
        DataConversionCompletionObserver dataConversionCompletionObserver = new DataConversionCompletionObserver(stringArray3);
        simulink.feval(this.fMFunctionName, this.fDataConversionActionCommand, d, stringArray, stringArray2, 2, dataConversionCompletionObserver);
    }

    private synchronized void processRawSimulnkData(int n, Object object) {
        try {
            if (n != 0) {
                throw new RuntimeException(String.valueOf(sRes.getString("string.SimulinkErrorStatus")) + Integer.toString(n));
            }
            this.repopulate((Object[])object);
            this.EMERGENCY_UPDATE_FLAG = false;
            return;
        }
        catch (Exception exception) {
            if (this.EMERGENCY_UPDATE_FLAG) {
                this.EMERGENCY_UPDATE_FLAG = false;
                exception.printStackTrace();
                throw new RuntimeException("Repeated failure in <processRawSimulnkData> method");
            }
            this.EMERGENCY_UPDATE_FLAG = true;
            this.getCommandCenter().doCommand(2);
            return;
        }
    }

    private void repopulate(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        String[] stringArray = (String[])objectArray[0];
        Object[] objectArray2 = (Object[])objectArray[1];
        double[] dArray = (double[])objectArray2[1];
        Object[] objectArray3 = (Object[])objectArray2[0];
        Vector<Object> vector = new Vector<Object>();
        Vector<String> vector2 = new Vector<String>();
        Object[] objectArray4 = null;
        Object[] objectArray5 = null;
        if (objectArray3 != null) {
            int n = 0;
            while (n < objectArray3.length) {
                if (dArray[n] == 1.0) {
                    vector.addElement(objectArray3[n]);
                    vector2.addElement(stringArray[n]);
                }
                ++n;
            }
            objectArray4 = new Object[vector.size()];
            objectArray5 = new Object[vector2.size()];
            vector.copyInto(objectArray4);
            vector2.copyInto(objectArray5);
            this.fObjectRegistry.setSelected(objectArray4, true);
        }
    }

    private boolean isComponentEnabled() {
        return this.fSelectedBeanDisplay.isEnabled() | this.fPropertyView.isEnabled();
    }

    private void setComponentEnabled(boolean bl) {
        this.fSelectedBeanDisplay.setEnabled(bl);
        this.fPropertyView.setEnabled(bl);
    }

    private void clearPropertyEditor() {
        Object[] objectArray = new Object[]{};
        this.fObjectRegistry.setSelected(objectArray, true);
    }

    private class DataConversionCompletionObserver
    implements CompletionObserver {
        private String[] fIconFileNames;

        public DataConversionCompletionObserver(String[] stringArray) {
            PropertyEditorWidget.this = PropertyEditorWidget.this;
            this.fIconFileNames = stringArray;
        }

        public String[] getIconFileNames() {
            return this.fIconFileNames;
        }

        public void completed(int n, Object object) {
            Object[] objectArray = new Object[]{this.fIconFileNames, object};
            PropertyEditorWidget.this.processRawSimulnkData(n, objectArray);
        }
    }

    private class SelectionCommandTimerListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PropertyEditorWidget.this.processSelectionCommand();
        }

        SelectionCommandTimerListener() {
            PropertyEditorWidget.this = PropertyEditorWidget.this;
        }
    }
}

