/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.databrowser;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.CellText;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableData;
import com.mathworks.mwt.table.ValueEvent;
import com.mathworks.mwt.table.ValueListener;
import com.mathworks.toolbox.simulink.databrowser.NewDialog;
import com.mathworks.toolbox.simulink.databrowser.util.EntryDataRec;
import com.mathworks.toolbox.simulink.databrowser.util.LocalStateFactory;
import com.mathworks.toolbox.simulink.selectiondialog.customcomponents.CustomListWidget;
import com.mathworks.toolbox.simulink.selectiondialog.customcomponents.CustomMWListbox;
import com.mathworks.toolbox.simulink.util.simulink.Simulink;
import com.mathworks.toolbox.simulink.util.simulink.SimulinkProxy;
import com.mathworks.toolbox.simulink.util.state.BooleanState;
import com.mathworks.toolbox.simulink.util.state.ObjectState;
import com.mathworks.toolbox.simulink.util.state.State;
import com.mathworks.toolbox.simulink.util.state.StateChainRoot;
import com.mathworks.toolbox.simulink.util.state.StateFactory;
import com.mathworks.toolbox.simulink.util.state.StateMulticastCmdPanel;
import com.mathworks.toolbox.simulink.util.state.StringState;
import com.mathworks.util.Combsort;
import com.mathworks.util.SortRows;
import com.mathworks.util.Timer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class ObjectListWidget
extends StateMulticastCmdPanel {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.databrowser.resources.RES_databrowser");
    private CustomListWidget fViewTable;
    private String[] fTitleStrings = new String[]{sRes.getString("title.Name"), sRes.getString("title.Class")};
    private int[] fColumnWidths = new int[]{125, 125};
    private String fMatchSequence;
    private SortDataRec fSortingData = new SortDataRec(0, false);
    private LocalContextMenu fContextMenu;
    private NewDialog fNewDialog;
    private Timer fTimer = new Timer(500, (ActionListener)new LocalTimerListener(), "Key Timer");
    private Timer fSelectionCommandTimer = new Timer(100, (ActionListener)new SelectionCommandTimerListener(), 2, "Selection Command Timer");
    private Timer fRenameCommandTimer = new Timer(1000, (ActionListener)new RenameTrackerTimerListener(), 2, "Rename Command Timer");
    private String fMFunctionName;
    private String fPopulationActionCommand = "GetDataLayer";
    private String fDataRemovalActionCommand = "ClearData";
    private String fDataValidationCommand = "ValidateNewNames";
    private String fRenameCommand = "RenameObject";
    private String fAddCommand = "AddNewObjects";
    private SimulinkProxy fPopulationProxy;
    private boolean EMERGENCY_UPDATE_FLAG = false;
    private boolean TRACK_RENAME_FLAG = false;
    private Point TRACK_RENAME_POINT = new Point(-2, -2);
    private double[] fNewNamesValidationFlags;
    private String fSignalIconName = "resources/SignalIcon.gif";
    private String fParameterIconName = "resources/ParameterIcon.gif";
    private String fMXArrayIconName = "resources/MXArrayIcon.gif";
    private Hashtable fIdItemRecTable;
    private Hashtable fNameItemRecTable;
    public static final String WAIT_STRING = sRes.getString("string.wait");
    private ListboxValueListener fListboxValueListener = new ListboxValueListener();
    static /* synthetic */ Class class$java$lang$String;

    public ObjectListWidget() {
        this.construct();
    }

    public State getState(int n) {
        switch (n) {
            case -301: {
                return StateFactory.generateState(-301, this.isComponentEnabled());
            }
            case -303: {
                return StateFactory.generateState(-303, this.fSortingData);
            }
            case -302: {
                int[] nArray = null;
                Double d = null;
                String[] stringArray = null;
                String[] stringArray2 = null;
                String[] stringArray3 = null;
                nArray = this.fViewTable.getSelectionData();
                if (nArray != null && nArray.length != 0) {
                    stringArray = new String[nArray.length];
                    stringArray2 = new String[nArray.length];
                    stringArray3 = new String[nArray.length];
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        ItemRec itemRec = this.retrieveItemRecById(nArray[n2]);
                        if (itemRec != null) {
                            if (d == null) {
                                d = itemRec.ReferenceHandle;
                            } else if (d != itemRec.ReferenceHandle) {
                                throw new RuntimeException("Corrupted ItemRecTable");
                            }
                            stringArray[n2] = itemRec.ItemName;
                            stringArray2[n2] = itemRec.ItemClass;
                            stringArray3[n2] = itemRec.ItemIconName;
                        }
                        ++n2;
                    }
                }
                Object[] objectArray = new Object[]{d, stringArray, stringArray2, stringArray3};
                return StateFactory.generateState(-302, objectArray);
            }
        }
        return super.getState(n);
    }

    public synchronized void setState(State state) {
        switch (state.getStateId()) {
            case -301: {
                this.setComponentEnabled(((BooleanState)state).getValue());
                state.setConsumed(true);
                return;
            }
            case -22: {
                this.fMFunctionName = ((StringState)state).getValue();
                super.setState(state);
                return;
            }
            case -303: {
                SortDataRec sortDataRec = (SortDataRec)((ObjectState)state).getValue();
                if (!this.fSortingData.equals(sortDataRec)) {
                    State state2 = this.getState(-302);
                    this.fSortingData = sortDataRec;
                    this.fViewTable.setWaitingState();
                    this.repopulate(this.fPopulationProxy.getDataRepository());
                    this.setState(state2);
                }
                state.setConsumed(true);
                return;
            }
            case -302: {
                Object[] objectArray = (Object[])((ObjectState)state).getValue();
                Double d = (Double)objectArray[0];
                if (d != null) {
                    Object object;
                    String[] stringArray = (String[])objectArray[1];
                    int[] nArray = new int[stringArray.length];
                    int n = 0;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        object = this.retrieveItemRecByName(stringArray[n2]);
                        if (object != null) {
                            nArray[n2] = object.ItemId;
                        } else {
                            nArray[n2] = -1;
                            ++n;
                        }
                        ++n2;
                    }
                    object = null;
                    if (n != 0) {
                        object = new int[nArray.length - n];
                        n = 0;
                        int n3 = 0;
                        while (n3 < nArray.length) {
                            if (nArray[n3] != -1) {
                                object[n++] = nArray[n3];
                            }
                            ++n3;
                        }
                    } else {
                        object = nArray;
                    }
                    this.fViewTable.setSelectionData((int[])object);
                }
                state.setConsumed(true);
                return;
            }
        }
        super.setState(state);
    }

    public void doCommand(int n) {
        switch (n) {
            case 2: 
            case 401: 
            case 402: 
            case 403: 
            case 501: {
                this.processSelectionCommand();
                if (n != 2) break;
                super.doCommand(n);
                return;
            }
            case 101: {
                this.fSelectionCommandTimer.stop();
                this.fSelectionCommandTimer.start();
                return;
            }
            case 701: {
                System.out.println("PROCESS_COPY_REQUEST");
                return;
            }
            case 702: {
                System.out.println("PROCESS_CUT_REQUEST");
                return;
            }
            case 703: {
                System.out.println("PROCESS_PASTE_REQUEST");
                return;
            }
            case 302: {
                int[] nArray = this.fViewTable.getSelectionData();
                if (nArray == null || nArray.length != 1) break;
                Cell cell = ((Table)this.fViewTable).getCell(nArray[0], 0);
                Style style = new Style(1024);
                LabeledImageResource labeledImageResource = (LabeledImageResource)((Table)this.fViewTable).getCellData(nArray[0], 0);
                style.setEditable(true);
                ((Table)this.fViewTable).setColumnStyle(0, style);
                this.fListboxValueListener.setOldCellValue(labeledImageResource.getLabel());
                cell.beginEdit(nArray[0], 0);
                style.setEditable(false);
                ((Table)this.fViewTable).setRowStyle(0, style);
                return;
            }
            case 601: {
                Object object = this;
                while (!(object instanceof Frame)) {
                    object = ((Component)object).getParent();
                }
                this.fNewDialog = new NewDialog((Frame)object, this.getCommandCenter());
                this.fNewDialog.setVisible(true);
                return;
            }
            case 602: {
                ObjectState objectState = (ObjectState)this.getState(-302);
                Object[] objectArray = (Object[])objectState.getValue();
                String[] stringArray = (String[])objectArray[1];
                if (stringArray == null || stringArray.length == 0) break;
                Simulink.getSimulinkInstance().feval(this.fMFunctionName, this.fDataRemovalActionCommand, stringArray, 0, null);
                this.getCommandCenter().doCommand(2);
                return;
            }
            case 4: {
                if (this.fNewDialog == null) break;
                String string = this.fNewDialog.getTypeSelection();
                String string2 = this.fNewDialog.getNameSelection();
                try {
                    String[] stringArray = this.parseNewNames(string2);
                    this.validateNewNames(stringArray);
                    this.addNewObjects(string, stringArray);
                    this.fNewDialog.closeDialog();
                    this.fNewDialog = null;
                    return;
                }
                catch (DataValidationException dataValidationException) {
                    this.launchAlertDialog(dataValidationException, sRes.getString("string.alertNew"));
                    return;
                }
            }
            case 3: {
                this.finalize();
                super.doCommand(n);
                return;
            }
            default: {
                super.doCommand(n);
            }
        }
    }

    public void registerCommandSources() {
        MWCommandCenter mWCommandCenter = this.getCommandCenter();
        if (mWCommandCenter != null && this.fViewTable != null) {
            this.fViewTable.setItemCommand(301);
            mWCommandCenter.addCommand(301, true, 0);
            ((CustomMWListbox)this.fViewTable).setTarget((MWCommandTarget)mWCommandCenter);
        }
    }

    private void construct() {
        this.fViewTable = new LocalCustomMWListbox();
        this.fIdItemRecTable = new Hashtable();
        this.fNameItemRecTable = new Hashtable();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)((Object)this.fViewTable));
        this.fPopulationProxy = SimulinkProxy.getSimulinkProxy(this);
    }

    private void processSelectionCommand() {
        ObjectState objectState = (ObjectState)this.getChainRoot().lookupState(-102);
        EntryDataRec entryDataRec = (EntryDataRec)objectState.getValue();
        if (entryDataRec != null) {
            this.fViewTable.setWaitingState();
            this.requestPopulationData(entryDataRec);
            return;
        }
        this.clearListBox();
    }

    private void requestPopulationData(EntryDataRec entryDataRec) {
        Simulink simulink = Simulink.getSimulinkInstance();
        StateChainRoot stateChainRoot = this.getChainRoot();
        this.fPopulationProxy.addCompletionObserver(new PopulationCompletionObserver(entryDataRec.Handle));
        simulink.feval(this.fMFunctionName, this.fPopulationActionCommand, new Double(entryDataRec.Handle), LocalStateFactory.TranslateStateToObject(stateChainRoot, -402), LocalStateFactory.TranslateStateToObject(stateChainRoot, -502), LocalStateFactory.TranslateStateToObject(stateChainRoot, -801), LocalStateFactory.TranslateStateToObject(stateChainRoot, -802), 3, this.fPopulationProxy.generateSimProxyCompletionObserver(simulink.getNextRequestId()));
    }

    private synchronized void processRawSimulnkData(int n, Object object) {
        try {
            if (n != 0) {
                throw new RuntimeException(String.valueOf(sRes.getString("string.SimulinkErrorStatus")) + Integer.toString(n));
            }
            this.repopulate((Object[])object);
            this.EMERGENCY_UPDATE_FLAG = false;
            return;
        }
        catch (Exception exception) {
            if (this.EMERGENCY_UPDATE_FLAG) {
                this.EMERGENCY_UPDATE_FLAG = false;
                exception.printStackTrace();
                throw new RuntimeException("Repeated failure in <processRawSimulnkData> method");
            }
            this.EMERGENCY_UPDATE_FLAG = true;
            this.getCommandCenter().doCommand(2);
            return;
        }
    }

    private void repopulate(Object object) {
        this.fViewTable.populate(object);
    }

    public void clearListBox() {
        this.fIdItemRecTable.clear();
        this.fNameItemRecTable.clear();
        ((LocalCustomMWListbox)this.fViewTable).removeAllItems();
        ((CustomMWListbox)this.fViewTable).itemStateChanged(null);
    }

    private boolean isComponentEnabled() {
        return ((Table)this.fViewTable).isEnabled();
    }

    private void setComponentEnabled(boolean bl) {
        ((Table)this.fViewTable).setEnabled(bl);
    }

    protected void finalize() {
        SimulinkProxy.disposeSimulinkProxy(this);
    }

    private Object sortListData(Object object, boolean bl) {
        return this.sortListData(object, 0, bl);
    }

    private Object sortListData(Object object, int n, boolean bl) {
        String[][] stringArray;
        Object[] objectArray = null;
        if (object == null) {
            return objectArray;
        }
        Double d = (Double)((Object[])object)[0];
        Object[] objectArray2 = (Object[])((Object[])object)[1];
        objectArray = new Object[2];
        objectArray[0] = d;
        if (objectArray2 == null) {
            return objectArray;
        }
        String[] stringArray2 = (String[])objectArray2[0];
        String[] stringArray3 = (String[])objectArray2[1];
        String[] stringArray4 = (String[])objectArray2[2];
        String[][] stringArray5 = new String[][]{stringArray2, stringArray3, stringArray4};
        Object[] objectArray3 = bl ? SortRows.reversesortrows((String[][])stringArray5, (int)n) : SortRows.sortrows((String[][])stringArray5, (int)n);
        objectArray[1] = stringArray = (String[][])objectArray3[0];
        return objectArray;
    }

    private void storeItemRec(int n, Double d, String string, String string2, String string3) {
        ItemRec itemRec = new ItemRec(n, d, string, string2, string3);
        this.fIdItemRecTable.put(new Integer(n), itemRec);
        this.fNameItemRecTable.put(string, itemRec);
    }

    private ItemRec retrieveItemRecById(int n) {
        return (ItemRec)this.fIdItemRecTable.get(new Integer(n));
    }

    private ItemRec retrieveItemRecByName(String string) {
        return (ItemRec)this.fNameItemRecTable.get(string);
    }

    private synchronized void validateNewNames(String[] stringArray) throws DataValidationException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.fNewNamesValidationFlags = null;
        Simulink.getSimulinkInstance().feval(this.fMFunctionName, this.fDataValidationCommand, stringArray, 1, new DataValidationCompletionObserver(this));
        try {
            this.wait(10000L);
        }
        catch (InterruptedException interruptedException) {}
        if (this.fNewNamesValidationFlags != null) {
            int n = 0;
            while (n < this.fNewNamesValidationFlags.length) {
                switch ((int)this.fNewNamesValidationFlags[n]) {
                    case 0: {
                        throw new DataValidationException(stringArray[n], sRes.getString("exception.InvalidIdentifier"));
                    }
                    case -1: {
                        throw new DataValidationException(stringArray[n], sRes.getString("exception.VariableExists"));
                    }
                    default: {
                        throw new RuntimeException(sRes.getString("exception.CorruptData"));
                    }
                    case 1: 
                }
                ++n;
            }
            return;
        }
        throw new RuntimeException("Matlab did not return data validation flags");
    }

    private void renameObject(String string, String string2) {
        Simulink.getSimulinkInstance().feval(this.fMFunctionName, this.fRenameCommand, string, string2, 0, null);
        ItemRec itemRec = this.retrieveItemRecByName(string);
        this.fNameItemRecTable.remove(string);
        itemRec.ItemName = string2;
        this.fNameItemRecTable.put(string2, itemRec);
        Object object = this.fPopulationProxy.getDataRepository();
        Object[] objectArray = (Object[])((Object[])object)[1];
        String[] stringArray = (String[])objectArray[0];
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                stringArray[n] = string2;
                return;
            }
            ++n;
        }
    }

    private String[] parseNewNames(String string) throws DataValidationException {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = string.trim();
        int n = string3.length();
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string3.charAt(n3) == ',') {
                string2 = string3.substring(n2, n3);
                if ((string2 = string2.trim()).length() == 0) {
                    throw new DataValidationException(string3, sRes.getString("exception.IncorrectInput"));
                }
                vector.addElement(string2);
                n2 = n3 + 1;
            }
            ++n3;
        }
        if (n2 < n) {
            string2 = string3.substring(n2, n);
            if ((string2 = string2.trim()).length() == 0) {
                throw new DataValidationException(string3, "Incorrect input");
            }
            vector.addElement(string2);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void addNewObjects(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        Simulink.getSimulinkInstance().feval(this.fMFunctionName, this.fAddCommand, string, stringArray, 0, null);
        int n = ((MWListbox)this.fViewTable).getItemCount();
        ItemRec itemRec = this.retrieveItemRecById(n - 1);
        Double d = itemRec == null ? new Double(-1.0) : itemRec.ReferenceHandle;
        int[] nArray = new int[stringArray.length];
        int n2 = n;
        while (n2 < n + stringArray.length) {
            ((LocalCustomMWListbox)this.fViewTable).addNewItem(d, stringArray[n2 - n], string, string, n2);
            nArray[n2 - n] = n2;
            ++n2;
        }
        this.fViewTable.setSelectionData(nArray);
        Object object = this.fPopulationProxy.getDataRepository();
        Object[] objectArray = (Object[])((Object[])object)[1];
        String[] stringArray2 = (String[])objectArray[0];
        String[] stringArray3 = (String[])objectArray[1];
        String[] cfr_ignored_0 = (String[])objectArray[2];
        int n3 = stringArray2 == null ? 0 : stringArray2.length;
        String[] stringArray4 = new String[n3 + stringArray.length];
        String[] stringArray5 = new String[n3 + stringArray.length];
        String[] stringArray6 = new String[n3 + stringArray.length];
        objectArray[0] = stringArray4;
        objectArray[1] = stringArray5;
        objectArray[2] = stringArray6;
        int n4 = 0;
        while (n4 < stringArray4.length) {
            stringArray4[n4] = n4 < n3 ? stringArray2[n4] : stringArray[n4 - n3];
            stringArray5[n4] = n4 < n3 ? stringArray3[n4] : string;
            stringArray6[n4] = n4 < n3 ? stringArray3[n4] : string;
            ++n4;
        }
    }

    private void launchAlertDialog(DataValidationException dataValidationException, String string) {
        String string2 = dataValidationException.getDataEntry();
        String string3 = dataValidationException.getDescription();
        Object object = this;
        String string4 = String.valueOf(string2) + "\n" + string3;
        while (!(object instanceof Frame)) {
            object = ((Component)object).getParent();
        }
        new MWAlert((Frame)object, string, string4, 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ double[] access$29(ObjectListWidget objectListWidget) {
        return objectListWidget.fNewNamesValidationFlags;
    }

    private class PopulationCompletionObserver
    implements CompletionObserver {
        private double fReferenceHandle;

        public PopulationCompletionObserver(double d) {
            ObjectListWidget.this = ObjectListWidget.this;
            this.fReferenceHandle = d;
        }

        public double getReferenceHandle() {
            return this.fReferenceHandle;
        }

        public void completed(int n, Object object) {
            Double d = new Double(this.fReferenceHandle);
            Object[] objectArray = new Object[]{d, object};
            ObjectListWidget.this.fPopulationProxy.removeCompletionObserver(this);
            ObjectListWidget.this.fPopulationProxy.updateDataRepository(objectArray);
            ObjectListWidget.this.processRawSimulnkData(n, objectArray);
        }
    }

    private class LocalTimerListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectListWidget.this.fMatchSequence = null;
        }

        LocalTimerListener() {
            ObjectListWidget.this = ObjectListWidget.this;
        }
    }

    private class SortDataRec {
        public int SortColumn;
        public boolean ReverseFlag;

        public SortDataRec(int n, boolean bl) {
            ObjectListWidget.this = ObjectListWidget.this;
            this.SortColumn = n;
            this.ReverseFlag = bl;
        }

        public boolean equals(Object object) {
            SortDataRec sortDataRec = null;
            boolean bl = false;
            if (this == object) {
                return true;
            }
            try {
                sortDataRec = (SortDataRec)object;
            }
            catch (Exception exception) {
                return false;
            }
            if (this.SortColumn == sortDataRec.SortColumn && this.ReverseFlag == sortDataRec.ReverseFlag) {
                bl = true;
            }
            return bl;
        }
    }

    private class LocalKeyListener
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            ObjectListWidget.this.fTimer.stop();
            if (!keyEvent.isActionKey() && keyEvent.getKeyCode() != 10) {
                char c = keyEvent.getKeyChar();
                ObjectListWidget.this.fMatchSequence = ObjectListWidget.this.fMatchSequence == null ? String.valueOf(c) : String.valueOf(ObjectListWidget.this.fMatchSequence) + c;
                ObjectListWidget.this.fViewTable.locateMatchedSequence(ObjectListWidget.this.fMatchSequence);
            }
            ObjectListWidget.this.fTimer.start();
        }

        LocalKeyListener() {
            ObjectListWidget.this = ObjectListWidget.this;
        }
    }

    private class LocalMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopUp(mouseEvent);
                return;
            }
            if (mouseEvent.getClickCount() == 2 || mouseEvent.isAltDown() || mouseEvent.isControlDown() || mouseEvent.isMetaDown() || mouseEvent.isShiftDown()) {
                ObjectListWidget.this.fRenameCommandTimer.stop();
                ObjectListWidget.this.TRACK_RENAME_FLAG = false;
                return;
            }
            if (ObjectListWidget.this.TRACK_RENAME_FLAG) {
                Point point = ((Table)ObjectListWidget.this.fViewTable).findCell(mouseEvent.getX(), mouseEvent.getY());
                ObjectListWidget.this.fRenameCommandTimer.stop();
                ObjectListWidget.this.TRACK_RENAME_FLAG = false;
                if (point != null && point.equals(ObjectListWidget.this.TRACK_RENAME_POINT)) {
                    ObjectListWidget.this.doCommand(302);
                    return;
                }
            } else {
                Point point = ((Table)ObjectListWidget.this.fViewTable).findCell(mouseEvent.getX(), mouseEvent.getY());
                if (point != null && point.x == 0 && point.y != -1) {
                    ObjectListWidget.this.fRenameCommandTimer.stop();
                    ObjectListWidget.this.fRenameCommandTimer.start();
                    ObjectListWidget.this.TRACK_RENAME_FLAG = true;
                    ObjectListWidget.this.TRACK_RENAME_POINT = point;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopUp(mouseEvent);
            }
        }

        private void showPopUp(MouseEvent mouseEvent) {
            if (ObjectListWidget.this.fContextMenu == null) {
                ObjectListWidget.this.fContextMenu = new LocalContextMenu(ObjectListWidget.this.getCommandCenter(), ObjectListWidget.this.fViewTable);
            }
            ObjectListWidget.this.fContextMenu.resensitize();
            ObjectListWidget.this.fContextMenu.show((Component)((Object)ObjectListWidget.this.fViewTable), mouseEvent.getX(), mouseEvent.getY());
        }

        LocalMouseListener() {
            ObjectListWidget.this = ObjectListWidget.this;
        }
    }

    private class LocalContextMenu
    extends MWMenu {
        private int fItemCount;
        private CustomListWidget fParent;

        public LocalContextMenu(MWCommandCenter mWCommandCenter, CustomListWidget customListWidget) {
            super("", mWCommandCenter);
            ObjectListWidget.this = ObjectListWidget.this;
            this.fParent = customListWidget;
            this.attachTo((Component)((Object)this.fParent));
            this.instantiate();
        }

        private void instantiate() {
            this.addMenuItem(sRes.getString("menuitem.new"), 601);
            ++this.fItemCount;
            this.addMenuItem(sRes.getString("menuitem.rename"), 302);
            ++this.fItemCount;
            this.addMenuItem(sRes.getString("menuitem.remove"), 602);
            ++this.fItemCount;
        }

        public void resensitize() {
            int n = 0;
            while (n < this.fItemCount) {
                MWMenuComponent mWMenuComponent = this.getItem(n);
                switch (n) {
                    case 0: {
                        boolean bl = ((Component)((Object)this.fParent)).isEnabled();
                        mWMenuComponent.setEnabled(bl);
                        break;
                    }
                    case 1: {
                        int[] nArray = this.fParent.getSelectionData();
                        boolean bl = false;
                        if (nArray != null && nArray.length == 1) {
                            bl = true;
                        }
                        mWMenuComponent.setEnabled(bl);
                        break;
                    }
                    case 2: {
                        int[] nArray = this.fParent.getSelectionData();
                        boolean bl = false;
                        if (nArray != null && nArray.length != 0) {
                            bl = true;
                        }
                        mWMenuComponent.setEnabled(bl);
                        break;
                    }
                }
                ++n;
            }
        }
    }

    private class LocalCustomMWListbox
    extends CustomMWListbox {
        private Style fBoldStyle;

        public LocalCustomMWListbox() {
            ObjectListWidget.this = ObjectListWidget.this;
            this.setColumnCount(ObjectListWidget.this.fTitleStrings.length);
            this.setHeaders(ObjectListWidget.this.fTitleStrings);
            this.setHeaderVisible(true);
            this.getSelectionOptions().setMode(3);
            this.getColumnOptions().setResizable(true);
            Class clazz = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ObjectListWidget.class$("java.lang.String"));
            ObjectListWidget objectListWidget2 = ObjectListWidget.this;
            objectListWidget2.getClass();
            this.registerCellType(clazz, (Cell)objectListWidget2.new CustomCellTextWithHeaderEvents(this));
            this.fBoldStyle = new Style(1);
            this.fBoldStyle.setFont(new Font("Dialog", 1, 12));
            this.setColumnWidthData(ObjectListWidget.this.fColumnWidths);
            ((Component)((Object)this)).addKeyListener(new LocalKeyListener());
            ((Component)((Object)this)).addMouseListener(new LocalMouseListener());
            this.addValueListener(ObjectListWidget.this.fListboxValueListener);
        }

        public int[] getSelectionData() {
            return this.getSelectedIndexes();
        }

        public void setSelectionData(int[] nArray) {
            if (nArray != null && nArray.length > 0) {
                this.setSelectedIndexes(nArray);
                this.scrollToCell(nArray[0], 0);
            }
        }

        public int[] getColumnWidthData() {
            int[] nArray = new int[this.getColumnCount()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.getColumnWidth(n);
                ++n;
            }
            return nArray;
        }

        public void setColumnWidthData(int[] nArray) {
            if (nArray != null) {
                int n = 0;
                while (n < nArray.length) {
                    this.setColumnWidth(n, nArray[n]);
                    ++n;
                }
            }
        }

        public void populate(Object object) {
            int[] nArray;
            String string = this.getSelectedItem();
            String string2 = null;
            if (string instanceof LabeledImageResource) {
                string2 = ((LabeledImageResource)string).getLabel();
            } else if (string instanceof String) {
                string2 = string;
            }
            ObjectListWidget.this.clearListBox();
            int n = 0;
            while (n < ObjectListWidget.this.fColumnWidths.length) {
                this.setCellStyle(-1, n, null);
                ++n;
            }
            SortDataRec sortDataRec = (SortDataRec)((ObjectState)ObjectListWidget.this.getState(-303)).getValue();
            this.setCellStyle(-1, sortDataRec.SortColumn, this.fBoldStyle);
            this.setColumnWidthData(ObjectListWidget.this.fColumnWidths);
            ((Component)((Object)this)).repaint();
            if (object == null) {
                return;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])objectArray[1];
            if (objectArray2 == null || objectArray2[0] == null || objectArray[1] == null) {
                return;
            }
            if (object == null) {
                return;
            }
            Double d = (Double)((Object[])object)[0];
            Object[] objectArray3 = (Object[])((Object[])object)[1];
            String[] stringArray = (String[])objectArray3[0];
            String[] stringArray2 = (String[])objectArray3[1];
            String[] stringArray3 = (String[])objectArray3[2];
            nArray = new int[]{sortDataRec.SortColumn, (nArray[0] + 1) % 3, (nArray[1] + 1) % 3};
            Combsort.sort((Object)objectArray3, (int[])nArray, null, (int)0, (int)(stringArray.length - 1));
            if (stringArray == null || stringArray2 == null || stringArray3 == null) {
                return;
            }
            if (stringArray.length != stringArray2.length) {
                throw new RuntimeException(sRes.getString("exception.DimensionMismatch"));
            }
            this.addNewItems(d, stringArray, stringArray2, stringArray3);
            if (string2 != null) {
                this.locateSelection(string2);
            }
        }

        public void setWaitingState() {
            this.addItem(WAIT_STRING);
        }

        public void clearWaitingState() {
        }

        public void locateMatchedSequence(String string) {
            int n = 0;
            int n2 = this.getItemCount();
            int n3 = string.length();
            boolean bl = false;
            String string2 = string.toLowerCase();
            n = 0;
            while (n <= n2) {
                ItemRec itemRec = ObjectListWidget.this.retrieveItemRecById(n);
                if (itemRec == null) break;
                String string3 = itemRec.ItemName.toLowerCase();
                int n4 = itemRec.ItemName.length();
                if (n4 >= n3 && string3.startsWith(string2)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.setSelectedIndex(n);
                this.scrollToCell(n, 0);
            }
        }

        public void locateSelection(String string) {
            int n = 0;
            int n2 = this.getItemCount();
            boolean bl = false;
            String string2 = null;
            n = 0;
            while (n <= n2) {
                ItemRec itemRec = ObjectListWidget.this.retrieveItemRecById(n);
                if (itemRec == null) break;
                string2 = itemRec.ItemName;
                if (string2.equals(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.setSelectedIndex(n);
                this.scrollToCell(n, 0);
            }
        }

        public boolean isInColumnResizeMode(int n, int n2) {
            return this.findPart(n, n2) == 3;
        }

        public void addNewItems(Double d, String[] stringArray, String[] stringArray2, String[] stringArray3) {
            ObjectListWidget.this.fIdItemRecTable.clear();
            ObjectListWidget.this.fIdItemRecTable = new Hashtable((int)((double)stringArray.length * 1.5));
            ObjectListWidget.this.fNameItemRecTable.clear();
            ObjectListWidget.this.fNameItemRecTable = new Hashtable((int)((double)stringArray.length * 1.5));
            TableData tableData = this.getData();
            tableData.setHeight(stringArray.length);
            try {
                tableData.suspendDataChangedNotification();
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray2[n].substring(stringArray2[n].lastIndexOf(46) + 1);
                    String string2 = string.equals("Signal") ? ObjectListWidget.this.fSignalIconName : (string.equals("Parameter") ? ObjectListWidget.this.fParameterIconName : ObjectListWidget.this.fMXArrayIconName);
                    tableData.setData(n, 0, (Object)new LabeledImageResource(string2, (Object)this, stringArray[n]));
                    tableData.setData(n, 1, (Object)stringArray3[n]);
                    ObjectListWidget.this.storeItemRec(n, d, stringArray[n], stringArray3[n], string2);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                tableData.resumeDataChangedNotification(true);
                throw throwable;
            }
            Object var9_9 = null;
            tableData.resumeDataChangedNotification(true);
        }

        public void addNewItem(Double d, String string, String string2, String string3, int n) {
            String string4 = string2.substring(string2.lastIndexOf(46) + 1);
            Object[] objectArray = new String[]{string, string3};
            String string5 = ObjectListWidget.this.fMXArrayIconName;
            if (string4.equals("Signal")) {
                string5 = ObjectListWidget.this.fSignalIconName;
            } else if (string4.equals("Parameter")) {
                string5 = ObjectListWidget.this.fParameterIconName;
            }
            this.addItem(objectArray);
            this.setCellData(n, 0, new LabeledImageResource(string5, (Object)this, string));
            ObjectListWidget.this.storeItemRec(n, d, string, string3, string5);
        }
    }

    private class CustomCellTextWithHeaderEvents
    extends CellText {
        private int selRow;
        private int selCol;
        private boolean mouseIn;
        private CustomListWidget fTable;

        public CustomCellTextWithHeaderEvents(CustomListWidget customListWidget) {
            super((Table)customListWidget);
            ObjectListWidget.this = ObjectListWidget.this;
            this.setEventMask(67);
            this.selRow = -2;
            this.selCol = -2;
            this.mouseIn = false;
            this.fTable = customListWidget;
        }

        public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
            if (this.mouseIn && n == this.selRow && n2 == this.selCol) {
                Decorations.drawButtonBevel((Graphics)graphics, (Rectangle)rectangle, (boolean)true, (boolean)false, (boolean)true);
                graphics.setColor(Color.black);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            }
            super.render(graphics, n, n2, rectangle, object, style, bl);
        }

        public boolean mousePressed(MouseEvent mouseEvent, int n, int n2, Object object) {
            if (n == -1 && !this.fTable.isInColumnResizeMode(mouseEvent.getX(), mouseEvent.getY())) {
                this.selRow = n;
                this.selCol = n2;
                this.mouseIn = true;
                ((Component)((Object)ObjectListWidget.this)).repaint();
            }
            return super.mousePressed(mouseEvent, n, n2, object);
        }

        public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2, Object object) {
            boolean bl;
            boolean bl2 = bl = n == this.selRow && n2 == this.selCol;
            if (this.mouseIn != bl) {
                this.mouseIn = bl;
            }
            return false;
        }

        public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2, Object object) {
            if (n == -1) {
                if (n == this.selRow && n2 == this.selCol) {
                    SortDataRec sortDataRec = (SortDataRec)((ObjectState)ObjectListWidget.this.getState(-303)).getValue();
                    int n3 = n2;
                    boolean bl = n2 == sortDataRec.SortColumn ? !sortDataRec.ReverseFlag : false;
                    ObjectListWidget.this.setState(StateFactory.generateState(-303, new SortDataRec(n3, bl)));
                }
                if (this.fTable.isInColumnResizeMode(mouseEvent.getX(), mouseEvent.getY())) {
                    ObjectListWidget.this.fColumnWidths = this.fTable.getColumnWidthData();
                }
            }
            ((Component)((Object)ObjectListWidget.this)).repaint();
            this.selRow = -2;
            this.selCol = -2;
            this.mouseIn = false;
            return super.mouseReleased(mouseEvent, n, n2, object);
        }
    }

    private class SelectionCommandTimerListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectListWidget.this.processSelectionCommand();
        }

        SelectionCommandTimerListener() {
            ObjectListWidget.this = ObjectListWidget.this;
        }
    }

    private class RenameTrackerTimerListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectListWidget.this.TRACK_RENAME_FLAG = false;
        }

        RenameTrackerTimerListener() {
            ObjectListWidget.this = ObjectListWidget.this;
        }
    }

    private class ListboxValueListener
    implements ValueListener {
        private String fOldCellValue;

        public void setOldCellValue(String string) {
            this.fOldCellValue = string;
        }

        public String getOldCellValue() {
            return this.fOldCellValue;
        }

        public void valueChanged(ValueEvent valueEvent) {
            LabeledImageResource labeledImageResource = (LabeledImageResource)((Table)ObjectListWidget.this.fViewTable).getCellData(valueEvent.getRow(), valueEvent.getColumn());
            String string = labeledImageResource.getLabel();
            String[] stringArray = new String[]{string};
            Table table = valueEvent.getSource();
            if (string.equals(this.fOldCellValue)) {
                return;
            }
            try {
                ObjectListWidget.this.validateNewNames(stringArray);
                ObjectListWidget.this.renameObject(this.fOldCellValue, string);
                return;
            }
            catch (DataValidationException dataValidationException) {
                ObjectListWidget.this.launchAlertDialog(dataValidationException, sRes.getString("string.rename"));
                labeledImageResource.setLabel(this.fOldCellValue);
                table.setCellData(valueEvent.getRow(), valueEvent.getColumn(), (Object)labeledImageResource);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        ListboxValueListener() {
            ObjectListWidget.this = ObjectListWidget.this;
        }
    }

    private class ItemRec {
        public int ItemId;
        public Double ReferenceHandle;
        public String ItemName;
        public String ItemClass;
        public String ItemIconName;

        public ItemRec(int n, Double d, String string, String string2, String string3) {
            ObjectListWidget.this = ObjectListWidget.this;
            this.ItemId = n;
            this.ReferenceHandle = d;
            this.ItemName = string;
            this.ItemClass = string2;
            this.ItemIconName = string3;
        }
    }

    private class DataValidationException
    extends Exception {
        private String fDataEntry;
        private String fDescription;

        public DataValidationException(String string, String string2) {
            super(string);
            ObjectListWidget.this = ObjectListWidget.this;
            this.fDataEntry = string;
            this.fDescription = string2;
        }

        public String getDataEntry() {
            return this.fDataEntry;
        }

        public String getDescription() {
            return this.fDescription;
        }
    }

    private class DataValidationCompletionObserver
    implements CompletionObserver {
        private Object fSynchronizer;

        public DataValidationCompletionObserver(Object object) {
            ObjectListWidget.this = ObjectListWidget.this;
            this.fSynchronizer = object;
        }

        public void completed(int n, Object object) {
            Object object2 = this.fSynchronizer;
            synchronized (object2) {
                if (n != 0) {
                    this.fSynchronizer.notify();
                    throw new RuntimeException(sRes.getString("exception.QueryFailed"));
                }
                ObjectListWidget.this.fNewNamesValidationFlags = (double[])object;
                this.fSynchronizer.notify();
                return;
            }
        }
    }
}

