/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.databrowser;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWToolTip;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.toolbox.simulink.selectiondialog.customcomponents.CustomMWButton;
import com.mathworks.toolbox.simulink.util.state.BooleanState;
import com.mathworks.toolbox.simulink.util.state.IntegerState;
import com.mathworks.toolbox.simulink.util.state.State;
import com.mathworks.toolbox.simulink.util.state.StateFactory;
import com.mathworks.toolbox.simulink.util.state.StateMulticastCmdPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.ResourceBundle;

public class DepthControlButtonGroup
extends StateMulticastCmdPanel {
    public static final int CURRENT_BUTTON = 101;
    public static final int CURRENT_AND_BELOW_BUTTON = 102;
    public static final int CURRENT_AND_ABOVE_BUTTON = 103;
    private MWButton fCurrentLevelButton;
    private MWButton fCurrentAndBelowButton;
    private MWButton fCurrentAndAboveButton;
    private MWExclusiveGroup fExclusiveGroup;
    private MWToolTip fCurrentLevelButtonTooltip;
    private MWToolTip fCurrentAndBelowButtonTooltip;
    private MWToolTip fCurrentAndAboveButtonTooltip;
    private String fCurrentLevelButtonTooltipStr = sRes.getString("button.CurrentLevel");
    private String fCurrentAndBelowButtonTooltipStr = sRes.getString("button.CurrentLevelBelow");
    private String fCurrentAndAboveButtonTooltipStr = sRes.getString("button.CurrentLevelAbove");
    private String fCurrentLevelIconFileName = "resources/CurrentLevelIcon.gif";
    private String fCurrentAndBelowIconFileName = "resources/CurrentAndBelowIcon.gif";
    private String fCurrentAndAboveIconFileName = "resources/CurrentAndAboveIcon.gif";
    private MWImageResource fCurrentLevelIcon;
    private MWImageResource fCurrentAndBelowIcon;
    private MWImageResource fCurrentAndAboveIcon;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.databrowser.resources.RES_databrowser");

    public DepthControlButtonGroup() {
        this.construct();
    }

    public State getState(int n) {
        switch (n) {
            case -401: {
                return StateFactory.generateState(-401, this.isComponentEnabled());
            }
            case -402: {
                int n2 = -1;
                if (this.fCurrentLevelButton.getState()) {
                    n2 = 101;
                }
                if (this.fCurrentAndBelowButton.getState()) {
                    n2 = 102;
                }
                if (this.fCurrentAndAboveButton.getState()) {
                    n2 = 103;
                }
                return StateFactory.generateState(-402, n2);
            }
        }
        return super.getState(n);
    }

    public synchronized void setState(State state) {
        switch (state.getStateId()) {
            case -401: {
                this.setComponentEnabled(((BooleanState)state).getValue());
                return;
            }
            case -402: {
                MWCommandCenter mWCommandCenter = this.getCommandCenter();
                int n = ((IntegerState)state).getValue();
                switch (n) {
                    case 101: {
                        this.fCurrentLevelButton.setState(true);
                        break;
                    }
                    case 102: {
                        this.fCurrentAndBelowButton.setState(true);
                        break;
                    }
                    case 103: {
                        this.fCurrentAndAboveButton.setState(true);
                        break;
                    }
                }
                state.setConsumed(true);
                return;
            }
        }
        super.setState(state);
    }

    public void registerCommandSources() {
        MWCommandCenter mWCommandCenter = this.getCommandCenter();
        if (mWCommandCenter != null) {
            mWCommandCenter.addCommandSource((MWCommandSource)this.fCurrentLevelButton, 401);
            mWCommandCenter.addCommandSource((MWCommandSource)this.fCurrentAndBelowButton, 402);
            mWCommandCenter.addCommandSource((MWCommandSource)this.fCurrentAndAboveButton, 403);
        }
    }

    private void construct() {
        this.fCurrentLevelIcon = new MWImageResource(this.fCurrentLevelIconFileName, (Object)this);
        this.fCurrentAndBelowIcon = new MWImageResource(this.fCurrentAndBelowIconFileName, (Object)this);
        this.fCurrentAndAboveIcon = new MWImageResource(this.fCurrentAndAboveIconFileName, (Object)this);
        this.fExclusiveGroup = new MWExclusiveGroup();
        this.fCurrentLevelButton = new CustomMWButton(this.fCurrentLevelIcon, this.fExclusiveGroup);
        this.fCurrentAndBelowButton = new CustomMWButton(this.fCurrentAndBelowIcon, this.fExclusiveGroup);
        this.fCurrentAndAboveButton = new CustomMWButton(this.fCurrentAndAboveIcon, this.fExclusiveGroup);
        this.fCurrentLevelButtonTooltip = new MWToolTip((Component)this.fCurrentLevelButton, this.fCurrentLevelButtonTooltipStr);
        this.fCurrentAndBelowButtonTooltip = new MWToolTip((Component)this.fCurrentAndBelowButton, this.fCurrentAndBelowButtonTooltipStr);
        this.fCurrentAndAboveButtonTooltip = new MWToolTip((Component)this.fCurrentAndAboveButton, this.fCurrentAndAboveButtonTooltipStr);
        ((Container)((Object)this)).setLayout(new FlowLayout(1, 0, 0));
        ((Container)((Object)this)).add((Component)this.fCurrentLevelButton);
        ((Container)((Object)this)).add((Component)this.fCurrentAndBelowButton);
        ((Container)((Object)this)).add((Component)this.fCurrentAndAboveButton);
        this.setState(StateFactory.generateState(-401, true));
        this.setState(StateFactory.generateState(-402, 101));
    }

    private boolean isComponentEnabled() {
        return this.fCurrentLevelButton.isEnabled() | this.fCurrentAndBelowButton.isEnabled() | this.fCurrentAndAboveButton.isEnabled();
    }

    private void setComponentEnabled(boolean bl) {
        this.fCurrentLevelButton.setEnabled(bl);
        this.fCurrentAndBelowButton.setEnabled(bl);
        this.fCurrentAndAboveButton.setEnabled(bl);
    }
}

