/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.databrowser;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mwt.MWTListEvent;
import com.mathworks.mwt.MWTListListener;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.toolbox.simulink.databrowser.util.EntryDataRec;
import com.mathworks.toolbox.simulink.databrowser.util.LocalStateFactory;
import com.mathworks.toolbox.simulink.selectiondialog.customcomponents.CustomMWTList;
import com.mathworks.toolbox.simulink.util.simulink.Simulink;
import com.mathworks.toolbox.simulink.util.simulink.SimulinkProxy;
import com.mathworks.toolbox.simulink.util.state.BooleanState;
import com.mathworks.toolbox.simulink.util.state.State;
import com.mathworks.toolbox.simulink.util.state.StateChainRoot;
import com.mathworks.toolbox.simulink.util.state.StateFactory;
import com.mathworks.toolbox.simulink.util.state.StateMulticastCmdPanel;
import com.mathworks.toolbox.simulink.util.state.StringState;
import com.mathworks.util.ResLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class DataHierarchyWidget
extends StateMulticastCmdPanel {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.databrowser.resources.RES_databrowser");
    private CustomMWTList fTree;
    private String fMFunctionName;
    private String fPopulationActionCommand = "GetBlockDiagrams";
    private String fExpansionActionCommand = "GetSubSystemLayer";
    private String fMatlabWorkspaceTitle = sRes.getString("string.MatlabWorkspace");
    private String fMatlabWorkspaceIconFileName = "resources/MatlabWorkspaceIcon.gif";
    private String fSimulinkWorkspaceIconFileName = "resources/SimulinkWorkspaceIcon.gif";
    private String fSimulinkModelIconFileName = "resources/SimulinkModelIcon.gif";
    private String fSubSystemIconFileName = "resources/SubSystemIcon.gif";
    private String fMaskedSubSystemIconFileName = "resources/MaskedSubSystemIcon.gif";
    private Image fMatlabWorkspaceIcon;
    private Image fSimulinkWorkspaceIcon;
    private Image fSimulinkModelIcon;
    private Image fSubSystemIcon;
    private Image fMaskedSubSystemIcon;
    private Integer fPopulationProxyId = new Integer(1);
    private Integer fExpansionProxyId = new Integer(2);
    private SimulinkProxy fPopulationProxy = SimulinkProxy.getSimulinkProxy(this.fPopulationProxyId);
    private SimulinkProxy fExpansionProxy = SimulinkProxy.getSimulinkProxy(this.fExpansionProxyId);
    private CompletionObserver fPopulationCompletionObserver = new PopulationCompletionObserver();
    private CompletionObserver fExpansionCompletionObserver = new ExpansionCompletionObserver();
    private static final int POPULATION = 128;
    private static final int EXPANSION = 256;
    private static final int MATLAB_WORKSPACE_ITEM_ID = 0;
    private Hashtable fEntryTable = new Hashtable();
    private Hashtable fMappingTable = new Hashtable();
    private int fNextId = 0;
    private boolean EMERGENCY_UPDATE_FLAG = false;
    public static final String WAIT_STRING = sRes.getString("string.wait");

    public DataHierarchyWidget() {
        this.construct();
    }

    public State getState(int n) {
        switch (n) {
            case -101: {
                return StateFactory.generateState(-101, this.isComponentEnabled());
            }
            case -22: {
                return StateFactory.generateState(n, this.fMFunctionName);
            }
            case -102: {
                int[] nArray = this.fTree.getSelectedIds();
                EntryDataRec entryDataRec = null;
                if (nArray.length > 0) {
                    entryDataRec = this.retrieveEntryRecord(nArray[0]);
                }
                return StateFactory.generateState(n, entryDataRec);
            }
        }
        return super.getState(n);
    }

    public synchronized void setState(State state) {
        switch (state.getStateId()) {
            case -101: {
                this.setComponentEnabled(((BooleanState)state).getValue());
                return;
            }
            case -22: {
                this.fMFunctionName = ((StringState)state).getValue();
                super.setState(state);
                return;
            }
        }
        super.setState(state);
    }

    public void doCommand(int n) {
        switch (n) {
            case 1: {
                this.setWaitingState();
                this.requestPopulationData();
                return;
            }
            case 2: {
                this.setWaitingState();
                this.requestPopulationData();
                super.doCommand(n);
                return;
            }
            case 3: {
                this.finalize();
                super.doCommand(n);
                return;
            }
            case 801: {
                this.getCommandCenter().doCommand(2);
                return;
            }
            case 802: {
                this.getCommandCenter().doCommand(2);
                return;
            }
        }
        super.doCommand(n);
    }

    public void registerCommandSources() {
        MWCommandCenter mWCommandCenter = this.getCommandCenter();
        if (mWCommandCenter != null) {
            mWCommandCenter.addCommandSource((MWCommandSource)this.fTree, 101);
        }
    }

    private void construct() {
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        this.fMatlabWorkspaceIcon = resLoader.loadImage(this.fMatlabWorkspaceIconFileName);
        this.fSimulinkWorkspaceIcon = resLoader.loadImage(this.fSimulinkWorkspaceIconFileName);
        this.fSimulinkModelIcon = resLoader.loadImage(this.fSimulinkModelIconFileName);
        this.fSubSystemIcon = resLoader.loadImage(this.fSubSystemIconFileName);
        this.fMaskedSubSystemIcon = resLoader.loadImage(this.fMaskedSubSystemIconFileName);
        resLoader.waitForPendingImages();
        this.fTree = new CustomMWTList(true, true, 1);
        this.fTree.addMWTListListener(new TreeListener());
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)((Object)this.fTree));
        this.fPopulationProxy.addCompletionObserver(this.fPopulationCompletionObserver);
        this.fExpansionProxy.addCompletionObserver(this.fExpansionCompletionObserver);
    }

    private boolean isComponentEnabled() {
        return ((Component)((Object)this.fTree)).isEnabled();
    }

    private void setComponentEnabled(boolean bl) {
        this.fTree.setEnabled(bl);
    }

    private void clearTreeView() {
        this.fTree.removeAll();
        this.fEntryTable.clear();
        this.fNextId = 0;
    }

    private void requestPopulationData() {
        Simulink simulink = Simulink.getSimulinkInstance();
        CompletionObserver completionObserver = this.fPopulationProxy.generateSimProxyCompletionObserver(simulink.getNextRequestId());
        StateChainRoot stateChainRoot = this.getChainRoot();
        simulink.feval(this.fMFunctionName, this.fPopulationActionCommand, LocalStateFactory.TranslateStateToObject(stateChainRoot, -801), LocalStateFactory.TranslateStateToObject(stateChainRoot, -802), 4, completionObserver);
    }

    private void requestNodeExpansionData(int n) {
        EntryDataRec entryDataRec = this.retrieveEntryRecord(n);
        if (entryDataRec != null) {
            Simulink simulink = Simulink.getSimulinkInstance();
            CompletionObserver completionObserver = this.fExpansionProxy.generateSimProxyCompletionObserver(simulink.getNextRequestId());
            StateChainRoot stateChainRoot = this.getChainRoot();
            simulink.feval(this.fMFunctionName, this.fExpansionActionCommand, new Double(entryDataRec.Handle), LocalStateFactory.TranslateStateToObject(stateChainRoot, -801), LocalStateFactory.TranslateStateToObject(stateChainRoot, -802), 4, completionObserver);
        }
    }

    private synchronized void processRawSimulnkData(int n, Object object, int n2) {
        try {
            if (n != 0) {
                throw new RuntimeException(String.valueOf(sRes.getString("string.SimulinkErrorStatus")) + Integer.toString(n));
            }
            switch (n2) {
                case 128: {
                    this.repopulate((Object[])object);
                    break;
                }
                case 256: {
                    this.expandNode((Object[])object);
                    break;
                }
            }
            this.EMERGENCY_UPDATE_FLAG = false;
            return;
        }
        catch (Exception exception) {
            if (this.EMERGENCY_UPDATE_FLAG) {
                this.EMERGENCY_UPDATE_FLAG = false;
                exception.printStackTrace();
                throw new RuntimeException("Repeated failure in <processRawSimulnkData> method");
            }
            this.EMERGENCY_UPDATE_FLAG = true;
            this.getCommandCenter().doCommand(2);
            return;
        }
    }

    private void repopulate(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        double[] dArray = (double[])objectArray[0];
        String[] stringArray = (String[])objectArray[1];
        String[] stringArray2 = (String[])objectArray[2];
        double[] dArray2 = (double[])objectArray[3];
        int n = dArray == null ? 0 : dArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (stringArray2[n3].equals("library")) {
                ++n2;
            }
            ++n3;
        }
        this.clearWaitingState();
        this.fTree.add(-1, this.fNextId++, this.fMatlabWorkspaceTitle, this.fMatlabWorkspaceIcon, (n -= n2) > 0);
        if (n > 0) {
            this.fTree.setItemTwisted(0, true);
        }
        this.storeEntryRecord(-1, 0, -1.0, this.fMatlabWorkspaceTitle, "", false);
        if (n > 0) {
            int n4 = 0;
            while (n4 < dArray.length) {
                if (!stringArray2[n4].equals("library")) {
                    int n5;
                    ++this.fNextId;
                    boolean bl = dArray2[n4] > 0.0;
                    stringArray[n4] = stringArray[n4].replace('\n', ' ');
                    this.fTree.add(0, n5, stringArray[n4], this.fSimulinkModelIcon, !bl);
                    this.storeEntryRecord(0, n5, dArray[n4], stringArray[n4], stringArray2[n4], bl);
                }
                ++n4;
            }
        }
    }

    private void expandNode(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        double[] dArray = (double[])objectArray[0];
        String[] stringArray = (String[])objectArray[1];
        String[] stringArray2 = (String[])objectArray[2];
        double[] dArray2 = (double[])objectArray[3];
        if (dArray.length > 0) {
            EntryDataRec entryDataRec = this.retrieveEntryRecord(dArray[0]);
            int n = entryDataRec.Id;
            if (this.fTree.isItemTwisted(n)) {
                int n2 = 1;
                while (n2 < dArray.length) {
                    boolean bl;
                    boolean bl2 = bl = dArray2[n2] > 0.0;
                    if (!bl || stringArray2[n2].equals("on")) {
                        int n3;
                        ++this.fNextId;
                        Image image = null;
                        image = stringArray2[n2].equals("on") ? this.fMaskedSubSystemIcon : this.fSubSystemIcon;
                        stringArray[n2] = stringArray[n2].replace('\n', ' ');
                        this.fTree.add(n, n3, stringArray[n2], image, !bl);
                        this.storeEntryRecord(n, n3, dArray[n2], stringArray[n2], stringArray2[n2], bl);
                    }
                    ++n2;
                }
            }
        }
    }

    private void storeEntryRecord(int n, int n2, double d, String string, String string2, boolean bl) {
        EntryDataRec entryDataRec = new EntryDataRec(n2, n, d, string, string2, bl);
        Integer n3 = new Integer(n2);
        Double d2 = new Double(d);
        this.fEntryTable.put(n3, entryDataRec);
        this.fMappingTable.put(d2, entryDataRec);
    }

    private EntryDataRec retrieveEntryRecord(int n) {
        return (EntryDataRec)this.fEntryTable.get(new Integer(n));
    }

    private EntryDataRec retrieveEntryRecord(double d) {
        return (EntryDataRec)this.fMappingTable.get(new Double(d));
    }

    public void setWaitingState() {
        this.clearTreeView();
        this.fTree.add(-1, 0, WAIT_STRING);
    }

    public void clearWaitingState() {
        this.clearTreeView();
    }

    protected void finalize() {
        this.fPopulationProxy.removeCompletionObserver(this.fPopulationCompletionObserver);
        this.fExpansionProxy.removeCompletionObserver(this.fExpansionCompletionObserver);
        SimulinkProxy.disposeSimulinkProxy(this.fPopulationProxyId);
        SimulinkProxy.disposeSimulinkProxy(this.fExpansionProxyId);
    }

    static /* synthetic */ int access$0() {
        return 256;
    }

    static /* synthetic */ int access$2() {
        return 0;
    }

    static /* synthetic */ int access$5() {
        return 128;
    }

    private class PopulationCompletionObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            DataHierarchyWidget.this.processRawSimulnkData(n, object, DataHierarchyWidget.access$5());
        }

        PopulationCompletionObserver() {
            DataHierarchyWidget.this = DataHierarchyWidget.this;
        }
    }

    private class ExpansionCompletionObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            DataHierarchyWidget.this.processRawSimulnkData(n, object, DataHierarchyWidget.access$0());
        }

        ExpansionCompletionObserver() {
            DataHierarchyWidget.this = DataHierarchyWidget.this;
        }
    }

    private class TreeListener
    implements MWTListListener {
        public void expandItem(MWTListEvent mWTListEvent) {
            int n = mWTListEvent.getItemId();
            if (n == DataHierarchyWidget.access$2()) {
                DataHierarchyWidget.this.requestPopulationData();
                return;
            }
            DataHierarchyWidget.this.requestNodeExpansionData(n);
        }

        public void collapseItem(MWTListEvent mWTListEvent) {
            int n = mWTListEvent.getItemId();
            mWTListEvent.getList().removeDescendants(n);
        }

        public void scrollList(MWTListEvent mWTListEvent) {
        }

        TreeListener() {
            DataHierarchyWidget.this = DataHierarchyWidget.this;
        }
    }
}

