/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.databrowser;

import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.toolbox.simulink.databrowser.DataBrowser;
import com.mathworks.toolbox.simulink.databrowser.ObjectListPanel;
import com.mathworks.toolbox.simulink.databrowser.PropertyEditorPanel;
import com.mathworks.toolbox.simulink.databrowser.util.EntryDataRec;
import com.mathworks.toolbox.simulink.databrowser.util.LocalStateFactory;
import com.mathworks.toolbox.simulink.util.state.BooleanState;
import com.mathworks.toolbox.simulink.util.state.State;
import com.mathworks.toolbox.simulink.util.state.StateBroadcastingCmdPanel;
import com.mathworks.toolbox.simulink.util.state.StateBroadcastingCmdSplitter;
import com.mathworks.toolbox.simulink.util.state.StateChainRoot;
import com.mathworks.toolbox.simulink.util.state.StateFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ResourceBundle;

public class DataBrowserPanel
extends StateBroadcastingCmdPanel
implements MWWindowOwner {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.databrowser.resources.RES_databrowser");
    private DataBrowser fBrowserFrame;
    private StateBroadcastingCmdSplitter fSplitter1;
    private StateBroadcastingCmdSplitter fSplitter2;

    public DataBrowserPanel() {
        this((DataBrowser)null);
    }

    public DataBrowserPanel(DataBrowser dataBrowser) {
        this.construct();
        this.fBrowserFrame = dataBrowser;
        if (this.fBrowserFrame != null) {
            WindowRegistry.getRegistry().register((MWWindowOwner)this);
        }
    }

    public int closeWindow() {
        if (this.fBrowserFrame != null) {
            WindowRegistry.getRegistry().unregister((MWWindowOwner)this);
            this.fBrowserFrame.disposeDataBrowser();
        }
        return 0;
    }

    public void setActive(boolean bl) {
        if (bl && this.fBrowserFrame != null) {
            this.fBrowserFrame.toFront();
        }
    }

    public String getShortName() {
        return DataBrowser.DIALOG_TITLE;
    }

    public String getLongName() {
        return this.getShortName();
    }

    public DataBrowser getDataBrowser() {
        return this.fBrowserFrame;
    }

    public State getState(int n) {
        switch (n) {
            case -1: {
                return StateFactory.generateState(-1, this.isDataBrowserPanelEnabled());
            }
            case -800: {
                return StateFactory.generateState(-800, true);
            }
            case -401: {
                return StateFactory.generateState(-401, true);
            }
            case -101: {
                return StateFactory.generateState(-101, true);
            }
            case -801: {
                return StateFactory.generateState(-801, false);
            }
            case -802: {
                return StateFactory.generateState(-802, false);
            }
            case -402: {
                return StateFactory.generateState(-402, 101);
            }
            case -102: {
                return StateFactory.generateState(n, new EntryDataRec(0, -1, -1.0, sRes.getString("string.MatlabWorkspace"), "", false));
            }
        }
        return super.getState(n);
    }

    public synchronized void setState(State state) {
        switch (state.getStateId()) {
            case -1: {
                this.setDataBrowserPanelEnabled(((BooleanState)state).getValue());
                return;
            }
        }
        super.setState(state);
    }

    public void doCommand(int n) {
        switch (n) {
            case 1: {
                this.getCommandCenter().doCommand(2);
                return;
            }
        }
        super.doCommand(n);
    }

    private void construct() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fSplitter2 = new StateBroadcastingCmdSplitter((Component)((Object)new ObjectListPanel()), (Component)((Object)new PropertyEditorPanel()), 0);
        this.fSplitter2.setDividerLocation(0.5);
        this.add((Component)((Object)this.fSplitter2));
    }

    private void setDataBrowserPanelEnabled(boolean bl) {
        int[] nArray = LocalStateFactory.getEnableStateIds();
        StateChainRoot stateChainRoot = this.getChainRoot();
        int n = 0;
        while (n < nArray.length) {
            stateChainRoot.broadcastState(StateFactory.generateState(nArray[n], bl));
            ++n;
        }
    }

    private boolean isDataBrowserPanelEnabled() {
        int[] nArray = LocalStateFactory.getEnableStateIds();
        StateChainRoot stateChainRoot = this.getChainRoot();
        boolean bl = false;
        int n = 0;
        while (n < nArray.length) {
            BooleanState booleanState = (BooleanState)stateChainRoot.lookupState(nArray[n]);
            if (bl |= booleanState.getValue()) break;
            ++n;
        }
        return bl;
    }
}

