/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.simulink.databrowser;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandCenterOwner;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.toolbox.simulink.databrowser.DataBrowserPanel;
import com.mathworks.toolbox.simulink.databrowser.util.LocalStateFactory;
import com.mathworks.toolbox.simulink.util.state.State;
import com.mathworks.toolbox.simulink.util.state.StateChainRoot;
import com.mathworks.toolbox.simulink.util.state.StateContainer;
import com.mathworks.toolbox.simulink.util.state.StateFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

public class DataBrowser
extends MWFrame
implements MWCommandCenterOwner,
MWCommandTarget,
StateChainRoot,
StateContainer {
    private DataBrowserPanel fDBrowserPanel;
    private MWButton fOKButton;
    private MWButton fHelpButton;
    private MWCommandCenter fCommandCenter;
    private StateChainRoot fStateChainRoot;
    private int fPrefWidth = 600;
    private int fPrefHight = 500;
    private int fScreenWidth = -1;
    private int fScreenHight = -1;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.simulink.databrowser.resources.RES_databrowser");
    public static final String DIALOG_TITLE = sRes.getString("string.DialogTitle");

    public DataBrowser(int n, int n2) {
        super(DIALOG_TITLE);
        this.construct();
        this.fScreenWidth = n;
        this.fScreenHight = n2;
    }

    public void showDataBrowser() {
        if (this.fScreenHight != -1 && this.fScreenWidth != -1) {
            int n = this.fScreenWidth / 2 - this.fPrefWidth / 2;
            int n2 = this.fScreenHight / 2 - this.fPrefHight / 2;
            ((Component)((Object)this)).setLocation(n, n2);
        }
        ((Component)((Object)this)).setSize(this.fPrefWidth, this.fPrefHight);
        ((Frame)((Object)this)).setResizable(true);
        ((Component)((Object)this)).setVisible(true);
    }

    public void disposeDataBrowser() {
        this.fCommandCenter.doCommand(3);
        this.dispose();
    }

    public MWCommandCenter getCommandCenter() {
        return this.fCommandCenter;
    }

    public void doCommand(int n) {
    }

    public State lookupState(int n) {
        return null;
    }

    public void broadcastState(State state) {
        this.fStateChainRoot.broadcastState(state);
    }

    public State getState(int n) {
        return null;
    }

    public void setState(State state) {
    }

    private void construct() {
        this.fDBrowserPanel = new DataBrowserPanel(this);
        this.fCommandCenter = new MWCommandCenter((MWCommandTarget)this.fDBrowserPanel);
        this.fStateChainRoot = this.fDBrowserPanel;
        this.fDBrowserPanel.setCommandCenter(this.fCommandCenter);
        this.fDBrowserPanel.setChainRoot(this.fStateChainRoot);
        this.initializeStates();
        this.fOKButton = new MWButton(sRes.getString("button.close"));
        this.fHelpButton = new MWButton(sRes.getString("button.help"));
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(2, 5, 0));
        mWPanel.setInsets(new Insets(0, 0, 5, 0));
        mWPanel.add((Component)this.fHelpButton);
        mWPanel.add((Component)this.fOKButton);
        ((Container)((Object)this)).add((Component)((Object)this.fDBrowserPanel), "Center");
        ((Container)((Object)this)).add((Component)mWPanel, "South");
        ((Window)((Object)this)).addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)this.fDBrowserPanel)));
        this.fOKButton.addActionListener((ActionListener)new 1());
        this.fHelpButton.addActionListener((ActionListener)new 2());
        ((Window)((Object)this)).addWindowListener((WindowListener)((Object)new 3(this)));
        this.fCommandCenter.addCommand(2, true, 0);
        this.fCommandCenter.addCommand(1, true, 0);
        this.fCommandCenter.addCommand(3, true, 0);
        this.fCommandCenter.addCommand(4, true, 0);
        this.fCommandCenter.addCommand(5, true, 0);
        this.fCommandCenter.addCommand(6, true, 0);
    }

    private void initializeStates() {
        this.fStateChainRoot.broadcastState(StateFactory.generateState(-1, true));
        this.fStateChainRoot.broadcastState(StateFactory.generateState(-22, LocalStateFactory.MFunctionName));
        this.fStateChainRoot.broadcastState(StateFactory.generateState(-601, false));
        this.fStateChainRoot.broadcastState(StateFactory.generateState(-701, false));
        this.fStateChainRoot.broadcastState(StateFactory.generateState(-401, false));
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DataBrowser.this.fDBrowserPanel.closeWindow();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends MWWindowActivater {
        public void windowClosing(WindowEvent windowEvent) {
            DataBrowser.this.fDBrowserPanel.closeWindow();
        }

        public void windowActivated(WindowEvent windowEvent) {
            DataBrowser.this.fCommandCenter.doCommand(2);
        }

        /* synthetic */ 3(DataBrowser dataBrowser2) {
            super((Component)((Object)dataBrowser2));
        }
    }
}

