/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.nnet;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.toolbox.nnet.ArrayControl;
import com.mathworks.toolbox.nnet.ChoiceControl;
import com.mathworks.toolbox.nnet.NNManager;
import com.mathworks.toolbox.nnet.NNTGUI;
import com.mathworks.toolbox.nnet.NNViewWindow;
import com.mathworks.toolbox.nnet.NNWarningDialog;
import com.mathworks.toolbox.nnet.NewNetworkFunction;
import com.mathworks.toolbox.nnet.PropertyControl;
import com.mathworks.toolbox.nnet.TextFieldControl;
import com.mathworks.toolbox.nnet.TitledBorderPanel;
import com.mathworks.toolbox.nnet.Vectors;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

class NNNewNetworkDialog
extends MWFrame
implements WindowListener,
ItemListener,
ActionListener {
    private static final int WINDOW_WIDTH = 400;
    private static final int SPACING = 6;
    NNManager manager;
    Vector networkFunctions;
    private final MWTextField networkNameField;
    private final MWChoice networkTypeChoice;
    private final MWButton viewButton;
    private final MWButton defaultsButton;
    private final MWButton cancelButton;
    private final MWButton createButton;
    private MWPanel networkParameterNamePanel;
    private MWPanel networkParameterValuePanel;
    private MWPanel embeddedPanel;
    private MWPanel layerNamesPanel;
    private MWPanel layerValuesPanel;
    private TextFieldControl rangesControl;
    private TextFieldControl inputsControl;
    private TextFieldControl targetsControl;
    private final MWChoice rangesChoice;
    private final MWChoice inputsChoice;
    private final MWChoice targetsChoice;
    private int networkIndex;
    private Vector networkControls;
    private int numLayers;
    private PropertyControl numLayersControl;
    private int layerIndex;
    private MWChoice layerIndexControl;
    private Vector layerControls;

    public NNNewNetworkDialog(NNManager nNManager) {
        this.manager = nNManager;
        ((Frame)((Object)this)).setTitle("Create New Network");
        ((Frame)((Object)this)).setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)((Object)this)).setBounds((dimension.width - 400) / 2, 40, 400, 0);
        this.setLayout(new BorderLayout());
        this.defineNetworkFunctions();
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        ((Container)((Object)this)).add((Component)mWPanel, "North");
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel.add((Component)mWPanel2, "North");
        mWPanel2.add((Component)new MWCanvas(6, 6), "North");
        mWPanel2.add((Component)new MWCanvas(6, 6), "East");
        mWPanel2.add((Component)new MWCanvas(6, 6), "West");
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel2.add((Component)mWPanel3, "Center");
        TitledBorderPanel titledBorderPanel = new TitledBorderPanel(12);
        titledBorderPanel.setInsets(new Insets(2, 4, 4, 4));
        ((Container)((Object)this)).add((Component)((Object)titledBorderPanel), "Center");
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel4.setInsets(new Insets(4, 4, 8, 4));
        ((Container)((Object)titledBorderPanel)).add((Component)mWPanel4, "Center");
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel4.add((Component)mWPanel5, "North");
        this.networkParameterNamePanel = new MWPanel((LayoutManager)new GridLayout(0, 1));
        mWPanel5.add((Component)this.networkParameterNamePanel, "West");
        this.networkParameterValuePanel = new MWPanel((LayoutManager)new GridLayout(0, 1));
        mWPanel5.add((Component)this.networkParameterValuePanel, "Center");
        this.embeddedPanel = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel4.add((Component)this.embeddedPanel, "South");
        TitledBorderPanel titledBorderPanel2 = new TitledBorderPanel(12);
        this.embeddedPanel.add((Component)((Object)titledBorderPanel2), "North");
        MWPanel mWPanel6 = new MWPanel((LayoutManager)new BorderLayout());
        ((Container)((Object)titledBorderPanel2)).add((Component)mWPanel6, "Center");
        this.layerNamesPanel = new MWPanel((LayoutManager)new GridLayout(0, 1));
        mWPanel6.add((Component)this.layerNamesPanel, "West");
        this.layerValuesPanel = new MWPanel((LayoutManager)new GridLayout(0, 1));
        mWPanel6.add((Component)this.layerValuesPanel, "Center");
        MWPanel mWPanel7 = new MWPanel((LayoutManager)new BorderLayout());
        ((Container)((Object)this)).add((Component)mWPanel7, "South");
        MWPanel mWPanel8 = new MWPanel((LayoutManager)new FlowLayout(0, 6, 6));
        mWPanel7.add((Component)mWPanel8, "West");
        MWPanel mWPanel9 = new MWPanel((LayoutManager)new FlowLayout(2, 6, 6));
        mWPanel7.add((Component)mWPanel9, "East");
        mWPanel3.add((Component)new MWLabel("Network Name:", 0), "West");
        this.networkNameField = new MWTextField("");
        mWPanel3.add((Component)this.networkNameField, "Center");
        titledBorderPanel.addTitleComponent((Component)new MWLabel("Network Type:  ", 0));
        this.networkIndex = this.getNetworkFunctionIndex("newff");
        if (this.networkIndex < 0) {
            this.networkIndex = 0;
        }
        this.networkTypeChoice = new MWChoice();
        int n = this.networkFunctions.size();
        int n2 = 0;
        while (n2 < n) {
            this.networkTypeChoice.add(this.getFunction((int)n2).title);
            ++n2;
        }
        this.networkTypeChoice.select(this.networkIndex);
        titledBorderPanel.addTitleComponent((Component)this.networkTypeChoice);
        this.networkTypeChoice.addItemListener((ItemListener)this);
        titledBorderPanel2.addTitleComponent((Component)new MWLabel("Properties for:  ", 0));
        this.layerIndex = 0;
        this.layerIndexControl = new MWChoice();
        this.numLayers = 1;
        int n3 = 0;
        while (n3 < this.numLayers) {
            this.layerIndexControl.add("Layer " + (n3 + 1));
            ++n3;
        }
        this.layerIndexControl.select(this.layerIndex);
        titledBorderPanel2.addTitleComponent((Component)this.layerIndexControl);
        this.layerIndexControl.addItemListener((ItemListener)this);
        this.rangesChoice = new MWChoice();
        this.rangesChoice.addItemListener((ItemListener)this);
        this.inputsChoice = new MWChoice();
        this.inputsChoice.addItemListener((ItemListener)this);
        this.targetsChoice = new MWChoice();
        this.targetsChoice.addItemListener((ItemListener)this);
        this.updateChoices();
        this.viewButton = new MWButton(" View ");
        mWPanel8.add((Component)this.viewButton);
        this.viewButton.addActionListener((ActionListener)this);
        this.defaultsButton = new MWButton("Defaults");
        mWPanel8.add((Component)this.defaultsButton);
        this.defaultsButton.addActionListener((ActionListener)this);
        this.cancelButton = new MWButton("Cancel");
        mWPanel9.add((Component)this.cancelButton);
        this.cancelButton.addActionListener((ActionListener)this);
        this.createButton = new MWButton("Create");
        mWPanel9.add((Component)this.createButton);
        this.createButton.addActionListener((ActionListener)this);
        this.setNetworkIndex(this.networkIndex);
        ((Window)((Object)this)).pack();
        Dimension dimension2 = ((Container)((Object)this)).getMinimumSize();
        ((Component)((Object)this)).setSize(400, dimension2.height);
        ((Window)((Object)this)).addWindowListener(this);
        int n4 = this.networkFunctions.size();
        int n5 = 0;
        while (n5 < n4) {
            PropertyControl propertyControl = this.getFunction((int)n5).numLayersControl;
            if (propertyControl != null) {
                ((MWTextField)propertyControl).addActionListener((ActionListener)this);
            }
            ++n5;
        }
    }

    protected void updateChoices() {
        this.rangesChoice.removeAll();
        this.rangesChoice.add("Get from input:");
        int n = 0;
        while (n < this.manager.inputList.getItemCount()) {
            this.rangesChoice.add(this.manager.inputList.getItem(n));
            ++n;
        }
        this.rangesChoice.setEnabled(this.rangesChoice.getItemCount() > 1);
        this.inputsChoice.removeAll();
        this.inputsChoice.add("Set to input:");
        int n2 = 0;
        while (n2 < this.manager.inputList.getItemCount()) {
            this.inputsChoice.add(this.manager.inputList.getItem(n2));
            ++n2;
        }
        this.inputsChoice.setEnabled(this.inputsChoice.getItemCount() > 1);
        this.targetsChoice.removeAll();
        this.targetsChoice.add("Set to target:");
        int n3 = 0;
        while (n3 < this.manager.targetList.getItemCount()) {
            this.targetsChoice.add(this.manager.targetList.getItem(n3));
            ++n3;
        }
        this.targetsChoice.setEnabled(this.targetsChoice.getItemCount() > 1);
    }

    protected void launch() {
        if (!((Component)((Object)this)).isVisible()) {
            this.networkNameField.setText(NNTGUI.nnManager.newName("network"));
        }
        ((Component)((Object)this)).setVisible(true);
        this.toFront();
        ((Component)((Object)this)).requestFocus();
    }

    private void defaults() {
        int n = this.networkControls.size();
        int n2 = 0;
        while (n2 < n) {
            PropertyControl propertyControl = (PropertyControl)this.networkControls.elementAt(n2);
            propertyControl.setValue(propertyControl.getDefaultValue());
            ++n2;
        }
        if (this.numLayersControl != null) {
            this.setNumLayers(this.toPositiveInteger(this.numLayersControl.getDefaultValue()));
            n = this.layerControls.size();
            int n3 = 0;
            while (n3 < n) {
                ArrayControl arrayControl = (ArrayControl)this.layerControls.elementAt(n3);
                arrayControl.defaults();
                ++n3;
            }
        }
    }

    protected void cancel() {
        ((Component)((Object)this)).setVisible(false);
    }

    private void create() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = this.getFunction((int)this.networkIndex).name;
        int n = this.networkControls.size();
        int n2 = 0;
        while (n2 < n) {
            object4 = (PropertyControl)this.networkControls.elementAt(n2);
            if (object4 instanceof TextFieldControl) {
                object3 = object4.getName();
                object2 = object4.getValue();
                object = new Vector();
                NNTGUI.postEvent("checkvalue", object3, object2, object);
                if (((Vector)object).size() > 0) {
                    new NNWarningDialog(this.manager, String.valueOf(object3) + " does not have a legal value.");
                    return;
                }
            }
            ++n2;
        }
        object4 = this.getFunction(this.networkIndex);
        if (((NewNetworkFunction)object4).numLayersControl != null) {
            n = ((NewNetworkFunction)object4).layerControls.size();
            int n3 = 0;
            while (n3 < n) {
                object2 = (ArrayControl)((NewNetworkFunction)object4).layerControls.elementAt(n3);
                if (((ArrayControl)object2).subControl instanceof TextFieldControl) {
                    object = ((ArrayControl)object2).getName();
                    int n4 = ((ArrayControl)object2).getLength();
                    int n5 = 0;
                    while (n5 < n4) {
                        String string2 = ((ArrayControl)object2).getValue(n3);
                        Vector vector = new Vector();
                        NNTGUI.postEvent("checkvalue", object, string2, vector);
                        if (vector.size() > 0) {
                            new NNWarningDialog(this.manager, String.valueOf(object) + " for layer " + (n5 + 1) + " does not have a legal value.");
                            return;
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        object3 = new Vector();
        n = this.networkControls.size();
        int n6 = 0;
        while (n6 < n) {
            object = (PropertyControl)this.networkControls.elementAt(n6);
            ((Vector)object3).addElement(object.getNNValue());
            ++n6;
        }
        if (((NewNetworkFunction)object4).numLayersControl != null) {
            n = ((NewNetworkFunction)object4).layerControls.size();
            int n7 = 0;
            while (n7 < n) {
                ArrayControl arrayControl = (ArrayControl)((NewNetworkFunction)object4).layerControls.elementAt(n7);
                ((Vector)object3).insertElementAt(arrayControl.getNNValue(), ((NewNetworkFunction)object4).layerParameterPosition + n7);
                ++n7;
            }
        }
        String string3 = this.networkNameField.getText();
        Vector vector = new Vector();
        NNTGUI.postEvent("newnet", string3, string, object3, vector);
        if (vector.size() == 0) {
            ((Component)((Object)this)).setVisible(false);
            this.manager.addNameToNetworkList(string3);
            return;
        }
        String string4 = (String)vector.elementAt(0);
        new NNWarningDialog(this.manager, string4);
    }

    private void view() {
        Object object;
        NewNetworkFunction newNetworkFunction = this.getFunction(this.networkIndex);
        String string = newNetworkFunction.name;
        Vector<Object> vector = new Vector<Object>();
        int n = this.networkControls.size();
        int n2 = 0;
        while (n2 < n) {
            object = (PropertyControl)this.networkControls.elementAt(n2);
            vector.addElement(object.getNNValue());
            ++n2;
        }
        if (newNetworkFunction.numLayersControl != null) {
            n = newNetworkFunction.layerControls.size();
            int n3 = 0;
            while (n3 < n) {
                ArrayControl arrayControl = (ArrayControl)newNetworkFunction.layerControls.elementAt(n3);
                vector.insertElementAt(arrayControl.getNNValue(), newNetworkFunction.layerParameterPosition + n3);
                ++n3;
            }
        }
        object = new Vector();
        NNTGUI.postEvent("newdiagram", object, string, vector);
        new NNViewWindow((Vector)object);
    }

    protected void setNetworkType(String string) {
        int n = this.networkFunctions.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.getFunction((int)n2).name.equals(string)) {
                this.setNetworkIndex(n2);
                return;
            }
            ++n2;
        }
    }

    private void setNetworkIndex(int n) {
        Object object;
        this.networkIndex = n;
        this.networkTypeChoice.select(n);
        this.networkParameterNamePanel.removeAll();
        this.networkParameterValuePanel.removeAll();
        this.layerNamesPanel.removeAll();
        this.layerValuesPanel.removeAll();
        this.networkControls = this.getFunction((int)this.networkIndex).networkControls;
        int n2 = this.networkControls.size();
        ((GridLayout)this.networkParameterNamePanel.getLayout()).setRows(n2);
        ((GridLayout)this.networkParameterValuePanel.getLayout()).setRows(n2);
        int n3 = 0;
        while (n3 < n2) {
            PropertyControl propertyControl = (PropertyControl)this.networkControls.elementAt(n3);
            this.networkParameterNamePanel.add((Component)new MWLabel(String.valueOf(propertyControl.getName()) + ":", 0));
            if (propertyControl.getName().equals("Input ranges")) {
                object = new MWPanel((LayoutManager)new GridLayout(1, 2));
                this.networkParameterValuePanel.add((Component)object);
                ((Container)object).add((Component)((Object)propertyControl));
                ((Container)object).add((Component)this.rangesChoice);
                this.rangesControl = (TextFieldControl)propertyControl;
            } else if (propertyControl.getName().equals("Input data")) {
                object = new MWPanel((LayoutManager)new GridLayout(1, 2));
                this.networkParameterValuePanel.add((Component)object);
                ((Container)object).add((Component)((Object)propertyControl));
                ((Container)object).add((Component)this.inputsChoice);
                this.inputsControl = (TextFieldControl)propertyControl;
            } else if (propertyControl.getName().equals("Target data")) {
                object = new MWPanel((LayoutManager)new GridLayout(1, 2));
                this.networkParameterValuePanel.add((Component)object);
                ((Container)object).add((Component)((Object)propertyControl));
                ((Container)object).add((Component)this.targetsChoice);
                this.targetsControl = (TextFieldControl)propertyControl;
            } else {
                this.networkParameterValuePanel.add((Component)((Object)propertyControl));
            }
            ++n3;
        }
        this.numLayersControl = this.getFunction((int)this.networkIndex).numLayersControl;
        this.layerIndex = 0;
        this.layerIndexControl.select(this.layerIndex);
        if (this.numLayersControl != null) {
            ((GridLayout)this.networkParameterNamePanel.getLayout()).setRows(n2 + 1);
            ((GridLayout)this.networkParameterValuePanel.getLayout()).setRows(n2 + 1);
            this.networkParameterNamePanel.add((Component)new MWLabel(String.valueOf(this.numLayersControl.getName()) + ":", 0));
            this.networkParameterValuePanel.add((Component)((Object)this.numLayersControl));
            this.layerControls = new Vector();
            this.setNumLayers(this.toPositiveInteger(this.numLayersControl.getValue()));
            this.layerControls = this.getFunction((int)this.networkIndex).layerControls;
            n2 = this.layerControls.size();
            ((GridLayout)this.layerNamesPanel.getLayout()).setRows(n2);
            ((GridLayout)this.layerValuesPanel.getLayout()).setRows(n2);
            int n4 = 0;
            while (n4 < n2) {
                object = (ArrayControl)this.layerControls.elementAt(n4);
                this.layerNamesPanel.add((Component)new MWLabel(String.valueOf(((ArrayControl)object).getName()) + ":", 0));
                this.layerValuesPanel.add((Component)((Object)((ArrayControl)object).subControl));
                ++n4;
            }
            this.embeddedPanel.setVisible(true);
        } else {
            this.embeddedPanel.setVisible(false);
            this.layerControls = null;
        }
        Dimension dimension = ((Container)((Object)this)).getMinimumSize();
        ((Component)((Object)this)).setSize(400, dimension.height + 10);
        ((Component)((Object)this)).setSize(400, dimension.height);
    }

    private void setNumLayers(int n) {
        this.numLayers = n;
        this.numLayersControl.setValue(String.valueOf(this.numLayers));
        int n2 = this.layerIndexControl.getItemCount() - 1;
        while (n2 >= this.numLayers) {
            this.layerIndexControl.remove(n2);
            --n2;
        }
        int n3 = this.layerIndexControl.getItemCount();
        while (n3 < this.numLayers) {
            this.layerIndexControl.add("Layer " + (n3 + 1));
            ++n3;
        }
        int n4 = this.layerControls.size();
        int n5 = 0;
        while (n5 < n4) {
            ArrayControl arrayControl = (ArrayControl)this.layerControls.elementAt(n5);
            arrayControl.setLength(this.numLayers);
            ++n5;
        }
        this.setLayerIndex(this.layerIndexControl.getSelectedIndex());
    }

    private void setLayerIndex(int n) {
        this.layerIndex = n;
        int n2 = this.layerControls.size();
        int n3 = 0;
        while (n3 < n2) {
            ArrayControl arrayControl = (ArrayControl)this.layerControls.elementAt(n3);
            arrayControl.setIndex(this.layerIndex);
            ++n3;
        }
    }

    private void setRanges() {
        String string = this.rangesChoice.getSelectedItem();
        Vector vector = new Vector();
        NNTGUI.postEvent("getdatarange", string, vector);
        String string2 = (String)vector.elementAt(0);
        this.rangesControl.setValue(string2);
        this.rangesChoice.select(0);
    }

    private void setInputs() {
        String string = this.inputsChoice.getSelectedItem();
        Vector vector = new Vector();
        NNTGUI.postEvent("getdata", string, vector);
        String string2 = (String)vector.elementAt(0);
        this.inputsControl.setValue(string2);
        this.inputsChoice.select(0);
    }

    private void setTargets() {
        String string = this.targetsChoice.getSelectedItem();
        Vector vector = new Vector();
        NNTGUI.postEvent("getdata", string, vector);
        String string2 = (String)vector.elementAt(0);
        this.targetsControl.setValue(string2);
        this.targetsChoice.select(0);
    }

    private int toPositiveInteger(String string) {
        int n = 1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        n = Math.max(1, n);
        return n;
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.toFront();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cancel();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.networkTypeChoice) {
            this.setNetworkIndex(this.networkTypeChoice.getSelectedIndex());
            return;
        }
        if (object == this.layerIndexControl) {
            this.setLayerIndex(this.layerIndexControl.getSelectedIndex());
            return;
        }
        if (object == this.rangesChoice) {
            this.setRanges();
            return;
        }
        if (object == this.inputsChoice) {
            this.setInputs();
            return;
        }
        if (object == this.targetsChoice) {
            this.setTargets();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.viewButton) {
            this.view();
            return;
        }
        if (object == this.defaultsButton) {
            this.defaults();
            return;
        }
        if (object == this.cancelButton) {
            this.cancel();
            return;
        }
        if (object == this.createButton) {
            this.create();
            return;
        }
        if (object == this.numLayersControl) {
            this.setNumLayers(this.toPositiveInteger(this.numLayersControl.getValue()));
        }
    }

    private NewNetworkFunction getFunction(int n) {
        return (NewNetworkFunction)this.networkFunctions.elementAt(n);
    }

    private int getNetworkFunctionIndex(String string) {
        int n = this.networkFunctions.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.getFunction((int)n2).name.equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void defineNetworkFunctions() {
        this.networkFunctions = new Vector();
        new NewNetworkFunction(this, "newc", "Competitive", Vectors.newVector(new TextFieldControl("Input ranges", "[0 1; -1 1]", 2), new TextFieldControl("Number of neurons", "2", 1), new TextFieldControl("Kohonen learning rate", "0.1", 3), new TextFieldControl("Conscience learning rate", "0.001", 3)));
        new NewNetworkFunction(this, "newcf", "Cascade-forward backprop", Vectors.newVector(new TextFieldControl("Input ranges", "[0 1; -1 1]", 2), new ChoiceControl("Training function", "TRAINLM", Vectors.newVector("TRAINBFG", "TRAINBR", "TRAINCGB", "TRAINCGF", "TRAINCGP", "TRAINGD", "TRAINGDM", "TRAINGDA", "TRAINGDX", "TRAINLM", "TRAINOSS", "TRAINR", "TRAINRP", "TRAINSCG")), new ChoiceControl("Adaption learning function", "LEARNGDM", Vectors.newVector("LEARNGD", "LEARNGDM")), new ChoiceControl("Performance function", "MSE", Vectors.newVector("MSE", "MSEREG", "SSE"))), 1, 2, Vectors.newVector(new TextFieldControl("Number of neurons", "1", 1), new ChoiceControl("Transfer Function", "TANSIG", Vectors.newVector("LOGSIG", "PURELIN", "TANSIG"))));
        new NewNetworkFunction(this, "newelm", "Elman backprop", Vectors.newVector(new TextFieldControl("Input ranges", "[0 1; -1 1]", 2), new ChoiceControl("Training function", "TRAINLM", Vectors.newVector("TRAINBFG", "TRAINBR", "TRAINCGB", "TRAINCGF", "TRAINCGP", "TRAINGD", "TRAINGDM", "TRAINGDA", "TRAINGDX", "TRAINLM", "TRAINOSS", "TRAINR", "TRAINRP", "TRAINSCG")), new ChoiceControl("Adaption learning function", "LEARNGDM", Vectors.newVector("LEARNGD", "LEARNGDM")), new ChoiceControl("Performance function", "MSE", Vectors.newVector("MSE", "MSEREG", "SSE"))), 1, 2, Vectors.newVector(new TextFieldControl("Number of neurons", "1", 1), new ChoiceControl("Transfer Function", "TANSIG", Vectors.newVector("LOGSIG", "PURELIN", "TANSIG"))));
        new NewNetworkFunction(this, "newff", "Feed-forward backprop", Vectors.newVector(new TextFieldControl("Input ranges", "[0 1; -1 1]", 2), new ChoiceControl("Training function", "TRAINLM", Vectors.newVector("TRAINBFG", "TRAINBR", "TRAINCGB", "TRAINCGF", "TRAINCGP", "TRAINGD", "TRAINGDM", "TRAINGDA", "TRAINGDX", "TRAINLM", "TRAINOSS", "TRAINR", "TRAINRP", "TRAINSCG")), new ChoiceControl("Adaption learning function", "LEARNGDM", Vectors.newVector("LEARNGD", "LEARNGDM")), new ChoiceControl("Performance function", "MSE", Vectors.newVector("MSE", "MSEREG", "SSE"))), 1, 2, Vectors.newVector(new TextFieldControl("Number of neurons", "1", 1), new ChoiceControl("Transfer Function", "TANSIG", Vectors.newVector("LOGSIG", "PURELIN", "TANSIG"))));
        new NewNetworkFunction(this, "newfftd", "Time-delay backprop", Vectors.newVector(new TextFieldControl("Input ranges", "[0 1; -1 1]", 2), new TextFieldControl("Input delay vector", "[0 1 2]", 5), new ChoiceControl("Training function", "TRAINLM", Vectors.newVector("TRAINBFG", "TRAINBR", "TRAINCGB", "TRAINCGF", "TRAINCGP", "TRAINGD", "TRAINGDM", "TRAINGDA", "TRAINGDX", "TRAINLM", "TRAINOSS", "TRAINR", "TRAINRP", "TRAINSCG")), new ChoiceControl("Adaption learning function", "LEARNGDM", Vectors.newVector("LEARNGD", "LEARNGDM")), new ChoiceControl("Performance function", "MSE", Vectors.newVector("MSE", "MSEREG", "SSE"))), 2, 2, Vectors.newVector(new TextFieldControl("Number of neurons", "1", 1), new ChoiceControl("Transfer Function", "TANSIG", Vectors.newVector("LOGSIG", "PURELIN", "TANSIG"))));
        new NewNetworkFunction(this, "newgrnn", "Generalized regression", Vectors.newVector(new TextFieldControl("Input data", "[0 1 2 3 4 5 6]", 6), new TextFieldControl("Target data", "[0 1 1.5 1 0 -1 -1.5]", 6), new TextFieldControl("Spread constant", "1.0", 4)));
        new NewNetworkFunction(this, "newhop", "Hopfield", Vectors.newVector(new TextFieldControl("Target data", "[1 1 1; -1 1 -1]'", 7)));
        new NewNetworkFunction(this, "newlind", "Linear layer (design)", Vectors.newVector(new TextFieldControl("Input data", "[0 1 2 3 4 5 6]", 6), new TextFieldControl("Target data", "[0 1 1.5 1 0 -1 -1.5]", 6)));
        new NewNetworkFunction(this, "newlin", "Linear layer (train)", Vectors.newVector(new TextFieldControl("Input ranges", "[0 1; -1 1]", 2), new TextFieldControl("Number of neurons", "1", 1), new TextFieldControl("Input delay vector", "[0]", 5), new TextFieldControl("Learning rate", "0.01", 3)));
        new NewNetworkFunction(this, "newlvq", "LVQ", Vectors.newVector(new TextFieldControl("Input ranges", "[0 1; -1 1]", 2), new TextFieldControl("Number of hidden neurons", "1", 1), new TextFieldControl("Output class percentages", "[0.3 0.5 0.2]", 9), new TextFieldControl("Learning rate", "0.01", 3), new ChoiceControl("Learning function", "LEARNLV1", Vectors.newVector("LEARNLV1", "LEARNLV2"))));
        new NewNetworkFunction(this, "newp", "Perceptron", Vectors.newVector(new TextFieldControl("Input ranges", "[0 1; -1 1]", 2), new TextFieldControl("Number of neurons", "1", 1), new ChoiceControl("Transfer function", "HARDLIM", Vectors.newVector("HARDLIM", "HARDLIMS")), new ChoiceControl("Learning function", "LEARNP", Vectors.newVector("LEARNP", "LEARNPN"))));
        new NewNetworkFunction(this, "newpnn", "Probabilistic", Vectors.newVector(new TextFieldControl("Input data", "[0 1 2 3 4 5 6]", 6), new TextFieldControl("Target data", "[0 1 1.5 1 0 -1 -1.5]", 6), new TextFieldControl("Spread constant", "1.0", 4)));
        new NewNetworkFunction(this, "newrbe", "Radial basis (exact fit)", Vectors.newVector(new TextFieldControl("Input data", "[0 1 2 3 4 5 6]", 6), new TextFieldControl("Target data", "[0 1 1.5 1 0 -1 -1.5]", 6), new TextFieldControl("Spread constant", "1.0", 4)));
        new NewNetworkFunction(this, "newrb", "Radial basis (fewer neurons)", Vectors.newVector(new TextFieldControl("Input data", "[0 1 2 3 4 5 6]", 6), new TextFieldControl("Target data", "[0 1 1.5 1 0 -1 -1.5]", 6), new TextFieldControl("Performance Goal", "0.0", 4), new TextFieldControl("Spread constant", "1.0", 4)));
        new NewNetworkFunction(this, "newsom", "Self-organizing map", Vectors.newVector(new TextFieldControl("Input ranges", "[0 1; -1 1]", 2), new TextFieldControl("Dimensions of map", "[5 8]", 1), new ChoiceControl("Topology function", "HEXTOP", Vectors.newVector("HEXTOP", "GRIDTOP", "RANDTOP")), new ChoiceControl("Distance function", "LINKDIST", Vectors.newVector("DIST", "LINKDIST", "MANDIST")), new TextFieldControl("Ordering phase learning rate", "0.9", 3), new TextFieldControl("Ordering phase steps", "1000", 1), new TextFieldControl("Tuning phase learning rate", "0.02", 3), new TextFieldControl("Neighborhood distance", "1.0", 4)));
    }
}

