/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.nnet;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWExclusiveGroupItem;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextArea;
import com.mathworks.mwt.MWTextField;
import com.mathworks.toolbox.nnet.NNManager;
import com.mathworks.toolbox.nnet.NNTGUI;
import com.mathworks.toolbox.nnet.NNWarningDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

class NNNewDataDialog
extends MWFrame
implements WindowListener,
ItemListener,
ActionListener {
    private static final int WINDOW_WIDTH = 400;
    private static final int SPACING = 6;
    private final NNManager manager;
    private final MWButton helpButton;
    private final MWButton cancelButton;
    private final MWButton createButton;
    private final MWTextField nameField;
    private final MWTextArea valueField;
    private final MWExclusiveGroup typeControls;
    private final MWCheckbox inputCheckbox;
    private final MWCheckbox targetCheckbox;
    private final MWCheckbox inputDelayCheckbox;
    private final MWCheckbox layerDelayCheckbox;
    private final MWCheckbox outputCheckbox;
    private final MWCheckbox errorCheckbox;

    public NNNewDataDialog(NNManager nNManager) {
        this.manager = nNManager;
        ((Frame)((Object)this)).setTitle("Create New Data");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)((Object)this)).setBounds((dimension.width - 400) / 2, 10, 400, 0);
        this.setLayout(new BorderLayout());
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        ((Container)((Object)this)).add((Component)mWPanel, "Center");
        MWGroupbox mWGroupbox = new MWGroupbox("Name");
        mWGroupbox.setLayout(new BorderLayout());
        mWPanel.add((Component)mWGroupbox, "North");
        MWGroupbox mWGroupbox2 = new MWGroupbox("Value");
        mWGroupbox2.setLayout(new BorderLayout());
        mWPanel.add((Component)mWGroupbox2, "Center");
        MWGroupbox mWGroupbox3 = new MWGroupbox("Data Type");
        mWGroupbox3.setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)mWGroupbox3, "East");
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new GridLayout(6, 1));
        mWGroupbox3.add((Component)mWPanel2, "Center");
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new FlowLayout(2, 6, 6));
        ((Container)((Object)this)).add((Component)mWPanel3, "South");
        this.nameField = new MWTextField("");
        mWGroupbox.add((Component)this.nameField, "Center");
        this.valueField = new MWTextArea("[0 1 -1; 2 3 1]");
        mWGroupbox2.add((Component)this.valueField, "Center");
        this.typeControls = new MWExclusiveGroup();
        this.inputCheckbox = new MWCheckbox("Inputs", this.typeControls, true);
        mWPanel2.add((Component)this.inputCheckbox);
        this.targetCheckbox = new MWCheckbox("Targets", this.typeControls, false);
        mWPanel2.add((Component)this.targetCheckbox);
        this.inputDelayCheckbox = new MWCheckbox("Input Delay States", this.typeControls, false);
        mWPanel2.add((Component)this.inputDelayCheckbox);
        this.layerDelayCheckbox = new MWCheckbox("Layer Delay States", this.typeControls, false);
        mWPanel2.add((Component)this.layerDelayCheckbox);
        this.outputCheckbox = new MWCheckbox("Outputs", this.typeControls, false);
        mWPanel2.add((Component)this.outputCheckbox);
        this.errorCheckbox = new MWCheckbox("Errors", this.typeControls, false);
        mWPanel2.add((Component)this.errorCheckbox);
        this.helpButton = new MWButton("Help");
        mWPanel3.add((Component)this.helpButton);
        this.helpButton.addActionListener((ActionListener)this);
        this.cancelButton = new MWButton("Cancel");
        mWPanel3.add((Component)this.cancelButton);
        this.cancelButton.addActionListener((ActionListener)this);
        this.createButton = new MWButton("Create");
        mWPanel3.add((Component)this.createButton);
        this.createButton.addActionListener((ActionListener)this);
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).addWindowListener(this);
    }

    void launch() {
        if (!((Component)((Object)this)).isVisible()) {
            this.nameField.setText(NNTGUI.nnManager.newName("data"));
        }
        ((Component)((Object)this)).setVisible(true);
        this.toFront();
        ((Component)((Object)this)).requestFocus();
    }

    protected void cancel() {
        ((Component)((Object)this)).setVisible(false);
    }

    private void create() {
        String string = this.valueField.getText();
        Vector vector = new Vector();
        NNTGUI.postEvent("checkdata", string, vector);
        if (vector.size() == 0) {
            ((Component)((Object)this)).setVisible(false);
            String string2 = this.nameField.getText();
            MWExclusiveGroupItem mWExclusiveGroupItem = this.typeControls.getSelectedItem();
            int n = 0;
            if (mWExclusiveGroupItem == this.inputCheckbox) {
                n = 1;
            } else if (mWExclusiveGroupItem == this.targetCheckbox) {
                n = 2;
            } else if (mWExclusiveGroupItem == this.inputDelayCheckbox) {
                n = 3;
            } else if (mWExclusiveGroupItem == this.layerDelayCheckbox) {
                n = 4;
            } else if (mWExclusiveGroupItem == this.outputCheckbox) {
                n = 5;
            } else if (mWExclusiveGroupItem == this.errorCheckbox) {
                n = 6;
            }
            this.manager.addNameToDataList(n, string2, string);
            return;
        }
        String string3 = (String)vector.elementAt(0);
        new NNWarningDialog(this.manager, string3);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cancel();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.helpButton) {
            this.manager.launchNewDataHelpWindow();
            return;
        }
        if (object == this.cancelButton) {
            this.cancel();
            return;
        }
        if (object == this.createButton) {
            this.create();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        itemEvent.getSource();
    }
}

