/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.nnet;

import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTabPanel;
import com.mathworks.mwt.MWTextArea;
import com.mathworks.mwt.MWTextField;
import com.mathworks.toolbox.nnet.NNManager;
import com.mathworks.toolbox.nnet.NNTGUI;
import com.mathworks.toolbox.nnet.NNTrainThread;
import com.mathworks.toolbox.nnet.NNWarningDialog;
import com.mathworks.toolbox.nnet.NetworkCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

class NNNetworkWindow
extends MWFrame
implements WindowListener,
ItemListener,
ActionListener {
    private static int WINDOW_WIDTH = 580;
    private static int WINDOW_HEIGHT = 350;
    private static int SPACING = 6;
    private static int TEXT_COLUMNS = 14;
    private static String zeroString = "(zeros)";
    protected NNManager manager;
    protected String name;
    boolean hasInputs;
    boolean hasOutputs;
    boolean hasTargets;
    boolean hasInputDelays;
    boolean hasLayerDelays;
    boolean hasTrainFcn;
    boolean hasAdaptFcn;
    private MWTabPanel tabPanel;
    private MWButton viewManagerButton;
    private MWTextArea rangesTextArea;
    private MWChoice rangesChoice;
    private MWButton rangesRevertButton;
    private MWButton rangesSetButton;
    private MWButton initManagerButton;
    private MWButton revertButton;
    private MWButton initButton;
    private MWLabel simInputsLabel;
    private MWLabel simInitInputStatesLabel;
    private MWLabel simInitLayerStatesLabel;
    private MWLabel simTargetsCheckboxLabel;
    private MWLabel simTargetsLabel;
    private MWChoice simInputsChoice;
    private MWChoice simInitInputStatesChoice;
    private MWChoice simInitLayerStatesChoice;
    private MWCheckbox simTargetsCheckbox;
    private MWChoice simTargetsChoice;
    private MWLabel simOutputsLabel;
    private MWLabel simFinalInputsLabel;
    private MWLabel simFinalLayersLabel;
    private MWLabel simErrorsLabel;
    private MWTextField simOutputsField;
    private MWTextField simFinalInputsField;
    private MWTextField simFinalLayersField;
    private MWTextField simErrorsField;
    private MWButton simManagerButton;
    private MWButton simButton;
    private MWLabel trainInputsLabel;
    private MWLabel trainInitInputStatesLabel;
    private MWLabel trainInitLayerStatesLabel;
    private MWLabel trainTargetsLabel;
    private MWChoice trainInputsChoice;
    private MWChoice trainInitInputStatesChoice;
    private MWChoice trainInitLayerStatesChoice;
    private MWChoice trainTargetsChoice;
    private MWLabel trainOutputsLabel;
    private MWLabel trainFinalInputsLabel;
    private MWLabel trainFinalLayersLabel;
    private MWLabel trainErrorsLabel;
    private MWTextField trainOutputsField;
    private MWTextField trainFinalInputsField;
    private MWTextField trainFinalLayersField;
    private MWTextField trainErrorsField;
    private Vector trainingParameterNames;
    private Vector trainingParameterFields;
    private MWCheckbox validationCheckbox;
    private MWLabel validationInputsLabel;
    private MWLabel validationInitInputStatesLabel;
    private MWLabel validationInitLayerStatesLabel;
    private MWLabel validationTargetsLabel;
    private MWChoice validationInputsChoice;
    private MWChoice validationInitInputStatesChoice;
    private MWChoice validationInitLayerStatesChoice;
    private MWChoice validationTargetsChoice;
    private MWCheckbox testCheckbox;
    private MWLabel testInputsLabel;
    private MWLabel testInitInputStatesLabel;
    private MWLabel testInitLayerStatesLabel;
    private MWLabel testTargetsLabel;
    private MWChoice testInputsChoice;
    private MWChoice testInitInputStatesChoice;
    private MWChoice testInitLayerStatesChoice;
    private MWChoice testTargetsChoice;
    private MWButton trainManagerButton;
    private MWButton trainButton;
    private MWLabel adaptInputsLabel;
    private MWLabel adaptInitInputStatesLabel;
    private MWLabel adaptInitLayerStatesLabel;
    private MWLabel adaptTargetsLabel;
    private MWChoice adaptInputsChoice;
    private MWChoice adaptInitInputStatesChoice;
    private MWChoice adaptInitLayerStatesChoice;
    private MWChoice adaptTargetsChoice;
    private MWLabel adaptOutputsLabel;
    private MWLabel adaptFinalInputsLabel;
    private MWLabel adaptFinalLayersLabel;
    private MWLabel adaptErrorsLabel;
    private MWTextField adaptOutputsField;
    private MWTextField adaptFinalInputsField;
    private MWTextField adaptFinalLayersField;
    private MWTextField adaptErrorsField;
    private Vector adaptionParameterNames;
    private Vector adaptParameterFields;
    private MWButton adaptManagerButton;
    private MWButton adaptButton;
    MWChoice weightsChoice;
    MWTextArea weightsTextArea;
    MWButton weightsManagerButton;
    MWButton weightsRevertButton;
    MWButton weightsSetButton;

    public NNNetworkWindow(NNManager nNManager, String string) {
        Object object;
        MWTextField mWTextField;
        MWPanel mWPanel;
        MWPanel mWPanel2;
        MWPanel mWPanel3;
        MWGroupbox mWGroupbox;
        this.name = string;
        this.manager = nNManager;
        nNManager.addNetworkWindow(this);
        ((Frame)((Object)this)).setTitle("Network: " + string);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)((Object)this)).setBounds((dimension.width - WINDOW_WIDTH) / 2, 10, WINDOW_WIDTH, WINDOW_HEIGHT);
        this.setLayout(new BorderLayout());
        Vector vector = new Vector();
        NNTGUI.postEvent("getnetworkinfo", string, vector);
        this.hasInputs = ((String)vector.elementAt(0)).equals("true");
        this.hasOutputs = ((String)vector.elementAt(1)).equals("true");
        this.hasTargets = ((String)vector.elementAt(2)).equals("true");
        this.hasInputDelays = ((String)vector.elementAt(3)).equals("true");
        this.hasLayerDelays = ((String)vector.elementAt(4)).equals("true");
        this.hasTrainFcn = ((String)vector.elementAt(5)).equals("true");
        this.hasAdaptFcn = ((String)vector.elementAt(6)).equals("true");
        this.tabPanel = new MWTabPanel();
        ((Container)((Object)this)).add((Component)this.tabPanel, "Center");
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new BorderLayout());
        this.tabPanel.addPanel("View", (Component)mWPanel4);
        Vector vector2 = new Vector();
        NNTGUI.postEvent("getdiagram", string, vector2);
        NetworkCanvas networkCanvas = new NetworkCanvas(vector2);
        mWPanel4.add((Component)((Object)networkCanvas), "Center");
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new FlowLayout(0, SPACING, SPACING));
        mWPanel4.add((Component)mWPanel5, "South");
        this.viewManagerButton = new MWButton("Manager");
        mWPanel5.add((Component)this.viewManagerButton);
        this.viewManagerButton.addActionListener((ActionListener)this);
        CloseButtonListener closeButtonListener = new CloseButtonListener();
        MWButton mWButton = new MWButton("Close");
        mWButton.addActionListener((ActionListener)closeButtonListener);
        mWPanel5.add((Component)mWButton);
        MWPanel mWPanel6 = new MWPanel((LayoutManager)new BorderLayout());
        this.tabPanel.addPanel("Initialize", (Component)mWPanel6);
        MWGroupbox mWGroupbox2 = new MWGroupbox("Directions");
        mWGroupbox2.setLayout(new GridLayout(0, 1));
        mWPanel6.add((Component)mWGroupbox2, "North");
        mWGroupbox2.add((Component)new MWLabel("Click [REVERT WEIGHTS] to set weights and biases to their last initial values."));
        mWGroupbox2.add((Component)new MWLabel("Click [INITIALIZE WEIGHTS] to set weights and biases to new initial values."));
        if (this.hasInputs) {
            mWGroupbox2.add((Component)new MWLabel("Use the \"Input Ranges\" area below to view and edit input ranges."));
        }
        if (this.hasInputs) {
            mWGroupbox = new MWGroupbox("Input Ranges");
            mWGroupbox.setLayout(new BorderLayout());
            mWPanel6.add((Component)mWGroupbox, "Center");
            mWPanel3 = new MWPanel((LayoutManager)new BorderLayout());
            mWGroupbox.add((Component)mWPanel3, "South");
            mWPanel2 = new MWPanel((LayoutManager)new FlowLayout(0, SPACING, SPACING));
            mWPanel3.add((Component)mWPanel2, "West");
            mWPanel = new MWPanel((LayoutManager)new FlowLayout(2, SPACING, SPACING));
            mWPanel3.add((Component)mWPanel, "East");
            this.rangesTextArea = new MWTextArea();
            mWGroupbox.add((Component)this.rangesTextArea, "Center");
            this.updateInputRanges();
            this.rangesChoice = new MWChoice();
            mWPanel2.add((Component)this.rangesChoice, "West");
            this.rangesChoice.addItemListener((ItemListener)this);
            this.updateInputRangesChoice();
            this.rangesRevertButton = new MWButton("Revert Ranges");
            mWPanel.add((Component)this.rangesRevertButton);
            this.rangesRevertButton.addActionListener((ActionListener)this);
            this.rangesSetButton = new MWButton(" Set Ranges ");
            mWPanel.add((Component)this.rangesSetButton);
            this.rangesSetButton.addActionListener((ActionListener)this);
        } else {
            this.rangesTextArea = null;
            this.rangesChoice = null;
            this.rangesRevertButton = null;
            this.rangesSetButton = null;
        }
        mWGroupbox = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel6.add((Component)mWGroupbox, "South");
        mWPanel3 = new MWPanel((LayoutManager)new FlowLayout(0, SPACING, SPACING));
        mWGroupbox.add((Component)mWPanel3, "West");
        mWPanel2 = new MWPanel((LayoutManager)new FlowLayout(2, SPACING, SPACING));
        mWGroupbox.add((Component)mWPanel2, "East");
        this.initManagerButton = new MWButton("Manager");
        mWPanel3.add((Component)this.initManagerButton);
        this.initManagerButton.addActionListener((ActionListener)this);
        mWButton = new MWButton("Close");
        mWButton.addActionListener((ActionListener)closeButtonListener);
        mWPanel3.add((Component)mWButton);
        this.revertButton = new MWButton("Revert Weights");
        mWPanel2.add((Component)this.revertButton);
        this.revertButton.addActionListener((ActionListener)this);
        this.initButton = new MWButton("Initialize Weights");
        mWPanel2.add((Component)this.initButton);
        this.initButton.addActionListener((ActionListener)this);
        mWPanel = new MWPanel((LayoutManager)new MWBorderLayout());
        this.tabPanel.addPanel("Simulate", (Component)mWPanel);
        MWPanel mWPanel7 = new MWPanel((LayoutManager)new GridLayout(0, 2));
        mWPanel.add((Component)mWPanel7, "North");
        MWGroupbox mWGroupbox3 = new MWGroupbox("Simulation Data");
        mWGroupbox3.setLayout(new GridLayout(0, 2));
        mWPanel7.add((Component)mWGroupbox3);
        this.simInputsLabel = new MWLabel("Inputs", 0);
        mWGroupbox3.add((Component)this.simInputsLabel);
        this.simInputsChoice = new MWChoice();
        this.simInputsChoice.add(zeroString);
        mWGroupbox3.add((Component)this.simInputsChoice);
        this.simInputsLabel.setEnabled(this.hasInputs);
        this.simInputsChoice.setEnabled(this.hasInputs);
        this.simInitInputStatesLabel = new MWLabel("Init Input Delay States", 0);
        mWGroupbox3.add((Component)this.simInitInputStatesLabel);
        this.simInitInputStatesChoice = new MWChoice();
        this.simInitInputStatesChoice.add(zeroString);
        mWGroupbox3.add((Component)this.simInitInputStatesChoice);
        this.simInitInputStatesLabel.setEnabled(this.hasInputDelays);
        this.simInitInputStatesChoice.setEnabled(this.hasInputDelays);
        this.simInitLayerStatesLabel = new MWLabel("Init Layer Delay States", 0);
        mWGroupbox3.add((Component)this.simInitLayerStatesLabel);
        this.simInitLayerStatesChoice = new MWChoice();
        this.simInitLayerStatesChoice.add(zeroString);
        mWGroupbox3.add((Component)this.simInitLayerStatesChoice);
        this.simInitLayerStatesLabel.setEnabled(this.hasLayerDelays);
        this.simInitLayerStatesChoice.setEnabled(this.hasLayerDelays);
        this.simTargetsCheckboxLabel = new MWLabel("Supply Targets", 0);
        mWGroupbox3.add((Component)this.simTargetsCheckboxLabel);
        this.simTargetsCheckbox = new MWCheckbox("", false);
        mWGroupbox3.add((Component)this.simTargetsCheckbox);
        this.simTargetsCheckbox.addItemListener((ItemListener)this);
        this.simTargetsCheckboxLabel.setEnabled(this.hasTargets);
        this.simTargetsCheckbox.setEnabled(this.hasTargets);
        this.simTargetsLabel = new MWLabel("Targets", 0);
        mWGroupbox3.add((Component)this.simTargetsLabel);
        this.simTargetsChoice = new MWChoice();
        this.simTargetsChoice.add(zeroString);
        mWGroupbox3.add((Component)this.simTargetsChoice);
        this.simTargetsLabel.setEnabled(this.hasTargets);
        this.simTargetsChoice.setEnabled(false);
        MWGroupbox mWGroupbox4 = new MWGroupbox("Simulation Results");
        mWGroupbox4.setLayout(new GridLayout(0, 2));
        mWPanel7.add((Component)mWGroupbox4);
        this.simOutputsLabel = new MWLabel("Outputs", 0);
        mWGroupbox4.add((Component)this.simOutputsLabel);
        this.simOutputsField = new MWTextField("outputs", TEXT_COLUMNS);
        mWGroupbox4.add((Component)this.simOutputsField);
        this.simOutputsLabel.setEnabled(this.hasOutputs);
        this.simOutputsField.setEnabled(this.hasOutputs);
        this.simFinalInputsLabel = new MWLabel("Final Input Delay States", 0);
        mWGroupbox4.add((Component)this.simFinalInputsLabel);
        this.simFinalInputsField = new MWTextField("inputStates", TEXT_COLUMNS);
        mWGroupbox4.add((Component)this.simFinalInputsField);
        this.simFinalInputsLabel.setEnabled(this.hasInputDelays);
        this.simFinalInputsField.setEnabled(this.hasInputDelays);
        this.simFinalLayersLabel = new MWLabel("Final Layer Delay States", 0);
        mWGroupbox4.add((Component)this.simFinalLayersLabel);
        this.simFinalLayersField = new MWTextField("layerStates", TEXT_COLUMNS);
        mWGroupbox4.add((Component)this.simFinalLayersField);
        this.simFinalLayersLabel.setEnabled(this.hasLayerDelays);
        this.simFinalLayersField.setEnabled(this.hasLayerDelays);
        mWGroupbox4.add((Component)new MWCanvas());
        mWGroupbox4.add((Component)new MWCanvas());
        this.simErrorsLabel = new MWLabel("Errors", 0);
        mWGroupbox4.add((Component)this.simErrorsLabel);
        this.simErrorsField = new MWTextField("errors", TEXT_COLUMNS);
        mWGroupbox4.add((Component)this.simErrorsField);
        this.simErrorsLabel.setEnabled(this.hasTargets);
        this.simErrorsField.setEnabled(false);
        MWPanel mWPanel8 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel.add((Component)mWPanel8, "South");
        MWPanel mWPanel9 = new MWPanel((LayoutManager)new FlowLayout(0, SPACING, SPACING));
        mWPanel8.add((Component)mWPanel9, "West");
        MWPanel mWPanel10 = new MWPanel((LayoutManager)new FlowLayout(2, SPACING, SPACING));
        mWPanel8.add((Component)mWPanel10, "East");
        this.simManagerButton = new MWButton("Manager");
        mWPanel9.add((Component)this.simManagerButton);
        this.simManagerButton.addActionListener((ActionListener)this);
        mWButton = new MWButton("Close");
        mWButton.addActionListener((ActionListener)closeButtonListener);
        mWPanel9.add((Component)mWButton);
        this.simButton = new MWButton("Simulate Network");
        mWPanel10.add((Component)this.simButton);
        this.simButton.addActionListener((ActionListener)this);
        MWPanel mWPanel11 = new MWPanel((LayoutManager)new BorderLayout());
        this.tabPanel.addPanel("Train", (Component)mWPanel11);
        MWTabPanel mWTabPanel = new MWTabPanel(1);
        mWPanel11.add((Component)mWTabPanel, "Center");
        mWTabPanel.setEnabled(this.hasTrainFcn);
        MWPanel mWPanel12 = new MWPanel((LayoutManager)new BorderLayout());
        mWTabPanel.addPanel("Training Info", (Component)mWPanel12);
        MWPanel mWPanel13 = new MWPanel((LayoutManager)new GridLayout(0, 2));
        mWPanel12.add((Component)mWPanel13, "North");
        MWGroupbox mWGroupbox5 = new MWGroupbox("Training Data");
        mWGroupbox5.setLayout(new GridLayout(0, 2));
        mWPanel13.add((Component)mWGroupbox5);
        mWGroupbox5.setEnabled(this.hasTrainFcn);
        this.trainInputsLabel = new MWLabel("Inputs", 0);
        mWGroupbox5.add((Component)this.trainInputsLabel);
        this.trainInputsChoice = new MWChoice();
        this.trainInputsChoice.add(zeroString);
        mWGroupbox5.add((Component)this.trainInputsChoice);
        this.trainInputsLabel.setEnabled(this.hasInputs && this.hasTrainFcn);
        this.trainInputsChoice.setEnabled(this.hasInputs && this.hasTrainFcn);
        this.trainTargetsLabel = new MWLabel("Targets", 0);
        mWGroupbox5.add((Component)this.trainTargetsLabel);
        this.trainTargetsChoice = new MWChoice();
        this.trainTargetsChoice.add(zeroString);
        mWGroupbox5.add((Component)this.trainTargetsChoice);
        this.trainTargetsLabel.setEnabled(this.hasTargets && this.hasTrainFcn);
        this.trainTargetsChoice.setEnabled(this.hasTargets && this.hasTrainFcn);
        this.trainInitInputStatesLabel = new MWLabel("Init Input Delay States", 0);
        mWGroupbox5.add((Component)this.trainInitInputStatesLabel);
        this.trainInitInputStatesChoice = new MWChoice();
        this.trainInitInputStatesChoice.add(zeroString);
        mWGroupbox5.add((Component)this.trainInitInputStatesChoice);
        this.trainInitInputStatesLabel.setEnabled(this.hasInputDelays && this.hasTrainFcn);
        this.trainInitInputStatesChoice.setEnabled(this.hasInputDelays && this.hasTrainFcn);
        this.trainInitLayerStatesLabel = new MWLabel("Init Layer Delay States", 0);
        mWGroupbox5.add((Component)this.trainInitLayerStatesLabel);
        this.trainInitLayerStatesChoice = new MWChoice();
        this.trainInitLayerStatesChoice.add(zeroString);
        mWGroupbox5.add((Component)this.trainInitLayerStatesChoice);
        this.trainInitLayerStatesLabel.setEnabled(this.hasLayerDelays && this.hasTrainFcn);
        this.trainInitLayerStatesChoice.setEnabled(this.hasLayerDelays && this.hasTrainFcn);
        MWGroupbox mWGroupbox6 = new MWGroupbox("Training Results");
        mWGroupbox6.setLayout(new GridLayout(0, 2, 0, 1));
        mWPanel13.add((Component)mWGroupbox6);
        mWGroupbox6.setEnabled(this.hasTrainFcn);
        this.trainOutputsLabel = new MWLabel("Outputs", 0);
        mWGroupbox6.add((Component)this.trainOutputsLabel);
        this.trainOutputsField = new MWTextField("outputs", TEXT_COLUMNS);
        mWGroupbox6.add((Component)this.trainOutputsField);
        this.trainOutputsLabel.setEnabled(this.hasOutputs && this.hasTrainFcn);
        this.trainOutputsField.setEnabled(this.hasOutputs && this.hasTrainFcn);
        this.trainErrorsLabel = new MWLabel("Errors", 0);
        mWGroupbox6.add((Component)this.trainErrorsLabel);
        this.trainErrorsField = new MWTextField("errors", TEXT_COLUMNS);
        mWGroupbox6.add((Component)this.trainErrorsField);
        this.trainErrorsLabel.setEnabled(this.hasTargets && this.hasTrainFcn);
        this.trainErrorsField.setEnabled(this.hasTargets && this.hasTrainFcn);
        this.trainFinalInputsLabel = new MWLabel("Final Input Delay States", 0);
        mWGroupbox6.add((Component)this.trainFinalInputsLabel);
        this.trainFinalInputsField = new MWTextField("inputStates", TEXT_COLUMNS);
        mWGroupbox6.add((Component)this.trainFinalInputsField);
        this.trainFinalInputsLabel.setEnabled(this.hasInputDelays && this.hasTrainFcn);
        this.trainFinalInputsField.setEnabled(this.hasInputDelays && this.hasTrainFcn);
        this.trainFinalLayersLabel = new MWLabel("Final Layer Delay States", 0);
        mWGroupbox6.add((Component)this.trainFinalLayersLabel);
        this.trainFinalLayersField = new MWTextField("layerStates", TEXT_COLUMNS);
        mWGroupbox6.add((Component)this.trainFinalLayersField);
        this.trainFinalLayersLabel.setEnabled(this.hasLayerDelays && this.hasTrainFcn);
        this.trainFinalLayersField.setEnabled(this.hasLayerDelays && this.hasTrainFcn);
        MWPanel mWPanel14 = new MWPanel((LayoutManager)new BorderLayout());
        MWPanel mWPanel15 = new MWPanel((LayoutManager)new BorderLayout());
        mWTabPanel.addPanel("Training Parameters", (Component)mWPanel15);
        mWPanel15.add((Component)mWPanel14, "West");
        MWPanel mWPanel16 = new MWPanel((LayoutManager)new GridLayout(6, 0, 6, 1));
        mWPanel14.add((Component)mWPanel16, "North");
        this.trainingParameterNames = new Vector();
        Vector vector3 = new Vector();
        this.trainingParameterFields = new Vector();
        if (this.hasTrainFcn) {
            NNTGUI.postEvent("gettrainparams", string, this.trainingParameterNames, vector3);
            int n = this.trainingParameterNames.size();
            int n2 = 0;
            while (n2 < n) {
                this.trainingParameterFields.addElement(null);
                ++n2;
            }
            int n3 = 0;
            while (n3 < 6) {
                int n4 = 0;
                while (n4 < 3) {
                    int n5 = n3 + n4 * 6;
                    if (n5 < n) {
                        mWTextField = new MWTextField((String)vector3.elementAt(n5), 8);
                        this.trainingParameterFields.setElementAt(mWTextField, n5);
                        mWPanel16.add((Component)new MWLabel((String)this.trainingParameterNames.elementAt(n5)));
                        mWPanel16.add((Component)mWTextField);
                    } else {
                        mWPanel16.add((Component)new MWCanvas());
                        mWPanel16.add((Component)new MWCanvas());
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        MWPanel mWPanel17 = new MWPanel((LayoutManager)new BorderLayout());
        mWTabPanel.addPanel("Optional Info", (Component)mWPanel17);
        MWPanel mWPanel18 = new MWPanel((LayoutManager)new GridLayout(2, 0, 0, 6));
        mWPanel18.setInsets(new Insets(0, 0, 10, 0));
        mWPanel17.add((Component)mWPanel18, "North");
        this.validationCheckbox = new MWCheckbox("Supply optional valdiation data? (Used for early stopping for many networks.)");
        mWPanel18.add((Component)this.validationCheckbox);
        this.validationCheckbox.addItemListener((ItemListener)this);
        this.validationCheckbox.setEnabled(this.hasTrainFcn);
        this.testCheckbox = new MWCheckbox("Supply optional testing data? (Useful for estimating a network's ability to generalize.)");
        mWPanel18.add((Component)this.testCheckbox);
        this.testCheckbox.addItemListener((ItemListener)this);
        this.testCheckbox.setEnabled(this.hasTrainFcn);
        MWPanel mWPanel19 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel17.add((Component)mWPanel19, "Center");
        MWPanel mWPanel20 = new MWPanel((LayoutManager)new GridLayout(0, 2));
        mWPanel19.add((Component)mWPanel20, "North");
        MWGroupbox mWGroupbox7 = new MWGroupbox("Validation Data");
        mWGroupbox7.setLayout(new GridLayout(0, 2));
        mWPanel20.add((Component)mWGroupbox7);
        mWGroupbox7.setEnabled(this.hasTrainFcn);
        this.validationInputsLabel = new MWLabel("Inputs", 0);
        mWGroupbox7.add((Component)this.validationInputsLabel);
        this.validationInputsChoice = new MWChoice();
        this.validationInputsChoice.add(zeroString);
        mWGroupbox7.add((Component)this.validationInputsChoice);
        this.validationInputsLabel.setEnabled(this.hasInputs && this.hasTrainFcn);
        this.validationInputsChoice.setEnabled(false);
        this.validationTargetsLabel = new MWLabel("Targets", 0);
        mWGroupbox7.add((Component)this.validationTargetsLabel);
        this.validationTargetsChoice = new MWChoice();
        this.validationTargetsChoice.add(zeroString);
        mWGroupbox7.add((Component)this.validationTargetsChoice);
        this.validationTargetsLabel.setEnabled(this.hasTargets && this.hasTrainFcn);
        this.validationTargetsChoice.setEnabled(false);
        this.validationInitInputStatesLabel = new MWLabel("Init Input Delay States", 0);
        mWGroupbox7.add((Component)this.validationInitInputStatesLabel);
        this.validationInitInputStatesChoice = new MWChoice();
        this.validationInitInputStatesChoice.add(zeroString);
        mWGroupbox7.add((Component)this.validationInitInputStatesChoice);
        this.validationInitInputStatesLabel.setEnabled(this.hasInputDelays && this.hasTrainFcn);
        this.validationInitInputStatesChoice.setEnabled(false);
        this.validationInitLayerStatesLabel = new MWLabel("Init Layer Delay States", 0);
        mWGroupbox7.add((Component)this.validationInitLayerStatesLabel);
        this.validationInitLayerStatesChoice = new MWChoice();
        this.validationInitLayerStatesChoice.add(zeroString);
        mWGroupbox7.add((Component)this.validationInitLayerStatesChoice);
        this.validationInitLayerStatesLabel.setEnabled(this.hasLayerDelays && this.hasTrainFcn);
        this.validationInitLayerStatesChoice.setEnabled(false);
        mWTextField = new MWGroupbox("Test Data");
        mWTextField.setLayout(new GridLayout(0, 2));
        mWPanel20.add((Component)mWTextField);
        mWTextField.setEnabled(this.hasTrainFcn);
        this.testInputsLabel = new MWLabel("Inputs", 0);
        mWTextField.add((Component)this.testInputsLabel);
        this.testInputsChoice = new MWChoice();
        this.testInputsChoice.add(zeroString);
        mWTextField.add((Component)this.testInputsChoice);
        this.testInputsLabel.setEnabled(this.hasInputs && this.hasTrainFcn);
        this.testInputsChoice.setEnabled(false);
        this.testTargetsLabel = new MWLabel("Targets", 0);
        mWTextField.add((Component)this.testTargetsLabel);
        this.testTargetsChoice = new MWChoice();
        this.testTargetsChoice.add(zeroString);
        mWTextField.add((Component)this.testTargetsChoice);
        this.testTargetsLabel.setEnabled(this.hasTargets && this.hasTrainFcn);
        this.testTargetsChoice.setEnabled(false);
        this.testInitInputStatesLabel = new MWLabel("Init Input Delay States", 0);
        mWTextField.add((Component)this.testInitInputStatesLabel);
        this.testInitInputStatesChoice = new MWChoice();
        this.testInitInputStatesChoice.add(zeroString);
        mWTextField.add((Component)this.testInitInputStatesChoice);
        this.testInitInputStatesLabel.setEnabled(this.hasInputDelays && this.hasTrainFcn);
        this.testInitInputStatesChoice.setEnabled(false);
        this.testInitLayerStatesLabel = new MWLabel("Init Layer Delay States", 0);
        mWTextField.add((Component)this.testInitLayerStatesLabel);
        this.testInitLayerStatesChoice = new MWChoice();
        this.testInitLayerStatesChoice.add(zeroString);
        mWTextField.add((Component)this.testInitLayerStatesChoice);
        this.testInitLayerStatesLabel.setEnabled(this.hasLayerDelays && this.hasTrainFcn);
        this.testInitLayerStatesChoice.setEnabled(false);
        MWPanel mWPanel21 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel11.add((Component)mWPanel21, "South");
        MWPanel mWPanel22 = new MWPanel((LayoutManager)new FlowLayout(0, SPACING, SPACING));
        mWPanel21.add((Component)mWPanel22, "West");
        MWPanel mWPanel23 = new MWPanel((LayoutManager)new FlowLayout(2, SPACING, SPACING));
        mWPanel21.add((Component)mWPanel23, "East");
        this.trainManagerButton = new MWButton("Manager");
        mWPanel22.add((Component)this.trainManagerButton);
        this.trainManagerButton.addActionListener((ActionListener)this);
        mWButton = new MWButton("Close");
        mWButton.addActionListener((ActionListener)closeButtonListener);
        mWPanel22.add((Component)mWButton);
        this.trainButton = new MWButton("Train Network");
        mWPanel23.add((Component)this.trainButton);
        this.trainButton.addActionListener((ActionListener)this);
        this.trainButton.setEnabled(this.hasTrainFcn);
        MWPanel mWPanel24 = new MWPanel((LayoutManager)new BorderLayout());
        this.tabPanel.addPanel("Adapt", (Component)mWPanel24);
        MWTabPanel mWTabPanel2 = new MWTabPanel(1);
        mWPanel24.add((Component)mWTabPanel2, "Center");
        mWTabPanel2.setEnabled(this.hasAdaptFcn);
        MWPanel mWPanel25 = new MWPanel((LayoutManager)new BorderLayout());
        mWTabPanel2.addPanel("Adaption Info", (Component)mWPanel25);
        MWPanel mWPanel26 = new MWPanel((LayoutManager)new GridLayout(0, 2));
        mWPanel25.add((Component)mWPanel26, "North");
        MWGroupbox mWGroupbox8 = new MWGroupbox("Adaption Data");
        mWGroupbox8.setLayout(new GridLayout(0, 2));
        mWPanel26.add((Component)mWGroupbox8);
        mWGroupbox8.setEnabled(this.hasAdaptFcn);
        this.adaptInputsLabel = new MWLabel("Inputs", 0);
        mWGroupbox8.add((Component)this.adaptInputsLabel);
        this.adaptInputsChoice = new MWChoice();
        this.adaptInputsChoice.add(zeroString);
        mWGroupbox8.add((Component)this.adaptInputsChoice);
        this.adaptInputsLabel.setEnabled(this.hasInputs && this.hasAdaptFcn);
        this.adaptInputsChoice.setEnabled(this.hasInputs && this.hasAdaptFcn);
        this.adaptTargetsLabel = new MWLabel("Targets", 0);
        mWGroupbox8.add((Component)this.adaptTargetsLabel);
        this.adaptTargetsChoice = new MWChoice();
        this.adaptTargetsChoice.add(zeroString);
        mWGroupbox8.add((Component)this.adaptTargetsChoice);
        this.adaptTargetsLabel.setEnabled(this.hasTargets && this.hasAdaptFcn);
        this.adaptTargetsChoice.setEnabled(this.hasTargets && this.hasAdaptFcn);
        this.adaptInitInputStatesLabel = new MWLabel("Init Input Delay States", 0);
        mWGroupbox8.add((Component)this.adaptInitInputStatesLabel);
        this.adaptInitInputStatesChoice = new MWChoice();
        this.adaptInitInputStatesChoice.add(zeroString);
        mWGroupbox8.add((Component)this.adaptInitInputStatesChoice);
        this.adaptInitInputStatesLabel.setEnabled(this.hasInputDelays && this.hasAdaptFcn);
        this.adaptInitInputStatesChoice.setEnabled(this.hasInputDelays && this.hasAdaptFcn);
        this.adaptInitLayerStatesLabel = new MWLabel("Init Layer Delay States", 0);
        mWGroupbox8.add((Component)this.adaptInitLayerStatesLabel);
        this.adaptInitLayerStatesChoice = new MWChoice();
        this.adaptInitLayerStatesChoice.add(zeroString);
        mWGroupbox8.add((Component)this.adaptInitLayerStatesChoice);
        this.adaptInitLayerStatesLabel.setEnabled(this.hasLayerDelays && this.hasAdaptFcn);
        this.adaptInitLayerStatesChoice.setEnabled(this.hasLayerDelays && this.hasAdaptFcn);
        MWGroupbox mWGroupbox9 = new MWGroupbox("Adaption Results");
        mWGroupbox9.setLayout(new GridLayout(0, 2, 0, 1));
        mWPanel26.add((Component)mWGroupbox9);
        mWGroupbox9.setEnabled(this.hasAdaptFcn);
        this.adaptOutputsLabel = new MWLabel("Outputs", 0);
        mWGroupbox9.add((Component)this.adaptOutputsLabel);
        this.adaptOutputsField = new MWTextField("outputs", TEXT_COLUMNS);
        mWGroupbox9.add((Component)this.adaptOutputsField);
        this.adaptOutputsLabel.setEnabled(this.hasOutputs && this.hasAdaptFcn);
        this.adaptOutputsField.setEnabled(this.hasOutputs && this.hasAdaptFcn);
        this.adaptErrorsLabel = new MWLabel("Errors", 0);
        mWGroupbox9.add((Component)this.adaptErrorsLabel);
        this.adaptErrorsField = new MWTextField("errors", TEXT_COLUMNS);
        mWGroupbox9.add((Component)this.adaptErrorsField);
        this.adaptErrorsLabel.setEnabled(this.hasTargets && this.hasAdaptFcn);
        this.adaptErrorsField.setEnabled(this.hasTargets && this.hasAdaptFcn);
        this.adaptFinalInputsLabel = new MWLabel("Final Input Delay States", 0);
        mWGroupbox9.add((Component)this.adaptFinalInputsLabel);
        this.adaptFinalInputsField = new MWTextField("inputStates", TEXT_COLUMNS);
        mWGroupbox9.add((Component)this.adaptFinalInputsField);
        this.adaptFinalInputsLabel.setEnabled(this.hasInputDelays && this.hasAdaptFcn);
        this.adaptFinalInputsField.setEnabled(this.hasInputDelays && this.hasAdaptFcn);
        this.adaptFinalLayersLabel = new MWLabel("Final Layer Delay States", 0);
        mWGroupbox9.add((Component)this.adaptFinalLayersLabel);
        this.adaptFinalLayersField = new MWTextField("layerStates", TEXT_COLUMNS);
        mWGroupbox9.add((Component)this.adaptFinalLayersField);
        this.adaptFinalLayersLabel.setEnabled(this.hasLayerDelays && this.hasAdaptFcn);
        this.adaptFinalLayersField.setEnabled(this.hasLayerDelays && this.hasAdaptFcn);
        MWPanel mWPanel27 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel15 = new MWPanel((LayoutManager)new BorderLayout());
        mWTabPanel2.addPanel("Adaption Parameters", (Component)mWPanel15);
        mWPanel15.add((Component)mWPanel27, "West");
        MWPanel mWPanel28 = new MWPanel((LayoutManager)new GridLayout(6, 0, 6, 1));
        mWPanel27.add((Component)mWPanel28, "North");
        this.adaptionParameterNames = new Vector();
        vector3 = new Vector();
        this.adaptParameterFields = new Vector();
        if (this.hasAdaptFcn) {
            NNTGUI.postEvent("getadaptparams", string, this.adaptionParameterNames, vector3);
            int n = this.adaptionParameterNames.size();
            int n6 = 0;
            while (n6 < n) {
                this.adaptParameterFields.addElement(null);
                ++n6;
            }
            int n7 = 0;
            while (n7 < 6) {
                int n8 = 0;
                while (n8 < 3) {
                    int n9 = n7 + n8 * 6;
                    if (n9 < n) {
                        object = new MWTextField((String)vector3.elementAt(n9), 8);
                        this.adaptParameterFields.setElementAt(object, n9);
                        mWPanel28.add((Component)new MWLabel((String)this.adaptionParameterNames.elementAt(n9)));
                        mWPanel28.add((Component)object);
                    } else {
                        mWPanel28.add((Component)new MWCanvas());
                        mWPanel28.add((Component)new MWCanvas());
                    }
                    ++n8;
                }
                ++n7;
            }
        }
        MWPanel mWPanel29 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel24.add((Component)mWPanel29, "South");
        MWPanel mWPanel30 = new MWPanel((LayoutManager)new FlowLayout(0, SPACING, SPACING));
        mWPanel29.add((Component)mWPanel30, "West");
        MWPanel mWPanel31 = new MWPanel((LayoutManager)new FlowLayout(2, SPACING, SPACING));
        mWPanel29.add((Component)mWPanel31, "East");
        this.adaptManagerButton = new MWButton("Manager");
        mWPanel30.add((Component)this.adaptManagerButton);
        this.adaptManagerButton.addActionListener((ActionListener)this);
        mWButton = new MWButton("Close");
        mWButton.addActionListener((ActionListener)closeButtonListener);
        mWPanel30.add((Component)mWButton);
        this.adaptButton = new MWButton("Adapt Network");
        mWPanel31.add((Component)this.adaptButton);
        this.adaptButton.addActionListener((ActionListener)this);
        this.adaptButton.setEnabled(this.hasAdaptFcn);
        MWPanel mWPanel32 = new MWPanel((LayoutManager)new BorderLayout());
        this.tabPanel.addPanel("Weights", (Component)mWPanel32);
        MWPanel mWPanel33 = new MWPanel((LayoutManager)new FlowLayout(0, SPACING, SPACING));
        mWPanel32.add((Component)mWPanel33, "North");
        this.weightsChoice = new MWChoice();
        object = new Vector();
        NNTGUI.postEvent("getweightnames", string, object);
        int n = 0;
        while (n < ((Vector)object).size()) {
            this.weightsChoice.add((String)((Vector)object).elementAt(n));
            ++n;
        }
        mWPanel33.add((Component)new MWLabel("Select the weight or bias to view: "));
        mWPanel33.add((Component)this.weightsChoice);
        this.weightsChoice.addItemListener((ItemListener)this);
        this.weightsTextArea = new MWTextArea();
        mWPanel32.add((Component)this.weightsTextArea, "Center");
        this.updateWeightValue();
        MWPanel mWPanel34 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel32.add((Component)mWPanel34, "South");
        MWPanel mWPanel35 = new MWPanel((LayoutManager)new FlowLayout(0, SPACING, SPACING));
        mWPanel34.add((Component)mWPanel35, "West");
        MWPanel mWPanel36 = new MWPanel((LayoutManager)new FlowLayout(2, SPACING, SPACING));
        mWPanel34.add((Component)mWPanel36, "East");
        this.weightsManagerButton = new MWButton("Manager");
        mWPanel35.add((Component)this.weightsManagerButton);
        this.weightsManagerButton.addActionListener((ActionListener)this);
        mWButton = new MWButton("Close");
        mWButton.addActionListener((ActionListener)closeButtonListener);
        mWPanel35.add((Component)mWButton);
        this.weightsRevertButton = new MWButton("Revert Weight");
        mWPanel36.add((Component)this.weightsRevertButton);
        this.weightsRevertButton.addActionListener((ActionListener)this);
        this.weightsSetButton = new MWButton(" Set Weight ");
        mWPanel36.add((Component)this.weightsSetButton);
        this.weightsSetButton.addActionListener((ActionListener)this);
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).addWindowListener(this);
        this.updateChoices();
        this.updateResultNames();
        this.tabPanel.selectPanel("View");
        mWTabPanel.selectPanel("Training Info");
        mWTabPanel2.selectPanel("Adaption Info");
        ((Component)((Object)this)).setVisible(true);
        this.toFront();
    }

    private void updateInputRanges() {
        Vector vector = new Vector();
        NNTGUI.postEvent("getinputranges", this.name, vector);
        this.rangesTextArea.setText((String)vector.elementAt(0));
    }

    protected void updateInputRangesChoice() {
        if (this.rangesChoice != null) {
            this.rangesChoice.removeAll();
            this.rangesChoice.add("Get from input:");
            int n = 0;
            while (n < this.manager.inputList.getItemCount()) {
                this.rangesChoice.add(this.manager.inputList.getItem(n));
                ++n;
            }
            this.rangesChoice.setEnabled(this.rangesChoice.getItemCount() > 1);
        }
    }

    private void updateWeightValue() {
        Vector vector = new Vector();
        NNTGUI.postEvent("getweightvalue", this.name, this.weightsChoice.getSelectedItem(), vector);
        this.weightsTextArea.setText((String)vector.elementAt(0));
    }

    private void updateResultNames() {
        this.simOutputsField.setText(String.valueOf(this.name) + "_outputs");
        this.simOutputsField.getView().setHScrollAmount(0);
        this.simFinalInputsField.setText(String.valueOf(this.name) + "_inputStates");
        this.simFinalInputsField.getView().setHScrollAmount(0);
        this.simFinalLayersField.setText(String.valueOf(this.name) + "_layerStates");
        this.simFinalLayersField.getView().setHScrollAmount(0);
        this.simErrorsField.setText(String.valueOf(this.name) + "_errors");
        this.simErrorsField.getView().setHScrollAmount(0);
        this.trainOutputsField.setText(String.valueOf(this.name) + "_outputs");
        this.trainOutputsField.getView().setHScrollAmount(0);
        this.trainFinalInputsField.setText(String.valueOf(this.name) + "_inputStates");
        this.trainFinalInputsField.getView().setHScrollAmount(0);
        this.trainFinalLayersField.setText(String.valueOf(this.name) + "_layerStates");
        this.trainFinalLayersField.getView().setHScrollAmount(0);
        this.trainErrorsField.setText(String.valueOf(this.name) + "_errors");
        this.trainErrorsField.getView().setHScrollAmount(0);
        this.adaptOutputsField.setText(String.valueOf(this.name) + "_outputs");
        this.adaptOutputsField.getView().setHScrollAmount(0);
        this.adaptFinalInputsField.setText(String.valueOf(this.name) + "_inputStates");
        this.adaptFinalInputsField.getView().setHScrollAmount(0);
        this.adaptFinalLayersField.setText(String.valueOf(this.name) + "_layerStates");
        this.adaptFinalLayersField.getView().setHScrollAmount(0);
        this.adaptErrorsField.setText(String.valueOf(this.name) + "_errors");
        this.adaptErrorsField.getView().setHScrollAmount(0);
    }

    private void updateValidation() {
        boolean bl = this.validationCheckbox.getState();
        this.validationInputsChoice.setEnabled(bl && this.hasInputs);
        this.validationInitInputStatesChoice.setEnabled(bl && this.hasInputDelays);
        this.validationInitLayerStatesChoice.setEnabled(bl && this.hasLayerDelays);
        this.validationTargetsChoice.setEnabled(bl && this.hasTargets);
    }

    private void updateTesting() {
        boolean bl = this.testCheckbox.getState();
        this.testInputsChoice.setEnabled(bl && this.hasInputs);
        this.testInitInputStatesChoice.setEnabled(bl && this.hasInputDelays);
        this.testInitLayerStatesChoice.setEnabled(bl && this.hasLayerDelays);
        this.testTargetsChoice.setEnabled(bl && this.hasTargets);
    }

    protected void updateChoices() {
        this.updateChoice(this.simInputsChoice, this.manager.inputList);
        this.updateChoice(this.simInitInputStatesChoice, this.manager.inputDelayList);
        this.updateChoice(this.simInitLayerStatesChoice, this.manager.layerDelayList);
        this.updateChoice(this.simTargetsChoice, this.manager.targetList);
        this.updateChoice(this.trainInputsChoice, this.manager.inputList);
        this.updateChoice(this.trainInitInputStatesChoice, this.manager.inputDelayList);
        this.updateChoice(this.trainInitLayerStatesChoice, this.manager.layerDelayList);
        this.updateChoice(this.trainTargetsChoice, this.manager.targetList);
        this.updateChoice(this.validationInputsChoice, this.manager.inputList);
        this.updateChoice(this.validationInitInputStatesChoice, this.manager.inputDelayList);
        this.updateChoice(this.validationInitLayerStatesChoice, this.manager.layerDelayList);
        this.updateChoice(this.validationTargetsChoice, this.manager.targetList);
        this.updateChoice(this.testInputsChoice, this.manager.inputList);
        this.updateChoice(this.testInitInputStatesChoice, this.manager.inputDelayList);
        this.updateChoice(this.testInitLayerStatesChoice, this.manager.layerDelayList);
        this.updateChoice(this.testTargetsChoice, this.manager.targetList);
        this.updateChoice(this.adaptInputsChoice, this.manager.inputList);
        this.updateChoice(this.adaptInitLayerStatesChoice, this.manager.layerDelayList);
        this.updateChoice(this.adaptTargetsChoice, this.manager.targetList);
        this.updateInputRangesChoice();
    }

    private void updateChoice(MWChoice mWChoice, MWListbox mWListbox) {
        String string = mWChoice.getSelectedItem();
        mWChoice.removeAll();
        mWChoice.add(zeroString);
        int n = mWListbox.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            mWChoice.add(mWListbox.getItem(n2));
            ++n2;
        }
        mWChoice.select(string);
    }

    private void setButtonEnables(boolean bl) {
        this.revertButton.setEnabled(bl);
        this.initButton.setEnabled(bl);
        this.simButton.setEnabled(bl);
        if (this.hasTrainFcn) {
            this.trainButton.setEnabled(bl);
        }
        if (this.hasAdaptFcn) {
            this.adaptButton.setEnabled(bl);
        }
    }

    private void updateSimTargets() {
        boolean bl = this.simTargetsCheckbox.getState();
        this.simTargetsChoice.setEnabled(bl);
        this.simErrorsField.setEnabled(bl);
    }

    private void goToManager() {
        this.manager.toFront();
        ((Component)((Object)this.manager)).requestFocus();
    }

    protected void close() {
        ((Component)((Object)this)).setVisible(false);
        this.manager.removeNetworkWindow(this);
        this.dispose();
    }

    private void revert() {
        this.setButtonEnables(false);
        this.updateInputRanges();
        NNTGUI.postEvent("revert", this.name);
        this.setButtonEnables(true);
    }

    private void initialize() {
        this.setButtonEnables(false);
        this.updateInputRanges();
        NNTGUI.postEvent("initialize", this.name);
        this.updateWeightValue();
        this.setButtonEnables(true);
    }

    private void simulate() {
        this.setButtonEnables(false);
        this.simTargetsCheckbox.getState();
        String string = this.simInputsChoice.isEnabled() ? this.simInputsChoice.getSelectedItem() : zeroString;
        String string2 = this.simInitInputStatesChoice.isEnabled() ? this.simInitInputStatesChoice.getSelectedItem() : zeroString;
        String string3 = this.simInitLayerStatesChoice.isEnabled() ? this.simInitLayerStatesChoice.getSelectedItem() : zeroString;
        String string4 = this.simTargetsChoice.isEnabled() ? this.simTargetsChoice.getSelectedItem() : zeroString;
        String string5 = this.simOutputsField.isEnabled() ? this.simOutputsField.getText() : "";
        String string6 = this.simFinalInputsField.isEnabled() ? this.simFinalInputsField.getText() : "";
        String string7 = this.simFinalLayersField.isEnabled() ? this.simFinalLayersField.getText() : "";
        String string8 = this.simErrorsField.isEnabled() ? this.simErrorsField.getText() : "";
        Vector vector = new Vector();
        NNTGUI.postEvent("simulate", this.name, string, string2, string3, string4, string5, string6, string7, string8, vector);
        if (vector.size() == 0) {
            if (string5.length() > 0) {
                this.manager.removeItem(string5);
                this.manager.outputList.addItem(string5);
            }
            if (string6.length() > 0) {
                this.manager.removeItem(string6);
                this.manager.inputDelayList.addItem(string6);
            }
            if (string7.length() > 0) {
                this.manager.removeItem(string7);
                this.manager.layerDelayList.addItem(string7);
            }
            if (string8.length() > 0) {
                this.manager.removeItem(string8);
                this.manager.errorList.addItem(string8);
            }
            this.manager.updateNetworkWindows();
        } else {
            String string9 = (String)vector.elementAt(0);
            new NNWarningDialog(this, string9);
        }
        this.setButtonEnables(true);
    }

    protected void train() {
        String string;
        Object object;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        this.setButtonEnables(false);
        String string11 = this.trainInputsChoice.isEnabled() ? this.trainInputsChoice.getSelectedItem() : zeroString;
        String string12 = this.trainInitInputStatesChoice.isEnabled() ? this.trainInitInputStatesChoice.getSelectedItem() : zeroString;
        String string13 = this.trainInitLayerStatesChoice.isEnabled() ? this.trainInitLayerStatesChoice.getSelectedItem() : zeroString;
        String string14 = this.trainTargetsChoice.isEnabled() ? this.trainTargetsChoice.getSelectedItem() : zeroString;
        String string15 = this.trainOutputsField.isEnabled() ? this.trainOutputsField.getText() : "";
        String string16 = this.trainFinalInputsField.isEnabled() ? this.trainFinalInputsField.getText() : "";
        String string17 = this.trainFinalLayersField.isEnabled() ? this.trainFinalLayersField.getText() : "";
        String string18 = string10 = this.trainErrorsField.isEnabled() ? this.trainErrorsField.getText() : "";
        if (this.validationCheckbox.getState()) {
            string9 = this.validationInputsChoice.getSelectedItem();
            string8 = this.validationInitInputStatesChoice.getSelectedItem();
            string7 = this.validationInitLayerStatesChoice.getSelectedItem();
            string6 = this.validationTargetsChoice.getSelectedItem();
        } else {
            string9 = "";
            string8 = "";
            string7 = "";
            string6 = "";
        }
        if (this.testCheckbox.getState()) {
            string5 = this.testInputsChoice.getSelectedItem();
            string4 = this.testInitInputStatesChoice.getSelectedItem();
            string3 = this.testInitLayerStatesChoice.getSelectedItem();
            string2 = this.testTargetsChoice.getSelectedItem();
        } else {
            string5 = "";
            string4 = "";
            string3 = "";
            string2 = "";
        }
        Vector<String> vector = new Vector<String>();
        int n = this.trainingParameterFields.size();
        int n2 = 0;
        while (n2 < n) {
            object = (String)this.trainingParameterNames.elementAt(n2);
            string = ((MWTextField)this.trainingParameterFields.elementAt(n2)).getText();
            Vector vector2 = new Vector();
            NNTGUI.postEvent("checkvalue", object, string, vector2);
            if (vector2.size() > 0) {
                new NNWarningDialog(this, "Training parameter '" + (String)object + "' does not have a legal value.");
                this.setButtonEnables(true);
                return;
            }
            vector.addElement(string);
            ++n2;
        }
        NNTGUI.postEvent("settrainparams", this.name, vector);
        object = new Vector();
        NNTGUI.postEvent("train", this.name, string11, string12, string13, string14, string15, string16, string17, string10, string9, string8, string7, string6, string5, string4, string3, string2, object);
        if (((Vector)object).size() == 0) {
            if (string15.length() > 0) {
                this.manager.removeItem(string15);
                this.manager.outputList.addItem(string15);
            }
            if (string16.length() > 0) {
                this.manager.removeItem(string16);
                this.manager.inputDelayList.addItem(string16);
            }
            if (string17.length() > 0) {
                this.manager.removeItem(string17);
                this.manager.layerDelayList.addItem(string17);
            }
            if (string10.length() > 0) {
                this.manager.removeItem(string10);
                this.manager.errorList.addItem(string10);
            }
            this.updateWeightValue();
            this.manager.updateNetworkWindows();
        } else {
            string = (String)((Vector)object).elementAt(0);
            new NNWarningDialog(this, string);
        }
        this.setButtonEnables(true);
    }

    private void adapt() {
        String string;
        Object object;
        this.setButtonEnables(false);
        String string2 = this.adaptInputsChoice.isEnabled() ? this.adaptInputsChoice.getSelectedItem() : zeroString;
        String string3 = this.adaptInitInputStatesChoice.isEnabled() ? this.adaptInitInputStatesChoice.getSelectedItem() : zeroString;
        String string4 = this.adaptInitLayerStatesChoice.isEnabled() ? this.adaptInitLayerStatesChoice.getSelectedItem() : zeroString;
        String string5 = this.adaptTargetsChoice.isEnabled() ? this.adaptTargetsChoice.getSelectedItem() : zeroString;
        String string6 = this.adaptOutputsField.isEnabled() ? this.adaptOutputsField.getText() : "";
        String string7 = this.adaptFinalInputsField.isEnabled() ? this.adaptFinalInputsField.getText() : "";
        String string8 = this.adaptFinalLayersField.isEnabled() ? this.adaptFinalLayersField.getText() : "";
        String string9 = this.adaptErrorsField.isEnabled() ? this.adaptErrorsField.getText() : "";
        Vector<String> vector = new Vector<String>();
        int n = this.adaptParameterFields.size();
        int n2 = 0;
        while (n2 < n) {
            object = (String)this.adaptionParameterNames.elementAt(n2);
            string = ((MWTextField)this.adaptParameterFields.elementAt(n2)).getText();
            Vector vector2 = new Vector();
            NNTGUI.postEvent("checkvalue", object, string, vector2);
            if (vector2.size() > 0) {
                new NNWarningDialog(this, "Adaption parameter '" + (String)object + "' does not have a legal value.");
                this.setButtonEnables(true);
                return;
            }
            vector.addElement(string);
            ++n2;
        }
        NNTGUI.postEvent("setadaptparams", this.name, vector);
        object = new Vector();
        NNTGUI.postEvent("adapt", this.name, string2, string3, string4, string5, string6, string7, string8, string9, object);
        if (((Vector)object).size() == 0) {
            if (string6.length() > 0) {
                this.manager.removeItem(string6);
                this.manager.outputList.addItem(string6);
            }
            if (string7.length() > 0) {
                this.manager.removeItem(string7);
                this.manager.inputDelayList.addItem(string7);
            }
            if (string8.length() > 0) {
                this.manager.removeItem(string8);
                this.manager.layerDelayList.addItem(string8);
            }
            if (string9.length() > 0) {
                this.manager.removeItem(string9);
                this.manager.errorList.addItem(string9);
            }
            this.manager.updateNetworkWindows();
            this.updateWeightValue();
        } else {
            string = (String)((Vector)object).elementAt(0);
            new NNWarningDialog(this, string);
        }
        this.setButtonEnables(true);
    }

    private void setWeightValue() {
        String string = this.weightsTextArea.getText();
        String string2 = this.weightsChoice.getSelectedItem();
        Vector vector = new Vector();
        NNTGUI.postEvent("checkweightvalue", this.name, string2, string, vector);
        if (vector.size() == 0) {
            NNTGUI.postEvent("setweightvalue", this.name, string2, string);
            this.updateWeightValue();
            return;
        }
        String string3 = (String)vector.elementAt(0);
        new NNWarningDialog(this, string3);
    }

    private void setInputRanges() {
        String string = this.rangesTextArea.getText();
        Vector vector = new Vector();
        NNTGUI.postEvent("checkinputranges", this.name, string, vector);
        if (vector.size() == 0) {
            NNTGUI.postEvent("setinputranges", this.name, string);
            this.updateInputRanges();
            return;
        }
        String string2 = (String)vector.elementAt(0);
        new NNWarningDialog(this, string2);
    }

    private void setRangesWithChoice() {
        String string = this.rangesChoice.getSelectedItem();
        Vector vector = new Vector();
        NNTGUI.postEvent("getdatarange", string, vector);
        String string2 = (String)vector.elementAt(0);
        vector = new Vector();
        NNTGUI.postEvent("checkinputranges", this.name, string2, vector);
        if (vector.size() == 0) {
            NNTGUI.postEvent("setinputranges", this.name, string2);
            this.updateInputRanges();
        } else {
            new NNWarningDialog(this, "That input you selected is incorrectly sized for this network.");
        }
        this.rangesChoice.select(0);
    }

    void setPanel(String string) {
        this.tabPanel.selectPanel(string);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.validationCheckbox) {
            this.updateValidation();
            return;
        }
        if (object == this.testCheckbox) {
            this.updateTesting();
            return;
        }
        if (object == this.simTargetsCheckbox) {
            this.updateSimTargets();
            return;
        }
        if (object == this.weightsChoice) {
            this.updateWeightValue();
            return;
        }
        if (object == this.rangesChoice) {
            this.setRangesWithChoice();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.revertButton) {
            this.revert();
            return;
        }
        if (object == this.initButton) {
            this.initialize();
            return;
        }
        if (object == this.simButton) {
            this.simulate();
            return;
        }
        if (object == this.trainButton) {
            new NNTrainThread(this).start();
            return;
        }
        if (object == this.adaptButton) {
            this.adapt();
            return;
        }
        if (object == this.weightsManagerButton) {
            this.goToManager();
            return;
        }
        if (object == this.weightsRevertButton) {
            this.updateWeightValue();
            return;
        }
        if (object == this.weightsSetButton) {
            this.setWeightValue();
            return;
        }
        if (object == this.rangesRevertButton) {
            this.updateInputRanges();
            return;
        }
        if (object == this.rangesSetButton) {
            this.setInputRanges();
            return;
        }
        if (object == this.viewManagerButton) {
            this.goToManager();
            return;
        }
        if (object == this.initManagerButton) {
            this.goToManager();
            return;
        }
        if (object == this.simManagerButton) {
            this.goToManager();
            return;
        }
        if (object == this.trainManagerButton) {
            this.goToManager();
            return;
        }
        if (object == this.adaptManagerButton) {
            this.goToManager();
        }
    }

    private class CloseButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            NNNetworkWindow.this.windowClosing(null);
        }

        CloseButtonListener() {
            NNNetworkWindow.this = NNNetworkWindow.this;
        }
    }
}

