/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.nnet;

import com.mathworks.toolbox.nnet.NNBlock;
import com.mathworks.toolbox.nnet.NetworkCanvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class NNNetInputFcn
extends NNBlock {
    String name;

    public NNNetInputFcn(NetworkCanvas networkCanvas, int n, int n2, String string) {
        super(networkCanvas, n, n2, 2, 2);
        this.name = string.toLowerCase();
    }

    void paint(Graphics graphics, int n) {
        int n2 = this.x * n;
        int n3 = this.y * n;
        int n4 = this.w * n;
        int n5 = this.h * n;
        int n6 = n2 + n4 / 2;
        int n7 = n3 + n5 / 2;
        graphics.setFont(new Font("monoco", 0, 9));
        graphics.setColor(Color.lightGray);
        graphics.fillOval(n2, n3, n4, n5);
        graphics.setColor(Color.black);
        graphics.drawOval(n2, n3, n4, n5);
        int n8 = 3;
        int n9 = n4 - 2 * n8;
        int n10 = n6 - n9 / 2;
        int n11 = n7 - n9 / 2;
        if (this.name.equals("netsum")) {
            NNNetInputFcn.paintNetSum(graphics, n10, n11, n9);
            return;
        }
        if (this.name.equals("netprod")) {
            NNNetInputFcn.paintNetProd(graphics, n10, n11, n9);
            return;
        }
        NNNetInputFcn.paintF(graphics, n10, n11, n9);
    }

    private static void paintNetSum(Graphics graphics, int n, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 + n3;
        int n6 = n + n3 / 2;
        int n7 = n2 + n3 / 2;
        graphics.setColor(Color.black);
        graphics.drawLine(n, n7, n4, n7);
        graphics.drawLine(n6, n2, n6, n5);
    }

    private static void paintNetProd(Graphics graphics, int n, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 + n3;
        graphics.setColor(Color.black);
        graphics.drawLine(n + n3 / 4, n2 + n3 / 4, n4 - n3 / 4, n5 - n3 / 4);
        graphics.drawLine(n + n3 / 4, n5 - n3 / 4, n4 - n3 / 4, n2 + n3 / 4);
    }

    private static void paintF(Graphics graphics, int n, int n2, int n3) {
        int n4 = n + n3 / 2;
        int n5 = n2 + n3 / 2;
        int n6 = graphics.getFontMetrics().stringWidth("F");
        int n7 = graphics.getFontMetrics().getHeight();
        graphics.setColor(Color.black);
        graphics.drawString("F", n4 - n6 / 2, n5 + n7 / 3);
    }
}

