/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.nnet;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.toolbox.nnet.BlankTile;
import com.mathworks.toolbox.nnet.NNCloseManagerDialog;
import com.mathworks.toolbox.nnet.NNDataWindow;
import com.mathworks.toolbox.nnet.NNExportDialog;
import com.mathworks.toolbox.nnet.NNImportDialog;
import com.mathworks.toolbox.nnet.NNMessageWindow;
import com.mathworks.toolbox.nnet.NNNetworkWindow;
import com.mathworks.toolbox.nnet.NNNewDataDialog;
import com.mathworks.toolbox.nnet.NNNewNetworkDialog;
import com.mathworks.toolbox.nnet.NNTGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

class NNManager
extends MWFrame
implements WindowListener,
ActionListener,
ItemListener {
    private static final int WINDOW_WIDTH = 440;
    private static final int WINDOW_HEIGHT = 440;
    private static final int SPACING = 6;
    protected static NNManager instance;
    protected WindowPanel windowPanel;
    protected MWListbox inputList;
    protected MWListbox targetList;
    protected MWListbox inputDelayList;
    protected MWListbox networkList;
    protected MWListbox outputList;
    protected MWListbox errorList;
    protected MWListbox layerDelayList;
    protected Vector lists;
    private MWButton helpButton;
    private MWButton newNetworkButton;
    private MWButton newDataButton;
    private MWButton importButton;
    private MWButton exportButton;
    private MWButton deleteButton;
    private MWButton viewButton;
    private MWButton initializeButton;
    private MWButton simulateButton;
    private MWButton trainButton;
    private MWButton adaptButton;
    private final Vector networkWindows = new Vector();
    private final Vector dataWindows = new Vector();
    private static NNNewNetworkDialog newNetworkDialog;
    private static NNNewDataDialog newDataDialog;
    private static NNMessageWindow managerHelpWindow;
    private static NNMessageWindow newDataHelpWindow;

    public NNManager() {
        instance = this;
        ((Frame)((Object)this)).setTitle("Network/Data Manager");
        ((Frame)((Object)this)).setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)((Object)this)).setBounds((dimension.width - 440) / 2, (dimension.height - 440) / 2, 440, 440);
        this.setLayout(new BorderLayout());
        this.windowPanel = new WindowPanel(this, new BorderLayout());
        ((Container)((Object)this)).add((Component)((Object)this.windowPanel), "Center");
        MWPanel mWPanel = new MWPanel((LayoutManager)new GridLayout(1, 3, 2, 2));
        ((Container)((Object)this.windowPanel)).add((Component)mWPanel, "Center");
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new GridLayout(3, 1, 2, 2));
        mWPanel.add((Component)mWPanel2);
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel2.add((Component)mWPanel3);
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel2.add((Component)mWPanel4);
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel2.add((Component)mWPanel5);
        MWPanel mWPanel6 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel.add((Component)mWPanel6);
        MWPanel mWPanel7 = new MWPanel((LayoutManager)new GridLayout(3, 1, 2, 2));
        mWPanel.add((Component)mWPanel7);
        MWPanel mWPanel8 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel7.add((Component)mWPanel8);
        MWPanel mWPanel9 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel7.add((Component)mWPanel9);
        MWPanel mWPanel10 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel7.add((Component)mWPanel10);
        MWPanel mWPanel11 = new MWPanel((LayoutManager)new BorderLayout());
        ((Container)((Object)this.windowPanel)).add((Component)mWPanel11, "South");
        MWGroupbox mWGroupbox = new MWGroupbox("Networks and Data");
        mWGroupbox.setLayout(new BorderLayout());
        mWPanel11.add((Component)mWGroupbox, "North");
        MWPanel mWPanel12 = new MWPanel((LayoutManager)new BorderLayout());
        mWGroupbox.add((Component)mWPanel12, "Center");
        MWPanel mWPanel13 = new MWPanel((LayoutManager)new FlowLayout(1, 6, 2));
        mWPanel12.add((Component)mWPanel13, "North");
        MWPanel mWPanel14 = new MWPanel((LayoutManager)new FlowLayout(1, 6, 2));
        mWPanel12.add((Component)mWPanel14, "South");
        MWGroupbox mWGroupbox2 = new MWGroupbox("Networks only");
        mWGroupbox2.setLayout(new BorderLayout());
        mWPanel11.add((Component)mWGroupbox2, "South");
        MWPanel mWPanel15 = new MWPanel((LayoutManager)new FlowLayout(1, 6, 2));
        mWGroupbox2.add((Component)mWPanel15, "Center");
        this.lists = new Vector();
        mWPanel3.add((Component)new MWLabel("Inputs:", 0), "North");
        this.inputList = new MWListbox();
        mWPanel3.add((Component)this.inputList, "Center");
        this.inputList.addActionListener((ActionListener)this);
        this.inputList.addItemListener((ItemListener)this);
        this.lists.addElement(this.inputList);
        mWPanel4.add((Component)new MWLabel("Targets:", 0), "North");
        this.targetList = new MWListbox();
        mWPanel4.add((Component)this.targetList, "Center");
        this.targetList.addActionListener((ActionListener)this);
        this.targetList.addItemListener((ItemListener)this);
        this.lists.addElement(this.targetList);
        mWPanel5.add((Component)new MWLabel("Input Delay States:", 0), "North");
        this.inputDelayList = new MWListbox();
        mWPanel5.add((Component)this.inputDelayList, "Center");
        this.inputDelayList.addActionListener((ActionListener)this);
        this.inputDelayList.addItemListener((ItemListener)this);
        this.lists.addElement(this.inputDelayList);
        mWPanel6.add((Component)new MWLabel("Networks:", 0), "North");
        this.networkList = new MWListbox();
        mWPanel6.add((Component)this.networkList, "Center");
        this.networkList.addActionListener((ActionListener)this);
        this.networkList.addItemListener((ItemListener)this);
        this.lists.addElement(this.networkList);
        mWPanel8.add((Component)new MWLabel("Outputs:", 0), "North");
        this.outputList = new MWListbox();
        mWPanel8.add((Component)this.outputList, "Center");
        this.outputList.addActionListener((ActionListener)this);
        this.outputList.addItemListener((ItemListener)this);
        this.lists.addElement(this.outputList);
        mWPanel9.add((Component)new MWLabel("Errors:", 0), "North");
        this.errorList = new MWListbox();
        mWPanel9.add((Component)this.errorList, "Center");
        this.errorList.addActionListener((ActionListener)this);
        this.errorList.addItemListener((ItemListener)this);
        this.lists.addElement(this.errorList);
        mWPanel10.add((Component)new MWLabel("Layer Delay States:", 0), "North");
        this.layerDelayList = new MWListbox();
        mWPanel10.add((Component)this.layerDelayList, "Center");
        this.layerDelayList.addActionListener((ActionListener)this);
        this.layerDelayList.addItemListener((ItemListener)this);
        this.lists.addElement(this.layerDelayList);
        this.helpButton = new MWButton("Help");
        mWPanel13.add((Component)this.helpButton);
        this.helpButton.addActionListener((ActionListener)this);
        this.newDataButton = new MWButton("New Data...");
        mWPanel13.add((Component)this.newDataButton);
        this.newDataButton.addActionListener((ActionListener)this);
        this.newNetworkButton = new MWButton("New Network...");
        mWPanel13.add((Component)this.newNetworkButton);
        this.newNetworkButton.addActionListener((ActionListener)this);
        mWPanel12.add((Component)((Object)new BlankTile(6, 6)), "Center");
        this.importButton = new MWButton("Import...");
        mWPanel14.add((Component)this.importButton);
        this.importButton.addActionListener((ActionListener)this);
        this.exportButton = new MWButton("Export...");
        mWPanel14.add((Component)this.exportButton);
        this.exportButton.addActionListener((ActionListener)this);
        this.viewButton = new MWButton("View");
        mWPanel14.add((Component)this.viewButton);
        this.viewButton.addActionListener((ActionListener)this);
        this.deleteButton = new MWButton("Delete");
        mWPanel14.add((Component)this.deleteButton);
        this.deleteButton.addActionListener((ActionListener)this);
        this.initializeButton = new MWButton("Initialize...");
        mWPanel15.add((Component)this.initializeButton);
        this.initializeButton.addActionListener((ActionListener)this);
        this.simulateButton = new MWButton("Simulate...");
        mWPanel15.add((Component)this.simulateButton);
        this.simulateButton.addActionListener((ActionListener)this);
        this.trainButton = new MWButton("Train...");
        mWPanel15.add((Component)this.trainButton);
        this.trainButton.addActionListener((ActionListener)this);
        this.adaptButton = new MWButton("Adapt...");
        mWPanel15.add((Component)this.adaptButton);
        this.adaptButton.addActionListener((ActionListener)this);
        ((Window)((Object)this)).addWindowListener(this);
        this.updateButtonEnables();
        newDataDialog = new NNNewDataDialog(this);
        newNetworkDialog = new NNNewNetworkDialog(this);
        ((Window)((Object)this)).addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)this)));
    }

    protected void hideAllWindows() {
        ((Component)((Object)managerHelpWindow)).setVisible(false);
        ((Component)((Object)newDataHelpWindow)).setVisible(false);
        while (this.networkWindows.size() > 0) {
            ((NNNetworkWindow)this.networkWindows.elementAt(0)).close();
        }
        while (this.networkWindows.size() > 0) {
            ((NNDataWindow)this.dataWindows.elementAt(0)).cancel();
        }
        if (((Component)((Object)newDataDialog)).isVisible()) {
            newDataDialog.cancel();
        }
        if (((Component)((Object)newNetworkDialog)).isVisible()) {
            newNetworkDialog.cancel();
        }
    }

    protected void launchManagerHelpWindow() {
        managerHelpWindow.launch();
    }

    protected void launchNewDataHelpWindow() {
        newDataHelpWindow.launch();
    }

    protected void addNetworkWindow(NNNetworkWindow nNNetworkWindow) {
        this.networkWindows.addElement(nNNetworkWindow);
    }

    protected void removeNetworkWindow(NNNetworkWindow nNNetworkWindow) {
        this.networkWindows.removeElement(nNNetworkWindow);
    }

    protected NNNetworkWindow getNetworkWindow(String string) {
        int n = this.networkWindows.size();
        int n2 = 0;
        while (n2 < n) {
            NNNetworkWindow nNNetworkWindow = (NNNetworkWindow)this.networkWindows.elementAt(n2);
            if (nNNetworkWindow.name.equals(string)) {
                return nNNetworkWindow;
            }
            ++n2;
        }
        return null;
    }

    protected void updateNetworkWindows() {
        int n = this.networkWindows.size();
        int n2 = 0;
        while (n2 < n) {
            NNNetworkWindow nNNetworkWindow = (NNNetworkWindow)this.networkWindows.elementAt(n2);
            nNNetworkWindow.updateChoices();
            ++n2;
        }
        if (newNetworkDialog != null) {
            newNetworkDialog.updateChoices();
        }
    }

    protected void addDataWindow(NNDataWindow nNDataWindow) {
        this.dataWindows.addElement(nNDataWindow);
    }

    protected void removeDataWindow(NNDataWindow nNDataWindow) {
        this.dataWindows.removeElement(nNDataWindow);
    }

    protected NNDataWindow getDataWindow(String string) {
        int n = this.dataWindows.size();
        int n2 = 0;
        while (n2 < n) {
            NNDataWindow nNDataWindow = (NNDataWindow)this.dataWindows.elementAt(n2);
            if (nNDataWindow.name.equals(string)) {
                return nNDataWindow;
            }
            ++n2;
        }
        return null;
    }

    protected void launch() {
        WindowRegistry.getRegistry().register((MWWindowOwner)this.windowPanel);
        ((Component)((Object)this)).setVisible(true);
        this.toFront();
    }

    protected void close() {
        if (!((Component)((Object)this)).isVisible()) {
            return;
        }
        if (this.getItemCount() == 0) {
            WindowRegistry.getRegistry().unregister((MWWindowOwner)this.windowPanel);
            ((Component)((Object)this)).setVisible(false);
            return;
        }
        Toolkit.getDefaultToolkit().beep();
        NNCloseManagerDialog nNCloseManagerDialog = new NNCloseManagerDialog(this);
        if (nNCloseManagerDialog.ok) {
            this.hideAllWindows();
            WindowRegistry.getRegistry().unregister((MWWindowOwner)this.windowPanel);
            ((Component)((Object)this)).setVisible(false);
        }
    }

    private void newNetwork() {
        newNetworkDialog.launch();
    }

    protected synchronized void addNameToNetworkList(String string) {
        this.removeItem(string);
        this.networkList.addItem(string);
    }

    private void newData() {
        newDataDialog.launch();
    }

    protected void addNameToDataList(int n, String string, String string2) {
        this.removeItem(string);
        switch (n) {
            case 1: {
                this.inputList.addItem(string);
                NNTGUI.postEvent("newinput", string, string2);
                break;
            }
            case 2: {
                this.targetList.addItem(string);
                NNTGUI.postEvent("newtarget", string, string2);
                break;
            }
            case 3: {
                this.inputDelayList.addItem(string);
                NNTGUI.postEvent("newinputstate", string, string2);
                break;
            }
            case 4: {
                this.layerDelayList.addItem(string);
                NNTGUI.postEvent("newlayerstate", string, string2);
                break;
            }
            case 5: {
                this.outputList.addItem(string);
                NNTGUI.postEvent("newoutput", string, string2);
                break;
            }
            default: {
                this.errorList.addItem(string);
                NNTGUI.postEvent("newerror", string, string2);
            }
        }
        this.updateNetworkWindows();
    }

    private void doImport() {
        NNImportDialog nNImportDialog = new NNImportDialog(this);
        if (nNImportDialog.imported) {
            String string = nNImportDialog.returnName;
            String string2 = nNImportDialog.returnVariable;
            this.removeItem(string);
            switch (nNImportDialog.returnType) {
                case 0: {
                    this.networkList.addItem(string);
                    NNTGUI.postEvent("importnet", string, string2);
                    break;
                }
                case 1: {
                    this.inputList.addItem(string);
                    NNTGUI.postEvent("importinput", string, string2);
                    break;
                }
                case 2: {
                    this.targetList.addItem(string);
                    NNTGUI.postEvent("importtarget", string, string2);
                    break;
                }
                case 3: {
                    this.inputDelayList.addItem(string);
                    NNTGUI.postEvent("importinputstate", string, string2);
                    break;
                }
                case 4: {
                    this.layerDelayList.addItem(string);
                    NNTGUI.postEvent("importlayerstate", string, string2);
                    break;
                }
                case 5: {
                    this.outputList.addItem(string);
                    NNTGUI.postEvent("importoutput", string, string2);
                    break;
                }
                default: {
                    this.errorList.addItem(string);
                    NNTGUI.postEvent("importerror", string, string2);
                    break;
                }
            }
        } else if (nNImportDialog.loaded) {
            String string = nNImportDialog.returnName;
            String string3 = nNImportDialog.returnVariable;
            String string4 = nNImportDialog.returnPath;
            this.removeItem(string);
            switch (nNImportDialog.returnType) {
                case 0: {
                    this.networkList.addItem(string);
                    NNTGUI.postEvent("loadnet", string, string3, string4);
                    break;
                }
                case 1: {
                    this.inputList.addItem(string);
                    NNTGUI.postEvent("loadinput", string, string3, string4);
                    break;
                }
                case 2: {
                    this.targetList.addItem(string);
                    NNTGUI.postEvent("loadtarget", string, string3, string4);
                    break;
                }
                case 3: {
                    this.inputDelayList.addItem(string);
                    NNTGUI.postEvent("loadinputstate", string, string3, string4);
                    break;
                }
                case 4: {
                    this.layerDelayList.addItem(string);
                    NNTGUI.postEvent("loadlayerstate", string, string3, string4);
                    break;
                }
                case 5: {
                    this.outputList.addItem(string);
                    NNTGUI.postEvent("loadoutput", string, string3, string4);
                    break;
                }
                default: {
                    this.errorList.addItem(string);
                    NNTGUI.postEvent("loaderror", string, string3, string4);
                    break;
                }
            }
        }
        this.updateNetworkWindows();
    }

    private void itemSelected(MWListbox mWListbox) {
        int n = this.lists.size();
        int n2 = 0;
        while (n2 < n) {
            MWListbox mWListbox2 = (MWListbox)this.lists.elementAt(n2);
            if (mWListbox2 != mWListbox) {
                mWListbox2.setSelectedIndexes(new int[0]);
            }
            ++n2;
        }
    }

    private void delete() {
        int n = 0;
        while (n < 7) {
            MWListbox mWListbox = (MWListbox)this.lists.elementAt(n);
            int n2 = mWListbox.getSelectedIndex();
            if (n2 >= 0) {
                NNDataWindow nNDataWindow;
                String string = mWListbox.getItem(n2);
                mWListbox.removeItem(n2);
                mWListbox.setSelectedIndexes(new int[0]);
                NNNetworkWindow nNNetworkWindow = this.getNetworkWindow(string);
                if (nNNetworkWindow != null) {
                    nNNetworkWindow.close();
                }
                if ((nNDataWindow = this.getDataWindow(string)) != null) {
                    nNDataWindow.cancel();
                }
                NNTGUI.postEvent("delete", string);
                this.selectNearestItem(mWListbox, n, n2);
                this.updateNetworkWindows();
                return;
            }
            ++n;
        }
    }

    private void selectNearestItem(MWListbox mWListbox, int n, int n2) {
        if (mWListbox.getItemCount() > n2) {
            mWListbox.setSelectedIndex(n2);
            return;
        }
        if (mWListbox.getItemCount() > 0) {
            mWListbox.setSelectedIndex(mWListbox.getItemCount() - 1);
            return;
        }
        int n3 = n + 1;
        while (n3 < 7) {
            mWListbox = (MWListbox)this.lists.elementAt(n3);
            if (mWListbox.getItemCount() > 0) {
                mWListbox.setSelectedIndex(0);
                return;
            }
            ++n3;
        }
        int n4 = n - 1;
        while (n4 >= 0) {
            mWListbox = (MWListbox)this.lists.elementAt(n4);
            if (mWListbox.getItemCount() > 0) {
                mWListbox.setSelectedIndex(mWListbox.getItemCount() - 1);
                return;
            }
            --n4;
        }
    }

    private void openNetwork() {
        int n = 0;
        while (n < 7) {
            MWListbox mWListbox = (MWListbox)this.lists.elementAt(n);
            int n2 = mWListbox.getSelectedIndex();
            if (n2 > 0) {
                MWFrame mWFrame;
                String string = mWListbox.getItem(n2);
                if (n == 3) {
                    mWFrame = this.getNetworkWindow(string);
                    if (mWFrame == null) {
                        mWFrame = new NNNetworkWindow(this, string);
                    }
                    mWFrame.toFront();
                    mWFrame.requestFocus();
                } else {
                    mWFrame = this.getDataWindow(string);
                    if (mWFrame == null) {
                        mWFrame = new NNDataWindow(this, string);
                    }
                    mWFrame.toFront();
                    mWFrame.requestFocus();
                }
            }
            ++n;
        }
    }

    private void view() {
        int n = 0;
        while (n < 7) {
            MWListbox mWListbox = (MWListbox)this.lists.elementAt(n);
            int n2 = mWListbox.getSelectedIndex();
            if (n2 >= 0) {
                MWFrame mWFrame;
                String string = mWListbox.getItem(n2);
                if (mWListbox == this.networkList) {
                    mWFrame = this.getNetworkWindow(string);
                    if (mWFrame == null) {
                        mWFrame = new NNNetworkWindow(this, string);
                    }
                    mWFrame.setPanel("View");
                    mWFrame.toFront();
                    mWFrame.requestFocus();
                } else {
                    mWFrame = this.getDataWindow(string);
                    if (mWFrame == null) {
                        mWFrame = new NNDataWindow(this, string);
                    }
                    mWFrame.toFront();
                    mWFrame.requestFocus();
                }
            }
            ++n;
        }
    }

    private void initialize() {
        int n = this.networkList.getSelectedIndex();
        if (n >= 0) {
            String string = this.networkList.getSelectedItem();
            NNNetworkWindow nNNetworkWindow = this.getNetworkWindow(string);
            if (nNNetworkWindow == null) {
                nNNetworkWindow = new NNNetworkWindow(this, string);
            }
            nNNetworkWindow.setPanel("Initialize");
            nNNetworkWindow.toFront();
            ((Component)((Object)nNNetworkWindow)).requestFocus();
        }
    }

    private void simulate() {
        int n = this.networkList.getSelectedIndex();
        if (n >= 0) {
            String string = this.networkList.getSelectedItem();
            NNNetworkWindow nNNetworkWindow = this.getNetworkWindow(string);
            if (nNNetworkWindow == null) {
                nNNetworkWindow = new NNNetworkWindow(this, string);
            }
            nNNetworkWindow.setPanel("Simulate");
            nNNetworkWindow.toFront();
            ((Component)((Object)nNNetworkWindow)).requestFocus();
        }
    }

    private void train() {
        int n = this.networkList.getSelectedIndex();
        if (n >= 0) {
            String string = this.networkList.getSelectedItem();
            NNNetworkWindow nNNetworkWindow = this.getNetworkWindow(string);
            if (nNNetworkWindow == null) {
                nNNetworkWindow = new NNNetworkWindow(this, string);
            }
            nNNetworkWindow.setPanel("Train");
            nNNetworkWindow.toFront();
            ((Component)((Object)nNNetworkWindow)).requestFocus();
        }
    }

    private void adapt() {
        int n = this.networkList.getSelectedIndex();
        if (n >= 0) {
            String string = this.networkList.getSelectedItem();
            NNNetworkWindow nNNetworkWindow = this.getNetworkWindow(string);
            if (nNNetworkWindow == null) {
                nNNetworkWindow = new NNNetworkWindow(this, string);
            }
            nNNetworkWindow.setPanel("Adapt");
            nNNetworkWindow.toFront();
            ((Component)((Object)nNNetworkWindow)).requestFocus();
        }
    }

    private void export() {
        NNExportDialog nNExportDialog = new NNExportDialog(this);
        if (nNExportDialog.saved) {
            String[] stringArray = nNExportDialog.returnVariables;
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
            NNTGUI.postEvent("save", nNExportDialog.returnPath, vector);
            return;
        }
        if (nNExportDialog.exported) {
            String[] stringArray = nNExportDialog.returnVariables;
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
            NNTGUI.postEvent("export", vector);
        }
    }

    protected boolean nameIsUsed(String string) {
        if (NNManager.locate(this.networkList, string) >= 0) {
            return true;
        }
        if (NNManager.locate(this.inputList, string) >= 0) {
            return true;
        }
        if (NNManager.locate(this.targetList, string) >= 0) {
            return true;
        }
        if (NNManager.locate(this.inputDelayList, string) >= 0) {
            return true;
        }
        if (NNManager.locate(this.outputList, string) >= 0) {
            return true;
        }
        if (NNManager.locate(this.errorList, string) >= 0) {
            return true;
        }
        return NNManager.locate(this.layerDelayList, string) >= 0;
    }

    protected String newName(String string) {
        int n = 1;
        String string2;
        while (this.nameIsUsed(string2 = String.valueOf(string) + n)) {
            ++n;
        }
        return string2;
    }

    protected void removeItem(String string) {
        NNManager.removeItem(this.networkList, string);
        NNManager.removeItem(this.inputList, string);
        NNManager.removeItem(this.targetList, string);
        NNManager.removeItem(this.inputDelayList, string);
        NNManager.removeItem(this.outputList, string);
        NNManager.removeItem(this.errorList, string);
        NNManager.removeItem(this.layerDelayList, string);
        this.updateButtonEnables();
    }

    protected int getItemCount() {
        int n = 0;
        n += this.networkList.getItemCount();
        n += this.inputList.getItemCount();
        n += this.targetList.getItemCount();
        n += this.inputDelayList.getItemCount();
        n += this.outputList.getItemCount();
        n += this.errorList.getItemCount();
        return n += this.layerDelayList.getItemCount();
    }

    private void updateButtonEnables() {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < 7) {
            MWListbox mWListbox = (MWListbox)this.lists.elementAt(n);
            if (mWListbox.getSelectedIndex() >= 0) {
                bl = true;
                bl2 = n == 3;
                break;
            }
            ++n;
        }
        this.viewButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
        this.initializeButton.setEnabled(bl2);
        this.simulateButton.setEnabled(bl2);
        this.trainButton.setEnabled(bl2);
        this.adaptButton.setEnabled(bl2);
    }

    private static void removeItem(MWListbox mWListbox, String string) {
        if (NNManager.locate(mWListbox, string) >= 0) {
            mWListbox.removeItem(string);
        }
    }

    private static int locate(MWListbox mWListbox, String string) {
        int n = mWListbox.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (mWListbox.getItem(n2).equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof MWListbox && itemEvent.getStateChange() == 1) {
            this.itemSelected((MWListbox)object);
        }
        this.updateButtonEnables();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.helpButton) {
            this.launchManagerHelpWindow();
        } else if (object == this.newNetworkButton) {
            this.newNetwork();
        } else if (object == this.newDataButton) {
            this.newData();
        } else if (object == this.deleteButton) {
            this.delete();
        } else if (object == this.networkList) {
            this.openNetwork();
        } else if (object == this.inputList) {
            this.openNetwork();
        } else if (object == this.targetList) {
            this.openNetwork();
        } else if (object == this.inputDelayList) {
            this.openNetwork();
        } else if (object == this.layerDelayList) {
            this.openNetwork();
        } else if (object == this.outputList) {
            this.openNetwork();
        } else if (object == this.errorList) {
            this.openNetwork();
        } else if (object == this.viewButton) {
            this.view();
        } else if (object == this.initializeButton) {
            this.initialize();
        } else if (object == this.simulateButton) {
            this.simulate();
        } else if (object == this.trainButton) {
            this.train();
        } else if (object == this.adaptButton) {
            this.adapt();
        } else if (object == this.importButton) {
            this.doImport();
        } else if (object == this.exportButton) {
            this.export();
        }
        this.updateButtonEnables();
    }

    static {
        newNetworkDialog = null;
        newDataDialog = null;
        managerHelpWindow = new NNMessageWindow("Network/Data Manager Help", " \n  To get started on a new problem do the following:\n  \n  1. Create new Input and Target data with [NEW DATA] or import data\n      from the workspace or a file with [IMPORT].\n  2. Create a new Network with [NEW NETWORK] or import a network\n      from the workspace or a file with [IMPORT].\n  3. Select the network in the Network list and click [TRAIN...] to open\n      the network's window to the training tab.\n  4. You can use the network's window to train the network, simulate it, or\n      perform other tasks such as initialization or editing weights.\n  \n  Here are descriptions of each button:\n  \n  [HELP] - Opens this window.\n  [NEW DATA...] - Allows you to type in data.\n  [NEW NETWORK...] - Allows you to create a new network.\n  [IMPORT] - Imports data and networks from the workspace or a file.\n  [EXPORT] - Exports data and networks to the workspace or a file.\n  [VIEW] - Opens the selected data or network for viewing and editing.\n  [DELETE] - Removes the selected data or network.\n  [INITIALIZE] - Opens the selected network for initialization.\n  [TRAIN] - Opens the selected network for training.\n  [ADAPT] - Opens the selected network for adaptive training.\n  \n  Here are descriptions of each list:\n  \n  Networks - List of networks.\n  Inputs - Data to present to a network.\n  Targets - Data defining the desired network outputs.\n  Outputs - Response of a nework to its inputs.\n  Errors - Difference between targets and outputs.\n  Input Delays - Input delay states for networks with input delays.\n  Layer Delays - Layer delay states for networks with layer delays.\n  \n  See the Neural Network Toolbox user's guide for more information.");
        newDataHelpWindow = new NNMessageWindow("Create New Data Help", "  \n  There are six kinds of data.  Most of the time you will only\n  need to create Inputs and Targets to train a network.\n  \n  Inputs - Data to be presented to a network.\n  Targets - Data defining the desired network outputs.\n  Outputs - Response of a nework to its inputs.\n  Errors - Difference between targets and outputs.\n  Input Delays - Input delay states for networks with input delays.\n  Layer Delays - Layer delay states for networks with layer delays.\n  \n  To define a set of four two-element vectors use a matrix with four\n  columns and two rows.  Here is an example:\n  \n  [0 1 4 2; -1 2 -1 0]\n  \n  For some networks, data needs to be arranged in a sequence.  The\n  following example shows how to represent a three time step sequence\n  of two-element vectors using a cell array.\n  \n  {[-1;1] [0;2] [0.5;-3]}\n  \n  See the Neural Network Toolbox user's guide for more information.");
    }

    protected class WindowPanel
    extends MWPanel
    implements MWWindowOwner {
        NNManager manager;

        WindowPanel(NNManager nNManager2, LayoutManager layoutManager) {
            super(layoutManager);
            NNManager.this = NNManager.this;
            this.manager = nNManager2;
        }

        public int closeWindow() {
            this.manager.close();
            if (((Component)((Object)this.manager)).isVisible()) {
                return 1;
            }
            return 0;
        }

        public String getLongName() {
            return ((Frame)((Object)this.manager)).getTitle();
        }

        public String getShortName() {
            return ((Frame)((Object)this.manager)).getTitle();
        }

        public void setActive(boolean bl) {
        }
    }
}

