/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.nnet;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWExclusiveGroupItem;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.dialog.MWDialog;
import com.mathworks.mwt.dialog.MWFileDialog;
import com.mathworks.toolbox.nnet.NNTGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;

class NNImportDialog
extends MWDialog
implements WindowListener,
ItemListener,
ActionListener {
    private static final int WINDOW_WIDTH = 520;
    private static final int SPACING = 6;
    private static final int TEXT_COLUMNS = 16;
    private final MWFrame owner;
    private final MWButton cancelButton;
    private final MWButton importButton;
    private final MWExclusiveGroup sourceCheckboxGroup;
    private final MWCheckbox workspaceCheckbox;
    private final MWCheckbox diskCheckbox;
    private final MWLabel diskLabel;
    private final MWTextField diskField;
    private final MWButton browseButton;
    private final MWListbox variableList;
    private final MWTextField nameField;
    private final MWExclusiveGroup kindCheckboxGroup;
    private final MWCheckbox networkCheckbox;
    private final MWCheckbox inputsCheckbox;
    private final MWCheckbox targetsCheckbox;
    private final MWCheckbox inputDelaysCheckbox;
    private final MWCheckbox layerDelaysCheckbox;
    private final MWCheckbox outputsCheckbox;
    private final MWCheckbox errorsCheckbox;
    protected boolean imported = false;
    protected boolean loaded = false;
    protected int returnType;
    protected String returnName;
    protected String returnVariable;
    protected String returnPath;

    protected NNImportDialog(MWFrame mWFrame) {
        super((Frame)mWFrame, true);
        this.owner = mWFrame;
        ((Dialog)((Object)this)).setTitle("Import or Load to Network/Data Manager");
        ((Dialog)((Object)this)).setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)((Object)this)).setBounds((dimension.width - 520) / 2, 30, 520, 0);
        this.setLayout(new BorderLayout());
        MWPanel mWPanel = new MWPanel((LayoutManager)new GridLayout(1, 3, 2, 2));
        ((Container)((Object)this)).add((Component)mWPanel, "Center");
        MWGroupbox mWGroupbox = new MWGroupbox("Source");
        mWGroupbox.setLayout(new BorderLayout());
        mWPanel.add((Component)mWGroupbox);
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new BorderLayout());
        mWGroupbox.add((Component)mWPanel2, "Center");
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new GridLayout(5, 1, 2, 2));
        mWPanel2.add((Component)mWPanel3, "North");
        this.sourceCheckboxGroup = new MWExclusiveGroup();
        this.workspaceCheckbox = new MWCheckbox("Import from MATLAB workspace", this.sourceCheckboxGroup, true);
        mWPanel3.add((Component)this.workspaceCheckbox);
        this.workspaceCheckbox.addItemListener((ItemListener)this);
        this.diskCheckbox = new MWCheckbox("Load from disk file", this.sourceCheckboxGroup, false);
        mWPanel3.add((Component)this.diskCheckbox);
        this.diskCheckbox.addItemListener((ItemListener)this);
        this.diskLabel = new MWLabel("MAT-file Name");
        mWPanel3.add((Component)this.diskLabel);
        this.diskLabel.setEnabled(false);
        this.diskField = new MWTextField("", 16);
        mWPanel3.add((Component)this.diskField);
        this.diskField.setEnabled(false);
        this.diskField.addActionListener((ActionListener)this);
        this.browseButton = new MWButton("Browse");
        mWPanel3.add((Component)this.browseButton);
        this.browseButton.addActionListener((ActionListener)this);
        this.browseButton.setEnabled(false);
        MWGroupbox mWGroupbox2 = new MWGroupbox("Select a Variable");
        mWGroupbox2.setLayout(new BorderLayout());
        mWPanel.add((Component)mWGroupbox2);
        this.variableList = new MWListbox();
        mWGroupbox2.add((Component)this.variableList, "Center");
        this.variableList.addItemListener((ItemListener)this);
        MWGroupbox mWGroupbox3 = new MWGroupbox("Destination");
        mWGroupbox3.setLayout(new BorderLayout());
        mWPanel.add((Component)mWGroupbox3);
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new BorderLayout());
        mWGroupbox3.add((Component)mWPanel4, "Center");
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new GridLayout(10, 1, 2, 2));
        mWPanel4.add((Component)mWPanel5, "North");
        MWLabel mWLabel = new MWLabel("Name");
        mWPanel5.add((Component)mWLabel);
        this.nameField = new MWTextField("", 16);
        mWPanel5.add((Component)this.nameField);
        this.nameField.addActionListener((ActionListener)this);
        MWLabel mWLabel2 = new MWLabel("Import As:");
        mWPanel5.add((Component)mWLabel2);
        this.kindCheckboxGroup = new MWExclusiveGroup();
        this.networkCheckbox = new MWCheckbox("Network", this.kindCheckboxGroup, true);
        mWPanel5.add((Component)this.networkCheckbox);
        this.inputsCheckbox = new MWCheckbox("Inputs", this.kindCheckboxGroup, false);
        mWPanel5.add((Component)this.inputsCheckbox);
        this.targetsCheckbox = new MWCheckbox("Targets", this.kindCheckboxGroup, false);
        mWPanel5.add((Component)this.targetsCheckbox);
        this.inputDelaysCheckbox = new MWCheckbox("Initial Input States", this.kindCheckboxGroup, false);
        mWPanel5.add((Component)this.inputDelaysCheckbox);
        this.layerDelaysCheckbox = new MWCheckbox("Initial Layer States", this.kindCheckboxGroup, false);
        mWPanel5.add((Component)this.layerDelaysCheckbox);
        this.outputsCheckbox = new MWCheckbox("Outputs", this.kindCheckboxGroup, false);
        mWPanel5.add((Component)this.outputsCheckbox);
        this.errorsCheckbox = new MWCheckbox("Errors", this.kindCheckboxGroup, false);
        mWPanel5.add((Component)this.errorsCheckbox);
        MWPanel mWPanel6 = new MWPanel((LayoutManager)new FlowLayout(2, 6, 6));
        ((Container)((Object)this)).add((Component)mWPanel6, "South");
        this.cancelButton = new MWButton("Cancel");
        mWPanel6.add((Component)this.cancelButton);
        this.cancelButton.addActionListener((ActionListener)this);
        this.importButton = new MWButton("Import");
        mWPanel6.add((Component)this.importButton);
        this.importButton.addActionListener((ActionListener)this);
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).addWindowListener(this);
        this.openWorkspace();
        this.updateImportButton();
        ((Dialog)((Object)this)).show();
    }

    private void updateImportButton() {
        boolean bl;
        if (this.variableList.getSelectedIndex() == 0) {
            this.networkCheckbox.setEnabled(false);
            this.inputsCheckbox.setEnabled(false);
            this.targetsCheckbox.setEnabled(false);
            this.inputDelaysCheckbox.setEnabled(false);
            this.layerDelaysCheckbox.setEnabled(false);
            this.outputsCheckbox.setEnabled(false);
            this.errorsCheckbox.setEnabled(false);
            this.importButton.setEnabled(false);
            return;
        }
        Vector vector = new Vector();
        if (this.workspaceCheckbox.getState()) {
            NNTGUI.postEvent("getwsvartype", this.variableList.getSelectedItem(), vector);
        } else {
            NNTGUI.postEvent("getfilevartype", this.diskField.getText(), this.variableList.getSelectedItem(), vector);
        }
        String string = (String)vector.elementAt(0);
        boolean bl2 = bl = this.nameField.getText().length() > 0;
        if (string.equals("NETWORK")) {
            this.networkCheckbox.setEnabled(true);
            this.inputsCheckbox.setEnabled(false);
            this.targetsCheckbox.setEnabled(false);
            this.inputDelaysCheckbox.setEnabled(false);
            this.layerDelaysCheckbox.setEnabled(false);
            this.outputsCheckbox.setEnabled(false);
            this.errorsCheckbox.setEnabled(false);
            this.networkCheckbox.setState(true);
            this.importButton.setEnabled(bl);
            return;
        }
        if (string.equals("DATA")) {
            this.networkCheckbox.setEnabled(false);
            this.inputsCheckbox.setEnabled(true);
            this.targetsCheckbox.setEnabled(true);
            this.inputDelaysCheckbox.setEnabled(true);
            this.layerDelaysCheckbox.setEnabled(true);
            this.outputsCheckbox.setEnabled(true);
            this.errorsCheckbox.setEnabled(true);
            if (this.networkCheckbox.getState()) {
                this.inputsCheckbox.setState(true);
            }
            this.importButton.setEnabled(bl);
            return;
        }
        this.networkCheckbox.setEnabled(false);
        this.inputsCheckbox.setEnabled(false);
        this.targetsCheckbox.setEnabled(false);
        this.inputDelaysCheckbox.setEnabled(false);
        this.layerDelaysCheckbox.setEnabled(false);
        this.outputsCheckbox.setEnabled(false);
        this.errorsCheckbox.setEnabled(false);
        this.importButton.setEnabled(false);
    }

    private synchronized void updateSource() {
        if (this.sourceCheckboxGroup.getSelectedItem() == this.workspaceCheckbox) {
            this.openWorkspace();
            return;
        }
        this.openFile();
    }

    private void updateName() {
        if (this.variableList.getSelectedIndex() != 0) {
            this.nameField.setText(this.variableList.getSelectedItem());
            return;
        }
        this.nameField.setText("");
    }

    private void openWorkspace() {
        this.variableList.removeItemListener((ItemListener)this);
        this.diskLabel.setEnabled(false);
        this.diskField.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.variableList.removeAllItems();
        Vector vector = new Vector();
        NNTGUI.postEvent("getwsvars", vector);
        int n = vector.size();
        if (n == 0) {
            this.variableList.addItem("(no variables exist)");
        } else {
            this.variableList.addItem("(no selection)");
        }
        int n2 = 0;
        while (n2 < n) {
            this.variableList.addItem((String)vector.elementAt(n2));
            ++n2;
        }
        this.variableList.setSelectedIndex(0);
        this.variableList.addItemListener((ItemListener)this);
        this.importButton.setLabel("Import");
    }

    private void openFile() {
        this.variableList.removeItemListener((ItemListener)this);
        this.diskLabel.setEnabled(true);
        this.diskField.setEnabled(true);
        this.browseButton.setEnabled(true);
        this.variableList.removeAllItems();
        String string = this.diskField.getText();
        File file = new File(string);
        if (file.exists()) {
            Vector vector = new Vector();
            NNTGUI.postEvent("getfilevars", string, vector);
            int n = vector.size();
            if (n == 0) {
                this.variableList.addItem("(no variables exist)");
            } else {
                this.variableList.addItem("(no selection)");
            }
            int n2 = 0;
            while (n2 < n) {
                this.variableList.addItem((String)vector.elementAt(n2));
                ++n2;
            }
        } else {
            this.variableList.addItem("(no such file)");
        }
        this.variableList.setSelectedIndex(0);
        this.variableList.addItemListener((ItemListener)this);
        this.importButton.setLabel("Load");
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void doImport() {
        if (this.sourceCheckboxGroup.getSelectedItem() == this.workspaceCheckbox) {
            this.imported = true;
            this.returnName = this.nameField.getText();
            this.returnVariable = this.variableList.getSelectedItem();
            MWExclusiveGroupItem mWExclusiveGroupItem = this.kindCheckboxGroup.getSelectedItem();
            if (mWExclusiveGroupItem == this.networkCheckbox) {
                this.returnType = 0;
            } else if (mWExclusiveGroupItem == this.inputsCheckbox) {
                this.returnType = 1;
            } else if (mWExclusiveGroupItem == this.targetsCheckbox) {
                this.returnType = 2;
            } else if (mWExclusiveGroupItem == this.inputDelaysCheckbox) {
                this.returnType = 3;
            } else if (mWExclusiveGroupItem == this.layerDelaysCheckbox) {
                this.returnType = 4;
            } else if (mWExclusiveGroupItem == this.outputsCheckbox) {
                this.returnType = 5;
            } else if (mWExclusiveGroupItem == this.errorsCheckbox) {
                this.returnType = 6;
            }
        } else {
            this.loaded = true;
            this.returnName = this.nameField.getText();
            this.returnPath = this.diskField.getText();
            this.returnVariable = this.variableList.getSelectedItem();
            MWExclusiveGroupItem mWExclusiveGroupItem = this.kindCheckboxGroup.getSelectedItem();
            if (mWExclusiveGroupItem == this.networkCheckbox) {
                this.returnType = 0;
            } else if (mWExclusiveGroupItem == this.inputsCheckbox) {
                this.returnType = 1;
            } else if (mWExclusiveGroupItem == this.targetsCheckbox) {
                this.returnType = 2;
            } else if (mWExclusiveGroupItem == this.inputDelaysCheckbox) {
                this.returnType = 3;
            } else if (mWExclusiveGroupItem == this.layerDelaysCheckbox) {
                this.returnType = 4;
            } else if (mWExclusiveGroupItem == this.outputsCheckbox) {
                this.returnType = 5;
            } else if (mWExclusiveGroupItem == this.errorsCheckbox) {
                this.returnType = 6;
            }
        }
        this.setVisible(false);
    }

    private void browse() {
        MWFileDialog mWFileDialog = new MWFileDialog((Frame)this.owner, "Select MAT file", 0, 2);
        mWFileDialog.setVisible(true);
        String string = String.valueOf(mWFileDialog.getDirectory()) + mWFileDialog.getFile();
        this.diskField.setText(string);
        this.updateSource();
        this.updateImportButton();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cancel();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleActionPerformed(actionEvent);
    }

    public void handleActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancelButton) {
            this.cancel();
        } else if (object == this.importButton) {
            this.doImport();
        } else if (object == this.browseButton) {
            this.browse();
        } else if (object == this.diskField) {
            this.openFile();
        }
        this.updateImportButton();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.workspaceCheckbox) {
            this.updateSource();
        } else if (object == this.diskCheckbox) {
            this.updateSource();
        } else if (object == this.variableList) {
            this.updateName();
        }
        this.updateImportButton();
    }
}

