/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.nnet;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.dialog.MWDialog;
import com.mathworks.toolbox.nnet.NNManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;

class NNExportDialog
extends MWDialog
implements WindowListener,
ItemListener,
ActionListener,
FilenameFilter {
    private static final int WINDOW_WIDTH = 320;
    private static final int WINDOW_HEIGHT = 300;
    private static final int SPACING = 6;
    private static final int TEXT_COLUMNS = 12;
    private final MWFrame owner;
    private final MWListbox variableList;
    private final MWButton selectAllButton;
    private final MWButton selectNoneButton;
    private final MWButton cancelButton;
    private final MWButton exportButton;
    private final MWButton saveButton;
    protected boolean exported = false;
    protected boolean saved = false;
    protected String[] returnVariables;
    protected String returnPath;

    public NNExportDialog(MWFrame mWFrame) {
        super((Frame)mWFrame, true);
        this.owner = mWFrame;
        ((Dialog)((Object)this)).setTitle("Export or Save from Network/Data Manager");
        ((Dialog)((Object)this)).setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)((Object)this)).setBounds((dimension.width - 320) / 2, 30, 320, 0);
        this.setLayout(new BorderLayout());
        MWGroupbox mWGroupbox = new MWGroupbox("Select Variables");
        mWGroupbox.setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)mWGroupbox);
        this.variableList = new MWListbox();
        mWGroupbox.add((Component)this.variableList, "Center");
        this.variableList.addItemListener((ItemListener)this);
        this.variableList.setMultiSelection(true);
        NNManager nNManager = NNManager.instance;
        int n = nNManager.networkList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            this.variableList.addItem(nNManager.networkList.getItem(n2));
            ++n2;
        }
        n = nNManager.inputList.getItemCount();
        int n3 = 0;
        while (n3 < n) {
            this.variableList.addItem(nNManager.inputList.getItem(n3));
            ++n3;
        }
        n = nNManager.targetList.getItemCount();
        int n4 = 0;
        while (n4 < n) {
            this.variableList.addItem(nNManager.targetList.getItem(n4));
            ++n4;
        }
        n = nNManager.inputDelayList.getItemCount();
        int n5 = 0;
        while (n5 < n) {
            this.variableList.addItem(nNManager.inputDelayList.getItem(n5));
            ++n5;
        }
        n = nNManager.layerDelayList.getItemCount();
        int n6 = 0;
        while (n6 < n) {
            this.variableList.addItem(nNManager.layerDelayList.getItem(n6));
            ++n6;
        }
        n = nNManager.outputList.getItemCount();
        int n7 = 0;
        while (n7 < n) {
            this.variableList.addItem(nNManager.outputList.getItem(n7));
            ++n7;
        }
        n = nNManager.errorList.getItemCount();
        int n8 = 0;
        while (n8 < n) {
            this.variableList.addItem(nNManager.errorList.getItem(n8));
            ++n8;
        }
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        ((Container)((Object)this)).add((Component)mWPanel, "South");
        MWGroupbox mWGroupbox2 = new MWGroupbox();
        mWGroupbox2.setLayout(new BorderLayout());
        mWPanel.add((Component)mWGroupbox2, "North");
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new GridLayout(2, 1));
        mWGroupbox2.add((Component)mWPanel2, "Center");
        mWPanel2.add((Component)new MWLabel("Select one or more variables. Then [Export] the variables"));
        mWPanel2.add((Component)new MWLabel("to the MATLAB workspace or [Save] them to a disk file"));
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel.add((Component)mWPanel3, "South");
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new FlowLayout(0, 6, 6));
        mWPanel3.add((Component)mWPanel4, "West");
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new FlowLayout(2, 6, 6));
        mWPanel3.add((Component)mWPanel5, "East");
        this.selectAllButton = new MWButton("Select All");
        mWPanel4.add((Component)this.selectAllButton);
        this.selectAllButton.addActionListener((ActionListener)this);
        this.selectNoneButton = new MWButton("Select None");
        mWPanel4.add((Component)this.selectNoneButton);
        this.selectNoneButton.addActionListener((ActionListener)this);
        this.cancelButton = new MWButton("Cancel");
        mWPanel5.add((Component)this.cancelButton);
        this.cancelButton.addActionListener((ActionListener)this);
        this.exportButton = new MWButton("Export");
        mWPanel5.add((Component)this.exportButton);
        this.exportButton.setEnabled(false);
        this.exportButton.addActionListener((ActionListener)this);
        this.saveButton = new MWButton("Save");
        mWPanel5.add((Component)this.saveButton);
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener((ActionListener)this);
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).addWindowListener(this);
        ((Dialog)((Object)this)).show();
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void export() {
        this.exported = true;
        this.returnVariables = this.variableList.getSelectedItems();
        this.setVisible(false);
    }

    private void save() {
        FileDialog fileDialog = new FileDialog((Frame)this.owner, "Save to a MAT file", 1);
        fileDialog.setFilenameFilter(this);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            this.saved = true;
            this.returnPath = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            this.returnVariables = this.variableList.getSelectedItems();
            this.setVisible(false);
        }
    }

    private void selectAll() {
        int n = 0;
        while (n < this.variableList.getItemCount()) {
            this.variableList.setSelectedIndex(n);
            ++n;
        }
    }

    private void selectNone() {
        int n = 0;
        while (n < this.variableList.getItemCount()) {
            this.variableList.setSelectedIndex(-1);
            ++n;
        }
    }

    void updateDestination() {
        boolean bl = true;
        String[] stringArray = this.variableList.getSelectedItems();
        if (stringArray.length == 0) {
            bl = false;
        }
        this.exportButton.setEnabled(bl);
        this.saveButton.setEnabled(bl);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cancel();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        itemEvent.getSource();
        this.updateDestination();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancelButton) {
            this.cancel();
        }
        if (object == this.exportButton) {
            this.export();
        }
        if (object == this.saveButton) {
            this.save();
        }
        if (object == this.selectAllButton) {
            this.selectAll();
        }
        if (object == this.selectNoneButton) {
            this.selectNone();
        }
        this.updateDestination();
    }

    public boolean accept(String string) {
        int n = string.length();
        if (n < 4) {
            return false;
        }
        return string.substring(n - 4).toLowerCase().equals(".mat");
    }

    public boolean accept(File file, String string) {
        return this.accept(string);
    }
}

