/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.nnet;

import com.mathworks.mwt.MWPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

abstract class BorderTile
extends MWPanel {
    static final int NORTH = 0;
    static final int NORTHEAST = 1;
    static final int EAST = 2;
    static final int SOUTHEAST = 3;
    static final int SOUTH = 4;
    static final int SOUTHWEST = 5;
    static final int WEST = 6;
    static final int NORTHWEST = 7;
    private Image offscreenImage;
    private Dimension offscreenDim;
    private Graphics offscreenGraphics;
    private final int side;

    protected BorderTile(int n, int n2, int n3) {
        ((Component)((Object)this)).setSize(n, n2);
        this.side = n3;
    }

    public void bufferedPaint(Graphics graphics) {
        Dimension dimension = ((Component)((Object)this)).getSize();
        if (this.offscreenImage == null || dimension.width != this.offscreenDim.width || dimension.height != this.offscreenDim.height) {
            this.offscreenImage = ((Component)((Object)this)).createImage(dimension.width, dimension.height);
            if (this.offscreenImage == null) {
                return;
            }
            this.offscreenDim = dimension;
            this.offscreenGraphics = this.offscreenImage.getGraphics();
            this.offscreenGraphics.setFont(new Font("helvetica", 0, 10));
        }
        this.offscreenGraphics.setColor(((Component)((Object)this)).getBackground());
        this.offscreenGraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offscreenGraphics.setColor(((Component)((Object)this)).getForeground());
        this.draw(this.offscreenGraphics);
        graphics.drawImage(this.offscreenImage, 0, 0, null);
    }

    public void draw(Graphics graphics) {
        Dimension dimension = ((Component)((Object)this)).getSize();
        int n = dimension.height;
        int n2 = dimension.width;
        switch (this.side) {
            case 0: {
                this.paintNorth(graphics, n2, n);
                return;
            }
            case 1: {
                this.paintNortheast(graphics, n2, n);
                return;
            }
            case 2: {
                this.paintEast(graphics, n2, n);
                return;
            }
            case 3: {
                this.paintSoutheast(graphics, n2, n);
                return;
            }
            case 4: {
                this.paintSouth(graphics, n2, n);
                return;
            }
            case 5: {
                this.paintSouthwest(graphics, n2, n);
                return;
            }
            case 6: {
                this.paintWest(graphics, n2, n);
                return;
            }
            case 7: {
                this.paintNorthwest(graphics, n2, n);
                return;
            }
        }
    }

    public void paint(Graphics graphics) {
        this.bufferedPaint(graphics);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected abstract void paintNorth(Graphics var1, int var2, int var3);

    protected abstract void paintNortheast(Graphics var1, int var2, int var3);

    protected abstract void paintEast(Graphics var1, int var2, int var3);

    protected abstract void paintSoutheast(Graphics var1, int var2, int var3);

    protected abstract void paintSouth(Graphics var1, int var2, int var3);

    protected abstract void paintSouthwest(Graphics var1, int var2, int var3);

    protected abstract void paintWest(Graphics var1, int var2, int var3);

    protected abstract void paintNorthwest(Graphics var1, int var2, int var3);
}

