/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.IniEvent;
import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.IniProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.Vxi;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

public final class VxiVisa
extends Vxi
implements ActionListener {
    private static final int TTL0 = 0;
    private static final int TTL1 = 1;
    private static final int TTL2 = 2;
    private static final int TTL3 = 3;
    private static final int TTL4 = 4;
    private static final int TTL5 = 5;
    private static final int TTL6 = 6;
    private static final int TTL7 = 7;
    private static final int ECL0 = 8;
    private static final int ECL1 = 9;
    private static final int HARDWARE = 0;
    private static final int SOFTWARE = 10;
    private MLArrayRef interruptAction = Instrument.ACTION;
    private MLArrayRef triggerAction = Instrument.ACTION;
    protected int triggerLine = 0;
    protected int triggerType = 0;
    VISA visa;
    private int defaultRM;
    protected static final String[] TrigLVals = new String[]{"TTL0", "TTL1", "TTL2", "TTL3", "TTL4", "TTL5", "TTL6", "TTL7", "ECL0", "ECL1"};
    protected static final String[] TrigTVals = new String[]{"hardware", "software"};
    static IniProp[] objectIniProps = new IniProp[]{new IniProp("ByteOrder", "string", "enum", Instrument.byteOVals, "littleEndian", "never", 0), new IniProp("BytesAvailable", "double", "none", "", new Integer(0), "always", 0), new IniProp("BytesAvailableAction", "action", "action", "", "", "never", 0), new IniProp("BytesAvailableActionCount", "double", "none", "", new Integer(48), "whileOpen", 0), new IniProp("BytesAvailableActionMode", "string", "enum", Vxi.dModeVals, "eosCharCode", "whileOpen", 0), new IniProp("BytesToOutput", "double", "none", "", new Integer(0), "always", 0), new IniProp("ChassisIndex", "double", "none", "", "", "whileopen", 1), new IniProp("CompareBits", "double", "bounded", Vxi.comVals, new Integer(8), "never", 1), new IniProp("EOIMode", "string", "enum", Instrument.boolVals, "on", "never", 1), new IniProp("EOSCharCode", "double", "bounded", Vxi.eosCVals, new Integer(10), "never", 1), new IniProp("EOSMode", "string", "enum", Vxi.EOSMVals, "none", "never", 1), new IniProp("ErrorAction", "action", "action", "", "", "never", 0), new IniProp("InputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("InterruptAction", "action", "action", "", "", "never", 1), new IniProp("LogicalAddress", "double", "none", "", new Integer(0), "whileOpen", 1), new IniProp("MappedMemoryBase", "string", "none", "", "0H", "always", 1), new IniProp("MappedMemorySize", "double", "none", "", new Integer(0), "always", 1), new IniProp("MemoryBase", "string", "none", "", "0H", "always", 1), new IniProp("MemorySize", "double", "none", "", new Integer(0), "always", 1), new IniProp("MemorySpace", "string", "enum", Vxi.MSpVals, "A16", "always", 1), new IniProp("Name", "string", "none", "", "", "never", 0), new IniProp("OutputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("OutputEmptyAction", "action", "action", "", "", "never", 0), new IniProp("RecordDetail", "string", "enum", Instrument.RDetVals, "compact", "never", 0), new IniProp("RecordMode", "string", "enum", Instrument.RModeVals, "overwrite", "whileRecording", 0), new IniProp("RecordName", "string", "none", "", "record.txt", "whileRecording", 0), new IniProp("RecordStatus", "string", "enum", Instrument.boolVals, "off", "always", 0), new IniProp("RsrcName", "string", "none", "", "", "always", 1), new IniProp("Slot", "double", "none", "", new Integer(0), "always", 1), new IniProp("Status", "string", "enum", Instrument.StatVals, "closed", "always", 0), new IniProp("Tag", "string", "none", "", "", "never", 0), new IniProp("Timeout", "double", "none", "", new Integer(10), "never", 0), new IniProp("TimerAction", "action", "action", "", "", "never", 0), new IniProp("TimerPeriod", "double", "none", "", new Integer(1), "whileOpen", 0), new IniProp("TransferStatus", "string", "enum", Vxi.TranSVals, "idle", "always", 0), new IniProp("TriggerAction", "action", "action", "", "", "never", 1), new IniProp("TriggerLine", "string", "enum", TrigLVals, "TTL0", "never", 1), new IniProp("TriggerType", "string", "enum", TrigTVals, "hardware", "never", 1), new IniProp("Type", "string", "none", "", "visa-vxi", "always", 0), new IniProp("UserData", "any", "none", "", new double[0], "never", 0), new IniProp("ValuesReceived", "double", "none", "", new Integer(0), "always", 0), new IniProp("ValuesSent", "double", "none", "", new Integer(0), "always", 0)};
    static final int CHASSISINDEX = 6;
    static final int LOGICALADDRESS = 14;
    static final int NAME = 20;
    static final int RSRCNAME = 27;

    public void setInterruptAction(MLArrayRef mLArrayRef) throws IniException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("InterruptAction", mLArrayRef);
        if (this.interruptAction != Instrument.ACTION) {
            this.interruptAction.dispose();
        }
        this.interruptAction = mLArrayRef2;
        this.enabledCallbacks[3] = 0;
    }

    public MLArrayRef getInterruptAction() {
        return this.interruptAction;
    }

    public void setTriggerAction(MLArrayRef mLArrayRef) throws IniException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("TriggerAction", mLArrayRef);
        if (this.triggerAction != Instrument.ACTION) {
            this.triggerAction.dispose();
        }
        this.triggerAction = mLArrayRef2;
        this.enabledCallbacks[7] = 0;
        if (this.status == 0) {
            return;
        }
        if (this.triggerAction == Instrument.ACTION) {
            this.visa.EnableAction(this, this.handle, 204, 0);
            return;
        }
        this.visa.EnableAction(this, this.handle, 204, 1);
    }

    public MLArrayRef getTriggerAction() {
        return this.triggerAction;
    }

    public void setTriggerLine(int n) throws IniException {
        if (this.status == 0) {
            this.triggerLine = n;
            return;
        }
        boolean bl = false;
        if (this.triggerAction != Instrument.ACTION) {
            bl = true;
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 0);
        }
        try {
            this.setHardwareTriggerLine(n);
            this.triggerLine = n;
        }
        catch (Exception exception) {
            if (bl) {
                this.visa.EnableAction(this, this.handle, 204, 1);
            }
            this.displayError(exception.getMessage());
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 1);
        }
    }

    public int getTriggerLine() {
        return this.triggerLine;
    }

    public void setTriggerType(int n) throws IniException {
        if (this.status == 0) {
            this.triggerType = n;
            return;
        }
        boolean bl = false;
        if (this.triggerAction != Instrument.ACTION) {
            bl = true;
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 0);
        }
        try {
            this.setHardwareTriggerType(n);
            this.triggerType = n;
        }
        catch (Exception exception) {
            if (bl) {
                this.visa.EnableAction(this, this.handle, 204, 1);
            }
            this.displayError(exception.getMessage());
        }
        if (bl) {
            this.visa.EnableAction(this, this.handle, 204, 1);
        }
    }

    public int getTriggerType() {
        return this.triggerType;
    }

    protected void setHardwareTriggerLine(int n) throws IniException {
        int n2 = this.visa.Set(this.handle, 205, n);
        if (n2 < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n2));
        }
    }

    protected void setHardwareTriggerType(int n) throws IniException {
        int n2 = 0;
        switch (this.triggerType) {
            case 0: {
                n2 = this.visa.Set(this.handle, 205, this.triggerLine);
                break;
            }
            case 10: {
                n2 = this.visa.Set(this.handle, 205, this.triggerType);
                break;
            }
        }
        if (n2 < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n2));
        }
    }

    protected void nameStandardFormat() {
        if (this.name.equals("VISA-VXI" + this.chassisIndex + "-" + this.logicalAddress)) {
            this.nameStandardFormat = true;
            return;
        }
        this.nameStandardFormat = false;
    }

    protected final void updateNameProperties() {
        this.rsrcName = "VXI" + this.chassisIndex + "::" + this.logicalAddress + "::INSTR";
        if (this.nameStandardFormat) {
            this.name = "VISA-VXI" + this.chassisIndex + "-" + this.logicalAddress;
        }
    }

    public VxiVisa() {
        this.deleteInstrumentObject(this);
    }

    public VxiVisa(String string, String string2, String string3) throws IniException {
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'visa'.");
        }
        try {
            boolean bl = this.verifyName(string3);
            if (!bl) {
                this.displayError("Invalid RSRCNAME specified. Type 'instrhelp visa' for more information.");
            }
            this.info[0] = String.valueOf(string) + Instrument.FILESEP + string2;
            this.info[1] = Instrument.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.updateNameProperties();
            this.type = "visa-vxi";
            this.objectProps = objectIniProps;
            this.visaobj = this.visa;
            return;
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new IniException(exception.getMessage());
        }
    }

    private boolean verifyName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return false;
        }
        this.chassisIndex = n == 3 ? 0 : this.str2num(string.substring(3, n));
        if (this.chassisIndex < 0) {
            return false;
        }
        String string2 = string.substring(n + 2, string.length());
        if ((n = string2.indexOf("::")) == -1) {
            return false;
        }
        this.logicalAddress = this.str2num(string2.substring(0, n));
        if (this.logicalAddress < 0) {
            return false;
        }
        if (!(string2 = string2.substring(n + 2, string2.length())).equals("INSTR")) {
            return false;
        }
        this.rsrcName = "VXI" + this.chassisIndex + "::" + this.logicalAddress + "::INSTR";
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        this.executeEvent(6, "Timer", this.eventTime, new IniEvent("Timer", Instrument.constructClockVector(this.eventTime)));
    }

    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "VxiVisaTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    protected void openHardware() throws IniException {
        int[] nArray;
        if (this.isInUse()) {
            this.displayError("The specified configuration: " + this.rsrcName + " is not available. " + Instrument.LINESEP + "Use INSTRHWINFO for a list of available configurations." + " Use INSTRFIND to " + Instrument.LINESEP + "determine if other instrument " + "objects are connected to the requested instrument.");
        }
        if ((nArray = this.visa.Create(this, this.rsrcName)) != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
            this.getPropertyValuesUponConnecting();
            return;
        }
        this.displayError("Could not create VISA object. Use INSTRHWINFO for a list of available configurations.");
    }

    protected void addToPoller() {
        Poller.addInstrument(this);
        if (this.timerAction != Instrument.ACTION) {
            if (!this.wasTimerStarted) {
                this.createTimer();
                return;
            }
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        }
    }

    protected void updatePropsOnOpen() throws Exception {
        this.eosCharByteArray[0] = (byte)this.eosCharCode;
        this.setHardwareEOIMode(this.eoiMode);
        this.setHardwareEOSMode(this.eosMode);
        this.setHardwareEOSChar(this.eosCharCode);
        this.setHardwareTimeout(this.timeout);
        this.timeout = this.getHardwareTimeout();
        this.setHardwareTriggerLine(this.triggerLine);
        if (this.triggerAction != Instrument.ACTION) {
            this.visa.EnableAction(this, this.handle, 204, 1);
        }
    }

    protected void closeHardware() throws Exception {
        int n;
        Poller.removeInstrument(this);
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if (this.mappedMemorySize != 0) {
            this.visa.UnMapAddress(this.handle);
            this.mappedMemorySize = 0;
            this.mappedMemoryBase = "0H";
        }
        if ((n = this.visa.Close(this.handle, this.defaultRM)) < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    private boolean isInUse() {
        int n = 0;
        while (n < Instrument.allInstrumentObjects.size()) {
            Object e = Instrument.allInstrumentObjects.elementAt(n);
            if (e instanceof VxiVisa) {
                VxiVisa vxiVisa = (VxiVisa)e;
                if (vxiVisa.rsrcName.equals(this.rsrcName) & vxiVisa.status == 1) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        if (this.interruptAction != Instrument.ACTION) {
            this.interruptAction.dispose();
        }
        if (this.triggerAction != Instrument.ACTION) {
            this.triggerAction.dispose();
        }
    }

    public final synchronized void poll() {
        try {
            if (this.readAsyncCount > 0 && !this.readingFromHardware) {
                this.pollingRead();
            }
            if (this.dataAvailableOutputVector()) {
                this.pollingWrite();
            }
            if (this.isActionAvailable()) {
                int n = this.getNextAction();
                int n2 = this.getNextAction();
                if (n == 0) {
                    if (this.transferStatus == 2) {
                        n = 2;
                    } else if (this.transferStatus == 1) {
                        n = 0;
                    } else if (this.oldTransferStatus == 2) {
                        n = 2;
                    } else if (this.oldTransferStatus == 1) {
                        n = 0;
                    } else {
                        return;
                    }
                }
                switch (n) {
                    case 0: {
                        this.pollReadActionSuccess(n2);
                        break;
                    }
                    case 1: {
                        this.pollReadActionSize(n2);
                        break;
                    }
                    case 2: {
                        this.pollWriteAction();
                        break;
                    }
                    case 202: {
                        if (this.interruptAction.equals(Instrument.ACTION)) break;
                        this.eventTime = Calendar.getInstance();
                        this.executeEvent(3, "Interrupt", this.eventTime, new IniEvent("Interrupt", Instrument.constructClockVector(this.eventTime)));
                        break;
                    }
                    default: {
                        if (n < 10 || this.triggerAction.equals(Instrument.ACTION)) break;
                        this.eventTime = Calendar.getInstance();
                        this.executeEvent(7, "Trigger", this.eventTime, new IniEvent("Trigger", n - 10, Instrument.constructClockVector(this.eventTime)));
                        break;
                    }
                }
            }
            this.checkForAsynchronousTimeouts();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void trigger() throws IniException {
        int n;
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            this.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if ((n = this.visa.Trigger(this.handle)) < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    protected void updateObjectSpecificProperties(IniProp[] iniPropArray) {
        iniPropArray[6].setDefaultValue(new Integer(this.chassisIndex));
        iniPropArray[14].setDefaultValue(new Integer(this.logicalAddress));
        iniPropArray[20].setDefaultValue("VISA-VXI" + this.chassisIndex + "-" + this.logicalAddress);
        iniPropArray[27].setDefaultValue(this.rsrcName);
    }

    public String display() {
        if (!this.isvalid()) {
            return this.invalidDisplay();
        }
        return String.valueOf(Instrument.LINESEP) + "   VISA-VXI Object Using " + this.info[2] + " Adaptor : " + this.name + Instrument.LINESEP + Instrument.LINESEP + "   Communication Address " + Instrument.LINESEP + "      ChassisIndex:       " + this.chassisIndex + Instrument.LINESEP + "      LogicalAddress:     " + this.logicalAddress + Instrument.LINESEP + Instrument.LINESEP + "   Communication State " + Instrument.LINESEP + "      Status:             " + Instrument.STATUS_ENUM[this.status] + Instrument.LINESEP + "      RecordStatus:       " + Instrument.RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + Instrument.LINESEP + Instrument.LINESEP + "   Read/Write State  " + Instrument.LINESEP + "      TransferStatus:     " + Instrument.TRANSFER_STATUS_ENUM[this.transferStatus] + Instrument.LINESEP + "      BytesAvailable:     " + this.bytesAvailable + Instrument.LINESEP + "      ValuesReceived:     " + this.valuesReceived + Instrument.LINESEP + "      ValuesSent:         " + this.valuesSent + Instrument.LINESEP + " " + Instrument.LINESEP;
    }

    public String setDisplay() {
        return "    ByteOrder: [ {littleEndian} | bigEndian ] " + Instrument.LINESEP + "    BytesAvailableAction" + Instrument.LINESEP + "    BytesAvailableActionCount" + Instrument.LINESEP + "    BytesAvailableActionMode: [ {eosCharCode} | byte ]" + Instrument.LINESEP + "    ErrorAction" + Instrument.LINESEP + "    InputBufferSize" + Instrument.LINESEP + "    Name" + Instrument.LINESEP + "    OutputBufferSize" + Instrument.LINESEP + "    OutputEmptyAction" + Instrument.LINESEP + "    RecordDetail: [ {compact} | verbose ]" + Instrument.LINESEP + "    RecordMode: [ {overwrite} | append | index ]" + Instrument.LINESEP + "    RecordName" + Instrument.LINESEP + "    Tag" + Instrument.LINESEP + "    Timeout" + Instrument.LINESEP + "    TimerAction" + Instrument.LINESEP + "    TimerPeriod" + Instrument.LINESEP + "    UserData" + Instrument.LINESEP + "    " + Instrument.LINESEP + "    VISA-VXI specific properties:" + Instrument.LINESEP + "    ChassisIndex" + Instrument.LINESEP + "    CompareBits" + Instrument.LINESEP + "    EOIMode: [ {on} | off ]" + Instrument.LINESEP + "    EOSCharCode" + Instrument.LINESEP + "    EOSMode: [ {none} | read | write | read&write ]" + Instrument.LINESEP + "    InterruptAction" + Instrument.LINESEP + "    LogicalAddress" + Instrument.LINESEP + "    TriggerAction" + Instrument.LINESEP + "    TriggerLine: [ {TTL0} | TTL1 | TTL2 | TTL3 | TTL4 | TTL5 | TTL6 | TTL7 | ECL0 | ECL1 ]" + Instrument.LINESEP + "    TriggerType: [ {hardware} | software ] " + Instrument.LINESEP + " " + Instrument.LINESEP;
    }
}

