/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.IniEvent;
import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.IniProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.Vxi;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

public final class VxiGpibVisa
extends Vxi
implements ActionListener {
    private int boardIndex;
    private int primaryAddress;
    private int secondaryAddress;
    VISA visa;
    private int defaultRM;
    static IniProp[] objectIniProps = new IniProp[]{new IniProp("BoardIndex", "double", "none", "", "", "always", 1), new IniProp("ByteOrder", "string", "enum", Instrument.byteOVals, "littleEndian", "never", 0), new IniProp("BytesAvailable", "double", "none", "", new Integer(0), "always", 0), new IniProp("BytesAvailableAction", "action", "action", "", "", "never", 0), new IniProp("BytesAvailableActionCount", "double", "none", "", new Integer(48), "whileOpen", 0), new IniProp("BytesAvailableActionMode", "string", "enum", Vxi.dModeVals, "eosCharCode", "whileOpen", 0), new IniProp("BytesToOutput", "double", "none", "", new Integer(0), "always", 0), new IniProp("ChassisIndex", "double", "none", "", "", "whileopen", 1), new IniProp("CompareBits", "double", "bounded", Vxi.comVals, new Integer(8), "never", 1), new IniProp("EOIMode", "string", "enum", Instrument.boolVals, "on", "never", 1), new IniProp("EOSCharCode", "double", "bounded", Vxi.eosCVals, new Integer(10), "never", 1), new IniProp("EOSMode", "string", "enum", Vxi.EOSMVals, "none", "never", 1), new IniProp("ErrorAction", "action", "action", "", "", "never", 0), new IniProp("InputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("LogicalAddress", "double", "none", "", new Integer(0), "whileOpen", 1), new IniProp("MappedMemoryBase", "string", "none", "", "0H", "always", 1), new IniProp("MappedMemorySize", "double", "none", "", new Integer(0), "always", 1), new IniProp("MemoryBase", "string", "none", "", "0H", "always", 1), new IniProp("MemorySize", "double", "none", "", new Integer(0), "always", 1), new IniProp("MemorySpace", "string", "enum", Vxi.MSpVals, "A16", "always", 1), new IniProp("Name", "string", "none", "", "", "never", 0), new IniProp("OutputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("OutputEmptyAction", "action", "action", "", "", "never", 0), new IniProp("PrimaryAddress", "double", "none", "", "", "always", 1), new IniProp("RecordDetail", "string", "enum", Instrument.RDetVals, "compact", "never", 0), new IniProp("RecordMode", "string", "enum", Instrument.RModeVals, "overwrite", "whileRecording", 0), new IniProp("RecordName", "string", "none", "", "record.txt", "whileRecording", 0), new IniProp("RecordStatus", "string", "enum", Instrument.boolVals, "off", "always", 0), new IniProp("RsrcName", "string", "none", "", "", "always", 1), new IniProp("SecondaryAddress", "double", "none", "", "", "always", 1), new IniProp("Slot", "double", "none", "", new Integer(0), "always", 1), new IniProp("Status", "string", "enum", Instrument.StatVals, "closed", "always", 0), new IniProp("Tag", "string", "none", "", "", "never", 0), new IniProp("Timeout", "double", "none", "", new Integer(10), "never", 0), new IniProp("TimerAction", "action", "action", "", "", "never", 0), new IniProp("TimerPeriod", "double", "none", "", new Integer(1), "whileOpen", 0), new IniProp("TransferStatus", "string", "enum", Vxi.TranSVals, "idle", "always", 0), new IniProp("Type", "string", "none", "", "visa-gpib-vxi", "always", 0), new IniProp("UserData", "any", "none", "", new double[0], "never", 0), new IniProp("ValuesReceived", "double", "none", "", new Integer(0), "always", 0), new IniProp("ValuesSent", "double", "none", "", new Integer(0), "always", 0)};
    static final int FBOARDINDEX = 0;
    static final int FCHASSISINDEX = 7;
    static final int FLOGICALADDRESS = 14;
    static final int FNAME = 20;
    static final int FPRIMARY_ADDRESS = 23;
    static final int FRSRCNAME = 28;
    static final int FSECONDARY_ADDRESS = 29;

    public void setBoardIndex(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("BoardIndex"));
    }

    public int getBoardIndex() {
        return this.boardIndex;
    }

    public void setPrimaryAddress(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("PrimaryAddress"));
    }

    public int getPrimaryAddress() {
        return this.primaryAddress;
    }

    public void setSecondaryAddress(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("SecondaryAddress"));
    }

    public int getSecondaryAddress() {
        return this.secondaryAddress;
    }

    protected void nameStandardFormat() {
        if (this.name.equals("VISA-GPIB-VXI" + this.chassisIndex + "-" + this.logicalAddress)) {
            this.nameStandardFormat = true;
            return;
        }
        this.nameStandardFormat = false;
    }

    protected final void updateNameProperties() {
        this.rsrcName = "GPIB-VXI" + this.chassisIndex + "::" + this.logicalAddress + "::INSTR";
        if (this.nameStandardFormat) {
            this.name = "VISA-GPIB-VXI" + this.chassisIndex + "-" + this.logicalAddress;
        }
    }

    public VxiGpibVisa() {
        this.deleteInstrumentObject(this);
    }

    public VxiGpibVisa(String string, String string2, String string3) throws IniException {
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'visa'.");
        }
        try {
            boolean bl = this.verifyName(string3);
            if (!bl) {
                this.displayError("Invalid RSRCNAME specified. Type 'instrhelp visa' for more information.");
            }
            this.info[0] = String.valueOf(string) + Instrument.FILESEP + string2;
            this.info[1] = Instrument.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.updateNameProperties();
            this.type = "visa-gpib-vxi";
            this.objectProps = objectIniProps;
            this.visaobj = this.visa;
            return;
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new IniException(exception.getMessage());
        }
    }

    private boolean verifyName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return false;
        }
        this.chassisIndex = n == 8 ? 0 : this.str2num(string.substring(8, n));
        if (this.chassisIndex < 0) {
            return false;
        }
        String string2 = string.substring(n + 2, string.length());
        if ((n = string2.indexOf("::")) == -1) {
            return false;
        }
        this.logicalAddress = this.str2num(string2.substring(0, n));
        if (this.logicalAddress < 0) {
            return false;
        }
        if (!(string2 = string2.substring(n + 2, string2.length())).equals("INSTR")) {
            return false;
        }
        this.rsrcName = "GPIB-VXI" + this.chassisIndex + "::" + this.logicalAddress + "::INSTR";
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        this.executeEvent(6, "Timer", this.eventTime, new IniEvent("Timer", Instrument.constructClockVector(this.eventTime)));
    }

    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "VxiGpibVisaTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    protected void openHardware() throws IniException {
        int[] nArray;
        if (this.isInUse()) {
            this.displayError("The specified configuration: " + this.rsrcName + " is not available. " + Instrument.LINESEP + "Use INSTRHWINFO for a list of available configurations." + " Use INSTRFIND to " + Instrument.LINESEP + "determine if other instrument " + "objects are connected to the requested instrument.");
        }
        if ((nArray = this.visa.Create(this, this.rsrcName)) != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
            int n = this.visa.Get(this.handle, 210);
            if (n >= 0) {
                this.boardIndex = n;
            }
            if ((n = this.visa.Get(this.handle, 211)) >= 0) {
                this.primaryAddress = n;
            }
            if ((n = this.visa.Get(this.handle, 212)) >= 0) {
                this.secondaryAddress = n;
            }
            this.getPropertyValuesUponConnecting();
            return;
        }
        this.displayError("Could not create VISA object. Use INSTRHWINFO for a list of available configurations.");
    }

    protected void addToPoller() {
        if (this.visa.VerifyAsyncVISARead()) {
            Poller.addInstrument(this);
        }
        if (this.timerAction != Instrument.ACTION) {
            if (!this.wasTimerStarted) {
                this.createTimer();
                return;
            }
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        }
    }

    protected void closeHardware() throws IniException {
        int n;
        if (this.visa.VerifyAsyncVISARead()) {
            Poller.removeInstrument(this);
        }
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if (this.mappedMemorySize != 0) {
            this.visa.UnMapAddress(this.handle);
            this.mappedMemorySize = 0;
            this.mappedMemoryBase = "0H";
        }
        if ((n = this.visa.Close(this.handle, this.defaultRM)) < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    protected void updatePropsOnOpen() throws IniException {
        this.eosCharByteArray[0] = (byte)this.eosCharCode;
        this.setHardwareEOIMode(this.eoiMode);
        this.setHardwareEOSMode(this.eosMode);
        this.setHardwareEOSChar(this.eosCharCode);
        this.setHardwareTimeout(this.timeout);
        this.timeout = this.getHardwareTimeout();
    }

    private boolean isInUse() {
        int n = 0;
        while (n < Instrument.allInstrumentObjects.size()) {
            Object e = Instrument.allInstrumentObjects.elementAt(n);
            if (e instanceof VxiGpibVisa) {
                VxiGpibVisa vxiGpibVisa = (VxiGpibVisa)e;
                if (vxiGpibVisa.rsrcName.equals(this.rsrcName) & vxiGpibVisa.status == 1) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
    }

    public final void poll() {
        try {
            if (this.readAsyncCount > 0 && !this.readingFromHardware) {
                this.pollingRead();
            }
            if (this.dataAvailableOutputVector()) {
                this.pollingWrite();
            }
            if (this.isActionAvailable()) {
                int n = this.getNextAction();
                int n2 = this.getNextAction();
                if (n == 0) {
                    if (this.transferStatus == 2) {
                        n = 2;
                    } else if (this.transferStatus == 1) {
                        n = 0;
                    } else if (this.oldTransferStatus == 2) {
                        n = 2;
                    } else if (this.oldTransferStatus == 1) {
                        n = 0;
                    } else {
                        return;
                    }
                }
                switch (n) {
                    case 0: {
                        this.pollReadActionSuccess(n2);
                        break;
                    }
                    case 1: {
                        this.pollReadActionSize(n2);
                        break;
                    }
                    case 2: {
                        this.pollWriteAction();
                        break;
                    }
                }
            }
            this.checkForAsynchronousTimeouts();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void updateObjectSpecificProperties(IniProp[] iniPropArray) {
        iniPropArray[0].setDefaultValue(new Integer(this.boardIndex));
        iniPropArray[7].setDefaultValue(new Integer(this.chassisIndex));
        iniPropArray[14].setDefaultValue(new Integer(this.logicalAddress));
        iniPropArray[20].setDefaultValue("VISA-GPIB-VXI" + this.chassisIndex + "-" + this.logicalAddress);
        iniPropArray[23].setDefaultValue(new Integer(this.primaryAddress));
        iniPropArray[28].setDefaultValue(this.rsrcName);
        iniPropArray[29].setDefaultValue(new Integer(this.secondaryAddress));
    }

    public String display() {
        if (!this.isvalid()) {
            return this.invalidDisplay();
        }
        return String.valueOf(Instrument.LINESEP) + "   VISA-GPIB-VXI Object Using " + this.info[2] + " Adaptor : " + this.name + Instrument.LINESEP + Instrument.LINESEP + "   Communication Address " + Instrument.LINESEP + "      ChassisIndex:       " + this.chassisIndex + Instrument.LINESEP + "      LogicalAddress:     " + this.logicalAddress + Instrument.LINESEP + Instrument.LINESEP + "   Communication State " + Instrument.LINESEP + "      Status:             " + Instrument.STATUS_ENUM[this.status] + Instrument.LINESEP + "      RecordStatus:       " + Instrument.RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + Instrument.LINESEP + Instrument.LINESEP + "   Read/Write State  " + Instrument.LINESEP + "      TransferStatus:     " + Instrument.TRANSFER_STATUS_ENUM[this.transferStatus] + Instrument.LINESEP + "      BytesAvailable:     " + this.bytesAvailable + Instrument.LINESEP + "      ValuesReceived:     " + this.valuesReceived + Instrument.LINESEP + "      ValuesSent:         " + this.valuesSent + Instrument.LINESEP + " " + Instrument.LINESEP;
    }

    public String setDisplay() {
        return "    ByteOrder: [ {littleEndian} | bigEndian ] " + Instrument.LINESEP + "    BytesAvailableAction" + Instrument.LINESEP + "    BytesAvailableActionCount" + Instrument.LINESEP + "    BytesAvailableActionMode: [ {eosCharCode} | byte ]" + Instrument.LINESEP + "    ErrorAction" + Instrument.LINESEP + "    InputBufferSize" + Instrument.LINESEP + "    Name" + Instrument.LINESEP + "    OutputBufferSize" + Instrument.LINESEP + "    OutputEmptyAction" + Instrument.LINESEP + "    RecordDetail: [ {compact} | verbose ]" + Instrument.LINESEP + "    RecordMode: [ {overwrite} | append | index ]" + Instrument.LINESEP + "    RecordName" + Instrument.LINESEP + "    Tag" + Instrument.LINESEP + "    Timeout" + Instrument.LINESEP + "    TimerAction" + Instrument.LINESEP + "    TimerPeriod" + Instrument.LINESEP + "    UserData" + Instrument.LINESEP + "    " + Instrument.LINESEP + "    VISA-GPIB-VXI specific properties:" + Instrument.LINESEP + "    ChassisIndex" + Instrument.LINESEP + "    CompareBits" + Instrument.LINESEP + "    EOIMode: [ {on} | off ]" + Instrument.LINESEP + "    EOSCharCode" + Instrument.LINESEP + "    EOSMode: [ {none} | read | write | read&write ]" + Instrument.LINESEP + "    LogicalAddress" + Instrument.LINESEP + " " + Instrument.LINESEP;
    }
}

