/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.IniEvent;
import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.VISA;
import java.io.IOException;
import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.Vector;

abstract class Vxi
extends Instrument {
    protected static final int NONE = 0;
    protected static final int READ = 1;
    protected static final int A16 = 0;
    protected static final int A16_A24 = 1;
    protected static final int A16_A32 = 2;
    protected static final int EOIMODE = 200;
    protected static final int EOSMODE = 201;
    protected static final int INTERRUPTACTION = 202;
    protected static final int TIMEOUT = 203;
    protected static final int TRIGGERACTION = 204;
    protected static final int TRIGGERLINE = 205;
    protected static final int MEMORY_BASE = 206;
    protected static final int MEMORY_SIZE = 207;
    protected static final int MEMORY_SPACE = 208;
    protected static final int SLOT = 209;
    protected static final int BOARDINDEX = 210;
    protected static final int PRIMARY_ADDRESS = 211;
    protected static final int SECONDARY_ADDRESS = 212;
    protected static final int ADAPTOR_DLL_NAME = 0;
    protected static final int ADAPTOR_DLL_VERSION = 1;
    protected static final int ADAPTOR_NAME = 2;
    protected static final int VENDOR_DRIVER_NAME = 3;
    protected static final int VENDOR_DRIVER_DESCRIPTION = 4;
    protected static final int VENDOR_DRIVER_VERSION = 5;
    protected static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription", "vendordriverversion"};
    protected static final String[] ADDRESS_SPACE_DESC = new String[]{"A16", "A24", "A32"};
    protected static final int SUCCESS = 0;
    protected int chassisIndex;
    protected int compareBits = 8;
    protected boolean eoiMode = true;
    protected int eosCharCode = 10;
    protected int eosMode = 0;
    protected int logicalAddress;
    protected String mappedMemoryBase = "0H";
    protected int mappedMemorySize;
    protected String memoryBase = "0H";
    protected int memorySize;
    protected int memorySpace = 0;
    protected String rsrcName = "";
    protected int slot;
    protected VISA visaobj;
    protected byte[] eosCharByteArray = new byte[1];
    protected int address;
    protected int mappedMemorySpace;
    protected int valuesToOutput;
    protected Vector dataReadLength = new Vector();
    protected int previousReadAction = 0;
    protected Object[] info = new Object[6];
    protected boolean readingFromHardware = false;
    protected double writeStopTime;
    protected int readId;
    protected int writeId;
    protected int oldTransferStatus = 0;
    protected static final Object[] comVals = new Object[]{new Double(8.0)};
    protected static final String[] dModeVals = new String[]{"eosCharCode", "byte"};
    protected static final Object[] eosCVals = new Object[]{new Double(0.0), new Double(255.0)};
    protected static final String[] EOSMVals = new String[]{"none", "read", "write", "read&write"};
    protected static final String[] MSpVals = new String[]{"A16", "A16/A24", "A16/A32"};
    protected static final String[] TranSVals = new String[]{"idle", "read", "write"};

    public final void setChassisIndex(int n) throws IniException {
        if (this.status == 1) {
            this.displayError("ChassisIndex cannot be set while OBJ is open.");
        }
        this.chassisIndex = n;
        this.updateNameProperties();
    }

    public final int getChassisIndex() {
        return this.chassisIndex;
    }

    public final void setCompareBits(int n) throws IniException {
        if (n != 8) {
            this.displayError("CompareBits could not be set to the specified value.");
        }
        if (this.status == 0) {
            this.compareBits = n;
            return;
        }
        try {
            this.setHardwareCompareBits(n);
            this.compareBits = n;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final int getCompareBits() {
        return this.compareBits;
    }

    public final void setEOIMode(boolean bl) throws IniException {
        if (this.status == 0) {
            this.eoiMode = bl;
            return;
        }
        try {
            this.setHardwareEOIMode(bl);
            this.eoiMode = bl;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final boolean getEOIMode() {
        return this.eoiMode;
    }

    public final void setEOSCharCode(int n) throws IniException {
        if (!this.verifySetRange(n, 0, 255)) {
            this.displayError("EOSCharCode must range between 0 and 255.");
        }
        if (this.status == 0) {
            this.eosCharCode = n;
            this.eosCharByteArray[0] = (byte)n;
            return;
        }
        try {
            this.setHardwareEOSChar(n);
            this.eosCharCode = n;
            this.eosCharByteArray[0] = (byte)this.eosCharCode;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final int getEOSCharCode() {
        return this.eosCharCode;
    }

    public final void setEOSMode(int n) throws IniException {
        if (this.status == 0) {
            this.eosMode = n;
            return;
        }
        try {
            this.setHardwareEOSMode(n);
            this.eosMode = n;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final int getEOSMode() {
        return this.eosMode;
    }

    public void setLogicalAddress(int n) throws IniException {
        if (this.status == 1) {
            this.displayError("LogicalAddress cannot be set while OBJ is open.");
        }
        this.logicalAddress = n;
        this.updateNameProperties();
    }

    public int getLogicalAddress() {
        return this.logicalAddress;
    }

    public void setMappedMemoryBase(String string) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("MappedMemoryBase"));
    }

    public String getMappedMemoryBase() {
        return this.mappedMemoryBase;
    }

    public void setMappedMemorySize(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("MappedMemorySize"));
    }

    public int getMappedMemorySize() {
        return this.mappedMemorySize;
    }

    public void setMemoryBase(String string) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("MemoryBase"));
    }

    public String getMemoryBase() {
        return this.memoryBase;
    }

    public void setMemorySize(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("MemorySize"));
    }

    public int getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySpace(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("MemorySpace"));
    }

    public int getMemorySpace() {
        return this.memorySpace;
    }

    public void setRsrcName(String string) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("RsrcName"));
    }

    public String getRsrcName() {
        return this.rsrcName;
    }

    public void setSlot(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("Slot"));
    }

    public int getSlot() {
        return this.slot;
    }

    protected void setHardwareCompareBits(int n) {
    }

    protected void setHardwareEOIMode(boolean bl) throws IniException {
        int n = this.visaobj.Set(this.handle, 200, this.bool2int(bl));
        if (n < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
    }

    protected void setHardwareEOSChar(int n) throws IniException {
        int n2 = 0;
        switch (this.eosMode) {
            case 0: {
                n2 = this.visaobj.Set(this.handle, 201, -1);
                break;
            }
            case 1: 
            case 3: {
                n2 = this.visaobj.Set(this.handle, 201, n);
                break;
            }
            case 2: {
                n2 = 0;
            }
        }
        if (n2 < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n2));
        }
    }

    protected void setHardwareEOSMode(int n) throws IniException {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = this.visaobj.Set(this.handle, 201, -1);
                break;
            }
            case 1: 
            case 3: {
                n2 = this.visaobj.Set(this.handle, 201, this.eosCharCode);
                break;
            }
            case 2: {
                n2 = 0;
            }
        }
        if (n2 < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n2));
        }
    }

    protected void getHardwareMemoryBase() throws IniException {
        int n = this.visaobj.Get(this.handle, 206);
        if (n < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
        this.memoryBase = String.valueOf(Integer.toHexString(n)) + "H";
    }

    protected void getHardwareMemorySize() throws IniException {
        int n = this.visaobj.Get(this.handle, 207);
        if (n < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
        this.memorySize = n;
    }

    protected void getHardwareMemorySpace() throws IniException {
        int n = this.visaobj.Get(this.handle, 208);
        if (n < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
        this.memorySpace = n - 1;
    }

    protected void getHardwareSlot() throws IniException {
        int n = this.visaobj.Get(this.handle, 209);
        if (n < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
        this.slot = n;
    }

    protected void setHardwareTimeout(double d) throws IniException {
        int n;
        if (d < 0.001) {
            this.displayError("Timeout must be greater than or equal to 1ms.");
        }
        if (d > 1000.0) {
            this.displayError("Timeout must be less than or equal to 1000s.");
        }
        if ((n = this.visaobj.Set(this.handle, 203, (int)(d * 1000.0))) < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
    }

    protected double getHardwareTimeout() {
        int n = this.visaobj.Get(this.handle, 203);
        return (double)n / 1000.0;
    }

    protected void getPropertyValuesUponConnecting() throws IniException {
        this.getHardwareMemoryBase();
        this.getHardwareMemorySize();
        this.getHardwareMemorySpace();
        this.getHardwareSlot();
    }

    protected void updateWriteTransferStatus(boolean bl) {
        if (bl) {
            this.transferStatus = 2;
            return;
        }
        this.transferStatus = 0;
    }

    protected void hardwareStopAsync() {
        this.oldTransferStatus = this.transferStatus;
        this.hardwareFlushOutputVector();
        switch (this.oldTransferStatus) {
            case 1: {
                this.visaobj.StopAsync(this.handle, this.readId);
                break;
            }
            case 2: {
                this.visaobj.StopAsync(this.handle, this.writeId);
                break;
            }
            default: {
                return;
            }
        }
        this.transferStatus = 0;
    }

    public final Object[] constructorargs() {
        String string = (String)this.info[0];
        int n = string.lastIndexOf(Instrument.FILESEP);
        Object[] objectArray = new Object[]{string.substring(0, n), string.substring(n + 1), this.rsrcName};
        return objectArray;
    }

    protected void hardwareFlushInput() {
        this.dataReadLength.removeAllElements();
    }

    protected void hardwareFlushOutput() throws IniException {
        this.oldTransferStatus = this.transferStatus;
        this.hardwareFlushOutputVector();
        switch (this.oldTransferStatus) {
            case 2: {
                this.visaobj.StopAsync(this.handle, this.writeId);
                break;
            }
        }
        this.transferStatus = 0;
    }

    protected void hardwareFlushOutputVector() {
        try {
            this.flushOutputVector();
        }
        catch (Exception exception) {}
        this.bytesToOutput = 0;
        this.transferStatus = 0;
    }

    protected void verifyWriteOperation() throws IniException {
        if (this.writeTransferMode == 1 && !this.visaobj.VerifyAsyncVISAWrite()) {
            this.displayError("Asynchronous operation is not supported for Agilent " + this.type.toUpperCase() + " objects.");
        }
        if (this.transferStatus == 2) {
            this.displayError("An asynchronous write is already in progress.");
            return;
        }
        if (this.transferStatus == 1) {
            this.displayError("An asynchronous read is already in progress.");
        }
    }

    protected void verifyReadOperation() throws IniException {
        if (!this.visaobj.VerifyAsyncVISARead()) {
            this.displayError("Asynchronous operation is not supported for Agilent " + this.type.toUpperCase() + " objects.");
        }
        if (this.transferStatus == 2) {
            this.displayError("An asynchronous write is already in progress.");
        } else if (this.transferStatus == 1) {
            this.displayError("An asynchronous read is already in progress.");
        }
        this.transferStatus = 1;
    }

    public final synchronized void pollingRead() {
        int n;
        int n2;
        this.transferStatus = 1;
        this.readingFromHardware = true;
        if (this.bytesAvailableActionMode == 1) {
            n2 = this.bytesAvailableActionCount - this.bytesAvailable % this.bytesAvailableActionCount;
            if (n2 > this.readAsyncCount) {
                n2 = this.readAsyncCount;
            }
        } else {
            n2 = this.readAsyncCount;
        }
        if ((n = this.visaobj.ReadBinaryByteAsync(this.handle, n2)) < 0) {
            this.transferStatus = 0;
            this.readAsyncCount = 0;
            this.readingFromHardware = false;
            this.readAsyncStopTime = 0.0;
            this.executeErrorEvent(Calendar.getInstance(), "VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
            return;
        }
        this.readId = n;
    }

    public final synchronized void pollingWrite() throws Exception {
        try {
            this.getDoubleFromOutputVector();
            int n = this.getIntFromOutputVector();
            Object object = this.getObjectFromOutputVector();
            byte[] byArray = null;
            byArray = Instrument.platform != this.byteOrder ? BinarySwapBytes.breakdownToBytesAndSwap(object, n) : BinarySwapBytes.breakdownToBytes(object, n);
            int n2 = this.visaobj.WriteBinaryByteAsync(this.handle, byArray, byArray.length);
            if (n2 < 0) {
                this.transferStatus = 0;
                this.bytesToOutput = 0;
                this.valuesSent += this.valuesToOutput;
                this.executeErrorEvent(Calendar.getInstance(), "VISA: " + this.visaobj.TranslateErrorCode(this.handle, n2));
                return;
            }
            this.writeId = n2;
            this.writeStopTime = (double)System.currentTimeMillis() + this.timeout * 1000.0;
            this.valuesToOutput = byArray.length / Instrument.DATASIZE[n];
            return;
        }
        catch (Exception exception) {
            this.hardwareFlushOutputVector();
            this.executeErrorEvent(Calendar.getInstance(), "VISA: Error while writing data.");
            return;
        }
    }

    protected synchronized void pollReadActionSuccess(int n) {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {}
        byte[] byArray = this.visaobj.GetAsyncReadData(this.handle, n);
        this.fillInBuffer(byArray, this.eosCharByteArray, byArray.length);
        this.readAsyncCount = 0;
        this.readingFromHardware = false;
        this.readAsyncStopTime = 0.0;
        if (this.previousReadAction == 0 || this.dataReadLength.size() == 0) {
            this.dataReadLength.addElement(new Integer(byArray.length));
        } else {
            int n2 = (Integer)this.dataReadLength.lastElement();
            this.dataReadLength.setElementAt(new Integer(n2 + byArray.length), this.dataReadLength.size() - 1);
        }
        this.previousReadAction = 0;
        this.transferStatus = 0;
    }

    protected synchronized void pollReadActionSize(int n) {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {}
        byte[] byArray = this.visaobj.GetAsyncReadData(this.handle, n);
        this.fillInBuffer(byArray, this.eosCharByteArray, byArray.length);
        this.readingFromHardware = false;
        if (this.previousReadAction == 0 || this.dataReadLength.size() == 0) {
            this.dataReadLength.addElement(new Integer(byArray.length));
        } else {
            int n2 = (Integer)this.dataReadLength.lastElement();
            this.dataReadLength.setElementAt(new Integer(n2 + byArray.length), this.dataReadLength.size() - 1);
        }
        this.previousReadAction = 1;
        if (this.readAsyncCount == 0) {
            this.transferStatus = 0;
            this.readAsyncStopTime = 0.0;
        }
    }

    protected synchronized void pollWriteAction() {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {}
        this.bytesToOutput = 0;
        this.valuesSent += this.valuesToOutput;
        this.transferStatus = 0;
        if (!this.outputEmptyAction.equals(Instrument.ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(4, "OutputEmpty", this.eventTime, new IniEvent("OutputEmpty", Instrument.constructClockVector(this.eventTime)));
        }
    }

    protected synchronized void checkForAsynchronousTimeouts() {
        if ((double)System.currentTimeMillis() > this.readAsyncStopTime && this.transferStatus == 1) {
            try {
                this.hardwareStopAsync();
            }
            catch (Exception exception) {}
            this.readAsyncCount = 0;
            this.transferStatus = 0;
            this.readingFromHardware = false;
            this.executeErrorEvent(Calendar.getInstance(), "The asynchronous read operation timed out.");
        }
        if ((double)System.currentTimeMillis() > this.writeStopTime && this.transferStatus == 2) {
            try {
                this.hardwareStopAsync();
            }
            catch (Exception exception) {}
            this.bytesToOutput = 0;
            this.transferStatus = 0;
            this.executeErrorEvent(Calendar.getInstance(), "The asynchronous write operation timed out.");
        }
    }

    protected String getAsciiMessage(Object[] objectArray) {
        String string = "";
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof String) {
                string = String.valueOf(string) + (String)objectArray[n];
            } else if (objectArray[n] instanceof Character) {
                string = String.valueOf(string) + (Character)objectArray[n];
            } else {
                switch (this.eosMode) {
                    case 2: 
                    case 3: {
                        string = String.valueOf(string) + new Character((char)this.eosCharCode);
                    }
                }
            }
            ++n;
        }
        return string;
    }

    protected Object[] writeHardwareAscii(String string) throws IniException {
        switch (this.writeTransferMode) {
            case 1: {
                return this.writeHardwareAsciiAsync(string);
            }
            case 0: {
                return this.writeHardwareAsciiSync(string);
            }
        }
        throw new IniException("Invalid TransferMode specified.");
    }

    protected Object[] writeHardwareAsciiAsync(String string) {
        byte[] byArray = string.getBytes();
        try {
            this.putDataInOutputVector(byArray, byArray.length, 0);
        }
        catch (IOException iOException) {
            this.hardwareFlushOutputVector();
            this.executeErrorEvent(Calendar.getInstance(), "Error occurred while writing data to the output buffer.");
        }
        Object[] objectArray = new Object[]{string, new Integer(0), ""};
        return objectArray;
    }

    protected Object[] writeHardwareAsciiSync(String string) {
        Object[] objectArray = new Object[3];
        int n = this.visaobj.Write(this.handle, string, string.length());
        if (n < 0) {
            objectArray[0] = "";
            objectArray[1] = Instrument.INTEGER_ZERO;
            objectArray[2] = "VISA: " + this.visaobj.TranslateErrorCode(this.handle, n);
        } else {
            objectArray[0] = string;
            objectArray[1] = new Integer(n);
            objectArray[2] = "";
        }
        return objectArray;
    }

    protected Object[] writeHardwareBinary(Object object, int n, int n2) throws IniException {
        switch (this.writeTransferMode) {
            case 1: {
                return this.writeHardwareBinaryAsync(object, n, n2);
            }
            case 0: {
                return this.writeHardwareBinarySync(object, n, n2);
            }
        }
        throw new IniException("Invalid TransferMode specified.");
    }

    protected Object[] writeHardwareBinaryAsync(Object object, int n, int n2) {
        try {
            this.putDataInOutputVector(object, n, n2);
        }
        catch (IOException iOException) {
            this.hardwareFlushOutputVector();
            this.executeErrorEvent(Calendar.getInstance(), "Error occurred while writing data to the output buffer.");
        }
        Object[] objectArray = new Object[]{Instrument.INTEGER_ZERO, ""};
        return objectArray;
    }

    protected Object[] writeHardwareBinarySync(Object object, int n, int n2) {
        int n3 = 0;
        n3 = Instrument.platform != this.byteOrder ? this.writeSwappedBytes(object, n, n2) : this.writeBytes(object, n, n2);
        Object[] objectArray = new Object[2];
        if (n3 < 0) {
            objectArray[0] = Instrument.INTEGER_ZERO;
            objectArray[1] = "VISA: " + this.visaobj.TranslateErrorCode(this.handle, n3);
        } else {
            objectArray[0] = new Integer(n3);
            objectArray[1] = "";
        }
        return objectArray;
    }

    private int writeSwappedBytes(Object object, int n, int n2) {
        Object object2 = null;
        try {
            object2 = BinarySwapBytes.swap(object, n2, n);
        }
        catch (Exception exception) {
            return -1;
        }
        switch (n2) {
            case 0: 
            case 5: {
                return this.visaobj.WriteBinaryByte(this.handle, (byte[])object2, n);
            }
            case 1: {
                return this.visaobj.WriteBinaryShort(this.handle, (short[])object2, n);
            }
            case 2: {
                return this.visaobj.WriteBinaryInt(this.handle, (int[])object2, n);
            }
            case 3: {
                return this.visaobj.WriteBinaryFloat(this.handle, (float[])object2, n);
            }
            case 4: {
                return this.visaobj.WriteBinaryDouble(this.handle, (double[])object2, n);
            }
        }
        return -1;
    }

    protected int writeBytes(Object object, int n, int n2) {
        if (object instanceof byte[]) {
            return this.visaobj.WriteBinaryByte(this.handle, (byte[])object, n);
        }
        if (object instanceof Byte) {
            return this.visaobj.WriteBinaryByte(this.handle, Instrument.object2byteArray(object), n);
        }
        if (object instanceof short[]) {
            return this.visaobj.WriteBinaryShort(this.handle, (short[])object, n);
        }
        if (object instanceof Short) {
            return this.visaobj.WriteBinaryShort(this.handle, this.object2shortArray(object), n);
        }
        if (object instanceof int[]) {
            return this.visaobj.WriteBinaryInt(this.handle, (int[])object, n);
        }
        if (object instanceof Integer) {
            return this.visaobj.WriteBinaryInt(this.handle, this.object2intArray(object), n);
        }
        if (object instanceof float[]) {
            return this.visaobj.WriteBinaryFloat(this.handle, (float[])object, n);
        }
        if (object instanceof Float) {
            return this.visaobj.WriteBinaryFloat(this.handle, this.object2floatArray(object), n);
        }
        if (object instanceof double[]) {
            return this.visaobj.WriteBinaryDouble(this.handle, (double[])object, n);
        }
        if (object instanceof Double) {
            return this.visaobj.WriteBinaryDouble(this.handle, this.object2doubleArray(object), n);
        }
        return -1;
    }

    protected Object[] readHardwareAscii(int n) throws Exception {
        Object[] objectArray = new Object[2];
        String string = "";
        double d = (double)System.currentTimeMillis() + this.timeout * 1000.0;
        int n2 = n;
        if (n == 0) {
            n2 = this.readAsyncCount;
        }
        if (this.dataReadLength.size() == 0) {
            while (this.readAsyncCount > 0 && this.bytesAvailable < n2 && (double)System.currentTimeMillis() < d) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        if (this.dataReadLength.size() != 0) {
            objectArray = this.readAsciiDataFromBuffer(objectArray, "", n);
            if (this.dataReadLength.size() >= 1 || this.dataReadLength.size() == 0 && this.previousReadAction == 0) {
                return objectArray;
            }
            string = (String)objectArray[0];
        }
        int n3 = 0;
        n3 = n == 0 ? this.inputBufferSize - string.length() : n - string.length();
        while (this.readAsyncCount > 0 && this.bytesAvailable < n3 && (double)System.currentTimeMillis() < d) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        if (this.dataReadLength.size() != 0) {
            objectArray = this.readAsciiDataFromBuffer(objectArray, string, n);
            if (this.dataReadLength.size() >= 1 || this.dataReadLength.size() == 0 && this.previousReadAction == 0) {
                return objectArray;
            }
            string = (String)objectArray[0];
        }
        if ((double)System.currentTimeMillis() > d) {
            objectArray[0] = string;
            objectArray[1] = this.reportTimeout(n);
            return objectArray;
        }
        n3 = n == 0 ? this.inputBufferSize - string.length() : n - string.length();
        if (n3 == 0) {
            objectArray[1] = this.wasAsciiReadSuccessful((String)objectArray[0], n, 0);
            return objectArray;
        }
        Object[] objectArray2 = this.visaobj.Read(this.handle, n3);
        if (!(objectArray2[0] instanceof String)) {
            Calendar.getInstance();
            objectArray[0] = string;
            objectArray[1] = "VISA: " + this.visaobj.TranslateErrorCode(this.handle, (Integer)objectArray2[0]);
            return objectArray;
        }
        objectArray[0] = String.valueOf(string) + (String)objectArray2[0];
        objectArray[1] = this.wasAsciiReadSuccessful(String.valueOf(string) + (String)objectArray2[0], n, (Integer)objectArray2[1]);
        return objectArray;
    }

    protected Object[] readAsciiDataFromBuffer(Object[] objectArray, String string, int n) throws Exception {
        int n2 = (Integer)this.dataReadLength.firstElement();
        if (n == 0) {
            objectArray[0] = String.valueOf(string) + this.readInBufferAscii(n2);
            objectArray[1] = "";
            this.dataReadLength.removeElementAt(0);
        } else if (n2 < n) {
            objectArray[0] = String.valueOf(string) + this.readInBufferAscii(n2);
            objectArray[1] = this.wasAsciiReadSuccessful((String)objectArray[0], n, 1);
            this.dataReadLength.removeElementAt(0);
        } else if (n2 == n) {
            objectArray[0] = String.valueOf(string) + this.readInBufferAscii(n);
            objectArray[1] = "";
            this.dataReadLength.removeElementAt(0);
        } else {
            objectArray[0] = String.valueOf(string) + this.readInBufferAscii(n);
            objectArray[1] = "";
            this.dataReadLength.setElementAt(new Integer(n2 - n), 0);
        }
        return objectArray;
    }

    protected String removeTerminator(String string) {
        switch (this.eosMode) {
            case 1: 
            case 3: {
                Character c = new Character((char)this.eosCharCode);
                if (string.endsWith(c.toString())) {
                    return string.substring(0, string.length() - 1);
                }
                return string;
            }
        }
        return string;
    }

    protected Object[] readHardwareBinary(int n, int n2) throws Exception {
        int n3 = Instrument.DATASIZE[n2];
        int n4 = n * n3;
        double d = (double)System.currentTimeMillis() + this.timeout * 1000.0;
        Object[] objectArray = new Object[3];
        String string = "";
        while (this.readAsyncCount > 0 && this.bytesAvailable < n4 && (double)System.currentTimeMillis() < d) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        if (this.dataReadLength.size() > 1 || this.dataReadLength.size() == 1 && this.previousReadAction == 0) {
            int n5 = (Integer)this.dataReadLength.firstElement();
            int n6 = 0;
            if (n5 >= n4) {
                n6 = n4;
            } else {
                int n7 = n5 / n3;
                n6 = n7 * n3;
            }
            byte[] byArray = this.readBinaryDataFromBuffer(n6);
            objectArray[0] = this.convertBinaryData(byArray, n2, n6);
            objectArray[1] = new Integer(n6 / n3);
            objectArray[2] = this.wasBinaryReadSuccessful(n6 / n3, n, "");
            return objectArray;
        }
        int n8 = 0;
        n8 = this.bytesAvailable >= n4 ? 0 : n4 - this.bytesAvailable;
        if (n8 != 0) {
            Object[] objectArray2 = this.visaobj.ReadBinary(this.handle, n8, 0);
            if (objectArray2.length != 1) {
                byte[] byArray = (byte[])objectArray2[0];
                int n9 = (Integer)objectArray2[1];
                int n10 = (Integer)objectArray2[2];
                this.fillInBuffer(byArray, n9);
                if (this.previousReadAction == 0 || this.dataReadLength.size() == 0) {
                    this.dataReadLength.addElement(new Integer(n9));
                } else {
                    int n11 = (Integer)this.dataReadLength.lastElement();
                    this.dataReadLength.setElementAt(new Integer(n11 + n9), this.dataReadLength.size() - 1);
                }
                this.previousReadAction = n10 == 1 ? 0 : 1;
            } else {
                string = "VISA: " + this.visaobj.TranslateErrorCode(this.handle, (Integer)objectArray2[0]);
            }
        }
        int n12 = 0;
        if (this.bytesAvailable >= n4) {
            n12 = n4;
        } else {
            int n13 = this.bytesAvailable / n3;
            n12 = n13 * n3;
        }
        byte[] byArray = this.readBinaryDataFromBuffer(n12);
        objectArray[0] = this.convertBinaryData(byArray, n2, n12);
        objectArray[1] = new Integer(n12 / n3);
        objectArray[2] = this.wasBinaryReadSuccessful(n12 / n3, n, string);
        return objectArray;
    }

    protected byte[] readBinaryDataFromBuffer(int n) throws Exception {
        byte[] byArray = null;
        try {
            int n2 = (Integer)this.dataReadLength.firstElement();
            if (n2 <= n) {
                byArray = this.readInBuffer(n2);
                this.dataReadLength.removeElementAt(0);
            } else {
                byArray = this.readInBuffer(n);
                this.dataReadLength.setElementAt(new Integer(n2 - n), 0);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return byArray;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    protected Object convertBinaryData(byte[] byArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            return null;
        }
        if (Instrument.platform == this.byteOrder) {
            switch (Instrument.platform) {
                case 1: {
                    return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
                }
                case 0: {
                    return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
                }
                default: {
                    throw new IniException("Invalid ByteOrder specified.");
                }
            }
        }
        switch (Instrument.platform) {
            case 1: {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
            case 0: {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
        }
        throw new IniException("Invalid ByteOrder specified.");
    }

    protected String wasAsciiReadSuccessful(String string, int n, int n2) {
        String string2 = new Character((char)this.eosCharCode).toString();
        String string3 = "";
        switch (n) {
            case 0: {
                if (n2 != 0 || string.length() != this.inputBufferSize) break;
                if (this.eosMode == 1 || this.eosMode == 3) {
                    string3 = "The input buffer was filled before the EOI line was asserted or the EOSCharCode was detected.";
                    break;
                }
                string3 = "The input buffer was filled before the EOI line was asserted.";
                break;
            }
            default: {
                if (string.length() == n) break;
                if (string.endsWith(string2)) {
                    if (this.eosMode == 1 || this.eosMode == 3) {
                        string3 = "The EOSCharCode was detected before SIZE values were available.";
                        break;
                    }
                    string3 = "The EOI line was asserted before SIZE values were available.";
                    break;
                }
                string3 = "The EOI line was asserted before SIZE values were available.";
            }
        }
        return string3;
    }

    protected String wasBinaryReadSuccessful(int n, int n2, String string) {
        if (!string.equals("")) {
            return string;
        }
        if (n < n2) {
            if (this.eosMode == 1 || this.eosMode == 3) {
                return "The EOI line was asserted or the EOSCharCode was detected before SIZE values were available.";
            }
            return "The EOI line was asserted before SIZE values were available.";
        }
        return "";
    }

    protected String reportTimeout(int n) {
        if (n == 0) {
            return "A timeout occurred before the EOI line was asserted.";
        }
        if (this.eosMode == 1 || this.eosMode == 3) {
            return "A timeout occurred before the EOI line was asserted, EOSCharCode was read" + Instrument.LINESEP + " or SIZE values were available.";
        }
        return "A timeout occurred before the EOI line was asserted or SIZE values were available.";
    }

    public void clrdevice() throws IniException {
        int n;
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            this.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if ((n = this.visaobj.Clear(this.handle)) < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
    }

    public void memunmap() throws IniException {
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            return;
        }
        if (this.mappedMemorySize == 0) {
            return;
        }
        int n = this.visaobj.UnMapAddress(this.handle);
        if (n < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
        this.mappedMemorySize = 0;
        this.mappedMemoryBase = "0H";
    }

    public void memmap(int n, int n2, int n3) throws IniException {
        int n4;
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            this.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if (this.mappedMemorySize != 0) {
            this.displayError("Memory has been mapped. Type 'instrhelp memmap' for more information.");
        }
        if ((n4 = this.visaobj.MapAddress(this.handle, n, n2, n3)) < 0) {
            this.displayError("VISA: Unable to map the specified address space.");
        }
        this.address = n4;
        this.mappedMemorySpace = n - 1;
        this.mappedMemorySize = n3;
        this.mappedMemoryBase = String.valueOf(Integer.toHexString(this.address)) + "H";
    }

    public Object mempeek(int n, int n2) throws IniException {
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            this.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if (this.mappedMemorySize == 0) {
            this.displayError("Memory must be mapped with the MEMMAP function.");
        }
        ++this.valuesReceived;
        Object object = this.visaobj.MemoryPeek(this.handle, n2, this.address, n);
        if (this.recordStatus) {
            try {
                this.binarySign = 0;
                String string = ", " + ADDRESS_SPACE_DESC[this.mappedMemorySpace] + " space, " + n + " offset";
                this.appendBinaryDataToFile(object, 1, n2, "<", string);
            }
            catch (Exception exception) {}
            ++this.numCommandsWritten;
        }
        return object;
    }

    public void mempoke(Object object, int n, int n2) throws IniException {
        Object object2;
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            this.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if (this.mappedMemorySize == 0) {
            this.displayError("Memory must be mapped with the MEMMAP function.");
        }
        switch (n) {
            case 0: {
                object2 = (Byte)object;
                this.visaobj.MemoryPokeByte(this.handle, this.address, n2, (Byte)object2);
                break;
            }
            case 1: {
                Short s = (Short)object;
                this.visaobj.MemoryPokeShort(this.handle, this.address, n2, s);
                break;
            }
            case 2: {
                Integer n3 = (Integer)object;
                this.visaobj.MemoryPokeInt(this.handle, this.address, n2, n3);
                break;
            }
        }
        if (this.recordStatus) {
            try {
                this.binarySign = 0;
                object2 = ", " + ADDRESS_SPACE_DESC[this.mappedMemorySpace] + " space, " + n2 + " offset";
                this.appendBinaryDataToFile(object, 1, n, ">", (String)object2);
            }
            catch (Exception exception) {}
            ++this.numCommandsWritten;
        }
        ++this.valuesSent;
    }

    public Object memread(int n, int n2, int n3, int n4) throws IniException {
        Object[] objectArray;
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            this.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if (n4 * Instrument.DATASIZE[n3] > this.inputBufferSize) {
            this.displayError("SIZE*PRECISION must be less than or equal to InputBufferSize.");
        }
        if ((objectArray = this.visaobj.MemRead(this.handle, n, n2, n4, n3))[0] instanceof String) {
            Integer n5 = (Integer)objectArray[1];
            String string = this.visaobj.TranslateErrorCode(this.handle, n5);
            if (string.indexOf("timeout") != -1) {
                string = "The specified data could not be read most likely due to a bus error.";
            }
            throw new IniException("VISA: " + string);
        }
        this.valuesReceived += n4;
        if (this.recordStatus) {
            try {
                this.binarySign = 0;
                String string = ", " + ADDRESS_SPACE_DESC[n - 1] + " space, " + n2 + " offset";
                this.appendBinaryDataToFile(objectArray[0], n4, n3, "<", string);
            }
            catch (Exception exception) {}
            ++this.numCommandsWritten;
        }
        return objectArray[0];
    }

    public void memwrite(int n, Object object, int n2, int n3, int n4) throws IniException {
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            this.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if (n4 * Instrument.DATASIZE[n3] > this.outputBufferSize) {
            this.displayError("The length(DATA)*PRECISION must be less than or equal to OutputBufferSize.");
        }
        int n5 = 0;
        switch (n3) {
            case 0: {
                if (object instanceof Byte) {
                    n5 = this.visaobj.MemWriteByte(this.handle, n, Instrument.object2byteArray(object), n2);
                    break;
                }
                n5 = this.visaobj.MemWriteByte(this.handle, n, (byte[])object, n2);
                break;
            }
            case 1: {
                if (object instanceof Short) {
                    n5 = this.visaobj.MemWriteShort(this.handle, n, this.object2shortArray(object), n2);
                    break;
                }
                n5 = this.visaobj.MemWriteShort(this.handle, n, (short[])object, n2);
                break;
            }
            case 2: {
                if (object instanceof Integer) {
                    n5 = this.visaobj.MemWriteInt(this.handle, n, this.object2intArray(object), n2);
                    break;
                }
                n5 = this.visaobj.MemWriteInt(this.handle, n, (int[])object, n2);
                break;
            }
        }
        if (n5 < 0) {
            this.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n5));
        }
        if (this.recordStatus) {
            try {
                this.binarySign = 0;
                String string = ", " + ADDRESS_SPACE_DESC[n - 1] + " space, " + n2 + " offset";
                this.appendBinaryDataToFile(object, n4, n3, ">", string);
            }
            catch (Exception exception) {}
            ++this.numCommandsWritten;
        }
        this.valuesSent += n4;
    }

    public Object ObjectHardwareInfo() {
        this.info[3] = (String)this.visaobj.HardwareInfo(this.handle, 3);
        this.info[4] = (String)this.visaobj.HardwareInfo(this.handle, 4);
        Integer n = (Integer)this.visaobj.HardwareInfo(0, 5);
        this.info[5] = Vxi.constructVersionString(n);
        return this.info;
    }

    private static Double constructVersionString(int n) {
        String string = Integer.toHexString(n);
        int n2 = string.length();
        Integer.valueOf(string.substring(0, n2 - 4)).intValue();
        int n3 = Integer.valueOf(string.substring(0, n2 - 4));
        int n4 = Integer.valueOf(string.substring(n2 - 4, n2));
        return Double.valueOf(String.valueOf(n3 /= 10) + "." + n4);
    }

    public Object[] ObjectHardwareInfo(String[] stringArray) throws IniException {
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.findPropertyCompleteName(stringArray[n].toLowerCase(), HWINFO_FIELDS, stringArray[n]);
            if (this.info[n2] == null) {
                this.ObjectHardwareInfo();
            }
            objectArray[n] = this.info[n2];
            ++n;
        }
        return objectArray;
    }

    abstract void updateNameProperties();

    Vxi() {
    }
}

