/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.IniEvent;
import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.IniProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.Serial;
import com.mathworks.toolbox.instrument.SerialComm;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.VisaAGILENT;
import com.mathworks.toolbox.instrument.VisaNI;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

public final class SerialVisa
extends Serial
implements ActionListener,
AutoConvertStringToMatlabChar {
    private static final int BAUDRATE = 0;
    private static final int DATABITS = 1;
    private static final int PARITY = 2;
    private static final int STOPBITS = 3;
    private static final int FLOWCONTROL = 4;
    private static final int TERMINATOR = 5;
    private static final int DATA_TERMINAL_READY = 6;
    private static final int REQUEST_TO_SEND = 7;
    private static final int TIMEOUT = 8;
    private static final int CARRIER_DETECT = 9;
    private static final int CLEAR_TO_SEND = 10;
    private static final int DATA_SET_READY = 11;
    private static final int RING_INDICATOR = 12;
    private static final int DATA_AVAILABLE = 13;
    private static final int ADAPTOR_DLL_NAME = 0;
    private static final int ADAPTOR_DLL_VERSION = 1;
    private static final int ADAPTOR_NAME = 2;
    private static final int VENDOR_DRIVER_NAME = 3;
    private static final int VENDOR_DRIVER_DESCRIPTION = 4;
    private static final int VENDOR_DRIVER_VERSION = 5;
    private static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription", "vendordriverversion"};
    private static final int FLOW_CTRL_NONE = 0;
    private static final int FLOW_CTRL_SOFT = 1;
    private static final int FLOW_CTRL_HARD = 2;
    private static final int SUCCESS = 0;
    private static final String[] visaAdaptors = new String[]{"mwagilentvisa", "mwnivisa"};
    private static final String[] visaName = new String[]{"agilent", "ni"};
    private String rsrcName = "";
    VISA visa;
    private int defaultRM;
    private Object[] info = new Object[6];
    private boolean readingFromHardware = false;
    private boolean writingToHardware = false;
    private int valuesToOutput;
    private double writeStopTime;
    private byte[] byteData;
    private int outputCount;
    private int datatype;
    private int chunkSize = 40;
    private byte[] dataOutput;
    private int writeId;
    private static final String[] TermVals = new String[]{"CR", "LF"};
    private static final Object[] StopVals = new Object[]{new Double(1.0), new Double(2.0)};
    static IniProp[] objectIniProps = new IniProp[]{new IniProp("BaudRate", "double", "none", "", new Integer(9600), "never", 1), new IniProp("ByteOrder", "string", "enum", Instrument.byteOVals, "littleEndian", "never", 0), new IniProp("BytesAvailable", "double", "none", "", new Integer(0), "always", 0), new IniProp("BytesAvailableAction", "action", "action", "", "", "never", 0), new IniProp("BytesAvailableActionCount", "double", "none", "", new Integer(48), "whileOpen", 0), new IniProp("BytesAvailableActionMode", "string", "enum", Serial.dModeVals, "terminator", "whileOpen", 0), new IniProp("BytesToOutput", "double", "none", "", new Integer(0), "always", 0), new IniProp("DataBits", "double", "bounded", Serial.dBitVals, new Integer(8), "never", 1), new IniProp("DataTerminalReady", "string", "enum", Instrument.boolVals, "on", "never", 1), new IniProp("ErrorAction", "action", "action", "", "", "never", 0), new IniProp("FlowControl", "string", "enum", Serial.flowVals, "none", "never", 1), new IniProp("InputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("Name", "string", "none", "", "", "never", 0), new IniProp("OutputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("OutputEmptyAction", "action", "action", "", "", "never", 0), new IniProp("Parity", "string", "enum", Serial.ParVals, "none", "never", 1), new IniProp("PinStatus", "struct", "none", "", Serial.pss, "always", 1), new IniProp("Port", "string", "none", "", "", "whileOpen", 1), new IniProp("ReadAsyncMode", "string", "enum", Serial.AsyncVals, "continuous", "never", 1), new IniProp("RecordDetail", "string", "enum", Instrument.RDetVals, "compact", "never", 0), new IniProp("RecordMode", "string", "enum", Instrument.RModeVals, "overwrite", "whileRecording", 0), new IniProp("RecordName", "string", "none", "", "record.txt", "whileRecording", 0), new IniProp("RecordStatus", "string", "enum", Instrument.boolVals, "off", "always", 0), new IniProp("RequestToSend", "string", "enum", Instrument.boolVals, "on", "never", 1), new IniProp("RsrcName", "string", "none", "", "", "always", 1), new IniProp("Status", "string", "enum", Instrument.StatVals, "closed", "always", 0), new IniProp("StopBits", "double", "bounded", StopVals, new Integer(1), "never", 1), new IniProp("Tag", "string", "none", "", "", "never", 0), new IniProp("Terminator", "string", "enum", TermVals, "LF", "never", 1), new IniProp("Timeout", "double", "none", "", new Integer(10), "never", 0), new IniProp("TimerAction", "action", "action", "", "", "never", 0), new IniProp("TimerPeriod", "double", "none", "", new Integer(1), "whileOpen", 0), new IniProp("TransferStatus", "string", "enum", Serial.TranSVals, "idle", "always", 0), new IniProp("Type", "string", "none", "", "visa-serial", "always", 0), new IniProp("UserData", "any", "none", "", new double[0], "never", 0), new IniProp("ValuesReceived", "double", "none", "", new Integer(0), "always", 0), new IniProp("ValuesSent", "double", "none", "", new Integer(0), "always", 0)};
    static final int NAME = 12;
    static final int PORT = 17;
    static final int RSRCNAME = 24;

    public void setRsrcName(String string) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("RsrcName"));
    }

    public String getRsrcName() {
        return this.rsrcName;
    }

    protected void setHardwareBaudRate(int n) throws IniException {
        int n2 = this.visa.Set(this.handle, 0, n);
        if (n2 < 0) {
            this.displayError("VISA: BaudRate could not be set to the specified value.");
        }
    }

    protected void setHardwareDataBits(int n) throws IniException {
        int n2 = this.visa.Set(this.handle, 1, n);
        if (n2 < 0) {
            this.displayError("VISA: DataBits could not be set to the specified value.");
        }
    }

    protected void setHardwareDataTerminalReady(boolean bl) throws IniException {
        int n = this.visa.Set(this.handle, 6, this.bool2int(bl));
        if (n < 0) {
            this.displayError("VISA: DataTerminalReady could not be set to the specified value.");
        }
    }

    protected boolean getHardwareDataTerminalReady() {
        return this.int2bool(this.visa.Get(this.handle, 6));
    }

    protected void setHardwareFlowControl(int n) throws IniException {
        int n2 = 1;
        switch (n) {
            case 0: {
                n2 = this.visa.Set(this.handle, 4, 0);
                break;
            }
            case 1: {
                n2 = this.visa.Set(this.handle, 4, 2);
                break;
            }
            case 2: {
                n2 = this.visa.Set(this.handle, 4, 1);
                break;
            }
        }
        if (n2 < 0) {
            this.displayError("VISA: FlowControl could not be set to the specified value.");
        }
    }

    protected void nameStandardFormat() {
        if (this.name.equals("VISA-Serial-" + this.port)) {
            this.nameStandardFormat = true;
            return;
        }
        this.nameStandardFormat = false;
    }

    protected void setHardwareParity(int n) throws IniException {
        int n2 = this.visa.Set(this.handle, 2, n);
        if (n2 < 0) {
            this.displayError("VISA: Parity could not be set to the specified value.");
        }
    }

    protected String getHardwareCarrierDetect() {
        return this.int2OnOff(this.visa.Get(this.handle, 9));
    }

    protected String getHardwareClearToSend() {
        return this.int2OnOff(this.visa.Get(this.handle, 10));
    }

    protected String getHardwareDataSetReady() {
        return this.int2OnOff(this.visa.Get(this.handle, 11));
    }

    protected String getHardwareRingIndicator() {
        return this.int2OnOff(this.visa.Get(this.handle, 12));
    }

    protected void setHardwarePort() {
        this.rsrcName = String.valueOf(this.port.toUpperCase()) + "::INSTR";
        if (this.nameStandardFormat) {
            this.name = "VISA-Serial-" + this.port;
        }
    }

    protected void setHardwareRequestToSend(boolean bl) throws IniException {
        int n = this.visa.Set(this.handle, 7, this.bool2int(bl));
        if (n < 0) {
            this.displayError("VISA: RequestToSend could not be set to the specified value.");
        }
    }

    protected boolean getHardwareRequestToSend() {
        return this.int2bool(this.visa.Get(this.handle, 7));
    }

    protected void setHardwareStopBits(double d) throws IniException {
        int n = this.visa.Set(this.handle, 3, (int)d * 10);
        if (n < 0) {
            this.displayError("VISA: StopBits could not be set to the specified value.");
        }
    }

    protected double[] getValidStopBits() {
        double[] dArray = new double[]{1.0, 2.0};
        return dArray;
    }

    protected void setHardwareTerminator(int n) throws IniException {
        int n2 = 13;
        switch (n) {
            case 0: {
                n2 = 13;
                break;
            }
            case 1: {
                n2 = 10;
                break;
            }
        }
        int n3 = this.visa.Set(this.handle, 5, n2);
        if (n3 < 0) {
            this.displayError("VISA: Terminator could not be set to the specified value.");
        }
    }

    protected void setHardwareTimeout(double d) throws IniException {
        int n;
        if (d < 0.001) {
            this.displayError("Timeout must be greater than or equal to 1ms.");
        }
        if ((n = this.visa.Set(this.handle, 8, (int)(d * 1000.0))) < 0) {
            this.displayError("VISA: Timeout could not be set to the specified value.");
        }
    }

    protected double getHardwareTimeout() {
        int n = this.visa.Get(this.handle, 8);
        return (double)n / 1000.0;
    }

    public SerialVisa() {
        this.deleteInstrumentObject(this);
    }

    public SerialVisa(String string, String string2, String string3) throws IniException {
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'visa'.");
        }
        try {
            boolean bl = this.verifyName(string3);
            if (!bl) {
                this.displayError("Invalid RSRCNAME specified. Type 'instrhelp visa' for more information.");
            }
            this.info[0] = String.valueOf(string) + Instrument.FILESEP + string2;
            this.info[1] = Instrument.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.type = "visa-serial";
            this.name = "VISA-Serial-" + this.port;
            this.objectProps = objectIniProps;
            return;
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new IniException(exception.getMessage());
        }
    }

    private boolean verifyName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return false;
        }
        String string2 = n == 4 ? "ASRL1" : string.substring(0, n);
        int n2 = this.str2num(string2.substring(4));
        if (n2 < 0) {
            return false;
        }
        if (!string.substring(n + 2, string.length()).equals("INSTR")) {
            return false;
        }
        this.rsrcName = String.valueOf(string2) + "::INSTR";
        this.port = string2;
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        this.executeEvent(6, "Timer", this.eventTime, new IniEvent("Timer", Instrument.constructClockVector(this.eventTime)));
    }

    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "SerialVisaTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    protected void openHardware() throws IniException {
        if (SerialVisa.isInUse(this.port)) {
            this.displayError("The specified configuration: " + this.rsrcName + " is not available. " + Instrument.LINESEP + "Use INSTRHWINFO for a list of available ports. Use INSTRFIND to determine" + Instrument.LINESEP + "if other instrument objects are connected to the requested instrument.");
        }
        boolean bl = false;
        try {
            SerialComm.freeSerial(this.convertVISAToSerial(this.port));
        }
        catch (IniException iniException) {
            bl = true;
        }
        int[] nArray = this.visa.Create(this, this.rsrcName);
        if (nArray != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
            return;
        }
        if (bl) {
            this.displayError("The specified configuration: " + this.rsrcName + " is not available. " + "Use INSTRFIND" + Instrument.LINESEP + "to determine if other instrument objects are " + "connected to the requested instrument.");
            return;
        }
        this.displayError("The specified configuration: " + this.rsrcName + " is not available. " + Instrument.LINESEP + "Use INSTRHWINFO for a list of available ports. Use INSTRFIND to determine" + Instrument.LINESEP + "if other instrument objects are connected to the requested instrument.");
    }

    protected String convertVISAToSerial(String string) {
        return "COM" + string.substring(4);
    }

    protected void addToPoller() {
        Poller.addInstrument(this);
        if (this.timerAction != Instrument.ACTION) {
            if (!this.wasTimerStarted) {
                this.createTimer();
                return;
            }
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        }
    }

    protected void closeHardware() throws IniException {
        Poller.removeInstrument(this);
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        try {
            this.setHardwareFlowControl(0);
        }
        catch (IniException iniException) {}
        int n = this.visa.Close(this.handle, this.defaultRM);
        if (n < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    private static boolean isInUse(String string) {
        int n = 0;
        while (n < Instrument.allInstrumentObjects.size()) {
            Object e = Instrument.allInstrumentObjects.elementAt(n);
            if (e instanceof SerialVisa) {
                SerialVisa serialVisa = (SerialVisa)e;
                if (serialVisa.port.equals(string) && serialVisa.status == 1) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    protected void hardwareStopAsync() throws IniException {
        this.readAsyncMode = 1;
        this.updateReadTransferStatus(false);
        this.hardwareFlushOutput();
    }

    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
    }

    public final Object[] constructorargs() {
        String string = (String)this.info[0];
        int n = string.lastIndexOf(Instrument.FILESEP);
        Object[] objectArray = new Object[]{string.substring(0, n), string.substring(n + 1), this.rsrcName};
        return objectArray;
    }

    protected void hardwareFlushInput() {
        try {
            int n = this.visa.Get(this.handle, 13);
            this.visa.Read(this.handle, n);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void hardwareFlushOutput() {
        try {
            this.flushOutputVector();
        }
        catch (Exception exception) {}
        this.updateWriteTransferStatus(false);
        this.byteData = null;
        this.outputCount = 0;
        this.bytesToOutput = 0;
    }

    public final void poll() {
        try {
            double d = System.currentTimeMillis() + 100L;
            while ((double)System.currentTimeMillis() < d && this.visa.Get(this.handle, 13) != 0 && this.inputBufferSize - this.bytesAvailable > 0 && (this.readAsyncMode == 0 || this.readAsyncMode == 1 && this.readAsyncCount > 0)) {
                this.pollingRead();
            }
            if (this.transferStatus == 2 || this.transferStatus == 3) {
                this.pollingWrite();
            }
            if ((double)System.currentTimeMillis() > this.writeStopTime && this.bytesToOutput > 0 && this.transferStatus == 2) {
                this.hardwareFlushOutput();
                if (this.transferStatus == 2 || this.transferStatus == 3) {
                    this.visa.StopAsync(this.handle, 2);
                    this.updateWriteTransferStatus(false);
                }
                this.bytesToOutput = 0;
                this.transferStatus = 0;
                this.executeErrorEvent(Calendar.getInstance(), "The asynchronous write operation timed out.");
            }
            if ((double)System.currentTimeMillis() > this.readAsyncStopTime && this.readAsyncCount > 0) {
                this.readAsyncCount = 0;
                this.updateReadTransferStatus(false);
                if (this.readAsyncMode == 1) {
                    this.executeErrorEvent(Calendar.getInstance(), "The asynchronous read operation timed out.");
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }

    private void pollingWrite() throws Exception {
        Object object;
        int n;
        if (this.byteData == null) {
            this.getDoubleFromOutputVector();
            n = this.getIntFromOutputVector();
            object = this.getObjectFromOutputVector();
            this.byteData = Instrument.platform != this.byteOrder ? BinarySwapBytes.breakdownToBytesAndSwap(object, n) : BinarySwapBytes.breakdownToBytes(object, n);
            this.writeStopTime = (double)System.currentTimeMillis() + this.timeout * 1000.0;
            this.datatype = n;
            this.chunkSize = 16;
            if (this.baudRate > 2500) {
                this.chunkSize = 40;
            } else if (this.baudRate > 10000) {
                this.chunkSize = 80;
            } else if (this.baudRate > 30000) {
                this.chunkSize = 160;
            } else if (this.baudRate > 60000) {
                this.chunkSize = 320;
            } else if (this.baudRate > 100000) {
                this.chunkSize = 640;
            } else if (this.baudRate > 120000) {
                this.chunkSize = 1280;
            } else if (this.baudRate > 250000) {
                this.chunkSize = 2560;
            }
            this.dataOutput = new byte[this.chunkSize];
        }
        n = 0;
        while (this.outputCount < this.byteData.length && this.byteData != null && n < this.chunkSize) {
            this.dataOutput[n++] = this.byteData[this.outputCount++];
            --this.bytesToOutput;
        }
        this.valuesSent += n / Instrument.DATASIZE[this.datatype];
        if (n == this.chunkSize) {
            this.writeId = this.visa.WriteBinaryByte(this.handle, this.dataOutput, n);
        } else {
            object = new byte[n];
            System.arraycopy(this.dataOutput, 0, object, 0, n);
            this.writeId = this.visa.WriteBinaryByte(this.handle, (byte[])object, n);
        }
        if (this.writeId < 0) {
            this.transferStatus = 0;
            this.bytesToOutput = 0;
            this.executeErrorEvent(Calendar.getInstance(), "VISA: " + this.visa.TranslateErrorCode(this.handle, this.writeId));
        }
        if (this.outputCount == this.byteData.length) {
            this.bytesToOutput = 0;
            this.updateWriteTransferStatus(false);
            this.valuesToOutput = 0;
            this.byteData = null;
            this.outputCount = 0;
            if (!this.outputEmptyAction.equals(Instrument.ACTION)) {
                this.eventTime = Calendar.getInstance();
                this.executeEvent(4, "OutputEmpty", this.eventTime, new IniEvent("OutputEmpty", Instrument.constructClockVector(this.eventTime)));
            }
        }
    }

    protected Object[] writeHardwareAsciiSync(String string) {
        this.updateWriteTransferStatus(true);
        int n = this.visa.Write(this.handle, string, string.length());
        this.updateWriteTransferStatus(false);
        Object[] objectArray = new Object[3];
        if (n < 0) {
            objectArray[0] = "";
            objectArray[1] = new Integer(0);
            objectArray[2] = "VISA: " + this.visa.TranslateErrorCode(this.handle, n);
        } else {
            objectArray[0] = string;
            objectArray[1] = new Integer(n);
            objectArray[2] = "";
        }
        return objectArray;
    }

    protected Object[] writeHardwareBinarySync(Object object, int n, int n2) {
        this.updateWriteTransferStatus(true);
        int n3 = 0;
        n3 = Instrument.platform != this.byteOrder ? this.writeSwappedBytes(object, n, n2) : this.writeBytes(object, n, n2);
        this.updateWriteTransferStatus(false);
        Object[] objectArray = new Object[2];
        if (n3 < 0) {
            objectArray[0] = Instrument.INTEGER_ZERO;
            objectArray[1] = "VISA: " + this.visa.TranslateErrorCode(this.handle, n3);
        } else {
            objectArray[0] = new Integer(n3);
            objectArray[1] = "";
        }
        return objectArray;
    }

    private int writeSwappedBytes(Object object, int n, int n2) {
        Object object2 = null;
        try {
            object2 = BinarySwapBytes.swap(object, n2, n);
        }
        catch (Exception exception) {
            return -1;
        }
        switch (n2) {
            case 0: 
            case 5: {
                return this.visa.WriteBinaryByte(this.handle, (byte[])object2, n);
            }
            case 1: {
                return this.visa.WriteBinaryShort(this.handle, (short[])object2, n);
            }
            case 2: {
                return this.visa.WriteBinaryInt(this.handle, (int[])object2, n);
            }
            case 3: {
                return this.visa.WriteBinaryFloat(this.handle, (float[])object2, n);
            }
            case 4: {
                return this.visa.WriteBinaryDouble(this.handle, (double[])object2, n);
            }
        }
        return -1;
    }

    private int writeBytes(Object object, int n, int n2) {
        if (object instanceof byte[]) {
            return this.visa.WriteBinaryByte(this.handle, (byte[])object, n);
        }
        if (object instanceof Byte) {
            return this.visa.WriteBinaryByte(this.handle, Instrument.object2byteArray(object), n);
        }
        if (object instanceof short[]) {
            return this.visa.WriteBinaryShort(this.handle, (short[])object, n);
        }
        if (object instanceof Short) {
            return this.visa.WriteBinaryShort(this.handle, this.object2shortArray(object), n);
        }
        if (object instanceof int[]) {
            return this.visa.WriteBinaryInt(this.handle, (int[])object, n);
        }
        if (object instanceof Integer) {
            return this.visa.WriteBinaryInt(this.handle, this.object2intArray(object), n);
        }
        if (object instanceof float[]) {
            return this.visa.WriteBinaryFloat(this.handle, (float[])object, n);
        }
        if (object instanceof Float) {
            return this.visa.WriteBinaryFloat(this.handle, this.object2floatArray(object), n);
        }
        if (object instanceof double[]) {
            return this.visa.WriteBinaryDouble(this.handle, (double[])object, n);
        }
        if (object instanceof Double) {
            return this.visa.WriteBinaryDouble(this.handle, this.object2doubleArray(object), n);
        }
        return -1;
    }

    protected int numAvailableFromHardware() {
        return this.visa.Get(this.handle, 13);
    }

    protected String readAsciiFromHardware(int n, double d) {
        Object[] objectArray = this.visa.Read(this.handle, n);
        if (objectArray.length == 2) {
            return (String)objectArray[0];
        }
        return "";
    }

    protected String readBinaryFromHardware(int n) {
        Object[] objectArray = this.visa.ReadBinary(this.handle, n, 0);
        if (objectArray.length != 1) {
            this.fillInBuffer((byte[])objectArray[0]);
            return "";
        }
        return "VISA: " + this.visa.TranslateErrorCode(this.handle, (Integer)objectArray[0]);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    protected Object convertBinaryData(byte[] byArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            return null;
        }
        if (Instrument.platform == this.byteOrder) {
            switch (Instrument.platform) {
                case 1: {
                    return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
                }
                case 0: {
                    return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
                }
                default: {
                    throw new IniException("Invalid ByteOrder specified.");
                }
            }
        }
        switch (Instrument.platform) {
            case 1: {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
            case 0: {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
        }
        throw new IniException("Invalid ByteOrder specified.");
    }

    protected void fillInBufferFromHardware(int n, byte[] byArray) {
        Object[] objectArray = this.visa.ReadBinary(this.handle, n, 0);
        byte[] byArray2 = (byte[])objectArray[0];
        this.fillInBuffer(byArray2, byArray);
    }

    protected void fillInBufferUntilTerminator(int n) {
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = this.visa.ReadBinary(this.handle, 1, 0);
            byte[] byArray = (byte[])objectArray[0];
            if (byArray[0] == this.terminatorByte[0]) {
                this.fillInBuffer(byArray, this.terminatorByte);
                this.readAsyncCount = 0;
                this.updateReadTransferStatus(false);
                return;
            }
            this.fillInBuffer(byArray, this.terminatorByte);
            ++n2;
        }
    }

    public static String[] findValidAdaptors(String string) throws IniException {
        Object object;
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            throw new IniException("Undefined function or variable 'instrhwinfo'.");
        }
        String[] stringArray = new String[2];
        int n = 0;
        String string2 = Instrument.platform == 0 ? ".dll" : ".so";
        try {
            object = new VisaAGILENT(String.valueOf(string) + Instrument.FILESEP + visaAdaptors[0] + string2);
            stringArray[n++] = visaName[0];
            object = null;
        }
        catch (SecurityException securityException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {}
        try {
            object = new VisaNI(String.valueOf(string) + Instrument.FILESEP + visaAdaptors[1] + string2);
            stringArray[n++] = visaName[1];
            object = null;
        }
        catch (SecurityException securityException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {}
        object = new String[n];
        System.arraycopy(stringArray, 0, object, 0, n);
        return object;
    }

    public Object[] hardwareInfoOnAdaptorAndVendor(String string, String string2) {
        Object[] objectArray = new Object[11];
        objectArray[0] = string;
        objectArray[1] = Instrument.jarVersion();
        objectArray[2] = string2.toUpperCase();
        objectArray[8] = (String)this.visa.HardwareInfo(0, 3);
        objectArray[9] = (String)this.visa.HardwareInfo(0, 4);
        Integer n = (Integer)this.visa.HardwareInfo(0, 5);
        objectArray[10] = SerialVisa.constructVersionString(n);
        return objectArray;
    }

    public Object[] hardwareInfoOnSerial(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.visa.FindSerial();
        if (objectArray2 == null) {
            objectArray[4] = "";
            objectArray[7] = "";
        } else {
            objectArray[7] = SerialVisa.parseAvailableSerialHardware(objectArray2);
            objectArray[4] = SerialVisa.findSerialNotInUse((String[])objectArray[7]);
        }
        Object[] objectArray3 = null;
        if (objectArray2 != null) {
            objectArray3 = (String[])objectArray[4];
        }
        objectArray[6] = SerialVisa.createConstructorCommand(string2, objectArray3, null, null, null);
        return objectArray;
    }

    public Object[] hardwareInfoOnGPIB(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.visa.FindGPIB();
        objectArray[5] = SerialVisa.parseAvailableGPIBHardware(objectArray2);
        objectArray[6] = SerialVisa.createConstructorCommand(string2, null, objectArray2, null, null);
        return objectArray;
    }

    public Object[] hardwareInfoOnGPIBVXI(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.visa.FindGPIBVXI();
        objectArray[3] = SerialVisa.parseAvailableVXIHardware(null, objectArray2);
        objectArray[6] = SerialVisa.createConstructorCommand(string2, null, null, null, objectArray2);
        return objectArray;
    }

    public Object[] hardwareInfoOnVXI(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.visa.FindVXI();
        objectArray[3] = SerialVisa.parseAvailableVXIHardware(objectArray2, null);
        objectArray[6] = SerialVisa.createConstructorCommand(string2, null, null, objectArray2, null);
        return objectArray;
    }

    public Object[] hardwareInfo(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.visa.FindVXI();
        Object[] objectArray3 = this.visa.FindGPIBVXI();
        objectArray[3] = SerialVisa.parseAvailableVXIHardware(objectArray2, objectArray3);
        Object[] objectArray4 = this.visa.FindGPIB();
        objectArray[5] = SerialVisa.parseAvailableGPIBHardware(objectArray4);
        Object[] objectArray5 = this.visa.FindSerial();
        if (objectArray5 == null) {
            objectArray[4] = "";
            objectArray[7] = "";
        } else {
            objectArray[7] = SerialVisa.parseAvailableSerialHardware(objectArray5);
            objectArray[4] = SerialVisa.findSerialNotInUse((String[])objectArray[7]);
        }
        Object[] objectArray6 = null;
        if (objectArray5 != null) {
            objectArray6 = (String[])objectArray[4];
        }
        objectArray[6] = SerialVisa.createConstructorCommand(string2, objectArray6, objectArray4, objectArray2, objectArray3);
        return objectArray;
    }

    private static String[] parseAvailableSerialHardware(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            String string = (String)objectArray[n2];
            n = string.indexOf("::");
            stringArray[n2] = string.substring(0, n);
            ++n2;
        }
        return stringArray;
    }

    private static double[] parseAvailableGPIBHardware(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int[] nArray = new int[objectArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            String string = (String)objectArray[n2];
            n = string.indexOf("::");
            nArray[n2] = Integer.valueOf(string.substring(4, n));
            ++n2;
        }
        return SerialVisa.unique(nArray);
    }

    private static double[] parseAvailableVXIHardware(Object[] objectArray, Object[] objectArray2) {
        String string;
        int n = 0;
        int n2 = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        if (objectArray2 != null) {
            n2 = objectArray2.length;
        }
        if (n + n2 == 0) {
            return null;
        }
        int[] nArray = new int[n + n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            string = (String)objectArray[n5];
            n3 = string.indexOf("::");
            nArray[n4++] = Integer.valueOf(string.substring(3, n3));
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            string = (String)objectArray2[n6];
            n3 = string.indexOf("::");
            nArray[n4++] = Integer.valueOf(string.substring(8, n3));
            ++n6;
        }
        return SerialVisa.unique(nArray);
    }

    private static String[] findSerialNotInUse(String[] stringArray) {
        boolean bl = true;
        int n = 0;
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            bl = SerialVisa.isInUse(stringArray[n2]);
            if (!bl) {
                stringArray2[n++] = stringArray[n2];
            }
            ++n2;
        }
        String[] stringArray3 = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray3[n3] = stringArray2[n3];
            ++n3;
        }
        return stringArray3;
    }

    private static String[] createConstructorCommand(String string, Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Object[] objectArray4) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        if (objectArray2 != null) {
            n2 = objectArray2.length;
        }
        if (objectArray3 != null) {
            n3 = objectArray3.length;
        }
        if (objectArray4 != null) {
            n4 = objectArray4.length;
        }
        String[] stringArray = new String[n + n2 + n3 + n4];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            stringArray[n5++] = "visa('" + string + "', '" + (String)objectArray[n6] + "::INSTR');";
            ++n6;
        }
        int n7 = 0;
        while (n7 < n2) {
            stringArray[n5++] = "visa('" + string + "', '" + objectArray2[n7] + "');";
            ++n7;
        }
        int n8 = 0;
        while (n8 < n3) {
            stringArray[n5++] = "visa('" + string + "', '" + objectArray3[n8] + "');";
            ++n8;
        }
        int n9 = 0;
        while (n9 < n4) {
            stringArray[n5++] = "visa('" + string + "', '" + objectArray4[n9] + "');";
            ++n9;
        }
        return stringArray;
    }

    private static Double constructVersionString(int n) {
        String string = Integer.toHexString(n);
        int n2 = string.length();
        Integer.valueOf(string.substring(0, n2 - 4)).intValue();
        int n3 = Integer.valueOf(string.substring(0, n2 - 4));
        int n4 = Integer.valueOf(string.substring(n2 - 4, n2));
        return Double.valueOf(String.valueOf(n3 /= 10) + "." + n4);
    }

    private static double[] unique(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] > n) {
                n = nArray[n2];
            }
            ++n2;
        }
        int[] nArray2 = new int[n + 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray2[nArray[n4]] == 0) {
                nArray2[nArray[n4]] = 1;
                ++n3;
            }
            ++n4;
        }
        double[] dArray = new double[n3];
        n3 = 0;
        int n5 = 0;
        while (n5 < nArray2.length) {
            if (nArray2[n5] != 0) {
                dArray[n3++] = n5;
            }
            ++n5;
        }
        return dArray;
    }

    public Object ObjectHardwareInfo() {
        this.info[3] = (String)this.visa.HardwareInfo(this.handle, 3);
        this.info[4] = (String)this.visa.HardwareInfo(this.handle, 4);
        Integer n = (Integer)this.visa.HardwareInfo(this.handle, 5);
        this.info[5] = SerialVisa.constructVersionString(n);
        return this.info;
    }

    public Object[] ObjectHardwareInfo(String[] stringArray) throws IniException {
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.findPropertyCompleteName(stringArray[n].toLowerCase(), HWINFO_FIELDS, stringArray[n]);
            if (this.info[n2] == null) {
                this.ObjectHardwareInfo();
            }
            objectArray[n] = this.info[n2];
            ++n;
        }
        return objectArray;
    }

    protected void updateObjectSpecificProperties(IniProp[] iniPropArray) {
        iniPropArray[12].setDefaultValue("VISA-Serial-" + this.port);
        iniPropArray[17].setDefaultValue(this.port);
        iniPropArray[24].setDefaultValue(this.rsrcName);
    }

    public String display() {
        if (!this.isvalid()) {
            return this.invalidDisplay();
        }
        return String.valueOf(Instrument.LINESEP) + "   VISA-Serial Object Using " + this.info[2] + " Adaptor : " + this.name + Instrument.LINESEP + Instrument.LINESEP + "   Communication Settings " + Instrument.LINESEP + "      Port:               " + this.port + Instrument.LINESEP + "      BaudRate:           " + this.baudRate + Instrument.LINESEP + "      Terminator:         " + Serial.terminatorEnum[this.terminator] + Instrument.LINESEP + Instrument.LINESEP + "   Communication State " + Instrument.LINESEP + "      Status:             " + Instrument.STATUS_ENUM[this.status] + Instrument.LINESEP + "      RecordStatus:       " + Instrument.RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + Instrument.LINESEP + Instrument.LINESEP + "   Read/Write State  " + Instrument.LINESEP + "      TransferStatus:     " + Instrument.TRANSFER_STATUS_ENUM[this.transferStatus] + Instrument.LINESEP + "      BytesAvailable:     " + this.bytesAvailable + Instrument.LINESEP + "      ValuesReceived:     " + this.valuesReceived + Instrument.LINESEP + "      ValuesSent:         " + this.valuesSent + Instrument.LINESEP + " " + Instrument.LINESEP;
    }

    public String setDisplay() throws Exception {
        return "    ByteOrder: [ {littleEndian} | bigEndian ] " + Instrument.LINESEP + "    BytesAvailableAction" + Instrument.LINESEP + "    BytesAvailableActionCount" + Instrument.LINESEP + "    BytesAvailableActionMode: [ {terminator} | byte ]" + Instrument.LINESEP + "    ErrorAction" + Instrument.LINESEP + "    InputBufferSize" + Instrument.LINESEP + "    Name" + Instrument.LINESEP + "    OutputBufferSize" + Instrument.LINESEP + "    OutputEmptyAction" + Instrument.LINESEP + "    RecordDetail: [ {compact} | verbose ]" + Instrument.LINESEP + "    RecordMode: [ {overwrite} | append | index ]" + Instrument.LINESEP + "    RecordName" + Instrument.LINESEP + "    Tag" + Instrument.LINESEP + "    Timeout" + Instrument.LINESEP + "    TimerAction" + Instrument.LINESEP + "    TimerPeriod" + Instrument.LINESEP + "    UserData" + Instrument.LINESEP + "    " + Instrument.LINESEP + "    VISA-SERIAL specific properties:" + Instrument.LINESEP + "    BaudRate" + Instrument.LINESEP + "    DataBits" + Instrument.LINESEP + "    DataTerminalReady: [ {on} | off ]" + Instrument.LINESEP + "    FlowControl: [ {none} | hardware | software ]" + Instrument.LINESEP + "    Parity: [ {none} | odd | even | mark | space ]" + Instrument.LINESEP + "    Port" + Instrument.LINESEP + "    ReadAsyncMode: [ {continuous} | manual ]" + Instrument.LINESEP + "    RequestToSend: [ {on} | off ]" + Instrument.LINESEP + "    StopBits" + Instrument.LINESEP + "    Terminator: [ CR | {LF} ]" + Instrument.LINESEP + " " + Instrument.LINESEP;
    }
}

