/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.IniEvent;
import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.IniProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.LineInputStream;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.Serial;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public final class SerialComm
extends Serial
implements SerialPortEventListener,
ActionListener {
    private static final int NO_FLOWCONTROL = 0;
    private static final int SOFTWARE_FLOWCONTROL = 12;
    private static final int HARDWARE_FLOWCONTROL = 3;
    private static final String[] ALLPORTS = SerialComm.findAllPorts();
    private static final int JAR_FILE_VERSION = 0;
    private static final String[] HWINFO_FIELDS = new String[]{"jarfileversion"};
    protected MLArrayRef pinStatusAction = Instrument.ACTION;
    protected MLArrayRef breakInterruptAction = Instrument.ACTION;
    private String portName;
    private CommPortIdentifier portId;
    private SerialPort serialPort;
    private InputStreamReader reader;
    private LineInputStream lineInputStream;
    private InputStream inputStream;
    private DataInputStream dataInputStream;
    private OutputStream outputStream;
    private OutputStreamWriter outputStreamWriter;
    private DataOutputStream dataOutputStream;
    private String[] info = new String[1];
    private double writeStopTime;
    private byte[] byteData;
    private int outputCount;
    private int datatype;
    private int chunkSize = 40;
    protected static Hashtable createdSerialPortTable = new Hashtable();
    private static final String[] TermVals = new String[]{"CR", "LF", "CR/LF", "LF/CR"};
    private static final Object[] StopVals = new Object[]{new Double(1.0), new Double(1.5), new Double(2.0)};
    static IniProp[] objectIniProps = new IniProp[]{new IniProp("BaudRate", "double", "none", "", new Integer(9600), "never", 1), new IniProp("BreakInterruptAction", "action", "action", "", "", "never", 1), new IniProp("ByteOrder", "string", "enum", Instrument.byteOVals, "littleEndian", "never", 0), new IniProp("BytesAvailable", "double", "none", "", new Integer(0), "always", 0), new IniProp("BytesAvailableAction", "action", "action", "", "", "never", 0), new IniProp("BytesAvailableActionCount", "double", "none", "", new Integer(48), "whileOpen", 0), new IniProp("BytesAvailableActionMode", "string", "enum", Serial.dModeVals, "terminator", "whileOpen", 0), new IniProp("BytesToOutput", "double", "none", "", new Integer(0), "always", 0), new IniProp("DataBits", "double", "bounded", Serial.dBitVals, new Integer(8), "never", 1), new IniProp("DataTerminalReady", "string", "enum", Instrument.boolVals, "on", "never", 1), new IniProp("ErrorAction", "action", "action", "", "", "never", 0), new IniProp("FlowControl", "string", "enum", Serial.flowVals, "none", "never", 1), new IniProp("InputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("Name", "string", "none", "", "", "never", 0), new IniProp("OutputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("OutputEmptyAction", "action", "action", "", "", "never", 0), new IniProp("Parity", "string", "enum", Serial.ParVals, "none", "never", 1), new IniProp("PinStatus", "struct", "none", "", Serial.pss, "always", 1), new IniProp("PinStatusAction", "action", "action", "", "", "never", 1), new IniProp("Port", "string", "none", "", "", "whileOpen", 1), new IniProp("ReadAsyncMode", "string", "enum", Serial.AsyncVals, "continuous", "never", 1), new IniProp("RecordDetail", "string", "enum", Instrument.RDetVals, "compact", "never", 0), new IniProp("RecordMode", "string", "enum", Instrument.RModeVals, "overwrite", "whileRecording", 0), new IniProp("RecordName", "string", "none", "", "record.txt", "whileRecording", 0), new IniProp("RecordStatus", "string", "enum", Instrument.boolVals, "off", "always", 0), new IniProp("RequestToSend", "string", "enum", Instrument.boolVals, "on", "never", 1), new IniProp("Status", "string", "enum", Instrument.StatVals, "closed", "always", 0), new IniProp("StopBits", "double", "enum", StopVals, new Integer(1), "never", 1), new IniProp("Tag", "string", "none", "", "", "never", 0), new IniProp("Terminator", "string", "enum", TermVals, "LF", "never", 1), new IniProp("Timeout", "double", "none", "", new Integer(10), "never", 0), new IniProp("TimerAction", "action", "action", "", "", "never", 0), new IniProp("TimerPeriod", "double", "none", "", new Integer(1), "whileOpen", 0), new IniProp("TransferStatus", "string", "enum", Serial.TranSVals, "idle", "always", 0), new IniProp("Type", "string", "none", "", "serial", "always", 0), new IniProp("UserData", "any", "none", "", new double[0], "never", 0), new IniProp("ValuesReceived", "double", "none", "", new Integer(0), "always", 0), new IniProp("ValuesSent", "double", "none", "", new Integer(0), "always", 0)};
    static final int NAME = 13;
    static final int PORT = 19;

    public void setBreakInterruptAction(MLArrayRef mLArrayRef) throws IniException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("BreakInterruptAction", mLArrayRef);
        if (this.breakInterruptAction != Instrument.ACTION) {
            this.breakInterruptAction.dispose();
        }
        this.breakInterruptAction = mLArrayRef2;
        this.enabledCallbacks[0] = 0;
    }

    public MLArrayRef getBreakInterruptAction() {
        return this.breakInterruptAction;
    }

    public final void setPinStatusAction(MLArrayRef mLArrayRef) throws IniException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("PinStatusAction", mLArrayRef);
        if (this.pinStatusAction != Instrument.ACTION) {
            this.pinStatusAction.dispose();
        }
        this.pinStatusAction = mLArrayRef2;
        this.enabledCallbacks[5] = 0;
    }

    public final MLArrayRef getPinStatusAction() {
        return this.pinStatusAction;
    }

    private String fixCommErrorMessage(String string) {
        if (string.indexOf("baud rate") != -1) {
            return "BaudRate could not be set to the specified value.";
        }
        if (string.indexOf("parity") != -1) {
            return "Parity could not be set to the specified value.";
        }
        if (string.indexOf("databits") != -1) {
            return "DataBits could not be set to the specified value.";
        }
        if (string.indexOf("stopbits") != -1) {
            return "StopBits could not be set to the specified value.";
        }
        return "Error while setting the BaudRate, Parity, DataBits and StopBits properties: " + string;
    }

    protected void setHardwareBaudRate(int n) throws IniException {
        try {
            this.serialPort.setSerialPortParams(n, this.dataBits, this.convertStopBits(this.stopBits), this.parity);
            return;
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new IniException(this.fixCommErrorMessage(unsupportedCommOperationException.getMessage()));
        }
    }

    protected void setHardwareDataBits(int n) throws IniException {
        try {
            this.serialPort.setSerialPortParams(this.baudRate, n, this.convertStopBits(this.stopBits), this.parity);
            return;
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new IniException(this.fixCommErrorMessage(unsupportedCommOperationException.getMessage()));
        }
    }

    protected void setHardwareDataTerminalReady(boolean bl) {
        this.serialPort.setDTR(bl);
    }

    protected boolean getHardwareDataTerminalReady() {
        return this.serialPort.isDTR();
    }

    protected void setHardwareFlowControl(int n) throws IniException {
        try {
            switch (n) {
                case 0: {
                    this.serialPort.setFlowControlMode(0);
                    return;
                }
                case 1: {
                    this.serialPort.setFlowControlMode(3);
                    return;
                }
                case 2: {
                    this.serialPort.setFlowControlMode(12);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new IniException("Flowcontrol could not be set to the specified value.");
        }
    }

    protected void nameStandardFormat() {
        if (this.name.equals("Serial-" + this.port)) {
            this.nameStandardFormat = true;
            return;
        }
        this.nameStandardFormat = false;
    }

    protected void setHardwareParity(int n) throws IniException {
        try {
            this.serialPort.setSerialPortParams(this.baudRate, this.dataBits, this.convertStopBits(this.stopBits), n);
            return;
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new IniException(this.fixCommErrorMessage(unsupportedCommOperationException.getMessage()));
        }
    }

    protected String getHardwareCarrierDetect() {
        return this.bool2OnOff(this.serialPort.isCD());
    }

    protected String getHardwareClearToSend() {
        return this.bool2OnOff(this.serialPort.isCTS());
    }

    protected String getHardwareDataSetReady() {
        return this.bool2OnOff(this.serialPort.isDSR());
    }

    protected String getHardwareRingIndicator() {
        return this.bool2OnOff(this.serialPort.isRI());
    }

    protected void setHardwarePort() {
        if (this.nameStandardFormat) {
            this.name = "Serial-" + this.port;
        }
    }

    protected void setHardwareRequestToSend(boolean bl) {
        this.serialPort.setRTS(bl);
    }

    protected boolean getHardwareRequestToSend() {
        return this.serialPort.isRTS();
    }

    protected void setHardwareStopBits(double d) throws IniException {
        try {
            this.serialPort.setSerialPortParams(this.baudRate, this.dataBits, this.convertStopBits(d), this.parity);
            return;
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new IniException(this.fixCommErrorMessage(unsupportedCommOperationException.getMessage()));
        }
    }

    protected double[] getValidStopBits() {
        double[] dArray = new double[]{1.0, 1.5, 2.0};
        return dArray;
    }

    protected int convertStopBits(double d) {
        if (d == 1.5) {
            return 3;
        }
        return (int)d;
    }

    protected void setHardwareTerminator(int n) {
    }

    protected void setHardwareTimeout(double d) {
        this.timeout = d;
    }

    protected double getHardwareTimeout() {
        return this.timeout;
    }

    protected final void addSerialToHashTable(String string, SerialPort serialPort) {
        createdSerialPortTable.put(string.toUpperCase(), serialPort);
    }

    protected static final void removeSerialFromHashTable(String string) {
        createdSerialPortTable.remove(string.toUpperCase());
    }

    protected static final boolean isSerialInHashTable(String string) {
        return createdSerialPortTable.containsKey(string.toUpperCase());
    }

    protected static final SerialPort getSerialPortFromHashTable(String string) {
        return (SerialPort)createdSerialPortTable.get(string.toUpperCase());
    }

    protected final SerialPort createSerialPort(String string) throws NoSuchPortException, PortInUseException {
        if (SerialComm.isSerialInHashTable(string)) {
            return SerialComm.getSerialPortFromHashTable(string);
        }
        this.portId = CommPortIdentifier.getPortIdentifier((String)string);
        SerialPort serialPort = (SerialPort)this.portId.open("MATLAB", 2000);
        this.addSerialToHashTable(string, serialPort);
        return serialPort;
    }

    public static final void freeSerial() throws IniException {
        Enumeration enumeration = createdSerialPortTable.keys();
        while (enumeration.hasMoreElements()) {
            SerialComm.freeSerial((String)enumeration.nextElement());
        }
    }

    public static final void freeSerial(String[] stringArray) throws IniException {
        int n = 0;
        while (n < stringArray.length) {
            SerialComm.freeSerial(stringArray[n]);
            ++n;
        }
    }

    public static final void freeSerial(String string) throws IniException {
        if (SerialComm.isSerialInHashTable(string)) {
            SerialComm serialComm = (SerialComm)SerialComm.objectConnectedToPort(string);
            if (serialComm != null && serialComm.getStatus() == 1) {
                throw new IniException("A serial port object is currently connected to the " + string + " port." + Instrument.LINESEP + "Use FCLOSE to disconnect the object from the port.");
            }
            SerialPort serialPort = SerialComm.getSerialPortFromHashTable(string);
            serialPort.close();
            SerialComm.removeSerialFromHashTable(string);
        }
    }

    public static final Object objectConnectedToPort(String string) {
        if (Instrument.platform == 0) {
            string = string.toUpperCase();
        }
        int n = 0;
        while (n < Instrument.allInstrumentObjects.size()) {
            Object e = Instrument.allInstrumentObjects.elementAt(n);
            if (e instanceof SerialComm) {
                SerialComm serialComm = (SerialComm)e;
                if (serialComm.port.equals(string) && serialComm.status == 1) {
                    return serialComm;
                }
            }
            ++n;
        }
        return null;
    }

    public SerialComm() {
        this.deleteInstrumentObject(this);
    }

    public SerialComm(String string) throws IniException {
        try {
            this.port = Instrument.platform == 0 ? string.toUpperCase() : string;
            this.type = "serial";
            this.name = "Serial-" + this.port;
            this.objectProps = objectIniProps;
            return;
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new IniException(exception.getMessage());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        this.executeEvent(6, "Timer", this.eventTime, new IniEvent("Timer", Instrument.constructClockVector(this.eventTime)));
    }

    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "SerialCommTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    public void openHardware() throws Exception {
        if (!this.isValidPort(this.port) || this.isInUse(this.port)) {
            this.displayError(this.errorSincePortIsInUse());
        }
        try {
            this.serialPort = this.createSerialPort(this.port);
        }
        catch (PortInUseException portInUseException) {
            this.displayError("Cannot connect to the " + this.port + " port. Possible reasons are another" + Instrument.LINESEP + "application is connected to the port or the port does not exist.");
        }
        catch (NoSuchPortException noSuchPortException) {
            this.displayError("Cannot connect to the " + this.port + " port. Possible reasons are another" + Instrument.LINESEP + "application is connected to the port or the port does not exist.");
        }
        this.inputStream = this.serialPort.getInputStream();
        if (this.inputStream != null) {
            this.reader = new InputStreamReader(this.inputStream);
            this.lineInputStream = new LineInputStream(this.inputStream);
            this.dataInputStream = new DataInputStream(this.inputStream);
            this.isSerialPortReadable = true;
        } else {
            this.isSerialPortReadable = false;
        }
        this.outputStream = this.serialPort.getOutputStream();
        if (this.outputStream != null) {
            this.outputStreamWriter = new OutputStreamWriter(this.outputStream);
            this.dataOutputStream = new DataOutputStream(this.outputStream);
            this.isSerialPortWriteable = true;
        } else {
            this.isSerialPortWriteable = false;
        }
        this.serialPort.setInputBufferSize(4096);
        this.serialPort.addEventListener((SerialPortEventListener)this);
        this.serialPort.notifyOnOutputEmpty(true);
        this.serialPort.notifyOnBreakInterrupt(true);
        this.serialPort.notifyOnCarrierDetect(true);
        this.serialPort.notifyOnCTS(true);
        this.serialPort.notifyOnDSR(true);
        this.serialPort.notifyOnRingIndicator(true);
        this.serialPort.notifyOnFramingError(true);
        this.serialPort.notifyOnParityError(true);
        this.serialPort.notifyOnOverrunError(true);
    }

    protected void addToPoller() {
        Poller.addInstrument(this);
        if (this.timerAction != Instrument.ACTION) {
            if (!this.wasTimerStarted) {
                this.createTimer();
                return;
            }
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        }
    }

    public void closeHardware() throws Exception {
        Poller.removeInstrument(this);
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        this.serialPort.notifyOnOutputEmpty(false);
        this.serialPort.notifyOnBreakInterrupt(false);
        this.serialPort.notifyOnCarrierDetect(false);
        this.serialPort.notifyOnCTS(false);
        this.serialPort.notifyOnDSR(false);
        this.serialPort.notifyOnRingIndicator(false);
        this.serialPort.notifyOnFramingError(false);
        this.serialPort.notifyOnParityError(false);
        this.serialPort.notifyOnOverrunError(false);
        this.serialPort.removeEventListener();
        this.setHardwareFlowControl(0);
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.lineInputStream != null) {
            this.lineInputStream.close();
            this.lineInputStream = null;
        }
        if (this.dataInputStream != null) {
            this.dataInputStream.close();
            this.dataInputStream = null;
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        try {
            if (this.dataOutputStream != null) {
                this.dataOutputStream.close();
            }
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            if (this.outputStreamWriter != null) {
                this.outputStreamWriter.close();
            }
        }
        catch (IllegalStateException illegalStateException) {}
        if (Instrument.platform == 1) {
            SerialComm.freeSerial(this.port);
        }
        if (Instrument.platform == 0) {
            if (this.isInUse(this.port.toUpperCase())) {
                this.displayError("Could not disconnect object from hardware.");
                return;
            }
        } else if (this.isInUse(this.port)) {
            this.displayError("Could not disconnect object from hardware.");
        }
    }

    private boolean isInUse(String string) {
        int n = 0;
        while (n < Instrument.allInstrumentObjects.size()) {
            Object e = Instrument.allInstrumentObjects.elementAt(n);
            if (e instanceof SerialComm) {
                SerialComm serialComm = (SerialComm)e;
                if (serialComm.port.equals(string) && serialComm.status == 1) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private boolean isValidPort(String string) {
        int n = 0;
        while (n < ALLPORTS.length) {
            if (string.equals(ALLPORTS[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final String errorSincePortIsInUse() {
        String string = "";
        boolean bl = true;
        int n = 0;
        while (n < ALLPORTS.length) {
            bl = this.isInUse(ALLPORTS[n]);
            if (!bl) {
                string = String.valueOf(string) + ALLPORTS[n] + ", ";
            }
            ++n;
        }
        if (string.length() != 0) {
            string = string.substring(0, string.length() - 2);
            return "Port: " + this.port + " is not available. Available ports: " + string + "." + Instrument.LINESEP + "Use INSTRFIND to determine if " + "other instrument objects are connected to the requested device.";
        }
        return "Port: " + this.port + " is not available. No ports are available." + Instrument.LINESEP + "Use INSTRFIND to determine if other instrument objects " + "are connected to the requested device.";
    }

    protected void hardwareStopAsync() {
        this.readAsyncMode = 1;
        this.updateReadTransferStatus(false);
        this.hardwareFlushOutput();
    }

    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        if (this.breakInterruptAction != Instrument.ACTION) {
            this.breakInterruptAction.dispose();
        }
        if (this.pinStatusAction != Instrument.ACTION) {
            this.pinStatusAction.dispose();
        }
    }

    private boolean checkForCtrlC() {
        if (Instrument.ctrlc_flag) {
            Instrument.ctrlc_flag = false;
            return true;
        }
        return false;
    }

    public final Object constructorargs() {
        return this.port;
    }

    protected void hardwareFlushInput() {
        try {
            int n = this.lineInputStream.numAvailable();
            this.lineInputStream.flushLine(n);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void hardwareFlushOutput() {
        try {
            this.flushOutputVector();
        }
        catch (Exception exception) {}
        this.updateWriteTransferStatus(false);
        this.byteData = null;
        this.outputCount = 0;
        this.asyncWriteFlag = false;
        this.bytesToOutput = 0;
    }

    public final void poll() {
        try {
            double d = System.currentTimeMillis() + 100L;
            while ((double)System.currentTimeMillis() < d && this.lineInputStream.numAvailable() != 0 && this.inputBufferSize - this.bytesAvailable > 0 && (this.readAsyncMode == 0 || this.readAsyncMode == 1 && this.readAsyncCount > 0)) {
                this.pollingRead();
            }
            if (this.transferStatus == 2 || this.transferStatus == 3) {
                this.pollingWrite();
            }
            if ((double)System.currentTimeMillis() > this.writeStopTime && this.bytesToOutput > 0 && this.transferStatus == 2) {
                this.hardwareFlushOutput();
                this.bytesToOutput = 0;
                this.transferStatus = 0;
                this.executeErrorEvent(Calendar.getInstance(), "The asynchronous write operation timed out.");
            }
            if ((double)System.currentTimeMillis() > this.readAsyncStopTime && this.readAsyncCount > 0) {
                this.readAsyncCount = 0;
                this.updateReadTransferStatus(false);
                if (this.readAsyncMode == 1) {
                    this.executeErrorEvent(Calendar.getInstance(), "The asynchronous read operation timed out.");
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }

    private final void pollingWrite() throws Exception {
        int n;
        if (this.byteData == null) {
            this.getDoubleFromOutputVector();
            n = this.getIntFromOutputVector();
            Object object = this.getObjectFromOutputVector();
            switch (this.byteOrder) {
                case 0: {
                    this.byteData = BinarySwapBytes.breakdownToBytes(object, n);
                    break;
                }
                case 1: {
                    this.byteData = BinarySwapBytes.breakdownToBytesAndSwap(object, n);
                }
            }
            this.writeStopTime = (double)System.currentTimeMillis() + this.timeout * 1000.0;
            this.datatype = n;
            this.chunkSize = 16;
            if (this.baudRate > 2500) {
                this.chunkSize = 40;
            } else if (this.baudRate > 10000) {
                this.chunkSize = 80;
            } else if (this.baudRate > 30000) {
                this.chunkSize = 160;
            } else if (this.baudRate > 60000) {
                this.chunkSize = 320;
            } else if (this.baudRate > 100000) {
                this.chunkSize = 640;
            } else if (this.baudRate > 120000) {
                this.chunkSize = 1280;
            } else if (this.baudRate > 250000) {
                this.chunkSize = 2560;
            }
        }
        n = 0;
        while (this.outputCount < this.byteData.length && this.byteData != null && n < this.chunkSize) {
            --this.bytesToOutput;
            if (++n % Instrument.DATASIZE[this.datatype] == 0) {
                ++this.valuesSent;
            }
            this.dataOutputStream.writeByte(this.byteData[this.outputCount++]);
        }
        if (this.outputCount == this.byteData.length) {
            this.byteData = null;
            this.outputCount = 0;
        }
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 2: {
                if (this.bytesToOutput != 0) break;
                this.updateWriteTransferStatus(false);
                if (this.asyncWriteFlag && !this.outputEmptyAction.equals(Instrument.ACTION)) {
                    this.eventTime = Calendar.getInstance();
                    this.executeEvent(4, "OutputEmpty", this.eventTime, new IniEvent("OutputEmpty", Instrument.constructClockVector(this.eventTime)));
                }
                this.asyncWriteFlag = false;
                return;
            }
            case 6: {
                this.reportPinStatusEvent("Carrier Detect", serialPortEvent.getNewValue());
                return;
            }
            case 3: {
                this.reportPinStatusEvent("Clear To Send", serialPortEvent.getNewValue());
                return;
            }
            case 4: {
                this.reportPinStatusEvent("Data Set Ready", serialPortEvent.getNewValue());
                return;
            }
            case 5: {
                this.reportPinStatusEvent("Ring Indicator", serialPortEvent.getNewValue());
                return;
            }
            case 10: {
                if (this.breakInterruptAction.equals(Instrument.ACTION)) break;
                this.eventTime = Calendar.getInstance();
                this.executeEvent(0, "BreakInterrupt", this.eventTime, new IniEvent("BreakInterrupt", Instrument.constructClockVector(this.eventTime)));
                return;
            }
            case 9: {
                this.reportErrorEvent("Serial: A framing error occurred.");
                return;
            }
            case 7: {
                this.reportErrorEvent("Serial: An overrun error occurred.");
                return;
            }
            case 8: {
                this.reportErrorEvent("Serial: A parity error occurred.");
                return;
            }
        }
    }

    private void reportPinStatusEvent(String string, boolean bl) {
        if (!this.pinStatusAction.equals(Instrument.ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(5, "PinStatus", this.eventTime, new IniEvent("PinStatus", Instrument.constructClockVector(this.eventTime), string, this.bool2OnOff(bl)));
        }
    }

    private void reportErrorEvent(String string) {
        if (!this.errorAction.equals(Instrument.ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(2, "Error", this.eventTime, new IniEvent("Error", Instrument.constructClockVector(this.eventTime), string));
        }
    }

    protected Object[] writeHardwareAsciiSync(String string) {
        String string2 = "";
        int n = 0;
        Object[] objectArray = new Object[3];
        objectArray[0] = string;
        try {
            this.updateWriteTransferStatus(true);
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = 0;
            while (n2 < string.length()) {
                if (this.checkForCtrlC()) {
                    objectArray[1] = new Integer(n2);
                    objectArray[2] = "Ctrl-C interrupted the write operation.";
                    return objectArray;
                }
                this.dataOutputStream.writeByte(stringBuffer.charAt(n2));
                ++n2;
            }
            this.dataOutputStream.flush();
            string2 = this.blockWhileWriting();
            n = string.length();
        }
        catch (Exception exception) {
            string2 = "An error occurred during writing.";
        }
        objectArray[1] = new Integer(n);
        objectArray[2] = string2;
        return objectArray;
    }

    protected Object[] writeHardwareBinarySync(Object object, int n, int n2) {
        int n3 = 0;
        String string = "";
        try {
            this.updateWriteTransferStatus(true);
            switch (this.byteOrder) {
                case 1: {
                    n3 = this.writeBigEndian(object, n, n2);
                    break;
                }
                case 0: {
                    n3 = this.writeLittleEndian(object, n, n2);
                    break;
                }
            }
            this.dataOutputStream.flush();
            string = this.blockWhileWriting();
        }
        catch (Exception exception) {
            string = "An error occurred during writing.";
        }
        Object[] objectArray = new Object[]{new Integer(n3), string};
        return objectArray;
    }

    private int writeBigEndian(Object object, int n, int n2) throws Exception {
        int n3 = 1;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            n3 = 0;
            while (n3 < byArray.length) {
                if (this.checkForCtrlC()) {
                    return n3;
                }
                this.dataOutputStream.writeByte(byArray[n3]);
                ++n3;
            }
        } else if (object instanceof Byte) {
            this.dataOutputStream.writeByte(((Byte)object).byteValue());
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            n3 = 0;
            while (n3 < sArray.length) {
                if (this.checkForCtrlC()) {
                    return n3;
                }
                this.dataOutputStream.writeShort(sArray[n3]);
                ++n3;
            }
        } else if (object instanceof Short) {
            this.dataOutputStream.writeShort(((Short)object).shortValue());
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            n3 = 0;
            while (n3 < nArray.length) {
                if (this.checkForCtrlC()) {
                    return n3;
                }
                this.dataOutputStream.writeInt(nArray[n3]);
                ++n3;
            }
        } else if (object instanceof Integer) {
            this.dataOutputStream.writeInt((Integer)object);
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            n3 = 0;
            while (n3 < fArray.length) {
                if (this.checkForCtrlC()) {
                    return n3;
                }
                this.dataOutputStream.writeFloat(fArray[n3]);
                ++n3;
            }
        } else if (object instanceof Float) {
            this.dataOutputStream.writeFloat(((Float)object).floatValue());
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            n3 = 0;
            while (n3 < dArray.length) {
                if (this.checkForCtrlC()) {
                    return n3;
                }
                this.dataOutputStream.writeDouble(dArray[n3]);
                ++n3;
            }
        } else if (object instanceof Double) {
            this.dataOutputStream.writeDouble((Double)object);
        }
        return n3;
    }

    private int writeLittleEndian(Object object, int n, int n2) throws Exception {
        int n3 = 1;
        Object object2 = BinarySwapBytes.swap(object, n2, n);
        switch (n2) {
            case 0: 
            case 5: {
                byte[] byArray = (byte[])object2;
                n3 = 0;
                while (n3 < byArray.length) {
                    if (this.checkForCtrlC()) {
                        return n3;
                    }
                    this.dataOutputStream.writeByte(byArray[n3]);
                    ++n3;
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object2;
                n3 = 0;
                while (n3 < sArray.length) {
                    if (this.checkForCtrlC()) {
                        return n3;
                    }
                    this.dataOutputStream.writeShort(sArray[n3]);
                    ++n3;
                }
                break;
            }
            case 2: {
                int[] nArray = (int[])object2;
                n3 = 0;
                while (n3 < nArray.length) {
                    if (this.checkForCtrlC()) {
                        return n3;
                    }
                    this.dataOutputStream.writeInt(nArray[n3]);
                    ++n3;
                }
                break;
            }
            case 3: {
                float[] fArray = (float[])object2;
                n3 = 0;
                while (n3 < fArray.length) {
                    if (this.checkForCtrlC()) {
                        return n3;
                    }
                    this.dataOutputStream.writeFloat(fArray[n3]);
                    ++n3;
                }
                break;
            }
            case 4: {
                double[] dArray = (double[])object2;
                n3 = 0;
                while (n3 < dArray.length) {
                    if (this.checkForCtrlC()) {
                        return n3;
                    }
                    this.dataOutputStream.writeDouble(dArray[n3]);
                    ++n3;
                }
                break;
            }
        }
        return n3;
    }

    private String blockWhileWriting() throws InterruptedException {
        double d = (double)System.currentTimeMillis() + this.timeout * 1000.0;
        while (!Instrument.ctrlc_flag && (double)System.currentTimeMillis() < d && (this.transferStatus == 2 || this.transferStatus == 3)) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        if (this.checkForCtrlC()) {
            this.hardwareFlushOutput();
            return "Ctrl-C interrupted the write operation.";
        }
        if (this.transferStatus == 2 || this.transferStatus == 3) {
            this.hardwareFlushOutput();
            return "A timeout occurred while writing.";
        }
        return "";
    }

    protected int numAvailableFromHardware() {
        try {
            return this.dataInputStream.available();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    protected String readAsciiFromHardware(int n, double d) {
        try {
            return this.lineInputStream.readLine(this.terminatorChar, d, n);
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected String readBinaryFromHardware(int n) throws Exception {
        this.fillInBuffer(this.lineInputStream.readByte(n));
        return "";
    }

    protected Object convertBinaryData(byte[] byArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            return null;
        }
        switch (this.byteOrder) {
            case 0: {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
            case 1: {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
        }
        throw new IniException("Unsupported byte order specified.");
    }

    protected void fillInBufferFromHardware(int n, byte[] byArray) throws Exception {
        this.fillInBuffer(this.lineInputStream.readByte(n), byArray);
    }

    protected void fillInBufferUntilTerminator(int n) throws Exception {
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray = this.lineInputStream.readByte(1);
            if (bl) {
                if (byArray[0] == this.terminatorByte[1]) {
                    this.fillInBuffer(byArray, this.terminatorByte);
                    this.readAsyncCount = 0;
                    this.updateReadTransferStatus(false);
                    return;
                }
                bl = false;
            } else if (byArray[0] == this.terminatorByte[0]) {
                if (this.terminatorByte.length == 1) {
                    this.fillInBuffer(byArray, this.terminatorByte);
                    this.readAsyncCount = 0;
                    this.updateReadTransferStatus(false);
                    return;
                }
                bl = true;
            }
            this.fillInBuffer(byArray, this.terminatorByte);
            ++n2;
        }
    }

    public void serialbreak(int n) throws IniException {
        if (!this.isvalid()) {
            this.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            this.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if (this.transferStatus == 2 || this.transferStatus == 3) {
            this.displayError("SERIALBREAK cannot be called while data is being written asynchronously." + Instrument.LINESEP + "STOPASYNC can be used to stop an asynchronous write operation.");
        }
        this.serialPort.sendBreak(n);
    }

    private static String[] findAllPorts() {
        CommPortIdentifier commPortIdentifier;
        int n = 0;
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            ++n;
        }
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        enumeration = CommPortIdentifier.getPortIdentifiers();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            stringArray[n2] = commPortIdentifier.getName();
            nArray[n2++] = commPortIdentifier.getPortType();
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            switch (nArray[n4]) {
                case 1: {
                    ++n3;
                }
            }
            ++n4;
        }
        String[] stringArray2 = new String[n3];
        n2 = 0;
        int n5 = 0;
        while (n5 < n) {
            switch (nArray[n5]) {
                case 1: {
                    stringArray2[n2++] = stringArray[n5];
                }
            }
            ++n5;
        }
        return stringArray2;
    }

    public Object[] hardwareInfo() throws IniException {
        SerialPort serialPort;
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'instrhwinfo'.");
        }
        String[] stringArray = new String[ALLPORTS.length];
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n2 < ALLPORTS.length) {
            bl = this.isInUse(ALLPORTS[n2]);
            if (!bl) {
                if (SerialComm.isSerialInHashTable(ALLPORTS[n2])) {
                    stringArray[n++] = ALLPORTS[n2];
                } else {
                    try {
                        if (Instrument.isSolaris == 0) {
                            this.portId = CommPortIdentifier.getPortIdentifier((String)ALLPORTS[n2]);
                            serialPort = (SerialPort)this.portId.open("MATLAB", 2000);
                            serialPort.close();
                        }
                        stringArray[n++] = ALLPORTS[n2];
                    }
                    catch (NoSuchPortException noSuchPortException) {
                    }
                    catch (PortInUseException portInUseException) {
                    }
                    catch (Exception exception) {}
                }
            }
            ++n2;
        }
        serialPort = new String[n];
        String[] stringArray2 = new String[n];
        int n3 = 0;
        while (n3 < n) {
            serialPort[n3] = stringArray[n3];
            stringArray2[n3] = "serial('" + stringArray[n3] + "');";
            ++n3;
        }
        Object[] objectArray = new Object[]{serialPort, Instrument.jarVersion(), stringArray2, ALLPORTS};
        return objectArray;
    }

    public String[] ObjectHardwareInfo() throws IniException {
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'instrhwinfo'.");
        }
        this.info[0] = Instrument.jarVersion();
        return this.info;
    }

    public Object[] ObjectHardwareInfo(String[] stringArray) throws IniException {
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'instrhwinfo'.");
        }
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.findPropertyCompleteName(stringArray[n].toLowerCase(), HWINFO_FIELDS, stringArray[n]);
            if (this.info[n2] == null) {
                this.ObjectHardwareInfo();
            }
            objectArray[n] = this.info[n2];
            ++n;
        }
        return objectArray;
    }

    protected void updateObjectSpecificProperties(IniProp[] iniPropArray) {
        iniPropArray[13].setDefaultValue("Serial-" + this.port);
        iniPropArray[19].setDefaultValue(this.port);
    }

    public String display() {
        if (!this.isvalid()) {
            return this.invalidDisplay();
        }
        return String.valueOf(Instrument.LINESEP) + "   Serial Port Object : " + this.name + Instrument.LINESEP + Instrument.LINESEP + "   Communication Settings " + Instrument.LINESEP + "      Port:               " + this.port + Instrument.LINESEP + "      BaudRate:           " + this.baudRate + Instrument.LINESEP + "      Terminator:         " + Serial.terminatorEnum[this.terminator] + Instrument.LINESEP + Instrument.LINESEP + "   Communication State " + Instrument.LINESEP + "      Status:             " + Instrument.STATUS_ENUM[this.status] + Instrument.LINESEP + "      RecordStatus:       " + Instrument.RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + Instrument.LINESEP + Instrument.LINESEP + "   Read/Write State  " + Instrument.LINESEP + "      TransferStatus:     " + Instrument.TRANSFER_STATUS_ENUM[this.transferStatus] + Instrument.LINESEP + "      BytesAvailable:     " + this.bytesAvailable + Instrument.LINESEP + "      ValuesReceived:     " + this.valuesReceived + Instrument.LINESEP + "      ValuesSent:         " + this.valuesSent + Instrument.LINESEP + " " + Instrument.LINESEP;
    }

    public String setDisplay() {
        return "    ByteOrder: [ {littleEndian} | bigEndian ] " + Instrument.LINESEP + "    BytesAvailableAction" + Instrument.LINESEP + "    BytesAvailableActionCount" + Instrument.LINESEP + "    BytesAvailableActionMode: [ {terminator} | byte ]" + Instrument.LINESEP + "    ErrorAction" + Instrument.LINESEP + "    InputBufferSize" + Instrument.LINESEP + "    Name" + Instrument.LINESEP + "    OutputBufferSize" + Instrument.LINESEP + "    OutputEmptyAction" + Instrument.LINESEP + "    RecordDetail: [ {compact} | verbose ]" + Instrument.LINESEP + "    RecordMode: [ {overwrite} | append | index ]" + Instrument.LINESEP + "    RecordName" + Instrument.LINESEP + "    Tag" + Instrument.LINESEP + "    Timeout" + Instrument.LINESEP + "    TimerAction" + Instrument.LINESEP + "    TimerPeriod" + Instrument.LINESEP + "    UserData" + Instrument.LINESEP + Instrument.LINESEP + "    SERIAL specific properties:" + Instrument.LINESEP + "    BaudRate" + Instrument.LINESEP + "    BreakInterruptAction" + Instrument.LINESEP + "    DataBits" + Instrument.LINESEP + "    DataTerminalReady: [ {on} | off ]" + Instrument.LINESEP + "    FlowControl: [ {none} | hardware | software ]" + Instrument.LINESEP + "    Parity: [ {none} | odd | even | mark | space ]" + Instrument.LINESEP + "    PinStatusAction" + Instrument.LINESEP + "    Port" + Instrument.LINESEP + "    ReadAsyncMode: [ {continuous} | manual ]" + Instrument.LINESEP + "    RequestToSend: [ {on} | off ]" + Instrument.LINESEP + "    StopBits" + Instrument.LINESEP + "    Terminator: [ CR | {LF} | CR/LF | LF/CR ]" + Instrument.LINESEP + " " + Instrument.LINESEP;
    }
}

