/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.PinStatusStruct;
import java.io.IOException;
import java.util.Calendar;

abstract class Serial
extends Instrument {
    protected static final int NOFLOW = 0;
    protected static final int HARDWARE = 1;
    protected static final int SOFTWARE = 2;
    protected static final int NONE = 0;
    protected static final int EVEN = 1;
    protected static final int MARK = 2;
    protected static final int ODD = 3;
    protected static final int SPACE = 4;
    protected static final int CONTINUOUS = 0;
    protected static final int MANUAL = 1;
    protected static final int CR = 0;
    protected static final int LF = 1;
    protected static final int CRLF = 2;
    protected static final int LFCR = 3;
    protected static final String STR_CARRIAGE = new Character('\r').toString();
    protected static final String STR_LINEFEED = new Character('\n').toString();
    protected static final String[] terminatorEnum = new String[]{"CR", "LF", "CR/LF", "LF/CR"};
    protected static final String[] parityEnum = new String[]{"N", "E", "M", "O", "S"};
    protected int baudRate = 9600;
    protected int dataBits = 8;
    protected boolean dataTerminalReady = true;
    protected int flowControl = 0;
    protected int parity = 0;
    protected PinStatusStruct pinStatus = new PinStatusStruct();
    protected String port = "";
    protected int readAsyncMode = 0;
    protected boolean requestToSend = true;
    protected double stopBits = 1.0;
    protected int terminator = 1;
    protected String terminatorChar = STR_LINEFEED;
    protected byte[] terminatorByte = this.terminatorChar.getBytes();
    protected boolean isSerialPortReadable = true;
    protected boolean isSerialPortWriteable = true;
    protected static final String[] AsyncVals = new String[]{"continuous", "manual"};
    protected static final Object[] dBitVals = new Object[]{new Double(5.0), new Double(8.0)};
    protected static final String[] dModeVals = new String[]{"terminator", "byte"};
    protected static final String[] flowVals = new String[]{"none", "hardware", "software"};
    protected static final String[] ParVals = new String[]{"none", "odd", "even", "mark", "space"};
    protected static final String[] TranSVals = new String[]{"idle", "read", "write", "read&write"};
    protected static final PinStatusStruct pss = new PinStatusStruct();

    public final void setBaudRate(int n) throws IniException {
        if (this.status == 0) {
            this.baudRate = n;
            return;
        }
        if (this.getTransferStatus() != 0) {
            this.displayError("BaudRate " + Instrument.NOASYNCOP);
        }
        try {
            this.setHardwareBaudRate(n);
            this.baudRate = n;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final int getBaudRate() {
        return this.baudRate;
    }

    public final void setDataBits(int n) throws IniException {
        if (!this.verifySetRange(n, 5, 8)) {
            this.displayError("DataBits must range between 5 and 8.");
        }
        if (this.status == 0) {
            this.dataBits = n;
            return;
        }
        if (this.getTransferStatus() != 0) {
            this.displayError("DataBits " + Instrument.NOASYNCOP);
        }
        try {
            this.setHardwareDataBits(n);
            this.dataBits = n;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final int getDataBits() {
        return this.dataBits;
    }

    public final void setDataTerminalReady(boolean bl) throws IniException {
        if (this.status == 0) {
            this.dataTerminalReady = bl;
            return;
        }
        if (this.getTransferStatus() != 0) {
            this.displayError("DataTerminalReady " + Instrument.NOASYNCOP);
        }
        try {
            this.setHardwareDataTerminalReady(bl);
            this.dataTerminalReady = bl;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final boolean getDataTerminalReady() {
        if (this.status == 1) {
            this.dataTerminalReady = this.getHardwareDataTerminalReady();
        }
        return this.dataTerminalReady;
    }

    public final void setFlowControl(int n) throws IniException {
        if (this.status == 0) {
            this.flowControl = n;
            return;
        }
        if (this.getTransferStatus() != 0) {
            this.displayError("FlowControlHardware " + Instrument.NOASYNCOP);
        }
        try {
            this.setHardwareFlowControl(n);
            this.flowControl = n;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final int getFlowControl() {
        return this.flowControl;
    }

    public final void setParity(int n) throws IniException {
        if (this.status == 0) {
            this.parity = n;
            return;
        }
        if (this.getTransferStatus() != 0) {
            this.displayError("Parity " + Instrument.NOASYNCOP);
        }
        try {
            this.setHardwareParity(n);
            this.parity = n;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final int getParity() {
        return this.parity;
    }

    public final void setPinStatus(PinStatusStruct pinStatusStruct) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("PinStatus"));
    }

    public final PinStatusStruct getPinStatus() {
        if (this.status == 1) {
            this.pinStatus.setCarrierDetect(this.getHardwareCarrierDetect());
            this.pinStatus.setClearToSend(this.getHardwareClearToSend());
            this.pinStatus.setDataSetReady(this.getHardwareDataSetReady());
            this.pinStatus.setRingIndicator(this.getHardwareRingIndicator());
        }
        return this.pinStatus;
    }

    public final void setPort(String string) throws IniException {
        if (this.status == 1) {
            this.displayError("Port cannot be set while OBJ is open.");
        }
        switch (Instrument.platform) {
            case 0: {
                this.port = string.toUpperCase();
                break;
            }
            default: {
                this.port = string;
            }
        }
        this.setHardwarePort();
    }

    public final String getPort() {
        return this.port;
    }

    public final void setReadAsyncMode(int n) {
        this.readAsyncMode = n;
    }

    public final int getReadAsyncMode() {
        return this.readAsyncMode;
    }

    public final void setRequestToSend(boolean bl) throws IniException {
        if (this.status == 0) {
            this.requestToSend = bl;
            return;
        }
        if (this.getTransferStatus() != 0) {
            this.displayError("RequestToSend " + Instrument.NOASYNCOP);
        }
        try {
            this.setHardwareRequestToSend(bl);
            this.requestToSend = bl;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final boolean getRequestToSend() {
        if (this.status == 1) {
            this.requestToSend = this.getHardwareRequestToSend();
        }
        return this.requestToSend;
    }

    public final void setStopBits(double d) throws IniException {
        double[] dArray = this.getValidStopBits();
        if (!this.verifySetValues(dArray, d)) {
            this.displayError("StopBits could not be set to specified value.");
        }
        if (this.status == 0) {
            this.stopBits = d;
            return;
        }
        if (this.getTransferStatus() != 0) {
            this.displayError("StopBits " + Instrument.NOASYNCOP);
        }
        try {
            this.setHardwareStopBits(d);
            this.stopBits = d;
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final double getStopBits() {
        return this.stopBits;
    }

    public final void setTerminator(int n) throws IniException {
        if (this.getTransferStatus() != 0) {
            this.displayError("Terminator " + Instrument.NOASYNCOP);
        }
        if (this.status == 1) {
            try {
                this.setHardwareTerminator(n);
                this.terminator = n;
            }
            catch (Exception exception) {
                this.displayError(exception.getMessage());
            }
        } else {
            this.terminator = n;
        }
        switch (this.terminator) {
            case 0: {
                this.terminatorChar = STR_CARRIAGE;
                break;
            }
            case 1: {
                this.terminatorChar = STR_LINEFEED;
                break;
            }
            case 2: {
                this.terminatorChar = String.valueOf(STR_CARRIAGE) + STR_LINEFEED;
                break;
            }
            case 3: {
                this.terminatorChar = String.valueOf(STR_LINEFEED) + STR_CARRIAGE;
                break;
            }
        }
        this.terminatorByte = this.terminatorChar.getBytes();
    }

    public final int getTerminator() {
        return this.terminator;
    }

    protected void updatePropsOnOpen() throws IniException {
        this.setHardwareBaudRate(this.baudRate);
        this.setHardwareDataBits(this.dataBits);
        this.setHardwareStopBits(this.stopBits);
        this.setHardwareParity(this.parity);
        this.setHardwareDataTerminalReady(this.dataTerminalReady);
        this.setHardwareRequestToSend(this.requestToSend);
        this.setHardwareTerminator(this.terminator);
        this.setHardwareTimeout(this.timeout);
        this.timeout = this.getHardwareTimeout();
        this.setFlowControl(this.flowControl);
    }

    protected synchronized void updateReadTransferStatus(boolean bl) {
        if (bl) {
            switch (this.transferStatus) {
                case 2: {
                    this.transferStatus = 3;
                    return;
                }
                case 0: {
                    this.transferStatus = 1;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (this.transferStatus) {
            case 3: {
                this.transferStatus = 2;
                return;
            }
            case 1: {
                this.transferStatus = 0;
                return;
            }
        }
    }

    protected synchronized void updateWriteTransferStatus(boolean bl) {
        if (bl) {
            switch (this.transferStatus) {
                case 1: {
                    this.transferStatus = 3;
                    return;
                }
                case 0: {
                    this.transferStatus = 2;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (this.transferStatus) {
            case 3: {
                this.transferStatus = 1;
                return;
            }
            case 2: {
                this.transferStatus = 0;
                return;
            }
        }
    }

    protected void verifyWriteOperation() throws IniException {
        if (this.transferStatus == 2) {
            this.displayError("An asynchronous write is already in progress.");
        }
    }

    protected void verifyReadOperation() throws IniException {
        if (this.transferStatus == 1) {
            this.displayError("An asynchronous read is already in progress.");
        }
        if (this.readAsyncMode == 1) {
            this.hardwareFlushInput();
            this.updateReadTransferStatus(true);
        }
    }

    protected final void pollingRead() throws IOException {
        if (this.inputBufferSize - this.bytesAvailable == 0) {
            this.updateReadTransferStatus(false);
        }
        if (this.readAsyncMode == 0) {
            this.pollingReadContinuousMode();
        }
        if (this.readAsyncMode == 1 && this.readAsyncCount > 0) {
            this.pollingReadManualMode();
        }
    }

    protected void pollingReadContinuousMode() {
        try {
            int n = this.numAvailableFromHardware();
            int n2 = this.inputBufferSize - this.bytesAvailable;
            if (n != 0 && n2 != 0) {
                int n3;
                this.updateReadTransferStatus(true);
                if (n < n2) {
                    n2 = n;
                }
                if ((n3 = this.bytesAvailableActionMode == 1 ? this.bytesAvailableActionCount - this.bytesAvailable % this.bytesAvailableActionCount : n2) > n2) {
                    this.fillInBufferFromHardware(n2, this.terminatorByte);
                } else {
                    this.fillInBufferFromHardware(n3, this.terminatorByte);
                }
                this.updateReadTransferStatus(false);
                return;
            }
        }
        catch (Exception exception) {}
    }

    protected void pollingReadManualMode() {
        try {
            int n;
            int n2 = this.inputBufferSize - this.bytesAvailable;
            if (this.readAsyncCount < n2) {
                n2 = this.readAsyncCount;
            }
            if ((n = this.numAvailableFromHardware()) != 0 && n2 != 0) {
                this.updateReadTransferStatus(true);
                if (n < n2) {
                    n2 = n;
                }
                this.fillInBufferUntilTerminator(n2);
            }
            if (this.readAsyncCount == 0) {
                this.updateReadTransferStatus(false);
                return;
            }
        }
        catch (Exception exception) {}
    }

    protected String getAsciiMessage(Object[] objectArray) {
        String string = "";
        int n = 0;
        while (n < objectArray.length) {
            string = objectArray[n] instanceof String ? String.valueOf(string) + (String)objectArray[n] : (objectArray[n] instanceof Character ? String.valueOf(string) + (Character)objectArray[n] : String.valueOf(string) + this.terminatorChar);
            ++n;
        }
        return string;
    }

    protected Object[] writeHardwareAscii(String string) throws IniException {
        if (!this.isSerialPortWriteable) {
            throw new IniException("Port: " + this.port + " is not writeable.");
        }
        switch (this.writeTransferMode) {
            case 1: {
                return this.writeHardwareAsciiAsync(string);
            }
            case 0: {
                return this.writeHardwareAsciiSync(string);
            }
        }
        throw new IniException("Invalid TransferMode specified.");
    }

    protected synchronized Object[] writeHardwareAsciiAsync(String string) throws IniException {
        byte[] byArray = string.getBytes();
        try {
            this.putDataInOutputVector(byArray, byArray.length, 0);
        }
        catch (IOException iOException) {
            this.hardwareFlushOutput();
            this.executeErrorEvent(Calendar.getInstance(), "Error occurred while writing data to the output buffer.");
        }
        Object[] objectArray = new Object[]{string, new Integer(0), ""};
        return objectArray;
    }

    protected Object[] writeHardwareBinary(Object object, int n, int n2) throws Exception {
        if (!this.isSerialPortWriteable) {
            throw new IniException("Port: " + this.port + " is not writeable.");
        }
        switch (this.writeTransferMode) {
            case 1: {
                return this.writeHardwareBinaryAsync(object, n, n2);
            }
            case 0: {
                return this.writeHardwareBinarySync(object, n, n2);
            }
        }
        throw new IniException("Invalid TransferMode specified.");
    }

    protected Object[] writeHardwareBinaryAsync(Object object, int n, int n2) throws IniException {
        try {
            this.putDataInOutputVector(object, n, n2);
        }
        catch (IOException iOException) {
            this.hardwareFlushOutput();
            this.executeErrorEvent(Calendar.getInstance(), "Error occurred while writing data to the output buffer.");
        }
        Object[] objectArray = new Object[]{Instrument.INTEGER_ZERO, ""};
        return objectArray;
    }

    protected Object[] readHardwareAscii(int n) throws Exception {
        if (!this.isSerialPortReadable) {
            throw new IniException("Port: " + this.port + " is not readable.");
        }
        switch (this.readAsyncMode) {
            case 0: {
                return this.readHardwareAsciiContinuous(n);
            }
            case 1: {
                this.hardwareFlushInput();
                return this.readHardwareAsciiManual(n);
            }
        }
        throw new IniException("Invalid ReadAsyncMode specified.");
    }

    protected Object[] readHardwareAsciiContinuous(int n) throws Exception {
        String string = n == 0 ? this.readInBufferAsciiLine(this.terminatorChar, this.inputBufferSize) : this.readInBufferAsciiLine(this.terminatorChar, n);
        Object[] objectArray = new Object[]{string, this.wasAsciiReadSucessful(string, n)};
        return objectArray;
    }

    protected Object[] readHardwareAsciiManual(int n) throws Exception {
        String string = "";
        Object[] objectArray = new Object[2];
        double d = (double)System.currentTimeMillis() + this.timeout * 1000.0;
        int n2 = n;
        if (n == 0) {
            n2 = this.readAsyncCount;
        }
        if (this.bytesAvailable == 0) {
            while (this.readAsyncCount > 0 && this.bytesAvailable < n2 && (double)System.currentTimeMillis() < d && !Instrument.ctrlc_flag) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        if (Instrument.ctrlc_flag) {
            Instrument.ctrlc_flag = false;
            return objectArray;
        }
        if (this.bytesAvailable != 0 && ((string = n != 0 && n < this.bytesAvailable ? this.readInBufferAsciiLine(this.terminatorChar, n) : this.readInBufferAsciiLine(this.terminatorChar, this.bytesAvailable)).endsWith(this.terminatorChar) || string.length() == n)) {
            objectArray[0] = string;
            objectArray[1] = this.wasAsciiReadSucessful(string, n);
            return objectArray;
        }
        double d2 = (d - (double)System.currentTimeMillis()) / 1000.0;
        if (d2 < 0.0) {
            objectArray[0] = string;
            objectArray[1] = this.wasAsciiReadSucessful(string, n);
            return objectArray;
        }
        int n3 = n == 0 ? this.inputBufferSize - string.length() : n - string.length();
        while (this.readAsyncCount > 0 && this.bytesAvailable < n3 && (double)System.currentTimeMillis() < d && !Instrument.ctrlc_flag) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        if (Instrument.ctrlc_flag) {
            Instrument.ctrlc_flag = false;
            return objectArray;
        }
        if (this.bytesAvailable != 0 && ((string = n != 0 && n < this.bytesAvailable ? String.valueOf(string) + this.readInBufferAsciiLine(this.terminatorChar, n) : String.valueOf(string) + this.readInBufferAsciiLine(this.terminatorChar, this.bytesAvailable)).endsWith(this.terminatorChar) || string.length() == n)) {
            objectArray[0] = string;
            objectArray[1] = this.wasAsciiReadSucessful(string, n);
            return objectArray;
        }
        d2 = (d - (double)System.currentTimeMillis()) / 1000.0;
        if (d2 < 0.0) {
            objectArray[0] = string;
            objectArray[1] = this.wasAsciiReadSucessful(string, n);
            return objectArray;
        }
        n3 = n == 0 ? this.inputBufferSize - string.length() : n - string.length();
        String string2 = this.readAsciiFromHardware(n3, d2);
        objectArray[0] = String.valueOf(string) + string2;
        objectArray[1] = this.wasAsciiReadSucessful(String.valueOf(string) + string2, n);
        return objectArray;
    }

    protected String removeTerminator(String string) {
        switch (this.terminator) {
            case 0: 
            case 1: {
                return string.substring(0, string.length() - 1);
            }
            case 2: 
            case 3: {
                return string.substring(0, string.length() - 2);
            }
        }
        return string;
    }

    protected Object[] readHardwareBinary(int n, int n2) throws Exception {
        if (!this.isSerialPortReadable) {
            throw new IniException("Port: " + this.port + " is not readable.");
        }
        switch (this.readAsyncMode) {
            case 0: {
                return this.readHardwareBinaryContinuous(n, n2);
            }
            case 1: {
                this.hardwareFlushInput();
                return this.readHardwareBinaryManual(n, n2);
            }
        }
        throw new IniException("Invalid ReadAsyncMode specified.");
    }

    protected Object[] readHardwareBinaryContinuous(int n, int n2) throws Exception {
        Object[] objectArray = new Object[3];
        int n3 = Instrument.DATASIZE[n2];
        int n4 = n * n3;
        double d = (double)System.currentTimeMillis() + this.timeout * 1000.0;
        while (this.bytesAvailable < n4 && (double)System.currentTimeMillis() < d && !Instrument.ctrlc_flag) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        if (Instrument.ctrlc_flag) {
            Instrument.ctrlc_flag = false;
            return objectArray;
        }
        int n5 = 0;
        if (this.bytesAvailable >= n4) {
            n5 = n4;
        } else {
            int n6 = this.bytesAvailable / n3;
            n5 = n6 * n3;
        }
        byte[] byArray = this.readInBuffer(n5);
        objectArray[0] = this.convertBinaryData(byArray, n2, n5);
        objectArray[1] = new Integer(n5 / n3);
        objectArray[2] = "";
        return objectArray;
    }

    protected Object[] readHardwareBinaryManual(int n, int n2) throws Exception {
        int n3;
        Object[] objectArray = new Object[3];
        int n4 = Instrument.DATASIZE[n2];
        int n5 = n * n4;
        double d = (double)System.currentTimeMillis() + this.timeout * 1000.0;
        String string = "";
        while (this.readAsyncCount > 0 && this.bytesAvailable < n5 && (double)System.currentTimeMillis() < d && !Instrument.ctrlc_flag) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        if (Instrument.ctrlc_flag) {
            Instrument.ctrlc_flag = false;
            return objectArray;
        }
        int n6 = 0;
        n6 = this.bytesAvailable >= n5 ? 0 : n5 - this.bytesAvailable;
        if (n6 != 0) {
            while (this.numAvailableFromHardware() < n6 && (double)System.currentTimeMillis() < d && !Instrument.ctrlc_flag) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            if (Instrument.ctrlc_flag) {
                Instrument.ctrlc_flag = false;
                return objectArray;
            }
            n3 = this.numAvailableFromHardware();
            if (n3 > n6) {
                n3 = n6;
            }
            string = this.readBinaryFromHardware(n3);
        }
        n3 = 0;
        if (this.bytesAvailable >= n5) {
            n3 = n5;
        } else {
            int n7 = this.bytesAvailable / n4;
            n3 = n7 * n4;
        }
        byte[] byArray = this.readInBuffer(n3);
        objectArray[0] = this.convertBinaryData(byArray, n2, n3);
        objectArray[1] = new Integer(n3 / n4);
        objectArray[2] = string;
        return objectArray;
    }

    protected String wasAsciiReadSucessful(String string, int n) {
        if (n == 0 && string.length() == this.inputBufferSize && !string.endsWith(this.terminatorChar)) {
            return "The input buffer was filled before the Terminator was reached.";
        }
        if (n == 0 && string.length() != this.inputBufferSize && !string.endsWith(this.terminatorChar)) {
            return "A timeout occurred before the Terminator was reached.";
        }
        if (n != 0 && string.length() != n && !string.endsWith(this.terminatorChar)) {
            return "A timeout occurred before the Terminator was reached or SIZE values were available.";
        }
        if (n != 0 && string.length() < n && string.endsWith(this.terminatorChar)) {
            return "The Terminator was reached before SIZE values were available.";
        }
        return "";
    }

    protected String readInBufferAsciiLine(String string, int n) throws Exception {
        boolean bl = false;
        String string2 = "";
        boolean bl2 = true;
        double d = (double)System.currentTimeMillis() + this.timeout * 1000.0;
        while ((double)System.currentTimeMillis() <= d && string2.length() < n && !Instrument.ctrlc_flag) {
            try {
                String string3 = this.readInBufferAscii(1);
                if (bl) {
                    if (string.endsWith(string3)) {
                        string2 = String.valueOf(string2) + string3;
                        return string2;
                    }
                    string2 = String.valueOf(string2) + string3;
                    bl = false;
                    bl2 = false;
                }
                if (bl2) {
                    if (string.startsWith(string3)) {
                        if (string.length() == 1) {
                            string2 = String.valueOf(string2) + string3;
                            return string2;
                        }
                        string2 = String.valueOf(string2) + string3;
                        bl = true;
                    } else {
                        string2 = String.valueOf(string2) + string3;
                        bl = false;
                    }
                }
                bl2 = true;
            }
            catch (IniException iniException) {
                Thread.currentThread();
                Thread.sleep(50L);
            }
        }
        Instrument.ctrlc_flag = false;
        return string2;
    }

    abstract boolean getHardwareDataTerminalReady();

    abstract boolean getHardwareRequestToSend();

    abstract String getHardwareCarrierDetect();

    abstract String getHardwareClearToSend();

    abstract String getHardwareDataSetReady();

    abstract String getHardwareRingIndicator();

    abstract void setHardwareBaudRate(int var1) throws IniException;

    abstract void setHardwareDataBits(int var1) throws IniException;

    abstract void setHardwareDataTerminalReady(boolean var1) throws IniException;

    abstract void setHardwareFlowControl(int var1) throws IniException;

    abstract void setHardwareParity(int var1) throws IniException;

    abstract void setHardwarePort();

    abstract void setHardwareRequestToSend(boolean var1) throws IniException;

    abstract void setHardwareStopBits(double var1) throws IniException;

    abstract void setHardwareTerminator(int var1) throws IniException;

    abstract double[] getValidStopBits();

    abstract Object[] writeHardwareAsciiSync(String var1) throws IniException;

    abstract Object[] writeHardwareBinarySync(Object var1, int var2, int var3) throws Exception;

    abstract String readAsciiFromHardware(int var1, double var2) throws Exception;

    abstract String readBinaryFromHardware(int var1) throws Exception;

    abstract int numAvailableFromHardware() throws Exception;

    abstract void fillInBufferUntilTerminator(int var1) throws Exception;

    abstract void fillInBufferFromHardware(int var1, byte[] var2) throws Exception;

    abstract Object convertBinaryData(byte[] var1, int var2, int var3) throws Exception;

    Serial() {
    }
}

