/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class Poller
implements ActionListener {
    private static Poller poller = null;
    private static Vector children = null;
    private static Timer timer;

    private Poller() {
        children = new Vector();
        timer = new Timer(50, (ActionListener)this, 2, 5, "InstrumentReadWritePoll");
    }

    public static final void addInstrument(Instrument instrument) {
        boolean bl = false;
        if (poller == null) {
            poller = new Poller();
            timer.start();
            bl = true;
        }
        children.addElement(instrument);
        if (children.size() == 1 && !bl) {
            timer.reset();
        }
    }

    public static final void removeInstrument(Instrument instrument) {
        if (poller == null) {
            return;
        }
        int n = children.indexOf(instrument);
        if (n != -1) {
            children.removeElementAt(n);
        }
        if (children.isEmpty()) {
            timer.hold();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double d = System.currentTimeMillis();
        int n = 0;
        while (n < children.size()) {
            Instrument instrument = (Instrument)children.elementAt(n);
            instrument.poll();
            ++n;
        }
        double d2 = (double)System.currentTimeMillis() - d;
        if (d2 < 50.0) {
            timer.setDelay(50 - (int)d2);
        } else {
            timer.setDelay(50);
        }
        timer.reset();
    }

    public static void dispose() {
        if (timer != null) {
            timer.stop();
        }
    }
}

