/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.ActionQueue;
import com.mathworks.toolbox.instrument.IniErrorEvent;
import com.mathworks.toolbox.instrument.IniEvent;
import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.IniPinEvent;
import com.mathworks.toolbox.instrument.IniProp;
import com.mathworks.toolbox.instrument.IniTriggerEvent;
import com.mathworks.toolbox.instrument.IniWarning;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.SerialComm;
import com.mathworks.util.Timer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Vector;

public abstract class Instrument
implements MatlabListener,
AutoConvertStringToMatlabChar {
    protected static final int LITTLE_ENDIAN = 0;
    protected static final int BIG_ENDIAN = 1;
    protected static final int PC = 0;
    protected static final int UNIX = 1;
    protected static final int TERMINATOR = 0;
    protected static final int BYTE = 1;
    protected static final int CLOSED = 0;
    protected static final int OPEN = 1;
    protected static final int OVERWRITE = 0;
    protected static final int APPEND = 1;
    protected static final int INDEX = 2;
    protected static final int SYNCHRONOUS = 0;
    protected static final int ASYNCHRONOUS = 1;
    protected static final int IDLE = 0;
    protected static final int READ = 1;
    protected static final int WRITE = 2;
    protected static final int READWRITE = 3;
    protected static final int MINT8 = 0;
    protected static final int MINT16 = 1;
    protected static final int MINT32 = 2;
    protected static final int MSINGLE = 3;
    protected static final int MDOUBLE = 4;
    protected static final int MCHAR = 5;
    protected static final int UNSIGNED = 0;
    protected static final int SIGNED = 1;
    protected static final int READACTION_SUCCESS = 0;
    protected static final int READACTION_SIZE = 1;
    protected static final int WRITEACTION = 2;
    protected static final int INTERRUPTACTION = 3;
    protected static final int TRIGGERACTION = 10;
    protected static final int[] DATASIZE = new int[]{1, 2, 4, 4, 8, 1};
    protected static final Integer INTEGER_ZERO = new Integer(0);
    protected static final int COMPACT = 0;
    protected static final int VERBOSE = 1;
    protected static final char CARRIAGE = '\r';
    protected static final char LINEFEED = '\n';
    protected static String LINESEP = System.getProperty("line.separator");
    protected static final String FILESEP = File.separator;
    protected static final String BLANKS = "                                         ";
    protected static final String ZEROS = "00000000000000000000";
    private static final String[] BYTE_ORDER_STR = new String[]{"little", "big"};
    protected static final String[] STATUS_ENUM = new String[]{"closed", "open"};
    protected static final String[] TRANSFER_MODE_ENUM = new String[]{"synchronous", "asynchronous"};
    protected static final String[] RECORD_STATUS_ENUM = new String[]{"off", "on"};
    protected static final String[] TRANSFER_STATUS_ENUM = new String[]{"idle", "read", "write", "read&write"};
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] PRE_DATATYPE_STR = new String[]{"u", ""};
    protected static final MLArrayRef ACTION = new MLArrayRef(4);
    protected static final MLArrayRef USERDATA = new MLArrayRef(6);
    protected static final int BREAK_INTERRUPT_ACTION = 0;
    protected static final int BYTES_AVAILABLE_ACTION = 1;
    protected static final int ERROR_ACTION = 2;
    protected static final int INTERRUPT_ACTION = 3;
    protected static final int OUTPUT_EMPTY_ACTION = 4;
    protected static final int PINSTATUS_ACTION = 5;
    protected static final int TIMER_ACTION = 6;
    protected static final int TRIGGER_ACTION = 7;
    protected static int platform;
    protected static int isSolaris;
    protected static Vector allInstrumentObjects;
    protected static boolean IS_TOOLBOX_INSTALLED;
    protected static Vector openRecordFileNames;
    private static byte[] singleByteMessage;
    private static short[] singleShortMessage;
    private static int[] singleIntegerMessage;
    private static float[] singleFloatMessage;
    private static double[] singleDoubleMessage;
    private static char[] singleCharacterMessage;
    protected static final String ACTIONERROR;
    protected static final String MUSTCONNECT = "OBJ must be connected to the hardware with FOPEN.";
    protected static final String INVALIDOBJ = "Instrument object OBJ is an invalid object.";
    protected static final String OPENOBJECT = "cannot be set while OBJ is open.";
    protected static final String NOTOOLBOX = "Undefined function or variable ";
    protected static final String NOASYNCOP;
    protected int byteOrder = 0;
    protected int bytesAvailable;
    protected MLArrayRef bytesAvailableAction = ACTION;
    protected int bytesAvailableActionCount = 48;
    protected int bytesAvailableActionMode = 0;
    protected int bytesToOutput;
    protected MLArrayRef errorAction = ACTION;
    protected int handle;
    protected int inputBufferSize = 512;
    protected String name = "";
    protected int outputBufferSize = 512;
    protected MLArrayRef outputEmptyAction = ACTION;
    protected int recordDetail = 0;
    protected int recordMode = 0;
    protected String recordName = "record.txt";
    protected boolean recordStatus = false;
    protected int status = 0;
    protected String tag = "";
    protected double timeout = 10.0;
    protected MLArrayRef timerAction = ACTION;
    protected double timerPeriod = 1.0;
    protected int transferStatus = 0;
    protected String type = "";
    protected MLArrayRef userData = USERDATA;
    protected int valuesReceived;
    protected int valuesSent;
    protected IniProp[] objectProps;
    protected boolean nameStandardFormat = true;
    protected boolean foundFirstTerminator = false;
    protected boolean foundSecondTerminator = false;
    protected int readAsyncCount;
    protected double readAsyncStopTime;
    protected Vector actionQueue = new Vector();
    protected Timer timer;
    protected boolean wasTimerStarted = false;
    protected int[] enabledCallbacks = new int[8];
    protected static boolean ctrlc_flag;
    protected boolean asyncWriteFlag = false;
    protected int writeTransferMode = 0;
    private int bInStart;
    private int bInLength = this.inputBufferSize;
    private int bInEnd;
    protected byte[] inputBuffer = new byte[this.bInLength];
    protected Vector outputBufferData = new Vector();
    private File file;
    private RandomAccessFile appendWriter;
    protected int numCommandsWritten = 1;
    protected Calendar eventTime;
    protected int binarySign = 1;
    protected static final String[] boolVals;
    protected static final String[] byteOVals;
    protected static final String[] RDetVals;
    protected static final String[] RModeVals;
    protected static final String[] StatVals;

    public void matlabEvent(MatlabEvent matlabEvent) {
        switch (matlabEvent.getEventType()) {
            case 1: {
                try {
                    SerialComm.freeSerial();
                    Poller.dispose();
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            case 2: {
                ctrlc_flag = true;
            }
        }
    }

    protected static boolean getCtrlC() {
        return ctrlc_flag;
    }

    protected static void setCtrlC(boolean bl) {
        ctrlc_flag = bl;
    }

    public final void setByteOrder(int n) {
        this.byteOrder = n;
    }

    public final int getByteOrder() {
        return this.byteOrder;
    }

    public final void setBytesAvailable(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("BytesAvailable"));
    }

    public final int getBytesAvailable() {
        return this.bytesAvailable;
    }

    public final void setBytesAvailableAction(MLArrayRef mLArrayRef) throws IniException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("BytesAvailableAction", mLArrayRef);
        if (this.bytesAvailableAction != ACTION) {
            this.bytesAvailableAction.dispose();
        }
        this.bytesAvailableAction = mLArrayRef2;
        this.enabledCallbacks[1] = 0;
    }

    public final MLArrayRef getBytesAvailableAction() {
        return this.bytesAvailableAction;
    }

    public final void setBytesAvailableActionCount(int n) throws IniException {
        if (this.status == 1) {
            this.displayError("BytesAvailableActionCount cannot be set while OBJ is open.");
        }
        this.bytesAvailableActionCount = n;
    }

    public final int getBytesAvailableActionCount() {
        return this.bytesAvailableActionCount;
    }

    public final void setBytesAvailableActionMode(int n) throws IniException {
        if (this.status == 1) {
            this.displayError("BytesAvailableActionMode cannot be set while OBJ is open.");
        }
        this.bytesAvailableActionMode = n;
    }

    public final int getBytesAvailableActionMode() {
        return this.bytesAvailableActionMode;
    }

    public final void setBytesToOutput(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("BytesToOutput"));
    }

    public final int getBytesToOutput() {
        return this.bytesToOutput;
    }

    public final void setErrorAction(MLArrayRef mLArrayRef) throws IniException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("ErrorAction", mLArrayRef);
        if (this.errorAction != ACTION) {
            this.errorAction.dispose();
        }
        this.errorAction = mLArrayRef2;
        this.enabledCallbacks[2] = 0;
    }

    public final MLArrayRef getErrorAction() {
        return this.errorAction;
    }

    public final void setInputBufferSize(int n) throws IniException {
        if (this.status == 1) {
            this.displayError("InputBufferSize cannot be set while OBJ is open.");
        }
        if (n < 1) {
            this.displayError("InputBufferSize must be greater than or equal to 1.");
        }
        this.inputBufferSize = n;
        this.bytesAvailable = 0;
        this.inputBuffer = new byte[this.inputBufferSize];
    }

    public final int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public final void setName(String string) {
        this.name = string;
        this.nameStandardFormat();
    }

    public final String getName() {
        return this.name;
    }

    public final void setOutputBufferSize(int n) throws IniException {
        if (this.status == 1) {
            this.displayError("OutputBufferSize cannot be set while OBJ is open.");
        }
        if (n < 1) {
            this.displayError("OutputBufferSize must be greater than or equal to 1.");
        }
        this.outputBufferSize = n;
        this.bytesToOutput = 0;
    }

    public final int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public final void setOutputEmptyAction(MLArrayRef mLArrayRef) throws IniException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("OutputEmptyAction", mLArrayRef);
        if (this.outputEmptyAction != ACTION) {
            this.outputEmptyAction.dispose();
        }
        this.outputEmptyAction = mLArrayRef2;
        this.enabledCallbacks[4] = 0;
    }

    public final MLArrayRef getOutputEmptyAction() {
        return this.outputEmptyAction;
    }

    public final void setRecordDetail(int n) {
        this.recordDetail = n;
    }

    public final int getRecordDetail() {
        return this.recordDetail;
    }

    public final void setRecordMode(int n) throws IniException {
        if (this.recordStatus) {
            this.displayError("RecordMode cannot be set while OBJ is recording.");
        }
        this.recordMode = n;
    }

    public final int getRecordMode() {
        return this.recordMode;
    }

    public final void setRecordName(String string) throws IniException {
        if (this.recordStatus) {
            this.displayError("RecordName cannot be set while OBJ is recording.");
        }
        if (string.equals("")) {
            this.displayError("RecordName cannot be set to an empty string.");
        }
        this.recordName = string;
    }

    public final String getRecordName() {
        return this.recordName;
    }

    public final void setRecordStatus(boolean bl) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("RecordStatus"));
    }

    public final boolean getRecordStatus() {
        return this.recordStatus;
    }

    public final void setStatus(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("Status"));
    }

    public final int getStatus() {
        return this.status;
    }

    public final void setTag(String string) {
        this.tag = string;
    }

    public final String getTag() {
        return this.tag;
    }

    public final void setTimeout(double d) throws IniException {
        if (d < 0.0) {
            this.displayError("Timeout must be greater than or equal to 0.");
        }
        if (this.status == 0) {
            this.timeout = d;
            return;
        }
        if (this.getTransferStatus() != 0) {
            this.displayError("Timeout " + NOASYNCOP);
        }
        try {
            this.setHardwareTimeout(d);
            this.timeout = this.getHardwareTimeout();
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final double getTimeout() {
        return this.timeout;
    }

    public void setTimerAction(MLArrayRef mLArrayRef) throws IniException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("TimerAction", mLArrayRef);
        if (this.timerAction != ACTION) {
            this.timerAction.dispose();
        }
        this.timerAction = mLArrayRef2;
        this.enabledCallbacks[6] = 0;
        if (this.status == 1) {
            if (this.timerAction == ACTION) {
                if (this.wasTimerStarted) {
                    this.timer.hold();
                    return;
                }
            } else {
                if (this.wasTimerStarted) {
                    this.timer.setDelay((int)(this.timerPeriod * 1000.0));
                    this.timer.reset();
                    return;
                }
                this.createTimer();
            }
        }
    }

    public MLArrayRef getTimerAction() {
        return this.timerAction;
    }

    public void setTimerPeriod(double d) throws IniException {
        if (this.status == 1) {
            this.displayError("TimerPeriod cannot be set while OBJ is open.");
        }
        if (d < 0.1) {
            this.displayError("TimerPeriod must be greater than or equal to 0.1s.");
        }
        this.timerPeriod = d;
    }

    public double getTimerPeriod() {
        return this.timerPeriod;
    }

    public final void setTransferStatus(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("TransferStatus"));
    }

    public final int getTransferStatus() {
        return this.transferStatus;
    }

    public final void setType(String string) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("Type"));
    }

    public final String getType() {
        return this.type;
    }

    public final void setUserData(MLArrayRef mLArrayRef) {
        if (this.userData != USERDATA) {
            this.userData.dispose();
        }
        this.userData = mLArrayRef;
    }

    public final MLArrayRef getUserData() {
        return this.userData;
    }

    public final void setValuesReceived(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("ValuesReceived"));
    }

    public final int getValuesReceived() {
        return this.valuesReceived;
    }

    public final void setValuesSent(int n) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("ValuesSent"));
    }

    public final int getValuesSent() {
        return this.valuesSent;
    }

    public Instrument() {
        allInstrumentObjects.addElement(this);
        Matlab.addListener((MatlabListener)this);
    }

    public final void fopen() throws IniException {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
            return;
        }
        if (this.status == 1) {
            this.displayError("OBJ has already been opened.");
        }
        try {
            this.openHardware();
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
        }
        try {
            this.updatePropsOnOpen();
            this.status = 1;
            this.valuesSent = 0;
            this.valuesReceived = 0;
            this.flushinput();
            this.flushoutput();
            int n = 0;
            while (n < this.enabledCallbacks.length) {
                this.enabledCallbacks[n] = 0;
                ++n;
            }
            this.addToPoller();
            return;
        }
        catch (Exception exception) {
            try {
                this.closeHardware();
            }
            catch (Exception exception2) {
                this.displayError("Could not disconnect.");
            }
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final void fclose() throws IniException {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        if (this.status == 0) {
            return;
        }
        if (this.transferStatus == 2 || this.transferStatus == 3) {
            this.displayError("OBJ cannot be closed while an asynchronous write is in progress." + LINESEP + "Use STOPASYNC to stop the asynchronous write operation.");
        }
        this.readAsyncCount = 0;
        this.readAsyncStopTime = 0.0;
        this.record("off");
        this.status = 0;
        this.transferStatus = 0;
        try {
            this.closeHardware();
            return;
        }
        catch (Exception exception) {
            this.displayError(exception.getMessage());
            return;
        }
    }

    public final void dispose() throws IniException {
        if (!this.isvalid()) {
            return;
        }
        if (this.status == 1) {
            this.displayError("OBJ must be disconnected from the hardware with FCLOSE before deleting.");
        }
        this.disposeMLArrayRefs();
        if (this.wasTimerStarted) {
            this.timer.stop();
            this.timer = null;
        }
        this.deleteInstrumentObject(this);
    }

    protected void superDisposeMLArrayRef() {
        if (this.bytesAvailableAction != ACTION) {
            this.bytesAvailableAction.dispose();
        }
        if (this.errorAction != ACTION) {
            this.errorAction.dispose();
        }
        if (this.outputEmptyAction != ACTION) {
            this.outputEmptyAction.dispose();
        }
        if (this.timerAction != ACTION) {
            this.timerAction.dispose();
        }
        if (this.userData != USERDATA) {
            this.userData.dispose();
        }
    }

    public final void flushinput() throws IniException {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        this.hardwareFlushInput();
        if (this.bytesAvailable > 0) {
            this.readInBuffer();
        }
        this.bytesAvailable = 0;
        this.bInStart = 0;
        this.bInLength = this.inputBufferSize;
        this.bInEnd = 0;
    }

    public final void flushoutput() throws Exception {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        int n = this.bytesToOutput;
        this.hardwareFlushOutput();
        if (n > 0 && !this.outputEmptyAction.equals(ACTION) && this.writeTransferMode == 1) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(4, "OutputEmpty", this.eventTime, new IniEvent("OutputEmpty", Instrument.constructClockVector(this.eventTime)));
        }
        this.bytesToOutput = 0;
    }

    public final void stopasync() throws Exception {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        this.readAsyncCount = 0;
        this.readAsyncStopTime = 0.0;
        this.hardwareStopAsync();
        this.transferStatus = 0;
    }

    public final void fprintf(Object[] objectArray, int n) throws Exception {
        String string;
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        if (this.status == 0) {
            this.displayError(MUSTCONNECT);
        }
        this.writeTransferMode = n;
        try {
            this.verifyWriteOperation();
        }
        catch (IniException iniException) {
            this.displayError(iniException.getMessage());
        }
        String string2 = this.getAsciiMessage(objectArray);
        int n2 = string2.length();
        if (n2 > this.outputBufferSize - this.bytesToOutput) {
            this.displayError("The number of bytes written must be less than or equal to OutputBufferSize-BytesToOutput.");
        }
        if (n2 == 0) {
            return;
        }
        if (this.writeTransferMode == 1) {
            this.updateWriteTransferStatus(true);
        }
        Object[] objectArray2 = null;
        objectArray2 = this.writeHardwareAscii(string2);
        this.valuesSent += ((Integer)objectArray2[1]).intValue();
        if (this.recordStatus) {
            try {
                this.appendAsciiDataToFile(string2, n2, ">");
            }
            catch (Exception exception) {}
            ++this.numCommandsWritten;
        }
        if (!(string = (String)objectArray2[2]).equals("")) {
            this.displayError(string);
        }
    }

    public final void fwrite(Object object, int n, int n2, int n3, int n4) throws Exception {
        String string;
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        if (this.status == 0) {
            this.displayError(MUSTCONNECT);
        }
        this.writeTransferMode = n3;
        try {
            this.verifyWriteOperation();
        }
        catch (IniException iniException) {
            this.displayError(iniException.getMessage());
        }
        if (DATASIZE[n2] * n > this.outputBufferSize - this.bytesToOutput) {
            this.displayError("The number of bytes written must be less than or equal to OutputBufferSize-BytesToOutput.");
        }
        if (this.writeTransferMode == 1) {
            this.updateWriteTransferStatus(true);
        }
        Object[] objectArray = this.writeHardwareBinary(object, n, n2);
        this.valuesSent += ((Integer)objectArray[0]).intValue();
        if (this.recordStatus) {
            try {
                this.binarySign = n4;
                this.appendBinaryDataToFile(object, n, n2, ">", "");
            }
            catch (Exception exception) {}
            ++this.numCommandsWritten;
        }
        if (!(string = (String)objectArray[1]).equals("")) {
            this.displayError(string);
        }
    }

    public final Object[] fscanf(int n) throws IniException {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        if (this.status == 0) {
            this.displayError(MUSTCONNECT);
        }
        if (n > this.inputBufferSize) {
            this.displayError("SIZE must be less than or equal to InputBufferSize.");
        }
        Object[] objectArray = new Object[3];
        try {
            Object[] objectArray2 = this.readHardwareAscii(n);
            String string = (String)objectArray2[0];
            if (this.recordStatus) {
                try {
                    this.appendAsciiDataToFile(string, string.length(), "<");
                }
                catch (Exception exception) {}
                ++this.numCommandsWritten;
            }
            this.valuesReceived += string.length();
            objectArray[0] = string;
            objectArray[1] = new Integer(string.length());
            objectArray[2] = objectArray2[1];
        }
        catch (Exception exception) {
            objectArray[0] = "";
            objectArray[1] = INTEGER_ZERO;
            objectArray[2] = exception.getMessage();
        }
        return objectArray;
    }

    public final Object[] fgets() throws IniException {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        if (this.status == 0) {
            this.displayError(MUSTCONNECT);
        }
        Object[] objectArray = new Object[3];
        try {
            Object[] objectArray2 = this.readHardwareAscii(0);
            String string = (String)objectArray2[0];
            this.valuesReceived += string.length();
            if (this.recordStatus) {
                try {
                    this.appendAsciiDataToFile(string, string.length(), "<");
                }
                catch (Exception exception) {}
                ++this.numCommandsWritten;
            }
            objectArray[0] = string;
            objectArray[1] = new Integer(string.length());
            objectArray[2] = objectArray2[1];
        }
        catch (Exception exception) {
            objectArray[0] = "";
            objectArray[1] = INTEGER_ZERO;
            objectArray[2] = exception.getMessage();
        }
        return objectArray;
    }

    public final Object[] fgetl() throws IniException {
        Object[] objectArray = this.fgets();
        String string = (String)objectArray[2];
        if (string.equals("")) {
            String string2 = (String)objectArray[0];
            Object[] objectArray2 = new Object[]{this.removeTerminator(string2), objectArray[1], objectArray[2]};
            return objectArray2;
        }
        return objectArray;
    }

    public final Object[] fread(int n, int n2, int n3) throws Exception {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        if (this.status == 0) {
            this.displayError(MUSTCONNECT);
        }
        if (DATASIZE[n2] * n > this.inputBufferSize) {
            this.displayError("SIZE * PRECISION must be less than or equal to InputBufferSize.");
        }
        Object[] objectArray = this.readHardwareBinary(n, n2);
        Object object = objectArray[0];
        int n4 = (Integer)objectArray[1];
        this.valuesReceived += n4;
        if (this.recordStatus) {
            try {
                this.binarySign = n3;
                this.appendBinaryDataToFile(object, n4, n2, "<", "");
            }
            catch (Exception exception) {}
            ++this.numCommandsWritten;
        }
        Object[] objectArray2 = new Object[]{object, objectArray[1], objectArray[2]};
        return objectArray2;
    }

    public final void readasync() throws IniException {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        if (this.status == 0) {
            this.displayError(MUSTCONNECT);
        }
        if (this.inputBufferSize - this.bytesAvailable == 0) {
            return;
        }
        this.verifyReadOperation();
        this.readAsyncCount = this.inputBufferSize - this.bytesAvailable;
        this.readAsyncStopTime = (double)System.currentTimeMillis() + this.timeout * 1000.0;
    }

    public final void readasync(int n) throws IniException {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        if (this.status == 0) {
            this.displayError(MUSTCONNECT);
        }
        if (n > this.inputBufferSize - this.bytesAvailable) {
            this.displayError("SIZE must be less than or equal to InputBufferSize-BytesAvailable.");
        }
        this.verifyReadOperation();
        this.readAsyncCount = n;
        this.readAsyncStopTime = (double)System.currentTimeMillis() + this.timeout * 1000.0;
    }

    public final Object[] query(Object[] objectArray) throws Exception {
        if (!IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'query'.");
        }
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        this.fprintf(objectArray, 0);
        return this.fscanf(0);
    }

    protected final void deleteInstrumentObject(Instrument instrument) {
        int n = allInstrumentObjects.indexOf(instrument);
        if (n != -1) {
            allInstrumentObjects.removeElementAt(n);
        }
    }

    public static final void deleteLastCreatedObject() {
        int n = allInstrumentObjects.size();
        if (n != 0) {
            allInstrumentObjects.removeElementAt(n - 1);
        }
    }

    public final boolean isvalid() {
        ctrlc_flag = false;
        int n = allInstrumentObjects.indexOf(this);
        return n != -1;
    }

    public static final Vector jinstrfind() {
        return allInstrumentObjects;
    }

    public final void record() throws IniException {
        if (this.recordStatus) {
            this.record("off");
            return;
        }
        this.record("on");
    }

    public final void record(String string) throws IniException {
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        string = string.toLowerCase();
        switch (this.status) {
            case 1: {
                if (string.equals("on")) {
                    this.turnOnRecordStatus();
                    return;
                }
                if (string.equals("off")) {
                    this.turnOffRecordStatus();
                }
                return;
            }
            case 0: {
                if (string.equals("off")) {
                    return;
                }
                if (!string.equals("on")) break;
                this.displayError(MUSTCONNECT);
            }
        }
    }

    private final void turnOnRecordStatus() throws IniException {
        if (this.recordStatus) {
            return;
        }
        int n = openRecordFileNames.indexOf(this.recordName);
        if (n != -1) {
            this.displayError("Another instrument object is currently recording to " + this.recordName + "." + " The RecordName " + LINESEP + "property should be set to a new filename or" + " recording should be turned off " + LINESEP + "with the RECORD function.");
        } else {
            openRecordFileNames.addElement(this.recordName);
        }
        this.recordStatus = true;
        try {
            this.file = new File(this.recordName);
            switch (this.recordMode) {
                case 0: 
                case 2: {
                    this.file.delete();
                }
            }
            this.appendWriter = new RandomAccessFile(this.file, "rw");
            long l = this.appendWriter.length();
            this.appendWriter.seek(l);
            switch (this.recordMode) {
                case 0: 
                case 2: {
                    this.appendLegendToFile();
                    break;
                }
                case 1: {
                    if (l != 0L) break;
                    this.appendLegendToFile();
                }
            }
            this.eventTime = Calendar.getInstance();
            this.appendToFile(String.valueOf(this.numCommandsWritten) + "      Recording on " + this.constructEventTime(this.eventTime) + "." + " Binary data in " + BYTE_ORDER_STR[platform] + " endian format.");
            ++this.numCommandsWritten;
            return;
        }
        catch (IOException iOException) {
            this.turnOffRecordStatus();
            this.displayWarning("An error occurred while opening the file. RecordMode has been set to off.");
            return;
        }
    }

    private final void appendLegendToFile() throws IniException {
        this.appendToFile("Legend: ");
        this.appendToFile("  * - An event occurred.");
        this.appendToFile("  > - A write operation occurred.");
        this.appendToFile("  < - A read operation occurred.");
        this.appendToFile(" ");
    }

    private final void turnOffRecordStatus() throws IniException {
        openRecordFileNames.removeElement(this.recordName);
        if (this.recordStatus && this.recordMode == 2) {
            this.recordName = this.parseFileName(this.recordName);
        }
        int n = 5 - new Integer(this.numCommandsWritten).toString().length();
        String string = String.valueOf(this.numCommandsWritten) + BLANKS.substring(0, n) + "  Recording off." + LINESEP;
        this.recordStatus = false;
        this.numCommandsWritten = 1;
        try {
            if (this.appendWriter != null) {
                this.appendToFile(string);
                this.appendWriter.close();
                this.appendWriter = null;
                return;
            }
        }
        catch (IOException iOException) {
            this.displayError(iOException.getMessage());
        }
    }

    protected final void appendToFile(String string) throws IniException {
        try {
            this.appendWriter.writeBytes(String.valueOf(string) + "\n");
            return;
        }
        catch (IOException iOException) {
            this.turnOffRecordStatus();
            this.displayWarning("An error occurred while writing to the file. Recording has been turned off.");
            return;
        }
    }

    private final void appendAsciiDataToFile(String string, int n, String string2) throws IniException {
        int n2 = 5 - new Integer(this.numCommandsWritten).toString().length();
        try {
            this.appendWriter.writeBytes(String.valueOf(this.numCommandsWritten) + BLANKS.substring(0, n2) + string2 + " ");
        }
        catch (IOException iOException) {
            this.turnOffRecordStatus();
            this.displayWarning("An error occurred while writing to the file. Recording has been turned off.");
        }
        switch (this.recordDetail) {
            case 0: {
                this.appendToFile(String.valueOf(n) + " ascii values.");
                return;
            }
            case 1: {
                this.appendToFile(String.valueOf(n) + " ascii values.");
                int n3 = 0;
                while (n3 < string.length()) {
                    int n4 = 60;
                    if (n3 + 60 > string.length()) {
                        n4 = string.length() - n3;
                    }
                    this.appendToFile(String.valueOf(BLANKS.substring(0, 7)) + string.substring(n3, n3 + n4));
                    n3 += 60;
                }
                return;
            }
        }
    }

    protected final void appendBinaryDataToFile(Object object, int n, int n2, String string, String string2) throws Exception {
        int n3 = 5 - new Integer(this.numCommandsWritten).toString().length();
        try {
            this.appendWriter.writeBytes(String.valueOf(this.numCommandsWritten) + BLANKS.substring(0, n3) + string + " ");
        }
        catch (IOException iOException) {
            this.turnOffRecordStatus();
            this.displayWarning("An error occurred while writing to the file. Recording has been turned off.");
        }
        switch (this.recordDetail) {
            case 0: {
                this.appendBinaryCompactToFile(n, n2, string2);
                return;
            }
            case 1: {
                this.appendBinaryVerboseToFile(object, n, n2, string2);
                return;
            }
        }
    }

    private final void appendBinaryCompactToFile(int n, int n2, String string) throws IniException {
        String string2 = "";
        switch (n2) {
            case 0: {
                string2 = String.valueOf(n) + " " + PRE_DATATYPE_STR[this.binarySign] + "int8 values" + string + ".";
                break;
            }
            case 1: {
                string2 = String.valueOf(n) + " " + PRE_DATATYPE_STR[this.binarySign] + "int16 values" + string + ".";
                break;
            }
            case 2: {
                string2 = String.valueOf(n) + " " + PRE_DATATYPE_STR[this.binarySign] + "int32 values" + string + ".";
                break;
            }
            case 3: {
                string2 = String.valueOf(n) + " single precision values.";
                break;
            }
            case 4: {
                string2 = String.valueOf(n) + " double precision values.";
                break;
            }
            case 5: {
                string2 = String.valueOf(n) + " " + PRE_DATATYPE_STR[this.binarySign] + "char values" + string + ".";
                break;
            }
        }
        this.appendToFile(string2);
    }

    private final void appendBinaryVerboseToFile(Object object, int n, int n2, String string) throws Exception {
        int n3 = 0;
        int n4 = 7;
        String string2 = "";
        switch (n2) {
            case 0: {
                byte[] byArray = object instanceof Byte ? Instrument.object2byteArray(object) : (byte[])object;
                string2 = String.valueOf(n) + " " + PRE_DATATYPE_STR[this.binarySign] + "int8 values" + string + ".\n" + BLANKS.substring(0, n4);
                this.appendWriter.writeBytes(string2);
                n3 = 1;
                while (n3 <= n) {
                    this.appendWriter.writeBytes(String.valueOf(this.dec2hex(byArray[n3 - 1], 2)) + " ");
                    if (n3 % 16 == 0) {
                        this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n4));
                    }
                    ++n3;
                }
                break;
            }
            case 1: {
                short[] sArray = object instanceof Short ? this.object2shortArray(object) : (short[])object;
                string2 = String.valueOf(n) + " " + PRE_DATATYPE_STR[this.binarySign] + "int16 values" + string + ".\n" + BLANKS.substring(0, n4);
                this.appendWriter.writeBytes(string2);
                n3 = 1;
                while (n3 <= n) {
                    this.appendWriter.writeBytes(String.valueOf(this.dec2hex(sArray[n3 - 1], 4)) + " ");
                    if (n3 % 8 == 0) {
                        this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n4));
                    }
                    ++n3;
                }
                break;
            }
            case 2: {
                int[] nArray = object instanceof Integer ? this.object2intArray(object) : (int[])object;
                string2 = String.valueOf(n) + " " + PRE_DATATYPE_STR[this.binarySign] + "int32 values" + string + ".\n" + BLANKS.substring(0, n4);
                this.appendWriter.writeBytes(string2);
                n3 = 1;
                while (n3 <= n) {
                    this.appendWriter.writeBytes(String.valueOf(this.dec2hex(nArray[n3 - 1], 8)) + " ");
                    if (n3 % 4 == 0) {
                        this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n4));
                    }
                    ++n3;
                }
                break;
            }
            case 3: {
                Object object2;
                float[] fArray = new float[4];
                int n5 = 0;
                float[] fArray2 = object instanceof Float ? this.object2floatArray(object) : (float[])object;
                this.appendWriter.writeBytes(String.valueOf(n) + " single precision values.\n" + BLANKS.substring(0, n4));
                n3 = 1;
                while (n3 <= n) {
                    object2 = this.dec2hex(Float.floatToIntBits(fArray2[n3 - 1]), 8);
                    this.appendWriter.writeBytes(String.valueOf(object2) + " ");
                    fArray[n5++] = fArray2[n3 - 1];
                    if (n5 == 4) {
                        int n6 = 0;
                        while (n6 < 4) {
                            this.appendBinaryText("    ", String.valueOf(fArray[n6]));
                            ++n6;
                        }
                        if (n3 != n) {
                            this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n4));
                        }
                        n5 = 0;
                    }
                    ++n3;
                }
                if (n5 == 0) break;
                object2 = new int[]{31, 22, 13};
                this.appendBinaryText(BLANKS.substring(0, (int)object2[n5 - 1]), String.valueOf(fArray[0]));
                n3 = 1;
                while (n3 < n5) {
                    this.appendBinaryText("    ", String.valueOf(fArray[n3]));
                    ++n3;
                }
                break;
            }
            case 4: {
                double[] dArray = new double[2];
                int n7 = 0;
                double[] dArray2 = object instanceof Double ? this.object2doubleArray(object) : (double[])object;
                this.appendWriter.writeBytes(String.valueOf(n) + " double precision values.\n" + BLANKS.substring(0, n4));
                n3 = 1;
                while (n3 <= n) {
                    long l = Double.doubleToLongBits(dArray2[n3 - 1]);
                    this.appendWriter.writeBytes(String.valueOf(this.dec2hex((int)(l >>> 56) & 0xFF, 2)) + this.dec2hex((int)(l >>> 48) & 0xFF, 2) + this.dec2hex((int)(l >>> 40) & 0xFF, 2) + this.dec2hex((int)(l >>> 32) & 0xFF, 2) + this.dec2hex((int)(l >>> 24) & 0xFF, 2) + this.dec2hex((int)(l >>> 16) & 0xFF, 2) + this.dec2hex((int)(l >>> 8) & 0xFF, 2) + this.dec2hex((int)l & 0xFF, 2) + " ");
                    dArray[n7++] = dArray2[n3 - 1];
                    if (n7 == 2) {
                        this.appendBinaryText("      ", String.valueOf(dArray[0]));
                        this.appendBinaryText("    ", String.valueOf(dArray[1]));
                        if (n3 != n) {
                            this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n4));
                        }
                        n7 = 0;
                    }
                    ++n3;
                }
                if (n7 == 0) break;
                this.appendBinaryText(BLANKS.substring(0, 23), String.valueOf(dArray[0]));
                break;
            }
            case 5: {
                byte[] byArray = object instanceof Byte ? Instrument.object2byteArray(object) : (byte[])object;
                string2 = String.valueOf(n) + " " + PRE_DATATYPE_STR[this.binarySign] + "char values" + string + ".\n" + BLANKS.substring(0, n4);
                this.appendWriter.writeBytes(string2);
                n3 = 1;
                while (n3 <= n) {
                    this.appendWriter.writeBytes(String.valueOf(this.dec2hex(byArray[n3 - 1], 2)) + " ");
                    if (n3 % 16 == 0) {
                        this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n4));
                    }
                    ++n3;
                }
                break;
            }
        }
        this.appendWriter.writeBytes("\n");
    }

    private void appendBinaryText(String string, String string2) throws IniException {
        try {
            String string3;
            int n = string2.lastIndexOf("E");
            if (n != -1) {
                double d;
                String string4;
                string3 = string2.substring(0, n);
                string2 = string3.length() >= 7 ? (string3.substring(6, 7).compareTo("5") >= 0 ? ((string4 = String.valueOf(d = new Double(string3.substring(0, 6)) + 1.0E-4)).length() > 6 ? String.valueOf(string4.substring(0, 6)) + "e" + string2.substring(n + 1) : String.valueOf(string4) + "e" + string2.substring(n + 1)) : String.valueOf(string3.substring(0, 6)) + "e" + string2.substring(n + 1)) : String.valueOf(string3.substring(0, n)) + "e" + string2.substring(n + 1);
            }
            string3 = "";
            if (string2.length() < 12) {
                string3 = BLANKS.substring(0, 12 - string2.length());
            }
            this.appendWriter.writeBytes(String.valueOf(string) + string2 + string3);
            return;
        }
        catch (Exception exception) {
            this.turnOffRecordStatus();
            this.displayWarning("An error occurred while writing to the file. Recording has been turned off.");
            return;
        }
    }

    private final String parseFileName(String string) {
        if (string.equals("")) {
            return "";
        }
        String string2 = "";
        String string3 = "";
        int n = string.lastIndexOf(FILESEP);
        if (n == -1) {
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        }
        boolean bl = true;
        int n2 = string2.lastIndexOf(".");
        if (n2 == -1) {
            n2 = string2.length();
            string2 = String.valueOf(string2) + ".txt";
            bl = false;
        }
        String string4 = string2.substring(n2, string2.length());
        char c = string2.charAt(n2 - 1);
        boolean bl2 = Character.isDigit(c);
        if (!bl2) {
            String string5 = string2.substring(0, n2);
            if (bl) {
                return String.valueOf(string3) + string5 + "01" + string4;
            }
            return String.valueOf(string3) + string5 + "01";
        }
        int n3 = 0;
        while (bl2 && n2 - n3 >= 1) {
            c = string2.charAt(n2 - n3 - 1);
            bl2 = Character.isDigit(c);
            if (!bl2) continue;
            ++n3;
        }
        String string6 = string2.substring(0, n2 - n3);
        String string7 = string2.substring(n2 - n3, n2);
        Integer n4 = new Integer(string7);
        int n5 = n4 + 1;
        int n6 = Integer.toString(n5).length();
        int n7 = n3 - n6;
        String string8 = n7 > 0 ? ZEROS.substring(0, n7) : "";
        if (bl) {
            return String.valueOf(string3) + string6 + string8 + n5 + string4;
        }
        return String.valueOf(string3) + string6 + string8 + n5;
    }

    public final Object[] propinfo(String[] stringArray) throws IniException {
        if (!IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'propinfo'.");
        }
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        this.updateObjectSpecificProperties(this.objectProps);
        int n = this.objectProps.length;
        Object[] objectArray = new Object[6];
        Object[] objectArray2 = new Object[stringArray.length];
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = this.objectProps[n2].name.toLowerCase();
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            Object object;
            int n4 = this.findPropertyCompleteName(stringArray[n3].toLowerCase(), stringArray2, stringArray[n3]);
            objectArray[0] = this.objectProps[n4].type;
            objectArray[1] = this.objectProps[n4].constraint;
            objectArray[2] = this.objectProps[n4].constraintValue;
            objectArray[3] = this.objectProps[n4].defaultValue;
            objectArray[4] = this.objectProps[n4].readOnly;
            objectArray[5] = new Integer(this.objectProps[n4].interfaceSpecific);
            objectArray2[n3] = object = objectArray.clone();
            ++n3;
        }
        return objectArray2;
    }

    public final Object[] propinfo() throws IniException {
        if (!IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'propinfo'.");
        }
        if (!this.isvalid()) {
            this.displayError(INVALIDOBJ);
        }
        this.updateObjectSpecificProperties(this.objectProps);
        int n = this.objectProps.length;
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[7];
        int n2 = 0;
        while (n2 < n) {
            Object object;
            objectArray2[0] = this.objectProps[n2].name;
            objectArray2[1] = this.objectProps[n2].type;
            objectArray2[2] = this.objectProps[n2].constraint;
            objectArray2[3] = this.objectProps[n2].constraintValue;
            objectArray2[4] = this.objectProps[n2].defaultValue;
            objectArray2[5] = this.objectProps[n2].readOnly;
            objectArray2[6] = new Integer(this.objectProps[n2].interfaceSpecific);
            objectArray[n2] = object = objectArray2.clone();
            ++n2;
        }
        return objectArray;
    }

    public final Object createPropSetArray(String string, String string2) throws IniException {
        int n = this.objectProps.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.objectProps[n2].name.toLowerCase();
            ++n2;
        }
        int n3 = this.findPropertyCompleteName(string.toLowerCase(), stringArray, string);
        if (this.objectProps[n3].readOnly.equals("always")) {
            this.displayError("Attempt to modify read-only " + string2 + " property: '" + this.objectProps[n3].name + "'.");
        }
        if (this.objectProps[n3].type.equals("double")) {
            return "";
        }
        return this.objectProps[n3].constraintValue;
    }

    public final String createPropSetDisplay(String[] stringArray, String string) throws IniException {
        int n = this.objectProps.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = this.objectProps[n2].name.toLowerCase();
            ++n2;
        }
        int n3 = this.findPropertyCompleteName(stringArray[0].toLowerCase(), stringArray2, stringArray[0]);
        if (this.objectProps[n3].readOnly.equals("always")) {
            this.displayError("Attempt to modify read-only " + string + " property: '" + this.objectProps[n3].name + "'.");
        }
        if (this.objectProps[n3].constraint.equals("enum")) {
            try {
                String[] stringArray3 = (String[])this.objectProps[n3].constraintValue;
                String string2 = (String)this.objectProps[n3].defaultValue;
                String string3 = "[ ";
                int n4 = 0;
                while (n4 < stringArray3.length) {
                    string3 = stringArray3[n4].equals(string2) ? String.valueOf(string3) + "{" + stringArray3[n4] + "}" : String.valueOf(string3) + stringArray3[n4];
                    string3 = n4 == stringArray3.length - 1 ? String.valueOf(string3) + " ]" : String.valueOf(string3) + " | ";
                    ++n4;
                }
                return string3;
            }
            catch (ClassCastException classCastException) {
                return "A " + string + " object's '" + this.objectProps[n3].name + "' property does not have a fixed set of property values.";
            }
        }
        return "A " + string + " object's '" + this.objectProps[n3].name + "' property does not have a fixed set of property values.";
    }

    public final int[] isInterfaceSpecific() {
        int n = this.objectProps.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.objectProps[n2].interfaceSpecific;
            ++n2;
        }
        return nArray;
    }

    public final int[] isSettable() {
        int n = this.objectProps.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.objectProps[n2].readOnly.equals("always") ? 0 : 1;
            ++n2;
        }
        return nArray;
    }

    public static final String[] findStructProps() {
        String[] stringArray = new String[]{"BusManagementStatus", "HandshakeStatus", "PinStatus"};
        return stringArray;
    }

    protected synchronized void putDataInOutputVector(Object object, int n, int n2) throws IOException {
        this.outputBufferData.addElement(new Double(n));
        this.outputBufferData.addElement(new Integer(n2));
        this.outputBufferData.addElement(object);
        this.bytesToOutput += n * DATASIZE[n2];
        this.asyncWriteFlag = true;
    }

    protected synchronized boolean dataAvailableOutputVector() throws IOException {
        return !this.outputBufferData.isEmpty();
    }

    protected synchronized double getDoubleFromOutputVector() throws IOException {
        return (Double)this.outputBufferData.elementAt(0);
    }

    protected synchronized int getIntFromOutputVector() throws IOException {
        return (Integer)this.outputBufferData.elementAt(1);
    }

    protected synchronized Object getObjectFromOutputVector() throws Exception {
        Object e = this.outputBufferData.elementAt(2);
        this.flushOutputVector();
        return e;
    }

    protected synchronized void flushOutputVector() throws Exception {
        this.outputBufferData.removeAllElements();
    }

    protected synchronized void bInPut(byte by) {
        this.inputBuffer[this.bInEnd] = by;
        ++this.bInEnd;
        if (this.bInEnd == this.bInLength) {
            this.bInEnd = 0;
        }
        ++this.bytesAvailable;
        --this.readAsyncCount;
    }

    protected synchronized byte bInGet() throws IniException {
        if (this.bytesAvailable == 0) {
            this.displayError("Input buffer empty.");
        }
        byte by = this.inputBuffer[this.bInStart];
        ++this.bInStart;
        --this.bytesAvailable;
        if (this.bInStart == this.bInLength) {
            this.bInStart = 0;
        }
        return by;
    }

    protected synchronized byte[] readInBuffer() throws IniException {
        return this.readInBuffer(this.bytesAvailable);
    }

    protected synchronized byte[] readInBuffer(int n) throws IniException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.bInGet();
            ++n2;
        }
        return byArray;
    }

    protected synchronized String readInBufferAscii(int n) throws IniException {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            String string = new Character((char)this.bInGet()).toString();
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected synchronized void fillInBuffer(byte[] byArray, byte[] byArray2) {
        this.fillInBuffer(byArray, byArray2, byArray.length);
    }

    protected synchronized void fillInBuffer(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            this.bInPut(byArray[n2]);
            if (!this.bytesAvailableAction.equals(ACTION)) {
                this.byteAvailableEventOccurred(byArray[n2], byArray2);
            }
            ++n2;
        }
    }

    protected synchronized void fillInBuffer(byte[] byArray) {
        this.fillInBuffer(byArray, byArray.length);
    }

    protected synchronized void fillInBuffer(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            this.bInPut(byArray[n2]);
            ++n2;
        }
    }

    private synchronized void byteAvailableEventOccurred(byte by, byte[] byArray) {
        switch (this.bytesAvailableActionMode) {
            case 1: {
                if (this.bytesAvailable % this.bytesAvailableActionCount != 0) break;
                this.eventTime = Calendar.getInstance();
                this.executeEvent(1, "BytesAvailable", this.eventTime, new IniEvent("BytesAvailable", Instrument.constructClockVector(this.eventTime)));
                return;
            }
            case 0: {
                if (this.foundFirstTerminator) {
                    if (by == byArray[1]) {
                        this.eventTime = Calendar.getInstance();
                        this.executeEvent(1, "BytesAvailable", this.eventTime, new IniEvent("BytesAvailable", Instrument.constructClockVector(this.eventTime)));
                        this.foundFirstTerminator = false;
                        return;
                    }
                    this.foundFirstTerminator = false;
                    return;
                }
                if (by == byArray[0]) {
                    if (byArray.length == 1) {
                        this.eventTime = Calendar.getInstance();
                        this.executeEvent(1, "BytesAvailable", this.eventTime, new IniEvent("BytesAvailable", Instrument.constructClockVector(this.eventTime)));
                        return;
                    }
                    this.foundFirstTerminator = true;
                    return;
                }
                this.foundFirstTerminator = false;
                return;
            }
        }
    }

    public synchronized void executeEvent(int n, String string, Calendar calendar, Object object) {
        if (this.enabledCallbacks[n] == 1) {
            return;
        }
        Matlab.whenMatlabReady((Runnable)new ActionQueue(this, n, object));
        IniEvent iniEvent = (IniEvent)object;
        if (this.recordStatus) {
            int n2 = 5 - new Integer(this.numCommandsWritten).toString().length();
            try {
                this.appendToFile(String.valueOf(this.numCommandsWritten) + BLANKS.substring(0, n2) + "* " + string + " event occurred at " + this.constructEventTime(calendar) + ".");
                if (iniEvent.Data instanceof IniErrorEvent) {
                    this.appendToFile(String.valueOf(BLANKS.substring(0, 7)) + ((IniErrorEvent)iniEvent.Data).Message);
                } else if (iniEvent.Data instanceof IniPinEvent) {
                    this.appendToFile(String.valueOf(BLANKS.substring(0, 7)) + ((IniPinEvent)iniEvent.Data).Pin + " is '" + ((IniPinEvent)iniEvent.Data).PinValue + "'.");
                } else if (iniEvent.Data instanceof IniTriggerEvent) {
                    this.appendToFile(String.valueOf(BLANKS.substring(0, 7)) + "Trigger line is " + ((IniTriggerEvent)iniEvent.Data).TriggerLine + ".");
                }
            }
            catch (Exception exception) {}
            ++this.numCommandsWritten;
        }
    }

    protected synchronized void executeErrorEvent(Calendar calendar, String string) {
        if (!this.errorAction.equals(ACTION)) {
            this.executeEvent(2, "Error", calendar, new IniEvent("Error", Instrument.constructClockVector(calendar), string));
        }
    }

    public void queueAction(int n) {
        this.actionQueue.addElement(new Integer(n));
    }

    protected boolean isActionAvailable() {
        return this.actionQueue.size() >= 2;
    }

    protected int getNextAction() {
        int n = (Integer)this.actionQueue.firstElement();
        this.actionQueue.removeElementAt(0);
        return n;
    }

    protected final String invalidDisplay() {
        return String.valueOf(LINESEP) + " Invalid instrument object." + LINESEP + " This object has been deleted and cannot be" + LINESEP + " connected to the hardware. This object should" + LINESEP + " be removed from your workspace with CLEAR." + LINESEP + " " + LINESEP;
    }

    protected static final double[] constructClockVector(Calendar calendar) {
        double[] dArray = new double[6];
        double d = calendar.get(14);
        dArray[0] = calendar.get(1);
        dArray[1] = calendar.get(2) + 1;
        dArray[2] = calendar.get(5);
        dArray[3] = calendar.get(11);
        dArray[4] = calendar.get(12);
        dArray[5] = (int)Math.round((double)calendar.get(13) + d / 1000.0);
        return dArray;
    }

    protected final String constructEventTime(Calendar calendar) {
        return String.valueOf(this.padWithZero(calendar.get(5))) + "-" + MONTHS[calendar.get(2)] + "-" + calendar.get(1) + " at " + this.padWithZero(calendar.get(11)) + ":" + this.padWithZero(calendar.get(12)) + ":" + this.padWithZero(calendar.get(13)) + "." + this.padMilliWithZero(calendar.get(14));
    }

    private final String padWithZero(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return new Integer(n).toString();
    }

    private final String padMilliWithZero(int n) {
        if (n < 10) {
            return "00" + n;
        }
        if (n < 100) {
            return "0" + n;
        }
        return new Integer(n).toString();
    }

    protected final int findPropertyCompleteName(String string, String[] stringArray, String string2) throws IniException {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].startsWith(string)) {
                if (n2 + 1 < n && stringArray[n2 + 1].startsWith(string) && !stringArray[n2].equals(string)) {
                    this.displayError("Specified property: '" + string2 + "' is not unique.");
                }
                return n2;
            }
            ++n2;
        }
        throw new IniException("Invalid property: '" + string2 + "' specified.");
    }

    protected final String getVendorName(String string) {
        if (string.startsWith("mw")) {
            int n = string.indexOf(".");
            string = string.substring(2, n - 4).toUpperCase();
        }
        return string;
    }

    protected final int str2num(String string) {
        return Integer.valueOf(string);
    }

    protected final int hex2dec(String string) throws Exception {
        return Integer.parseInt(string, 16);
    }

    protected final String dec2hex(int n, int n2) {
        String string;
        if (this.binarySign == 1) {
            n = Math.abs(n);
        }
        try {
            string = Integer.toHexString(n);
        }
        catch (Exception exception) {
            string = "?";
        }
        int n3 = n2 - string.length();
        if (n3 < 0) {
            return string.substring(string.length() - n2);
        }
        return String.valueOf(ZEROS.substring(0, n3)) + string;
    }

    protected final MLArrayRef verifyActionValue(String string, MLArrayRef mLArrayRef) throws IniException {
        int n = mLArrayRef.getType();
        if (n != 1 && n != 4) {
            this.displayError(String.valueOf(string) + ACTIONERROR);
        }
        if (mLArrayRef.getM() == 0 && mLArrayRef.getN() == 0) {
            return ACTION;
        }
        if (mLArrayRef.getM() != 1) {
            this.displayError(String.valueOf(string) + ACTIONERROR);
        }
        if (n == 1) {
            MLArrayRef mLArrayRef2 = mLArrayRef.cellInfoAt(0);
            if (mLArrayRef2.getType() != 4) {
                mLArrayRef2.dispose();
                this.displayError(String.valueOf(string) + ACTIONERROR);
            }
            mLArrayRef2.dispose();
        }
        return mLArrayRef;
    }

    protected final boolean verifySetValues(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] == d) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected final boolean verifySetRange(int n, int n2, int n3) {
        return n <= n3 && n >= n2;
    }

    protected static final byte[] object2byteArray(Object object) {
        Byte by = (Byte)object;
        Instrument.singleByteMessage[0] = by;
        return singleByteMessage;
    }

    protected final short[] object2shortArray(Object object) {
        Short s = (Short)object;
        Instrument.singleShortMessage[0] = s;
        return singleShortMessage;
    }

    protected final int[] object2intArray(Object object) {
        Integer n = (Integer)object;
        Instrument.singleIntegerMessage[0] = n;
        return singleIntegerMessage;
    }

    protected final float[] object2floatArray(Object object) {
        Float f = (Float)object;
        Instrument.singleFloatMessage[0] = f.floatValue();
        return singleFloatMessage;
    }

    protected final double[] object2doubleArray(Object object) {
        Double d = (Double)object;
        Instrument.singleDoubleMessage[0] = d;
        return singleDoubleMessage;
    }

    protected static final char[] object2charArray(Object object) {
        Character c = (Character)object;
        Instrument.singleCharacterMessage[0] = c.charValue();
        return singleCharacterMessage;
    }

    protected final String int2OnOff(int n) {
        switch (n) {
            case 0: {
                return "off";
            }
        }
        return "on";
    }

    protected final String bool2OnOff(boolean bl) {
        if (bl) {
            return "on";
        }
        return "off";
    }

    protected final int bool2int(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    protected final boolean int2bool(int n) {
        return n > 0;
    }

    protected final void displayError(String string) throws IniException {
        throw new IniException(string);
    }

    protected final void displayWarning(String string) {
        Object[] objectArray = new Object[]{string};
        Matlab.whenMatlabReady((Runnable)new IniWarning(objectArray));
    }

    protected final String createReadOnlyPropertyError(String string) {
        return "The property: '" + string + "' is read-only.";
    }

    public static final String jarVersion() {
        return "Version 1.0 (R12)";
    }

    public static void main(String[] stringArray) {
    }

    protected abstract void openHardware() throws Exception;

    protected abstract void closeHardware() throws Exception;

    protected abstract void createTimer();

    protected abstract void disposeMLArrayRefs();

    protected abstract Object[] writeHardwareAscii(String var1) throws Exception;

    protected abstract Object[] writeHardwareBinary(Object var1, int var2, int var3) throws Exception;

    protected abstract Object[] readHardwareAscii(int var1) throws Exception;

    protected abstract Object[] readHardwareBinary(int var1, int var2) throws Exception;

    protected abstract void updatePropsOnOpen() throws Exception;

    protected abstract void setHardwareTimeout(double var1) throws IniException;

    protected abstract double getHardwareTimeout();

    protected abstract void nameStandardFormat();

    protected abstract String removeTerminator(String var1);

    protected abstract void hardwareStopAsync() throws Exception;

    protected abstract String getAsciiMessage(Object[] var1);

    protected abstract void verifyWriteOperation() throws IniException;

    protected abstract void verifyReadOperation() throws IniException;

    protected abstract void hardwareFlushInput();

    protected abstract void hardwareFlushOutput() throws IniException;

    protected abstract void updateObjectSpecificProperties(IniProp[] var1);

    protected abstract void poll();

    protected abstract void addToPoller();

    protected abstract void updateWriteTransferStatus(boolean var1);

    static {
        allInstrumentObjects = new Vector();
        try {
            Object[] objectArray = new String[]{"Instr_Control_Toolbox"};
            boolean[] blArray = (boolean[])Matlab.mtSend((int)6, (Object[])objectArray);
            IS_TOOLBOX_INSTALLED = blArray[0];
        }
        catch (Exception exception) {
            IS_TOOLBOX_INSTALLED = false;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            platform = 0;
            LINESEP = new Character('\r').toString();
        } else {
            if (System.getProperty("os.name").startsWith("Solaris")) {
                isSolaris = 1;
            }
            platform = 1;
            LINESEP = new Character('\n').toString();
        }
        openRecordFileNames = new Vector(5);
        singleByteMessage = new byte[1];
        singleShortMessage = new short[1];
        singleIntegerMessage = new int[1];
        singleFloatMessage = new float[1];
        singleDoubleMessage = new double[1];
        singleCharacterMessage = new char[1];
        ACTIONERROR = " must be set to a string or a 1-by-N cell array." + LINESEP + "The first element of the 1-by-N cell array must be the action function name.";
        NOASYNCOP = "cannot be modified while an asynchronous operation is in progress." + LINESEP + "Use STOPASYNC to stop the asynchronous operation.";
        boolVals = new String[]{"on", "off"};
        byteOVals = new String[]{"littleEndian", "bigEndian"};
        RDetVals = new String[]{"compact", "verbose"};
        RModeVals = new String[]{"overwrite", "append", "index"};
        StatVals = new String[]{"open", "closed"};
    }
}

