/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.Gpib;
import com.mathworks.toolbox.instrument.IniEvent;
import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.IniProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

public final class GpibVisa
extends Gpib
implements ActionListener {
    private static final int EOIMODE = 100;
    private static final int EOSMODE = 101;
    private static final int EOSCHAR = 102;
    private static final int COMPAREBITS = 103;
    private static final int TIMEOUT = 104;
    private static final int SUCCESS = 0;
    protected static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription", "vendordriverversion"};
    private String rsrcName = "";
    private VISA visa;
    private int defaultRM;
    private Object[] info = new Object[6];
    private int readId;
    private int writeId;
    private int oldTransferStatus = 0;
    private static final Object[] comVals = new Object[]{new Double(8.0)};
    private static final Object[] SadVals = new Object[]{new Double(0.0), new Double(30.0)};
    static IniProp[] objectIniProps = new IniProp[]{new IniProp("BoardIndex", "double", "none", "", "", "whileopen", 1), new IniProp("ByteOrder", "string", "enum", Instrument.byteOVals, "littleEndian", "never", 0), new IniProp("BytesAvailable", "double", "none", "", new Integer(0), "always", 0), new IniProp("BytesAvailableAction", "action", "action", "", "", "never", 0), new IniProp("BytesAvailableActionCount", "double", "none", "", new Integer(48), "whileOpen", 0), new IniProp("BytesAvailableActionMode", "string", "enum", Gpib.dModeVals, "eosCharCode", "whileOpen", 0), new IniProp("BytesToOutput", "double", "none", "", new Integer(0), "always", 0), new IniProp("CompareBits", "double", "bounded", comVals, new Integer(8), "never", 1), new IniProp("EOIMode", "string", "enum", Instrument.boolVals, "on", "never", 1), new IniProp("EOSCharCode", "double", "bounded", Gpib.eosCVals, new Integer(10), "never", 1), new IniProp("EOSMode", "string", "enum", Gpib.EOSMVals, "none", "never", 1), new IniProp("ErrorAction", "action", "action", "", "", "never", 0), new IniProp("InputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("Name", "string", "none", "", "", "never", 0), new IniProp("OutputBufferSize", "double", "none", "", new Integer(512), "whileOpen", 0), new IniProp("OutputEmptyAction", "action", "action", "", "", "never", 0), new IniProp("PrimaryAddress", "double", "bounded", Gpib.PadVals, "", "whileOpen", 1), new IniProp("RecordDetail", "string", "enum", Instrument.RDetVals, "compact", "never", 0), new IniProp("RecordMode", "string", "enum", Instrument.RModeVals, "overwrite", "whileRecording", 0), new IniProp("RecordName", "string", "none", "", "record.txt", "whileRecording", 0), new IniProp("RecordStatus", "string", "enum", Instrument.boolVals, "off", "always", 0), new IniProp("RsrcName", "string", "none", "", "", "always", 1), new IniProp("SecondaryAddress", "double", "bounded", SadVals, new Integer(0), "whileOpen", 1), new IniProp("Status", "string", "enum", Instrument.StatVals, "closed", "always", 0), new IniProp("Tag", "string", "none", "", "", "never", 0), new IniProp("Timeout", "double", "none", "", new Integer(10), "never", 0), new IniProp("TimerAction", "action", "action", "", "", "never", 0), new IniProp("TimerPeriod", "double", "none", "", new Integer(1), "whileOpen", 0), new IniProp("TransferStatus", "string", "enum", Gpib.TranSVals, "idle", "always", 0), new IniProp("Type", "string", "none", "", "visa-gpib", "always", 0), new IniProp("UserData", "any", "none", "", new double[0], "never", 0), new IniProp("ValuesReceived", "double", "none", "", new Integer(0), "always", 0), new IniProp("ValuesSent", "double", "none", "", new Integer(0), "always", 0)};
    static final int FBOARDINDEX = 0;
    static final int FNAME = 13;
    static final int FPRIMARYADDRESS = 16;
    static final int FRSRCNAME = 21;
    static final int FSECONDARYADDRESS = 22;

    public void setRsrcName(String string) throws IniException {
        this.displayError(this.createReadOnlyPropertyError("RsrcName"));
    }

    public String getRsrcName() {
        return this.rsrcName;
    }

    protected void nameStandardFormat() {
        if (this.name.equals("VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress)) {
            this.nameStandardFormat = true;
            return;
        }
        if (this.name.equals("VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress)) {
            this.nameStandardFormat = true;
            return;
        }
        this.nameStandardFormat = false;
    }

    protected final void updateNameProperties() {
        this.rsrcName = "GPIB" + this.boardIndex + "::" + this.primaryAddress + "::" + this.secondaryAddress + "::INSTR";
        if (this.nameStandardFormat) {
            if (this.secondaryAddress == 0) {
                this.name = "VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress;
                return;
            }
            this.name = "VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress;
        }
    }

    protected void setHardwareCompareBits(int n) {
    }

    protected final int[] getValidCompareBits() {
        int[] nArray = new int[]{8, 8};
        return nArray;
    }

    protected void setHardwareEOIMode(boolean bl) throws IniException {
        int n = this.visa.Set(this.handle, 100, this.bool2int(bl));
        if (n < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    protected void setHardwareEOSChar(int n) throws IniException {
        int n2 = 0;
        switch (this.eosMode) {
            case 0: {
                n2 = this.visa.Set(this.handle, 102, -1);
                break;
            }
            case 1: 
            case 3: {
                n2 = this.visa.Set(this.handle, 102, n);
                break;
            }
            case 2: {
                n2 = 0;
            }
        }
        if (n2 < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n2));
        }
    }

    protected void setHardwareEOSMode(int n) throws IniException {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = this.visa.Set(this.handle, 101, -1);
                break;
            }
            case 1: 
            case 3: {
                n2 = this.visa.Set(this.handle, 101, this.eosCharCode);
                break;
            }
            case 2: {
                n2 = 0;
            }
        }
        if (n2 < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n2));
        }
    }

    protected int[] getValidSecondaryAddress() {
        int[] nArray = new int[2];
        nArray[1] = 30;
        int[] nArray2 = nArray;
        return nArray2;
    }

    protected void setHardwareTimeout(double d) throws IniException {
        int n;
        if (d < 0.001) {
            this.displayError("Timeout must be greater than or equal to 1ms.");
        }
        if (d > 1000.0) {
            this.displayError("Timeout must be less than or equal to 1000s.");
        }
        if ((n = this.visa.Set(this.handle, 104, (int)(d * 1000.0))) < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    protected double getHardwareTimeout() {
        int n = this.visa.Get(this.handle, 104);
        return (double)n / 1000.0;
    }

    public GpibVisa() {
        this.deleteInstrumentObject(this);
    }

    public GpibVisa(String string, String string2, String string3) throws IniException {
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            this.displayError("Undefined function or variable 'visa'.");
        }
        try {
            boolean bl = this.verifyName(string3);
            if (!bl) {
                this.displayError("Invalid RSRCNAME specified. Type 'instrhelp visa' for more information.");
            }
            this.info[0] = String.valueOf(string) + Instrument.FILESEP + string2;
            this.info[1] = Instrument.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.updateNameProperties();
            this.type = "visa-gpib";
            this.objectProps = objectIniProps;
            return;
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new IniException(exception.getMessage());
        }
    }

    private boolean verifyName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return false;
        }
        this.boardIndex = n == 4 ? 0 : this.str2num(string.substring(4, n));
        if (this.boardIndex < 0) {
            return false;
        }
        String string2 = string.substring(n + 2, string.length());
        if ((n = string2.indexOf("::")) == -1) {
            return false;
        }
        this.primaryAddress = this.str2num(string2.substring(0, n));
        if (!this.verifySetRange(this.primaryAddress, 0, 30)) {
            return false;
        }
        if ((n = (string2 = string2.substring(n + 2, string2.length())).indexOf("::")) == -1) {
            this.secondaryAddress = 0;
        } else {
            this.secondaryAddress = this.str2num(string2.substring(0, n));
            string2 = string2.substring(n + 2, string2.length());
        }
        if (!this.verifySetRange(this.secondaryAddress, 0, 30)) {
            return false;
        }
        if (!string2.equals("INSTR")) {
            return false;
        }
        this.rsrcName = "GPIB" + this.boardIndex + "::" + this.primaryAddress + "::" + this.secondaryAddress + "::INSTR";
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        this.executeEvent(6, "Timer", this.eventTime, new IniEvent("Timer", Instrument.constructClockVector(this.eventTime)));
    }

    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "GpibVisaTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    protected void openHardware() throws IniException {
        int[] nArray;
        if (this.isInUse()) {
            this.displayError("The specified configuration: " + this.rsrcName + " is not available.  " + Instrument.LINESEP + "Use INSTRHWINFO for a list of available configurations. Use INSTRFIND to " + Instrument.LINESEP + "determine if other instrument objects are connected to the requested instrument.");
        }
        if ((nArray = this.visa.Create(this, this.rsrcName)) != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
            return;
        }
        this.displayError("Could not create VISA object. Use INSTRHWINFO for a list of available configurations.");
    }

    protected void addToPoller() {
        if (this.visa.VerifyAsyncVISARead()) {
            Poller.addInstrument(this);
        }
        if (this.timerAction != Instrument.ACTION) {
            if (!this.wasTimerStarted) {
                this.createTimer();
                return;
            }
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        }
    }

    protected void closeHardware() throws IniException {
        int n;
        if (this.visa.VerifyAsyncVISARead()) {
            Poller.removeInstrument(this);
        }
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if ((n = this.visa.Close(this.handle, this.defaultRM)) < 0) {
            this.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    protected void hardwareStopAsync() throws IniException {
        this.oldTransferStatus = this.transferStatus;
        this.hardwareFlushOutputVector();
        switch (this.oldTransferStatus) {
            case 1: {
                this.visa.StopAsync(this.handle, this.readId);
                break;
            }
            case 2: {
                this.visa.StopAsync(this.handle, this.writeId);
                break;
            }
        }
        this.transferStatus = 0;
    }

    public final Object[] constructorargs() {
        String string = (String)this.info[0];
        int n = string.lastIndexOf(Instrument.FILESEP);
        Object[] objectArray = new Object[]{string.substring(0, n), string.substring(n + 1), this.rsrcName};
        return objectArray;
    }

    protected void hardwareFlushOutput() throws IniException {
        this.oldTransferStatus = this.transferStatus;
        this.hardwareFlushOutputVector();
        switch (this.oldTransferStatus) {
            case 2: {
                this.visa.StopAsync(this.handle, this.writeId);
                break;
            }
        }
        this.transferStatus = 0;
    }

    protected void hardwareFlushOutputVector() {
        try {
            this.flushOutputVector();
        }
        catch (Exception exception) {}
        this.bytesToOutput = 0;
        this.transferStatus = 0;
    }

    protected void verifyWriteOperation() throws IniException {
        if (this.writeTransferMode == 1 && !this.visa.VerifyAsyncVISAWrite()) {
            this.displayError("Asynchronous operation is not supported for Agilent VISA-GPIB objects.");
        }
        if (this.transferStatus == 2) {
            this.displayError("An asynchronous write is already in progress.");
            return;
        }
        if (this.transferStatus == 1) {
            this.displayError("An asynchronous read is already in progress.");
        }
    }

    protected void verifyReadOperation() throws IniException {
        if (!this.visa.VerifyAsyncVISARead()) {
            this.displayError("Asynchronous operation is not supported for Agilent VISA-GPIB objects.");
        }
        if (this.transferStatus == 2) {
            this.displayError("An asynchronous write is already in progress.");
        } else if (this.transferStatus == 1) {
            this.displayError("An asynchronous read is already in progress.");
        }
        this.transferStatus = 1;
    }

    public final void poll() {
        try {
            if (this.readAsyncCount > 0 && !this.readingFromHardware) {
                this.pollingRead();
            }
            if (this.dataAvailableOutputVector()) {
                this.pollingWrite();
            }
            if (this.isActionAvailable()) {
                int n = this.getNextAction();
                int n2 = this.getNextAction();
                if (n == 0) {
                    if (this.transferStatus == 2) {
                        n = 2;
                    } else if (this.transferStatus == 1) {
                        n = 0;
                    } else if (this.oldTransferStatus == 2) {
                        n = 2;
                    } else if (this.oldTransferStatus == 1) {
                        n = 0;
                    } else {
                        return;
                    }
                }
                switch (n) {
                    case 0: {
                        this.pollingReadActionSuccess(n2);
                        break;
                    }
                    case 1: {
                        this.pollingReadActionSize(n2);
                        break;
                    }
                    case 2: {
                        this.pollingWriteAction();
                        break;
                    }
                }
            }
            this.checkForAsynchronousTimeouts();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void pollingRead() {
        int n;
        this.transferStatus = 1;
        this.readingFromHardware = true;
        int n2 = this.bytesAvailableActionMode == 1 ? this.bytesAvailableActionCount - this.bytesAvailable % this.bytesAvailableActionCount : this.readAsyncCount;
        if (n2 > this.readAsyncCount) {
            n2 = this.readAsyncCount;
        }
        if ((n = this.visa.ReadBinaryByteAsync(this.handle, n2)) < 0) {
            this.transferStatus = 0;
            this.readAsyncCount = 0;
            this.readingFromHardware = false;
            this.readAsyncStopTime = 0.0;
            this.executeErrorEvent(Calendar.getInstance(), "VISA: " + this.visa.TranslateErrorCode(this.handle, n));
            return;
        }
        this.readId = n;
    }

    protected void pollingWrite() {
        try {
            this.getDoubleFromOutputVector();
            int n = this.getIntFromOutputVector();
            Object object = this.getObjectFromOutputVector();
            byte[] byArray = Instrument.platform != this.byteOrder ? BinarySwapBytes.breakdownToBytesAndSwap(object, n) : BinarySwapBytes.breakdownToBytes(object, n);
            int n2 = this.visa.WriteBinaryByteAsync(this.handle, byArray, byArray.length);
            if (n2 < 0) {
                this.transferStatus = 0;
                this.bytesToOutput = 0;
                this.valuesSent += this.valuesToOutput;
                this.executeErrorEvent(Calendar.getInstance(), "VISA: " + this.visa.TranslateErrorCode(this.handle, n2));
                return;
            }
            this.writeId = n2;
            this.writeStopTime = (double)System.currentTimeMillis() + this.timeout * 1000.0;
            this.valuesToOutput = byArray.length / Instrument.DATASIZE[n];
            return;
        }
        catch (Exception exception) {
            this.hardwareFlushOutputVector();
            this.executeErrorEvent(Calendar.getInstance(), "VISA: Error while writing data.");
            return;
        }
    }

    protected int writeAsciiToHardware(String string) {
        return this.visa.Write(this.handle, string, string.length());
    }

    protected int writeSwappedBytes(Object object, int n, int n2) {
        Object object2 = null;
        try {
            object2 = BinarySwapBytes.swap(object, n2, n);
        }
        catch (Exception exception) {
            return -1;
        }
        switch (n2) {
            case 0: 
            case 5: {
                return this.visa.WriteBinaryByte(this.handle, (byte[])object2, n);
            }
            case 1: {
                return this.visa.WriteBinaryShort(this.handle, (short[])object2, n);
            }
            case 2: {
                return this.visa.WriteBinaryInt(this.handle, (int[])object2, n);
            }
            case 3: {
                return this.visa.WriteBinaryFloat(this.handle, (float[])object2, n);
            }
            case 4: {
                return this.visa.WriteBinaryDouble(this.handle, (double[])object2, n);
            }
        }
        return -1;
    }

    protected int writeBytes(Object object, int n, int n2) {
        if (object instanceof byte[]) {
            return this.visa.WriteBinaryByte(this.handle, (byte[])object, n);
        }
        if (object instanceof Byte) {
            return this.visa.WriteBinaryByte(this.handle, Instrument.object2byteArray(object), n);
        }
        if (object instanceof short[]) {
            return this.visa.WriteBinaryShort(this.handle, (short[])object, n);
        }
        if (object instanceof Short) {
            return this.visa.WriteBinaryShort(this.handle, this.object2shortArray(object), n);
        }
        if (object instanceof int[]) {
            return this.visa.WriteBinaryInt(this.handle, (int[])object, n);
        }
        if (object instanceof Integer) {
            return this.visa.WriteBinaryInt(this.handle, this.object2intArray(object), n);
        }
        if (object instanceof float[]) {
            return this.visa.WriteBinaryFloat(this.handle, (float[])object, n);
        }
        if (object instanceof Float) {
            return this.visa.WriteBinaryFloat(this.handle, this.object2floatArray(object), n);
        }
        if (object instanceof double[]) {
            return this.visa.WriteBinaryDouble(this.handle, (double[])object, n);
        }
        if (object instanceof Double) {
            return this.visa.WriteBinaryDouble(this.handle, this.object2doubleArray(object), n);
        }
        return -1;
    }

    protected Object[] readAsciiFromHardware(int n) {
        return this.visa.Read(this.handle, n);
    }

    protected Object[] readBinaryFromHardware(int n) {
        return this.visa.ReadBinary(this.handle, n, 0);
    }

    protected byte[] readAsynchronousDataFromHardware(int n) {
        return this.visa.GetAsyncReadData(this.handle, n);
    }

    protected String getErrorMessageFromHardware(int n) {
        return "VISA: " + this.visa.TranslateErrorCode(this.handle, n);
    }

    protected int getSuccessValue() {
        return 0;
    }

    protected void hardwareGPIBTrigger() throws IniException {
        int n = this.visa.Trigger(this.handle);
        if (n < 0) {
            this.displayError(this.getErrorMessageFromHardware(n));
        }
    }

    protected void hardwareGPIBClear() throws IniException {
        int n = this.visa.Clear(this.handle);
        if (n < 0) {
            this.displayError(this.getErrorMessageFromHardware(n));
        }
    }

    public Object ObjectHardwareInfo() {
        this.info[3] = (String)this.visa.HardwareInfo(this.handle, 3);
        this.info[4] = (String)this.visa.HardwareInfo(this.handle, 4);
        Integer n = (Integer)this.visa.HardwareInfo(0, 5);
        this.info[5] = GpibVisa.constructVersionString(n);
        return this.info;
    }

    private static Double constructVersionString(int n) {
        String string = Integer.toHexString(n);
        int n2 = string.length();
        Integer.valueOf(string.substring(0, n2 - 4)).intValue();
        int n3 = Integer.valueOf(string.substring(0, n2 - 4));
        int n4 = Integer.valueOf(string.substring(n2 - 4, n2));
        return Double.valueOf(String.valueOf(n3 /= 10) + "." + n4);
    }

    public Object[] ObjectHardwareInfo(String[] stringArray) throws IniException {
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.findPropertyCompleteName(stringArray[n].toLowerCase(), HWINFO_FIELDS, stringArray[n]);
            if (this.info[n2] == null) {
                this.ObjectHardwareInfo();
            }
            objectArray[n] = this.info[n2];
            ++n;
        }
        return objectArray;
    }

    protected void updateObjectSpecificProperties(IniProp[] iniPropArray) {
        if (this.secondaryAddress == 0) {
            iniPropArray[13].setDefaultValue("VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress);
        } else {
            iniPropArray[13].setDefaultValue("VISA-GPIB" + this.boardIndex + "-" + this.primaryAddress + "-" + this.secondaryAddress);
        }
        iniPropArray[0].setDefaultValue(new Integer(this.boardIndex));
        iniPropArray[16].setDefaultValue(new Integer(this.primaryAddress));
        iniPropArray[21].setDefaultValue(this.rsrcName);
        iniPropArray[22].setDefaultValue(new Integer(this.secondaryAddress));
    }

    public String display() {
        if (!this.isvalid()) {
            return this.invalidDisplay();
        }
        return String.valueOf(Instrument.LINESEP) + "   VISA-GPIB Object Using " + this.info[2] + " Adaptor : " + this.name + Instrument.LINESEP + Instrument.LINESEP + this.gpibDisplay();
    }

    public String setDisplay() throws Exception {
        return "    ByteOrder: [ {littleEndian} | bigEndian ] " + Instrument.LINESEP + "    BytesAvailableAction" + Instrument.LINESEP + "    BytesAvailableActionCount" + Instrument.LINESEP + "    BytesAvailableActionMode: [ {eosCharCode} | byte ]" + Instrument.LINESEP + "    ErrorAction" + Instrument.LINESEP + "    InputBufferSize" + Instrument.LINESEP + "    Name" + Instrument.LINESEP + "    OutputBufferSize" + Instrument.LINESEP + "    OutputEmptyAction" + Instrument.LINESEP + "    RecordDetail: [ {compact} | verbose ]" + Instrument.LINESEP + "    RecordMode: [ {overwrite} | append | index ]" + Instrument.LINESEP + "    RecordName" + Instrument.LINESEP + "    Tag" + Instrument.LINESEP + "    Timeout" + Instrument.LINESEP + "    TimerAction" + Instrument.LINESEP + "    TimerPeriod" + Instrument.LINESEP + "    UserData" + Instrument.LINESEP + "    " + Instrument.LINESEP + "    VISA-GPIB specific properties:" + Instrument.LINESEP + "    BoardIndex" + Instrument.LINESEP + "    CompareBits" + Instrument.LINESEP + "    EOIMode: [ {on} | off ]" + Instrument.LINESEP + "    EOSCharCode" + Instrument.LINESEP + "    EOSMode: [ {none} | read | write | read&write ]" + Instrument.LINESEP + "    PrimaryAddress" + Instrument.LINESEP + "    SecondaryAddress" + Instrument.LINESEP + " " + Instrument.LINESEP;
    }
}

