/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.GpibDll;
import com.mathworks.toolbox.instrument.IniException;
import com.mathworks.toolbox.instrument.Instrument;

public class GpibNI
extends GpibDll {
    public native int Create(int var1, int var2, int var3, double var4, boolean var6, boolean var7);

    public native int Close(int var1);

    public native int Clear(int var1);

    public native int Set(int var1, int var2, int var3);

    public native int SetDouble(int var1, int var2, double var3);

    public native double GetDouble(int var1, int var2);

    public native int Write(int var1, String var2, int var3, int var4);

    public native int WriteBinaryByte(int var1, byte[] var2, int var3, int var4);

    public native int WriteBinaryShort(int var1, short[] var2, int var3, int var4);

    public native int WriteBinaryInt(int var1, int[] var2, int var3, int var4);

    public native int WriteBinaryFloat(int var1, float[] var2, int var3, int var4);

    public native int WriteBinaryDouble(int var1, double[] var2, int var3, int var4);

    public native int WriteBinaryChar(int var1, char[] var2, int var3, int var4);

    public native Object[] Read(int var1, int var2);

    public native Object[] ReadBinary(int var1, int var2, int var3);

    public native int WriteBinaryByteAsync(Instrument var1, int var2, byte[] var3, int var4);

    public native int ReadBinaryByteAsync(Instrument var1, int var2, int var3);

    public native byte[] GetAsyncReadData(int var1, int var2);

    public native int StopAsync(int var1);

    public native int Trigger(int var1);

    public native int Lines(int var1, int var2, int var3);

    public native String HwInfo(int var1);

    public native int[] FindBoards();

    public native int PPollConfig(int var1, int var2, int var3, int var4);

    public native int PPoll(int var1, int var2);

    public native int SPoll(int var1);

    public native String TranslateErrorCode(int var1, int var2);

    public GpibNI() throws IniException {
        this.deleteInstrumentObject(this);
    }

    public GpibNI(String string, int n, int n2) throws Exception {
        try {
            this.configureProps(string, "NI", n, n2, Instrument.platform != 1);
            System.load(string);
            return;
        }
        catch (SecurityException securityException) {
            this.deleteInstrumentObject(this);
            this.displayError(securityException.getMessage());
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.deleteInstrumentObject(this);
            this.displayError(unsatisfiedLinkError.getMessage());
            return;
        }
    }

    protected final int[] getValidCompareBits() {
        int[] nArray = new int[]{7, 8};
        return nArray;
    }

    protected void verifyReadOperation() throws IniException {
        super.verifyReadOperation();
        if (Instrument.platform == 1) {
            this.displayError("Asynchronous operation is not supported by the NI GPIB adaptor on the UNIX platform.");
        }
    }

    protected void verifyWriteOperation() throws IniException {
        super.verifyWriteOperation();
        if (this.writeTransferMode == 1 && Instrument.platform == 1) {
            this.displayError("Asynchronous operation is not supported by the NI GPIB adaptor on the UNIX platform.");
        }
    }
}

